// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/user_event_service.proto

#include "google/cloud/discoveryengine/v1/user_event_connection.h"
#include "google/cloud/discoveryengine/v1/internal/user_event_connection_impl.h"
#include "google/cloud/discoveryengine/v1/internal/user_event_option_defaults.h"
#include "google/cloud/discoveryengine/v1/internal/user_event_stub_factory.h"
#include "google/cloud/discoveryengine/v1/internal/user_event_tracing_connection.h"
#include "google/cloud/discoveryengine/v1/user_event_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

UserEventServiceConnection::~UserEventServiceConnection() = default;

StatusOr<google::cloud::discoveryengine::v1::UserEvent>
UserEventServiceConnection::WriteUserEvent(
    google::cloud::discoveryengine::v1::WriteUserEventRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::api::HttpBody> UserEventServiceConnection::CollectUserEvent(
    google::cloud::discoveryengine::v1::CollectUserEventRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::discoveryengine::v1::PurgeUserEventsResponse>>
UserEventServiceConnection::PurgeUserEvents(
    google::cloud::discoveryengine::v1::PurgeUserEventsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::PurgeUserEventsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
UserEventServiceConnection::PurgeUserEvents(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::PurgeUserEventsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::PurgeUserEventsResponse>>
UserEventServiceConnection::PurgeUserEvents(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::PurgeUserEventsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::ImportUserEventsResponse>>
UserEventServiceConnection::ImportUserEvents(
    google::cloud::discoveryengine::v1::ImportUserEventsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::ImportUserEventsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
UserEventServiceConnection::ImportUserEvents(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::ImportUserEventsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::ImportUserEventsResponse>>
UserEventServiceConnection::ImportUserEvents(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::ImportUserEventsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<UserEventServiceConnection> MakeUserEventServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 UserEventServicePolicyOptionList>(options,
                                                                   __func__);
  options = discoveryengine_v1_internal::UserEventServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = discoveryengine_v1_internal::CreateDefaultUserEventServiceStub(
      std::move(auth), options);
  return discoveryengine_v1_internal::MakeUserEventServiceTracingConnection(
      std::make_shared<
          discoveryengine_v1_internal::UserEventServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
