// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

#include "google/cloud/filestore/v1/internal/cloud_filestore_manager_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace filestore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudFilestoreManagerTracingConnection::CloudFilestoreManagerTracingConnection(
    std::shared_ptr<filestore_v1::CloudFilestoreManagerConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::filestore::v1::Instance>
CloudFilestoreManagerTracingConnection::ListInstances(
    google::cloud::filestore::v1::ListInstancesRequest request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::ListInstances");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstances(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::filestore::v1::Instance>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::filestore::v1::Instance>
CloudFilestoreManagerTracingConnection::GetInstance(
    google::cloud::filestore::v1::GetInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::GetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstance(request));
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerTracingConnection::CreateInstance(
    google::cloud::filestore::v1::CreateInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::CreateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateInstance(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::CreateInstance(
    NoAwaitTag,
    google::cloud::filestore::v1::CreateInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::CreateInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerTracingConnection::CreateInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::CreateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateInstance(operation));
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerTracingConnection::UpdateInstance(
    google::cloud::filestore::v1::UpdateInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::UpdateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateInstance(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::UpdateInstance(
    NoAwaitTag,
    google::cloud::filestore::v1::UpdateInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::UpdateInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerTracingConnection::UpdateInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::UpdateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateInstance(operation));
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerTracingConnection::RestoreInstance(
    google::cloud::filestore::v1::RestoreInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::RestoreInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RestoreInstance(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::RestoreInstance(
    NoAwaitTag,
    google::cloud::filestore::v1::RestoreInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::RestoreInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->RestoreInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerTracingConnection::RestoreInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::RestoreInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RestoreInstance(operation));
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerTracingConnection::RevertInstance(
    google::cloud::filestore::v1::RevertInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::RevertInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RevertInstance(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::RevertInstance(
    NoAwaitTag,
    google::cloud::filestore::v1::RevertInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::RevertInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->RevertInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerTracingConnection::RevertInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::RevertInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RevertInstance(operation));
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerTracingConnection::DeleteInstance(
    google::cloud::filestore::v1::DeleteInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::DeleteInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteInstance(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::DeleteInstance(
    NoAwaitTag,
    google::cloud::filestore::v1::DeleteInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::DeleteInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerTracingConnection::DeleteInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::DeleteInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteInstance(operation));
}

StreamRange<google::cloud::filestore::v1::Snapshot>
CloudFilestoreManagerTracingConnection::ListSnapshots(
    google::cloud::filestore::v1::ListSnapshotsRequest request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::ListSnapshots");
  internal::OTelScope scope(span);
  auto sr = child_->ListSnapshots(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::filestore::v1::Snapshot>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::filestore::v1::Snapshot>
CloudFilestoreManagerTracingConnection::GetSnapshot(
    google::cloud::filestore::v1::GetSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::GetSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSnapshot(request));
}

future<StatusOr<google::cloud::filestore::v1::Snapshot>>
CloudFilestoreManagerTracingConnection::CreateSnapshot(
    google::cloud::filestore::v1::CreateSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::CreateSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSnapshot(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::CreateSnapshot(
    NoAwaitTag,
    google::cloud::filestore::v1::CreateSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::CreateSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::filestore::v1::Snapshot>>
CloudFilestoreManagerTracingConnection::CreateSnapshot(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::CreateSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSnapshot(operation));
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerTracingConnection::DeleteSnapshot(
    google::cloud::filestore::v1::DeleteSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::DeleteSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSnapshot(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::DeleteSnapshot(
    NoAwaitTag,
    google::cloud::filestore::v1::DeleteSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::DeleteSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerTracingConnection::DeleteSnapshot(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::DeleteSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSnapshot(operation));
}

future<StatusOr<google::cloud::filestore::v1::Snapshot>>
CloudFilestoreManagerTracingConnection::UpdateSnapshot(
    google::cloud::filestore::v1::UpdateSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::UpdateSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSnapshot(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::UpdateSnapshot(
    NoAwaitTag,
    google::cloud::filestore::v1::UpdateSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::UpdateSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::filestore::v1::Snapshot>>
CloudFilestoreManagerTracingConnection::UpdateSnapshot(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::UpdateSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSnapshot(operation));
}

StreamRange<google::cloud::filestore::v1::Backup>
CloudFilestoreManagerTracingConnection::ListBackups(
    google::cloud::filestore::v1::ListBackupsRequest request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::ListBackups");
  internal::OTelScope scope(span);
  auto sr = child_->ListBackups(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::filestore::v1::Backup>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::filestore::v1::Backup>
CloudFilestoreManagerTracingConnection::GetBackup(
    google::cloud::filestore::v1::GetBackupRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::GetBackup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetBackup(request));
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerTracingConnection::CreateBackup(
    google::cloud::filestore::v1::CreateBackupRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::CreateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateBackup(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::CreateBackup(
    NoAwaitTag,
    google::cloud::filestore::v1::CreateBackupRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::CreateBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateBackup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerTracingConnection::CreateBackup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::CreateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateBackup(operation));
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerTracingConnection::DeleteBackup(
    google::cloud::filestore::v1::DeleteBackupRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::DeleteBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteBackup(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::DeleteBackup(
    NoAwaitTag,
    google::cloud::filestore::v1::DeleteBackupRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::DeleteBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteBackup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerTracingConnection::DeleteBackup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::DeleteBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteBackup(operation));
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerTracingConnection::UpdateBackup(
    google::cloud::filestore::v1::UpdateBackupRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::UpdateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateBackup(request));
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerTracingConnection::UpdateBackup(
    NoAwaitTag,
    google::cloud::filestore::v1::UpdateBackupRequest const& request) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::UpdateBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateBackup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerTracingConnection::UpdateBackup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "filestore_v1::CloudFilestoreManagerConnection::UpdateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateBackup(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<filestore_v1::CloudFilestoreManagerConnection>
MakeCloudFilestoreManagerTracingConnection(
    std::shared_ptr<filestore_v1::CloudFilestoreManagerConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<CloudFilestoreManagerTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace filestore_v1_internal
}  // namespace cloud
}  // namespace google
