// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/dep.proto

#include "google/cloud/networkservices/v1/dep_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace networkservices_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DepServiceConnectionIdempotencyPolicy::
    ~DepServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<DepServiceConnectionIdempotencyPolicy>
DepServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DepServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency DepServiceConnectionIdempotencyPolicy::ListLbTrafficExtensions(
    google::cloud::networkservices::v1::
        ListLbTrafficExtensionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DepServiceConnectionIdempotencyPolicy::GetLbTrafficExtension(
    google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DepServiceConnectionIdempotencyPolicy::CreateLbTrafficExtension(
    google::cloud::networkservices::v1::
        CreateLbTrafficExtensionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DepServiceConnectionIdempotencyPolicy::UpdateLbTrafficExtension(
    google::cloud::networkservices::v1::
        UpdateLbTrafficExtensionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DepServiceConnectionIdempotencyPolicy::DeleteLbTrafficExtension(
    google::cloud::networkservices::v1::
        DeleteLbTrafficExtensionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DepServiceConnectionIdempotencyPolicy::ListLbRouteExtensions(
    google::cloud::networkservices::v1::
        ListLbRouteExtensionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DepServiceConnectionIdempotencyPolicy::GetLbRouteExtension(
    google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DepServiceConnectionIdempotencyPolicy::CreateLbRouteExtension(
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DepServiceConnectionIdempotencyPolicy::UpdateLbRouteExtension(
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DepServiceConnectionIdempotencyPolicy::DeleteLbRouteExtension(
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<DepServiceConnectionIdempotencyPolicy>
MakeDefaultDepServiceConnectionIdempotencyPolicy() {
  return std::make_unique<DepServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1
}  // namespace cloud
}  // namespace google
