// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

#include "google/cloud/privilegedaccessmanager/v1/privileged_access_manager_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace privilegedaccessmanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

PrivilegedAccessManagerConnectionIdempotencyPolicy::
    ~PrivilegedAccessManagerConnectionIdempotencyPolicy() = default;

std::unique_ptr<PrivilegedAccessManagerConnectionIdempotencyPolicy>
PrivilegedAccessManagerConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<PrivilegedAccessManagerConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
PrivilegedAccessManagerConnectionIdempotencyPolicy::CheckOnboardingStatus(
    google::cloud::privilegedaccessmanager::v1::
        CheckOnboardingStatusRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
PrivilegedAccessManagerConnectionIdempotencyPolicy::ListEntitlements(
    google::cloud::privilegedaccessmanager::v1::
        ListEntitlementsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
PrivilegedAccessManagerConnectionIdempotencyPolicy::SearchEntitlements(
    google::cloud::privilegedaccessmanager::v1::
        SearchEntitlementsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency PrivilegedAccessManagerConnectionIdempotencyPolicy::GetEntitlement(
    google::cloud::privilegedaccessmanager::v1::GetEntitlementRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
PrivilegedAccessManagerConnectionIdempotencyPolicy::CreateEntitlement(
    google::cloud::privilegedaccessmanager::v1::
        CreateEntitlementRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
PrivilegedAccessManagerConnectionIdempotencyPolicy::DeleteEntitlement(
    google::cloud::privilegedaccessmanager::v1::
        DeleteEntitlementRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
PrivilegedAccessManagerConnectionIdempotencyPolicy::UpdateEntitlement(
    google::cloud::privilegedaccessmanager::v1::
        UpdateEntitlementRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency PrivilegedAccessManagerConnectionIdempotencyPolicy::ListGrants(
    google::cloud::privilegedaccessmanager::v1::ListGrantsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency PrivilegedAccessManagerConnectionIdempotencyPolicy::SearchGrants(
    google::cloud::privilegedaccessmanager::v1::
        SearchGrantsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency PrivilegedAccessManagerConnectionIdempotencyPolicy::GetGrant(
    google::cloud::privilegedaccessmanager::v1::GetGrantRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency PrivilegedAccessManagerConnectionIdempotencyPolicy::CreateGrant(
    google::cloud::privilegedaccessmanager::v1::CreateGrantRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency PrivilegedAccessManagerConnectionIdempotencyPolicy::ApproveGrant(
    google::cloud::privilegedaccessmanager::v1::ApproveGrantRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency PrivilegedAccessManagerConnectionIdempotencyPolicy::DenyGrant(
    google::cloud::privilegedaccessmanager::v1::DenyGrantRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency PrivilegedAccessManagerConnectionIdempotencyPolicy::RevokeGrant(
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<PrivilegedAccessManagerConnectionIdempotencyPolicy>
MakeDefaultPrivilegedAccessManagerConnectionIdempotencyPolicy() {
  return std::make_unique<PrivilegedAccessManagerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privilegedaccessmanager_v1
}  // namespace cloud
}  // namespace google
