// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#include "google/cloud/pubsub/admin/topic_admin_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace pubsub_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TopicAdminConnectionIdempotencyPolicy::
    ~TopicAdminConnectionIdempotencyPolicy() = default;

std::unique_ptr<TopicAdminConnectionIdempotencyPolicy>
TopicAdminConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<TopicAdminConnectionIdempotencyPolicy>(*this);
}

Idempotency TopicAdminConnectionIdempotencyPolicy::CreateTopic(
    google::pubsub::v1::Topic const&) {
  return Idempotency::kIdempotent;
}

Idempotency TopicAdminConnectionIdempotencyPolicy::UpdateTopic(
    google::pubsub::v1::UpdateTopicRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TopicAdminConnectionIdempotencyPolicy::GetTopic(
    google::pubsub::v1::GetTopicRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TopicAdminConnectionIdempotencyPolicy::ListTopics(
    google::pubsub::v1::ListTopicsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TopicAdminConnectionIdempotencyPolicy::ListTopicSubscriptions(
    google::pubsub::v1::ListTopicSubscriptionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TopicAdminConnectionIdempotencyPolicy::ListTopicSnapshots(
    google::pubsub::v1::ListTopicSnapshotsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TopicAdminConnectionIdempotencyPolicy::DeleteTopic(
    google::pubsub::v1::DeleteTopicRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TopicAdminConnectionIdempotencyPolicy::DetachSubscription(
    google::pubsub::v1::DetachSubscriptionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TopicAdminConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency TopicAdminConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TopicAdminConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<TopicAdminConnectionIdempotencyPolicy>
MakeDefaultTopicAdminConnectionIdempotencyPolicy() {
  return std::make_unique<TopicAdminConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_admin
}  // namespace cloud
}  // namespace google
