// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/serviceusage/v1/serviceusage.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_V1_SERVICE_USAGE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_V1_SERVICE_USAGE_CONNECTION_H

#include "google/cloud/serviceusage/v1/internal/service_usage_retry_traits.h"
#include "google/cloud/serviceusage/v1/service_usage_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/api/serviceusage/v1/serviceusage.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace serviceusage_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `ServiceUsageConnection`.
class ServiceUsageRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<ServiceUsageRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `ServiceUsageConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ServiceUsageLimitedErrorCountRetryPolicy
    : public ServiceUsageRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit ServiceUsageLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  ServiceUsageLimitedErrorCountRetryPolicy(
      ServiceUsageLimitedErrorCountRetryPolicy&& rhs) noexcept
      : ServiceUsageLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  ServiceUsageLimitedErrorCountRetryPolicy(
      ServiceUsageLimitedErrorCountRetryPolicy const& rhs) noexcept
      : ServiceUsageLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ServiceUsageRetryPolicy> clone() const override {
    return std::make_unique<ServiceUsageLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ServiceUsageRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      serviceusage_v1_internal::ServiceUsageRetryTraits>
      impl_;
};

/**
 * A retry policy for `ServiceUsageConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ServiceUsageLimitedTimeRetryPolicy : public ServiceUsageRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit ServiceUsageLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  ServiceUsageLimitedTimeRetryPolicy(
      ServiceUsageLimitedTimeRetryPolicy&& rhs) noexcept
      : ServiceUsageLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  ServiceUsageLimitedTimeRetryPolicy(
      ServiceUsageLimitedTimeRetryPolicy const& rhs) noexcept
      : ServiceUsageLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ServiceUsageRetryPolicy> clone() const override {
    return std::make_unique<ServiceUsageLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ServiceUsageRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      serviceusage_v1_internal::ServiceUsageRetryTraits>
      impl_;
};

/**
 * The `ServiceUsageConnection` object for `ServiceUsageClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `ServiceUsageClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `ServiceUsageClient`.
 *
 * To create a concrete instance, see `MakeServiceUsageConnection()`.
 *
 * For mocking, see `serviceusage_v1_mocks::MockServiceUsageConnection`.
 */
class ServiceUsageConnection {
 public:
  virtual ~ServiceUsageConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::api::serviceusage::v1::EnableServiceResponse>>
  EnableService(
      google::api::serviceusage::v1::EnableServiceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> EnableService(
      NoAwaitTag,
      google::api::serviceusage::v1::EnableServiceRequest const& request);

  virtual future<StatusOr<google::api::serviceusage::v1::EnableServiceResponse>>
  EnableService(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::api::serviceusage::v1::DisableServiceResponse>>
  DisableService(
      google::api::serviceusage::v1::DisableServiceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DisableService(
      NoAwaitTag,
      google::api::serviceusage::v1::DisableServiceRequest const& request);

  virtual future<
      StatusOr<google::api::serviceusage::v1::DisableServiceResponse>>
  DisableService(google::longrunning::Operation const& operation);

  virtual StatusOr<google::api::serviceusage::v1::Service> GetService(
      google::api::serviceusage::v1::GetServiceRequest const& request);

  virtual StreamRange<google::api::serviceusage::v1::Service> ListServices(
      google::api::serviceusage::v1::ListServicesRequest request);

  virtual future<
      StatusOr<google::api::serviceusage::v1::BatchEnableServicesResponse>>
  BatchEnableServices(
      google::api::serviceusage::v1::BatchEnableServicesRequest const& request);

  virtual StatusOr<google::longrunning::Operation> BatchEnableServices(
      NoAwaitTag,
      google::api::serviceusage::v1::BatchEnableServicesRequest const& request);

  virtual future<
      StatusOr<google::api::serviceusage::v1::BatchEnableServicesResponse>>
  BatchEnableServices(google::longrunning::Operation const& operation);

  virtual StatusOr<google::api::serviceusage::v1::BatchGetServicesResponse>
  BatchGetServices(
      google::api::serviceusage::v1::BatchGetServicesRequest const& request);
};

/**
 * A factory function to construct an object of type `ServiceUsageConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of ServiceUsageClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `ServiceUsageConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::serviceusage_v1::ServiceUsagePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `ServiceUsageConnection` created by
 * this function.
 */
std::shared_ptr<ServiceUsageConnection> MakeServiceUsageConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace serviceusage_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_V1_SERVICE_USAGE_CONNECTION_H
