// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/timeseriesinsights/v1/timeseries_insights.proto

#include "google/cloud/timeseriesinsights/v1/timeseries_insights_controller_connection.h"
#include "google/cloud/timeseriesinsights/v1/internal/timeseries_insights_controller_connection_impl.h"
#include "google/cloud/timeseriesinsights/v1/internal/timeseries_insights_controller_option_defaults.h"
#include "google/cloud/timeseriesinsights/v1/internal/timeseries_insights_controller_stub_factory.h"
#include "google/cloud/timeseriesinsights/v1/internal/timeseries_insights_controller_tracing_connection.h"
#include "google/cloud/timeseriesinsights/v1/timeseries_insights_controller_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace timeseriesinsights_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TimeseriesInsightsControllerConnection::
    ~TimeseriesInsightsControllerConnection() = default;

StreamRange<google::cloud::timeseriesinsights::v1::DataSet>
TimeseriesInsightsControllerConnection::ListDataSets(
    google::cloud::timeseriesinsights::v1::
        ListDataSetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::timeseriesinsights::v1::DataSet>>();
}

StatusOr<google::cloud::timeseriesinsights::v1::DataSet>
TimeseriesInsightsControllerConnection::CreateDataSet(
    google::cloud::timeseriesinsights::v1::CreateDataSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status TimeseriesInsightsControllerConnection::DeleteDataSet(
    google::cloud::timeseriesinsights::v1::DeleteDataSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::timeseriesinsights::v1::AppendEventsResponse>
TimeseriesInsightsControllerConnection::AppendEvents(
    google::cloud::timeseriesinsights::v1::AppendEventsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::timeseriesinsights::v1::QueryDataSetResponse>
TimeseriesInsightsControllerConnection::QueryDataSet(
    google::cloud::timeseriesinsights::v1::QueryDataSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::timeseriesinsights::v1::EvaluatedSlice>
TimeseriesInsightsControllerConnection::EvaluateSlice(
    google::cloud::timeseriesinsights::v1::EvaluateSliceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::timeseriesinsights::v1::EvaluatedSlice>
TimeseriesInsightsControllerConnection::EvaluateTimeseries(
    google::cloud::timeseriesinsights::v1::EvaluateTimeseriesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<TimeseriesInsightsControllerConnection>
MakeTimeseriesInsightsControllerConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 TimeseriesInsightsControllerPolicyOptionList>(
      options, __func__);
  options = timeseriesinsights_v1_internal::
      TimeseriesInsightsControllerDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = timeseriesinsights_v1_internal::
      CreateDefaultTimeseriesInsightsControllerStub(std::move(auth), options);
  return timeseriesinsights_v1_internal::
      MakeTimeseriesInsightsControllerTracingConnection(
          std::make_shared<timeseriesinsights_v1_internal::
                               TimeseriesInsightsControllerConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace timeseriesinsights_v1
}  // namespace cloud
}  // namespace google
