/* 
    TowBowlTactics: Adaptation of the tabletop game Blood Bowl

    Copyright (C) 2001-2003 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef PUBLIC_H
#define PUBLIC_H

#include "global.h"
#include "Team.h"

/**
 * Classe representant le public assistant a un match.
 * @doc 
 * @author Toweld
 * @version 0.5
 */

class Public{
 public:
	/**
	* Constructeur par defaut
	*/
	Public();
	/**
	* Constructeur a 1 parametre
	* @param n nombre de spectateur assistant (voire meme participant) au match
	*/
	Public(int);
	/**
	* Changer le nombre de spectateur
	* @param n nombre de spectateur
	*/
	~Public();
	void set_number(int);
	/**
	* Pour connaitre le nombre de spectateur
	* @return nombre de spectateur
	*/
	int get_number();
	/**
	* Lors d'une touche
	* @return distance parcouru par le ballon lors de la remise en jeu
	*/
	int throwin_distance();
	/**
	* Lors d'une touche
	* @return direction prise lors de la remise en jeu (LEFT, RIGHT, SIDE)
	*/
	int throwin_direction(); 
	/**
	* Aggression d'un joueur par la foule
	* @return dommage inflige par la foule a un joueur
	*/
	int aggress_player();
	/**
	* Choix d'un joueur par la foule
	* @param t Team ou va etre pris le joueur
	* @return Player de l'equipe t choisit
	*/
	Player* select_player(Team*); 
	/**
	* Choix d'un joueur par la foule
	* @param t Team ou va etre pris le joueur
	* @return position du Player de l'equipe t choisit
	*/
	int select_player_num(Team*); 

	void save_state(FILE *,int);
 
protected:
	int number;
	Dice *d6;
};

#endif







