// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/model_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_MOCKS_MOCK_MODEL_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_MOCKS_MOCK_MODEL_CONNECTION_H

#include "google/cloud/aiplatform/v1/model_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace aiplatform_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `ModelServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `ModelServiceClient`. To do so,
 * construct an object of type `ModelServiceClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockModelServiceConnection
    : public aiplatform_v1::ModelServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::UploadModelResponse>>,
      UploadModel,
      (google::cloud::aiplatform::v1::UploadModelRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::aiplatform::v1::Model>, GetModel,
              (google::cloud::aiplatform::v1::GetModelRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::aiplatform::v1::Model>), ListModels,
              (google::cloud::aiplatform::v1::ListModelsRequest request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::aiplatform::v1::Model>),
              ListModelVersions,
              (google::cloud::aiplatform::v1::ListModelVersionsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::aiplatform::v1::Model>, UpdateModel,
      (google::cloud::aiplatform::v1::UpdateModelRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<
          google::cloud::aiplatform::v1::UpdateExplanationDatasetResponse>>,
      UpdateExplanationDataset,
      (google::cloud::aiplatform::v1::UpdateExplanationDatasetRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>,
      DeleteModel,
      (google::cloud::aiplatform::v1::DeleteModelRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>,
      DeleteModelVersion,
      (google::cloud::aiplatform::v1::DeleteModelVersionRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::aiplatform::v1::Model>,
              MergeVersionAliases,
              (google::cloud::aiplatform::v1::MergeVersionAliasesRequest const&
                   request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::ExportModelResponse>>,
      ExportModel,
      (google::cloud::aiplatform::v1::ExportModelRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::CopyModelResponse>>,
      CopyModel,
      (google::cloud::aiplatform::v1::CopyModelRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::aiplatform::v1::ModelEvaluation>,
      ImportModelEvaluation,
      (google::cloud::aiplatform::v1::ImportModelEvaluationRequest const&
           request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::aiplatform::v1::
                           BatchImportModelEvaluationSlicesResponse>,
              BatchImportModelEvaluationSlices,
              (google::cloud::aiplatform::v1::
                   BatchImportModelEvaluationSlicesRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::aiplatform::v1::
                           BatchImportEvaluatedAnnotationsResponse>,
              BatchImportEvaluatedAnnotations,
              (google::cloud::aiplatform::v1::
                   BatchImportEvaluatedAnnotationsRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::aiplatform::v1::ModelEvaluation>,
      GetModelEvaluation,
      (google::cloud::aiplatform::v1::GetModelEvaluationRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::aiplatform::v1::ModelEvaluation>),
      ListModelEvaluations,
      (google::cloud::aiplatform::v1::ListModelEvaluationsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::aiplatform::v1::ModelEvaluationSlice>,
      GetModelEvaluationSlice,
      (google::cloud::aiplatform::v1::GetModelEvaluationSliceRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::aiplatform::v1::ModelEvaluationSlice>),
      ListModelEvaluationSlices,
      (google::cloud::aiplatform::v1::ListModelEvaluationSlicesRequest request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_MOCKS_MOCK_MODEL_CONNECTION_H
