// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/addresses/v1/addresses.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ADDRESSES_V1_INTERNAL_ADDRESSES_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ADDRESSES_V1_INTERNAL_ADDRESSES_TRACING_CONNECTION_H

#include "google/cloud/compute/addresses/v1/addresses_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_addresses_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class AddressesTracingConnection
    : public compute_addresses_v1::AddressesConnection {
 public:
  ~AddressesTracingConnection() override = default;

  explicit AddressesTracingConnection(
      std::shared_ptr<compute_addresses_v1::AddressesConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<std::pair<std::string,
                        google::cloud::cpp::compute::v1::AddressesScopedList>>
  AggregatedListAddresses(
      google::cloud::cpp::compute::addresses::v1::AggregatedListAddressesRequest
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> DeleteAddress(
      google::cloud::cpp::compute::addresses::v1::DeleteAddressRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::Address> GetAddress(
      google::cloud::cpp::compute::addresses::v1::GetAddressRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> InsertAddress(
      google::cloud::cpp::compute::addresses::v1::InsertAddressRequest const&
          request) override;

  StreamRange<google::cloud::cpp::compute::v1::Address> ListAddresses(
      google::cloud::cpp::compute::addresses::v1::ListAddressesRequest request)
      override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> Move(
      google::cloud::cpp::compute::addresses::v1::MoveRequest const& request)
      override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetLabels(
      google::cloud::cpp::compute::addresses::v1::SetLabelsRequest const&
          request) override;

 private:
  std::shared_ptr<compute_addresses_v1::AddressesConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_addresses_v1::AddressesConnection>
MakeAddressesTracingConnection(
    std::shared_ptr<compute_addresses_v1::AddressesConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_addresses_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ADDRESSES_V1_INTERNAL_ADDRESSES_TRACING_CONNECTION_H
