// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/agent.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_AGENTS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_AGENTS_CONNECTION_IMPL_H

#include "google/cloud/dialogflow_es/agents_connection.h"
#include "google/cloud/dialogflow_es/agents_connection_idempotency_policy.h"
#include "google/cloud/dialogflow_es/agents_options.h"
#include "google/cloud/dialogflow_es/internal/agents_retry_traits.h"
#include "google/cloud/dialogflow_es/internal/agents_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AgentsConnectionImpl : public dialogflow_es::AgentsConnection {
 public:
  ~AgentsConnectionImpl() override = default;

  AgentsConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<dialogflow_es_internal::AgentsStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::dialogflow::v2::Agent> GetAgent(
      google::cloud::dialogflow::v2::GetAgentRequest const& request) override;

  StatusOr<google::cloud::dialogflow::v2::Agent> SetAgent(
      google::cloud::dialogflow::v2::SetAgentRequest const& request) override;

  Status DeleteAgent(google::cloud::dialogflow::v2::DeleteAgentRequest const&
                         request) override;

  StreamRange<google::cloud::dialogflow::v2::Agent> SearchAgents(
      google::cloud::dialogflow::v2::SearchAgentsRequest request) override;

  future<StatusOr<google::protobuf::Struct>> TrainAgent(
      google::cloud::dialogflow::v2::TrainAgentRequest const& request) override;

  future<StatusOr<google::cloud::dialogflow::v2::ExportAgentResponse>>
  ExportAgent(google::cloud::dialogflow::v2::ExportAgentRequest const& request)
      override;

  future<StatusOr<google::protobuf::Struct>> ImportAgent(
      google::cloud::dialogflow::v2::ImportAgentRequest const& request)
      override;

  future<StatusOr<google::protobuf::Struct>> RestoreAgent(
      google::cloud::dialogflow::v2::RestoreAgentRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::v2::ValidationResult> GetValidationResult(
      google::cloud::dialogflow::v2::GetValidationResultRequest const& request)
      override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<dialogflow_es_internal::AgentsStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_AGENTS_CONNECTION_IMPL_H
