// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/documentai/v1/document_processor_service.proto

#include "google/cloud/documentai/v1/internal/document_processor_connection_impl.h"
#include "google/cloud/documentai/v1/internal/document_processor_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace documentai_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<documentai_v1::DocumentProcessorServiceRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<documentai_v1::DocumentProcessorServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<documentai_v1::DocumentProcessorServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    documentai_v1::DocumentProcessorServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<documentai_v1::
               DocumentProcessorServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options
      .get<documentai_v1::DocumentProcessorServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

DocumentProcessorServiceConnectionImpl::DocumentProcessorServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<documentai_v1_internal::DocumentProcessorServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), DocumentProcessorServiceConnection::options())) {}

StatusOr<google::cloud::documentai::v1::ProcessResponse>
DocumentProcessorServiceConnectionImpl::ProcessDocument(
    google::cloud::documentai::v1::ProcessRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ProcessDocument(request),
      [this](grpc::ClientContext& context,
             google::cloud::documentai::v1::ProcessRequest const& request) {
        return stub_->ProcessDocument(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::documentai::v1::BatchProcessResponse>>
DocumentProcessorServiceConnectionImpl::BatchProcessDocuments(
    google::cloud::documentai::v1::BatchProcessRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::BatchProcessResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::documentai::v1::BatchProcessRequest const& request) {
        return stub->AsyncBatchProcessDocuments(cq, std::move(context), options,
                                                request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::documentai::v1::BatchProcessResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchProcessDocuments(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::documentai::v1::FetchProcessorTypesResponse>
DocumentProcessorServiceConnectionImpl::FetchProcessorTypes(
    google::cloud::documentai::v1::FetchProcessorTypesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->FetchProcessorTypes(request),
      [this](grpc::ClientContext& context,
             google::cloud::documentai::v1::FetchProcessorTypesRequest const&
                 request) {
        return stub_->FetchProcessorTypes(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::documentai::v1::ProcessorType>
DocumentProcessorServiceConnectionImpl::ListProcessorTypes(
    google::cloud::documentai::v1::ListProcessorTypesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListProcessorTypes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::documentai::v1::ProcessorType>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<documentai_v1::DocumentProcessorServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::documentai::v1::ListProcessorTypesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::documentai::v1::ListProcessorTypesRequest const&
                    request) {
              return stub->ListProcessorTypes(context, request);
            },
            r, function_name);
      },
      [](google::cloud::documentai::v1::ListProcessorTypesResponse r) {
        std::vector<google::cloud::documentai::v1::ProcessorType> result(
            r.processor_types().size());
        auto& messages = *r.mutable_processor_types();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::documentai::v1::ProcessorType>
DocumentProcessorServiceConnectionImpl::GetProcessorType(
    google::cloud::documentai::v1::GetProcessorTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetProcessorType(request),
      [this](grpc::ClientContext& context,
             google::cloud::documentai::v1::GetProcessorTypeRequest const&
                 request) { return stub_->GetProcessorType(context, request); },
      request, __func__);
}

StreamRange<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceConnectionImpl::ListProcessors(
    google::cloud::documentai::v1::ListProcessorsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListProcessors(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::documentai::v1::Processor>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<documentai_v1::DocumentProcessorServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::documentai::v1::ListProcessorsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::documentai::v1::ListProcessorsRequest const&
                       request) {
              return stub->ListProcessors(context, request);
            },
            r, function_name);
      },
      [](google::cloud::documentai::v1::ListProcessorsResponse r) {
        std::vector<google::cloud::documentai::v1::Processor> result(
            r.processors().size());
        auto& messages = *r.mutable_processors();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceConnectionImpl::GetProcessor(
    google::cloud::documentai::v1::GetProcessorRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetProcessor(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::documentai::v1::GetProcessorRequest const& request) {
        return stub_->GetProcessor(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::documentai::v1::TrainProcessorVersionResponse>>
DocumentProcessorServiceConnectionImpl::TrainProcessorVersion(
    google::cloud::documentai::v1::TrainProcessorVersionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::TrainProcessorVersionResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::documentai::v1::TrainProcessorVersionRequest const&
              request) {
        return stub->AsyncTrainProcessorVersion(cq, std::move(context), options,
                                                request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::documentai::v1::TrainProcessorVersionResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TrainProcessorVersion(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::documentai::v1::ProcessorVersion>
DocumentProcessorServiceConnectionImpl::GetProcessorVersion(
    google::cloud::documentai::v1::GetProcessorVersionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetProcessorVersion(request),
      [this](grpc::ClientContext& context,
             google::cloud::documentai::v1::GetProcessorVersionRequest const&
                 request) {
        return stub_->GetProcessorVersion(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::documentai::v1::ProcessorVersion>
DocumentProcessorServiceConnectionImpl::ListProcessorVersions(
    google::cloud::documentai::v1::ListProcessorVersionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListProcessorVersions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::documentai::v1::ProcessorVersion>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<documentai_v1::DocumentProcessorServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::documentai::v1::ListProcessorVersionsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::documentai::v1::
                       ListProcessorVersionsRequest const& request) {
              return stub->ListProcessorVersions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::documentai::v1::ListProcessorVersionsResponse r) {
        std::vector<google::cloud::documentai::v1::ProcessorVersion> result(
            r.processor_versions().size());
        auto& messages = *r.mutable_processor_versions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::documentai::v1::DeleteProcessorVersionMetadata>>
DocumentProcessorServiceConnectionImpl::DeleteProcessorVersion(
    google::cloud::documentai::v1::DeleteProcessorVersionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::DeleteProcessorVersionMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::documentai::v1::DeleteProcessorVersionRequest const&
              request) {
        return stub->AsyncDeleteProcessorVersion(cq, std::move(context),
                                                 options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::documentai::v1::DeleteProcessorVersionMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteProcessorVersion(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::documentai::v1::DeployProcessorVersionResponse>>
DocumentProcessorServiceConnectionImpl::DeployProcessorVersion(
    google::cloud::documentai::v1::DeployProcessorVersionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::DeployProcessorVersionResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::documentai::v1::DeployProcessorVersionRequest const&
              request) {
        return stub->AsyncDeployProcessorVersion(cq, std::move(context),
                                                 options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::documentai::v1::DeployProcessorVersionResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeployProcessorVersion(request),
      polling_policy(*current), __func__);
}

future<
    StatusOr<google::cloud::documentai::v1::UndeployProcessorVersionResponse>>
DocumentProcessorServiceConnectionImpl::UndeployProcessorVersion(
    google::cloud::documentai::v1::UndeployProcessorVersionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::UndeployProcessorVersionResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::documentai::v1::UndeployProcessorVersionRequest const&
              request) {
        return stub->AsyncUndeployProcessorVersion(cq, std::move(context),
                                                   options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::documentai::v1::UndeployProcessorVersionResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UndeployProcessorVersion(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceConnectionImpl::CreateProcessor(
    google::cloud::documentai::v1::CreateProcessorRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateProcessor(request),
      [this](grpc::ClientContext& context,
             google::cloud::documentai::v1::CreateProcessorRequest const&
                 request) { return stub_->CreateProcessor(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::documentai::v1::DeleteProcessorMetadata>>
DocumentProcessorServiceConnectionImpl::DeleteProcessor(
    google::cloud::documentai::v1::DeleteProcessorRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::DeleteProcessorMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::documentai::v1::DeleteProcessorRequest const&
              request) {
        return stub->AsyncDeleteProcessor(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::documentai::v1::DeleteProcessorMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteProcessor(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::documentai::v1::EnableProcessorResponse>>
DocumentProcessorServiceConnectionImpl::EnableProcessor(
    google::cloud::documentai::v1::EnableProcessorRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::EnableProcessorResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::documentai::v1::EnableProcessorRequest const&
              request) {
        return stub->AsyncEnableProcessor(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::documentai::v1::EnableProcessorResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->EnableProcessor(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::documentai::v1::DisableProcessorResponse>>
DocumentProcessorServiceConnectionImpl::DisableProcessor(
    google::cloud::documentai::v1::DisableProcessorRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::DisableProcessorResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::documentai::v1::DisableProcessorRequest const&
              request) {
        return stub->AsyncDisableProcessor(cq, std::move(context), options,
                                           request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::documentai::v1::DisableProcessorResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DisableProcessor(request),
      polling_policy(*current), __func__);
}

future<
    StatusOr<google::cloud::documentai::v1::SetDefaultProcessorVersionResponse>>
DocumentProcessorServiceConnectionImpl::SetDefaultProcessorVersion(
    google::cloud::documentai::v1::SetDefaultProcessorVersionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::SetDefaultProcessorVersionResponse>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::documentai::v1::
                         SetDefaultProcessorVersionRequest const& request) {
        return stub->AsyncSetDefaultProcessorVersion(cq, std::move(context),
                                                     options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::documentai::v1::SetDefaultProcessorVersionResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetDefaultProcessorVersion(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::documentai::v1::ReviewDocumentResponse>>
DocumentProcessorServiceConnectionImpl::ReviewDocument(
    google::cloud::documentai::v1::ReviewDocumentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::ReviewDocumentResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::documentai::v1::ReviewDocumentRequest const& request) {
        return stub->AsyncReviewDocument(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::documentai::v1::ReviewDocumentResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ReviewDocument(request),
      polling_policy(*current), __func__);
}

future<
    StatusOr<google::cloud::documentai::v1::EvaluateProcessorVersionResponse>>
DocumentProcessorServiceConnectionImpl::EvaluateProcessorVersion(
    google::cloud::documentai::v1::EvaluateProcessorVersionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::documentai::v1::EvaluateProcessorVersionResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::documentai::v1::EvaluateProcessorVersionRequest const&
              request) {
        return stub->AsyncEvaluateProcessorVersion(cq, std::move(context),
                                                   options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::documentai::v1::EvaluateProcessorVersionResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->EvaluateProcessorVersion(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::documentai::v1::Evaluation>
DocumentProcessorServiceConnectionImpl::GetEvaluation(
    google::cloud::documentai::v1::GetEvaluationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEvaluation(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::documentai::v1::GetEvaluationRequest const& request) {
        return stub_->GetEvaluation(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::documentai::v1::Evaluation>
DocumentProcessorServiceConnectionImpl::ListEvaluations(
    google::cloud::documentai::v1::ListEvaluationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListEvaluations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::documentai::v1::Evaluation>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<documentai_v1::DocumentProcessorServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::documentai::v1::ListEvaluationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::documentai::v1::ListEvaluationsRequest const&
                       request) {
              return stub->ListEvaluations(context, request);
            },
            r, function_name);
      },
      [](google::cloud::documentai::v1::ListEvaluationsResponse r) {
        std::vector<google::cloud::documentai::v1::Evaluation> result(
            r.evaluations().size());
        auto& messages = *r.mutable_evaluations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace documentai_v1_internal
}  // namespace cloud
}  // namespace google
