// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/hub.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_HUB_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_HUB_CLIENT_H

#include "google/cloud/networkconnectivity/v1/hub_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace networkconnectivity_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Network Connectivity Center is a hub-and-spoke abstraction for network
/// connectivity management in Google Cloud. It reduces operational complexity
/// through a simple, centralized connectivity management model.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class HubServiceClient {
 public:
  explicit HubServiceClient(std::shared_ptr<HubServiceConnection> connection,
                            Options opts = {});
  ~HubServiceClient();

  ///@{
  /// @name Copy and move support
  HubServiceClient(HubServiceClient const&) = default;
  HubServiceClient& operator=(HubServiceClient const&) = default;
  HubServiceClient(HubServiceClient&&) = default;
  HubServiceClient& operator=(HubServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(HubServiceClient const& a, HubServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(HubServiceClient const& a, HubServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists the Network Connectivity Center hubs associated with a given project.
  ///
  /// @param parent  Required. The parent resource's name.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.Hub], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.Hub]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L338}
  /// [google.cloud.networkconnectivity.v1.ListHubsRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L667}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::Hub> ListHubs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the Network Connectivity Center hubs associated with a given project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.ListHubsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.Hub], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.Hub]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L338}
  /// [google.cloud.networkconnectivity.v1.ListHubsRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L667}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::Hub> ListHubs(
      google::cloud::networkconnectivity::v1::ListHubsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details about a Network Connectivity Center hub.
  ///
  /// @param name  Required. The name of the hub resource to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.Hub])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetHubRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L708}
  /// [google.cloud.networkconnectivity.v1.Hub]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L338}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::Hub> GetHub(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details about a Network Connectivity Center hub.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.GetHubRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.Hub])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetHubRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L708}
  /// [google.cloud.networkconnectivity.v1.Hub]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L338}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::Hub> GetHub(
      google::cloud::networkconnectivity::v1::GetHubRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Network Connectivity Center hub in the specified project.
  ///
  /// @param parent  Required. The parent resource.
  /// @param hub  Required. The initial values for a new hub.
  /// @param hub_id  Required. A unique identifier for the hub.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.Hub] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.CreateHubRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L721}
  /// [google.cloud.networkconnectivity.v1.Hub]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L338}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::Hub>> CreateHub(
      std::string const& parent,
      google::cloud::networkconnectivity::v1::Hub const& hub,
      std::string const& hub_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Network Connectivity Center hub in the specified project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.CreateHubRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.Hub] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.CreateHubRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L721}
  /// [google.cloud.networkconnectivity.v1.Hub]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L338}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::Hub>> CreateHub(
      google::cloud::networkconnectivity::v1::CreateHubRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the description and/or labels of a Network Connectivity Center
  /// hub.
  ///
  /// @param hub  Required. The state that the hub should be in after the update.
  /// @param update_mask  Optional. In the case of an update to an existing hub, field mask is used
  ///  to specify the fields to be overwritten. The fields specified in the
  ///  update_mask are relative to the resource, not the full request. A field is
  ///  overwritten if it is in the mask. If the user does not provide a mask, then
  ///  all fields are overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.Hub] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.Hub]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L338}
  /// [google.cloud.networkconnectivity.v1.UpdateHubRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L756}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::Hub>> UpdateHub(
      google::cloud::networkconnectivity::v1::Hub const& hub,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the description and/or labels of a Network Connectivity Center
  /// hub.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.UpdateHubRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.Hub] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.Hub]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L338}
  /// [google.cloud.networkconnectivity.v1.UpdateHubRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L756}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::Hub>> UpdateHub(
      google::cloud::networkconnectivity::v1::UpdateHubRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a Network Connectivity Center hub.
  ///
  /// @param name  Required. The name of the hub to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.DeleteHubRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L787}
  /// [google.cloud.networkconnectivity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/common.proto#L40}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeleteHub(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a Network Connectivity Center hub.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.DeleteHubRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.DeleteHubRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L787}
  /// [google.cloud.networkconnectivity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/common.proto#L40}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeleteHub(
      google::cloud::networkconnectivity::v1::DeleteHubRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the Network Connectivity Center spokes associated with a
  /// specified hub and location. The list includes both spokes that are attached
  /// to the hub and spokes that have been proposed but not yet accepted.
  ///
  /// @param name  Required. The name of the hub.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.Spoke], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.ListHubSpokesRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L816}
  /// [google.cloud.networkconnectivity.v1.Spoke]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L422}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::Spoke> ListHubSpokes(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Lists the Network Connectivity Center spokes associated with a
  /// specified hub and location. The list includes both spokes that are attached
  /// to the hub and spokes that have been proposed but not yet accepted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.ListHubSpokesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.Spoke], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.ListHubSpokesRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L816}
  /// [google.cloud.networkconnectivity.v1.Spoke]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L422}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::Spoke> ListHubSpokes(
      google::cloud::networkconnectivity::v1::ListHubSpokesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the Network Connectivity Center spokes in a specified project and
  /// location.
  ///
  /// @param parent  Required. The parent resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.Spoke], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.ListSpokesRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L888}
  /// [google.cloud.networkconnectivity.v1.Spoke]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L422}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::Spoke> ListSpokes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the Network Connectivity Center spokes in a specified project and
  /// location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.ListSpokesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.Spoke], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.ListSpokesRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L888}
  /// [google.cloud.networkconnectivity.v1.Spoke]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L422}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::Spoke> ListSpokes(
      google::cloud::networkconnectivity::v1::ListSpokesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details about a Network Connectivity Center spoke.
  ///
  /// @param name  Required. The name of the spoke resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.Spoke])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L927}
  /// [google.cloud.networkconnectivity.v1.Spoke]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L422}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::Spoke> GetSpoke(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details about a Network Connectivity Center spoke.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.GetSpokeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.Spoke])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L927}
  /// [google.cloud.networkconnectivity.v1.Spoke]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L422}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::Spoke> GetSpoke(
      google::cloud::networkconnectivity::v1::GetSpokeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Network Connectivity Center spoke.
  ///
  /// @param parent  Required. The parent resource.
  /// @param spoke  Required. The initial values for a new spoke.
  /// @param spoke_id  Required. Unique id for the spoke to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.Spoke] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.CreateSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L939}
  /// [google.cloud.networkconnectivity.v1.Spoke]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>> CreateSpoke(
      std::string const& parent,
      google::cloud::networkconnectivity::v1::Spoke const& spoke,
      std::string const& spoke_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a Network Connectivity Center spoke.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.CreateSpokeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.Spoke] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.CreateSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L939}
  /// [google.cloud.networkconnectivity.v1.Spoke]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>> CreateSpoke(
      google::cloud::networkconnectivity::v1::CreateSpokeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a Network Connectivity Center spoke.
  ///
  /// @param spoke  Required. The state that the spoke should be in after the update.
  /// @param update_mask  Optional. In the case of an update to an existing spoke, field mask is used
  ///  to specify the fields to be overwritten. The fields specified in the
  ///  update_mask are relative to the resource, not the full request. A field is
  ///  overwritten if it is in the mask. If the user does not provide a mask, then
  ///  all fields are overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.Spoke] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.Spoke]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L422}
  /// [google.cloud.networkconnectivity.v1.UpdateSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L974}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>> UpdateSpoke(
      google::cloud::networkconnectivity::v1::Spoke const& spoke,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a Network Connectivity Center spoke.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.UpdateSpokeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.Spoke] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.Spoke]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L422}
  /// [google.cloud.networkconnectivity.v1.UpdateSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L974}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>> UpdateSpoke(
      google::cloud::networkconnectivity::v1::UpdateSpokeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Rejects a Network Connectivity Center spoke from being attached to a hub.
  /// If the spoke was previously in the `ACTIVE` state, it
  /// transitions to the `INACTIVE` state and is no longer able to
  /// connect to other spokes that are attached to the hub.
  ///
  /// @param name  Required. The name of the hub from which to reject the spoke.
  /// @param spoke_uri  Required. The URI of the spoke to reject from the hub.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.RejectHubSpokeResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.RejectHubSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1076}
  /// [google.cloud.networkconnectivity.v1.RejectHubSpokeResponse]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1115}
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::networkconnectivity::v1::RejectHubSpokeResponse>>
  RejectHubSpoke(std::string const& name, std::string const& spoke_uri,
                 Options opts = {});

  // clang-format off
  ///
  /// Rejects a Network Connectivity Center spoke from being attached to a hub.
  /// If the spoke was previously in the `ACTIVE` state, it
  /// transitions to the `INACTIVE` state and is no longer able to
  /// connect to other spokes that are attached to the hub.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.RejectHubSpokeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.RejectHubSpokeResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.RejectHubSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1076}
  /// [google.cloud.networkconnectivity.v1.RejectHubSpokeResponse]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1115}
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::networkconnectivity::v1::RejectHubSpokeResponse>>
  RejectHubSpoke(
      google::cloud::networkconnectivity::v1::RejectHubSpokeRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Accepts a proposal to attach a Network Connectivity Center spoke
  /// to a hub.
  ///
  /// @param name  Required. The name of the hub into which to accept the spoke.
  /// @param spoke_uri  Required. The URI of the spoke to accept into the hub.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.AcceptHubSpokeResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.AcceptHubSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1033}
  /// [google.cloud.networkconnectivity.v1.AcceptHubSpokeResponse]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1069}
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::networkconnectivity::v1::AcceptHubSpokeResponse>>
  AcceptHubSpoke(std::string const& name, std::string const& spoke_uri,
                 Options opts = {});

  // clang-format off
  ///
  /// Accepts a proposal to attach a Network Connectivity Center spoke
  /// to a hub.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.AcceptHubSpokeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.AcceptHubSpokeResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.AcceptHubSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1033}
  /// [google.cloud.networkconnectivity.v1.AcceptHubSpokeResponse]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1069}
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::networkconnectivity::v1::AcceptHubSpokeResponse>>
  AcceptHubSpoke(
      google::cloud::networkconnectivity::v1::AcceptHubSpokeRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a Network Connectivity Center spoke.
  ///
  /// @param name  Required. The name of the spoke to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.DeleteSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1005}
  /// [google.cloud.networkconnectivity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/common.proto#L40}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeleteSpoke(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a Network Connectivity Center spoke.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.DeleteSpokeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.DeleteSpokeRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1005}
  /// [google.cloud.networkconnectivity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/common.proto#L40}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeleteSpoke(
      google::cloud::networkconnectivity::v1::DeleteSpokeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details about a Network Connectivity Center route table.
  ///
  /// @param name  Required. The name of the route table resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.RouteTable])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetRouteTableRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1122}
  /// [google.cloud.networkconnectivity.v1.RouteTable]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L525}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::RouteTable> GetRouteTable(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details about a Network Connectivity Center route table.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.GetRouteTableRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.RouteTable])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetRouteTableRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1122}
  /// [google.cloud.networkconnectivity.v1.RouteTable]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L525}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::RouteTable> GetRouteTable(
      google::cloud::networkconnectivity::v1::GetRouteTableRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details about the specified route.
  ///
  /// @param name  Required. The name of the route resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.Route])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetRouteRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1134}
  /// [google.cloud.networkconnectivity.v1.Route]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L564}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::Route> GetRoute(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details about the specified route.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.GetRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.Route])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetRouteRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1134}
  /// [google.cloud.networkconnectivity.v1.Route]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L564}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::Route> GetRoute(
      google::cloud::networkconnectivity::v1::GetRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists routes in a given project.
  ///
  /// @param parent  Required. The parent resource's name.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.Route], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.ListRoutesRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1147}
  /// [google.cloud.networkconnectivity.v1.Route]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L564}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::Route> ListRoutes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists routes in a given project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.ListRoutesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.Route], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.ListRoutesRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1147}
  /// [google.cloud.networkconnectivity.v1.Route]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L564}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::Route> ListRoutes(
      google::cloud::networkconnectivity::v1::ListRoutesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists route tables in a given project.
  ///
  /// @param parent  Required. The parent resource's name.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.RouteTable], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.ListRouteTablesRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1188}
  /// [google.cloud.networkconnectivity.v1.RouteTable]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L525}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::RouteTable>
  ListRouteTables(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists route tables in a given project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.ListRouteTablesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.RouteTable], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.ListRouteTablesRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1188}
  /// [google.cloud.networkconnectivity.v1.RouteTable]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L525}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::RouteTable>
  ListRouteTables(
      google::cloud::networkconnectivity::v1::ListRouteTablesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details about a Network Connectivity Center group.
  ///
  /// @param name  Required. The name of the route table resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.Group])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetGroupRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1430}
  /// [google.cloud.networkconnectivity.v1.Group]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L627}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::Group> GetGroup(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details about a Network Connectivity Center group.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.GetGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.Group])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetGroupRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1430}
  /// [google.cloud.networkconnectivity.v1.Group]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L627}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::Group> GetGroup(
      google::cloud::networkconnectivity::v1::GetGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists groups in a given hub.
  ///
  /// @param parent  Required. The parent resource's name.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.Group], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.Group]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L627}
  /// [google.cloud.networkconnectivity.v1.ListGroupsRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1229}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::Group> ListGroups(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists groups in a given hub.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.ListGroupsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.Group], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.Group]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L627}
  /// [google.cloud.networkconnectivity.v1.ListGroupsRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/hub.proto#L1229}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::Group> ListGroups(
      google::cloud::networkconnectivity::v1::ListGroupsRequest request,
      Options opts = {});

 private:
  std::shared_ptr<HubServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_HUB_CLIENT_H
