// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workstations/v1/workstations.proto

#include "google/cloud/workstations/v1/internal/workstations_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace workstations_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

WorkstationsTracingConnection::WorkstationsTracingConnection(
    std::shared_ptr<workstations_v1::WorkstationsConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::workstations::v1::WorkstationCluster>
WorkstationsTracingConnection::GetWorkstationCluster(
    google::cloud::workstations::v1::GetWorkstationClusterRequest const&
        request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::GetWorkstationCluster");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetWorkstationCluster(request));
}

StreamRange<google::cloud::workstations::v1::WorkstationCluster>
WorkstationsTracingConnection::ListWorkstationClusters(
    google::cloud::workstations::v1::ListWorkstationClustersRequest request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::ListWorkstationClusters");
  internal::OTelScope scope(span);
  auto sr = child_->ListWorkstationClusters(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::workstations::v1::WorkstationCluster>(std::move(span),
                                                           std::move(sr));
}

future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
WorkstationsTracingConnection::CreateWorkstationCluster(
    google::cloud::workstations::v1::CreateWorkstationClusterRequest const&
        request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::CreateWorkstationCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateWorkstationCluster(request));
}

future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
WorkstationsTracingConnection::UpdateWorkstationCluster(
    google::cloud::workstations::v1::UpdateWorkstationClusterRequest const&
        request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::UpdateWorkstationCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateWorkstationCluster(request));
}

future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
WorkstationsTracingConnection::DeleteWorkstationCluster(
    google::cloud::workstations::v1::DeleteWorkstationClusterRequest const&
        request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::DeleteWorkstationCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteWorkstationCluster(request));
}

StatusOr<google::cloud::workstations::v1::WorkstationConfig>
WorkstationsTracingConnection::GetWorkstationConfig(
    google::cloud::workstations::v1::GetWorkstationConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::GetWorkstationConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetWorkstationConfig(request));
}

StreamRange<google::cloud::workstations::v1::WorkstationConfig>
WorkstationsTracingConnection::ListWorkstationConfigs(
    google::cloud::workstations::v1::ListWorkstationConfigsRequest request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::ListWorkstationConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListWorkstationConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::workstations::v1::WorkstationConfig>(std::move(span),
                                                          std::move(sr));
}

StreamRange<google::cloud::workstations::v1::WorkstationConfig>
WorkstationsTracingConnection::ListUsableWorkstationConfigs(
    google::cloud::workstations::v1::ListUsableWorkstationConfigsRequest
        request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::ListUsableWorkstationConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListUsableWorkstationConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::workstations::v1::WorkstationConfig>(std::move(span),
                                                          std::move(sr));
}

future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
WorkstationsTracingConnection::CreateWorkstationConfig(
    google::cloud::workstations::v1::CreateWorkstationConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::CreateWorkstationConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateWorkstationConfig(request));
}

future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
WorkstationsTracingConnection::UpdateWorkstationConfig(
    google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::UpdateWorkstationConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateWorkstationConfig(request));
}

future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
WorkstationsTracingConnection::DeleteWorkstationConfig(
    google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::DeleteWorkstationConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteWorkstationConfig(request));
}

StatusOr<google::cloud::workstations::v1::Workstation>
WorkstationsTracingConnection::GetWorkstation(
    google::cloud::workstations::v1::GetWorkstationRequest const& request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::GetWorkstation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetWorkstation(request));
}

StreamRange<google::cloud::workstations::v1::Workstation>
WorkstationsTracingConnection::ListWorkstations(
    google::cloud::workstations::v1::ListWorkstationsRequest request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::ListWorkstations");
  internal::OTelScope scope(span);
  auto sr = child_->ListWorkstations(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::workstations::v1::Workstation>(std::move(span),
                                                    std::move(sr));
}

StreamRange<google::cloud::workstations::v1::Workstation>
WorkstationsTracingConnection::ListUsableWorkstations(
    google::cloud::workstations::v1::ListUsableWorkstationsRequest request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::ListUsableWorkstations");
  internal::OTelScope scope(span);
  auto sr = child_->ListUsableWorkstations(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::workstations::v1::Workstation>(std::move(span),
                                                    std::move(sr));
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsTracingConnection::CreateWorkstation(
    google::cloud::workstations::v1::CreateWorkstationRequest const& request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::CreateWorkstation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateWorkstation(request));
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsTracingConnection::UpdateWorkstation(
    google::cloud::workstations::v1::UpdateWorkstationRequest const& request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::UpdateWorkstation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateWorkstation(request));
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsTracingConnection::DeleteWorkstation(
    google::cloud::workstations::v1::DeleteWorkstationRequest const& request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::DeleteWorkstation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteWorkstation(request));
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsTracingConnection::StartWorkstation(
    google::cloud::workstations::v1::StartWorkstationRequest const& request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::StartWorkstation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StartWorkstation(request));
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsTracingConnection::StopWorkstation(
    google::cloud::workstations::v1::StopWorkstationRequest const& request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::StopWorkstation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StopWorkstation(request));
}

StatusOr<google::cloud::workstations::v1::GenerateAccessTokenResponse>
WorkstationsTracingConnection::GenerateAccessToken(
    google::cloud::workstations::v1::GenerateAccessTokenRequest const&
        request) {
  auto span = internal::MakeSpan(
      "workstations_v1::WorkstationsConnection::GenerateAccessToken");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GenerateAccessToken(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<workstations_v1::WorkstationsConnection>
MakeWorkstationsTracingConnection(
    std::shared_ptr<workstations_v1::WorkstationsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<WorkstationsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workstations_v1_internal
}  // namespace cloud
}  // namespace google
