/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.decorations.PolygonBoundaryDecoration;
import org.xmind.ui.mindmap.IBoundaryPart;

public class RoundedPolygonBoundaryDecoration
extends PolygonBoundaryDecoration
implements ICorneredDecoration {
    private static final float CORNER_CONTROL_RATIO = 0.447715f;
    private IBoundaryPart boundary;
    private int cornerSize = 0;

    public RoundedPolygonBoundaryDecoration() {
    }

    public RoundedPolygonBoundaryDecoration(IBoundaryPart boundary, String id) {
        super(id);
        this.boundary = boundary;
    }

    @Override
    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        List<Point> points = this.calcPathPoints(box, this.boundary);
        int c = this.getAppliedCornerSize();
        if (points.size() > 4) {
            if (c == 0) {
                shape.moveTo(points.get(0));
                int i = 1;
                while (i < points.size()) {
                    shape.lineTo(points.get(i));
                    ++i;
                }
                shape.lineTo(points.get(0));
                shape.close();
            } else {
                Point c2;
                Point c1;
                Point p0 = this.calcRoundedPoint(points.get(0), points.get(points.size() - 1), c);
                Point p1 = null;
                shape.moveTo(p0);
                int i = 0;
                while (i < points.size() - 1) {
                    p1 = this.calcRoundedPoint(points.get(i), points.get(i + 1), c);
                    c1 = this.calcControlPoint(p0, points.get(i));
                    c2 = this.calcControlPoint(p1, points.get(i));
                    shape.cubicTo(c1, c2, p1);
                    p0 = this.calcRoundedPoint(points.get(i + 1), points.get(i), c);
                    shape.lineTo(p0);
                    ++i;
                }
                p1 = this.calcRoundedPoint(points.get(points.size() - 1), points.get(0), c);
                c1 = this.calcControlPoint(p0, points.get(points.size() - 1));
                c2 = this.calcControlPoint(p1, points.get(points.size() - 1));
                shape.cubicTo(c1, c2, p1);
                p0 = this.calcRoundedPoint(points.get(0), points.get(points.size() - 1), c);
                shape.lineTo(p0);
                shape.close();
            }
        } else if (c == 0) {
            shape.addRectangle(box);
        } else {
            shape.addRoundedRectangle(box, (float)c);
        }
    }

    private Point calcRoundedPoint(Point p1, Point p2, int corner) {
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        if (dx == 0) {
            if (dy > 0) {
                return p1.getTranslated(0, corner);
            }
            return p1.getTranslated(0, -corner);
        }
        if (dy == 0) {
            if (dx > 0) {
                return p1.getTranslated(corner, 0);
            }
            return p1.getTranslated(-corner, 0);
        }
        double l = p1.getDistance(p2);
        double x = (double)dx / l * (double)corner;
        double y = (double)dy / l * (double)corner;
        return p1.getTranslated(x, y);
    }

    private Point calcControlPoint(Point p1, Point p2) {
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        return p1.getTranslated(dx * (double)0.447715f, dy * (double)0.447715f);
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    private int getAppliedCornerSize() {
        return this.getCornerSize();
    }

    public void setCornerSize(IFigure figure, int cornerSize) {
        if (cornerSize == this.cornerSize) {
            return;
        }
        this.cornerSize = cornerSize;
        this.invalidate();
        if (figure != null) {
            figure.revalidate();
            figure.repaint();
        }
    }
}

