;;;; cnepspng.el
;;;; Created LDF 2003.12.16.
  
;;;; This file is part of 3DLDF, a package for three-dimensional drawing. 
;;;; Copyright (C) 2003, 2004 Laurence D. Finston. 

;;;; 3DLDF is free software; you can redistribute it and/or modify 
;;;; it under the terms of the GNU General Public License as published by 
;;;; the Free Software Foundation; either version 2 of the License, or 
;;;; (at your option) any later version. 

;;;; 3DLDF is distributed in the hope that it will be useful, 
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of 
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
;;;; GNU General Public License for more details. 

;;;; You should have received a copy of the GNU General Public License 
;;;; along with 3DLDF; if not, write to the Free Software 
;;;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 

;;;; 3DLDF is a GNU package.  
;;;; It is part of the GNU Project of the  
;;;; Free Software Foundation 
;;;; and is published under the GNU General Public License. 
;;;; See the website http://www.gnu.org 
;;;; for more information.   
;;;; 3DLDF is available for downloading from 
;;;; http://www.gnu.org/3DLDF. 
;;;; It is also available from 
;;;; http://www.dante.de/software/ctan/, the Dante www-server  
;;;; and from http://wwwuser.gwdg.de/~lfinsto1, 
;;;; the author's website.  

;;;; Please send bug reports to bug-3DLDF@gnu.org 
;;;; The mailing list help-3DLDF@gnu.org is available for people to 
;;;; ask other users for help.  
;;;; The mailing list info-3DLDF@gnu.org is for sending 
;;;; announcements to users. To subscribe to these mailing lists, send an 
;;;; email with ``subscribe <email-address>'' as the subject.  

;;;; The author can be contacted at: 

;;;; Laurence D. Finston 
;;;; Kreuzbergring 41 
;;;; D-37075 Goettingen 
;;;; Germany 

;;;; lfinsto1@gwdg.de 
;;;; s246794@stud.uni-goettingen.de 


;; (local-set-key [C-kp-begin] 'convert-eps)
;; (local-set-key [C-kp-right] 'convert-eps-loop)  

(defun convert-eps (filename do-not-delete-files)
  "convert-eps converts an Encapsulated PostScript (EPS) file to a 
structured PostScript (PS) file and a Portable Network Graphics (PNG) file.
It is used for converting the EPS files generated by MetaPost to PS and PNG files 
of the same size and shape and using the same fonts.  This function is needed 
because the Computer Modern fonts are not used when `prologues' is set to 1 
in the MetaPost file.

If called interactively, convert-eps prompts for a filename with 
its extension.

If do-not-delete-files is nil, the .tex, .dvi, and .log files 
will be deleted.  This is the case when convert-eps is called 
interactively with no prefix argument.
If convert-eps is called interactively with a prefix
argument, or non-interactively with a non-nil 
do-not-delete-files argument, these files will not be deleted."

  (interactive   "fEnter a filename or type <RETURN> to convert this file: 
P")
  
  (let (tex-filename dvi-filename log-filename ps-filename png-filename)

    (setq filename (file-name-nondirectory filename))

    (setq tex-filename (concat filename "_.tex"))
    (setq dvi-filename (concat filename "_.dvi"))
    (setq log-filename (concat filename "_.log"))
    (setq ps-filename (concat filename ".ps"))
    (setq png-filename (concat filename ".png"))

    (find-file-other-window tex-filename)
    (erase-buffer)
    (insert (concat "\\advance\\voffset by -1in
\\advance\\hoffset by -1in
\\nopagenumbers
\\input epsf
\\epsfverbosetrue
\\def\\epsfsize#1#2{#1}\n\n
\\setbox0=\\vbox{\\epsffile{" filename "}}
\\vsize=\\ht0
\\hsize=\\wd0
\\special{papersize=\\the\\wd0,\\the\\ht0}
\\box0\n\\bye\n"))

    (save-buffer)
    (kill-buffer nil)
    (shell-command (concat "clear && tex " tex-filename 
			   " && dvips -o " ps-filename " " dvi-filename
			   " && convert " ps-filename " " png-filename))

    (if do-not-delete-files
	(progn
	  (message "Not deleting generated files")
	  )
      ;; else
      (progn
	(message "Deleting generated files")
	(delete-file tex-filename)
	(delete-file dvi-filename)
	(delete-file log-filename)
	) 
      ) ;; if
    (sit-for 2)
    (message nil)
    )  ;; let
  ) ;; defun convert-eps
   
(defun convert-eps-loop (arg start end do-not-delete-files)
  "convert-eps-loop converts a set of EPS image files to the PS and PNG formats.  
The files must all have the same filename, and the extensions must form a range of
positive integers.  

If called interactively, convert-eps-loop prompts for `filename' 
with no extension, and the starting and ending numbers of the range.  

For all integers i such that start <= i <= end, convert-eps-loop checks 
whether a file named `filename.i' exists.  If it does, it calls 
convert-eps, passing `filename.i' as the latter's filename argument. 

do-not-delete-files is also passed to convert-eps.  
If it's nil, the .tex, .dvi, and .log files will be deleted. 
This is the case when convert-eps-loop is called interactively 
with no prefix argument.
If convert-eps-loop is called interactively with a prefix
argument, or non-interactively with a non-nil 
do-not-delete-files argument, these files will not be deleted."

  (interactive "MEnter a filename: 
nStart: 
nEnd: 
P")
  
(if (or (not (eq start (truncate start)))
	(not (eq end (truncate end))))
    (progn
      (message "ERROR! start or end isn't an integer!")
      (sit-for 2)
      ) ;; then progn
  ;; else
  (progn
    (message (concat "Start: " (number-to-string start)))
    (sit-for 1)
    (message (concat "End: " (number-to-string end)))
    (while (<= start end)
      (setq filename (concat arg "." (number-to-string start)))
      (if (file-exists-p filename)
	  (convert-eps filename do-not-delete-files)
	;; else
	(progn
	  (message (concat filename " doesn't exist"))
	  (sit-for 1)
	  (message nil)
	  ) ;; else progn
	)
      (setq start (1+ start))
      );; while
    ) ;; else progn
  ) ;; if
) ;; defun convert-eps-loop

 




