/*
 * Electric(tm) VLSI Design System
 *
 * File: network.h
 * Network tool: header file for fully instantiated networks
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

extern INTBIG      net_use_port_nameskey;		/* key for "NET_use_port_names" */
extern INTBIG      net_compare_hierarchykey;	/* key for "NET_compare_hierarchy" */
extern INTBIG      net_unify_port_nameskey;		/* key for "NET_unify_port_names" */
extern AIDENTRY   *net_aid;						/* the aid objects */
extern INTSML      net_debug;					/* nonzero for debugging */

/*********************** EQUIVALENCE MODULES ***********************/

#define	NOEQUIV ((EQUIV *)-1)

typedef struct Iequiv
{
	NODEINST      *first;					/* component */
	NODEINST      *second;					/* component */
	struct Iequiv *nextequiv;				/* next in list */
} EQUIV;

extern EQUIV *net_firstequiv;

/*********************** PCOMP MODULES ***********************/

#define	NOPCOMP ((PCOMP *)-1)

/* meaning of PCOMP->state */
#define	NEGATEDPORT  1				/* if port is negated */
#define	EXPORTEDPORT 2				/* if port is exported */

typedef struct Ipcomp
{
	NODEINST       *actual;			/* actual component */
	NODEINST       *topactual;		/* actual component at topmost level */
	INTSML          function;		/* component function */
	INTBIG          id;				/* local data for component */
	INTSML          wirecount;		/* number of unconnected ports (wires) */
	PORTPROTO     **portlist;		/* PORTPROTOs on each wire */
	struct Ipnet  **netnumbers;		/* initial netnumbers for each wire */
	INTSML         *state;			/* information about the connection */
	INTSML         *count;			/* connection count on each wire */
	struct Ipconn **pconnlist;		/* array of connections */
	struct Ipcomp  *nextinbucket;	/* next in bucket list */
	struct Ipcomp  *nextpcomp;		/* next in list of pseudocomponents */
} PCOMP;
extern PCOMP *net_pcompfree;

/*********************** PNET MODULES ***********************/

#define	NOPNET ((PNET *)-1)

/* meaning of PNET->flags */
#define	POWERNET    1				/* if net is power */
#define	GROUNDNET   2				/* if net is ground */
#define	EXPORTEDNET 4				/* if net is exported */

typedef struct Ipnet
{
	INTSML         flags;			/* state bits */
	PORTPROTO     *realport;		/* top-level port on this net (if any) */
	struct Ipnet  *nextpnet;		/* next in list */
} PNET;
extern PNET *net_pnetfree;

/*********************** PCONN MODULES ***********************/

#define	NOPCONN ((PCONN *)-1)

typedef struct Ipconn
{
	PCOMP         *pcomp;			/* component on this net */
	struct Ipconn *nextpconn;		/* next in list */
} PCONN;
extern PCONN *net_pconnfree;

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* prototypes for tool interface */
void net_init(INTBIG*, char*[], AIDENTRY*);
void net_done(void);
INTSML net_set(INTSML, char*[]);
INTBIG net_request(char*, va_list);
void net_examinenodeproto(NODEPROTO*);
void net_startbatch(AIDENTRY*, INTSML);
void net_endbatch(void);
void net_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void net_newobject(INTBIG, INTBIG);
void net_killobject(INTBIG, INTBIG);
void net_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void net_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void net_readlibrary(LIBRARY*);

/* prototypes for intratool interface */
INTSML   net_getfunction(NODEINST*);
NETWORK *net_gethighlightednet(INTSML, INTSML);
void     net_freeallpcomp(PCOMP*);
void     net_freeallpnet(PNET*);
PCOMP   *net_makepseudo(NODEPROTO*, INTSML*, INTSML*, INTSML*, INTSML*, PNET**,
			INTSML, INTSML, INTSML);
INTSML   net_equate(INTSML);
INTSML   net_compare(void);
INTSML   net_setfirst(void);
INTSML   net_setsecond(void);
INTSML   net_setequiv(void);
INTSML   net_clearequiv(void);
INTSML   net_buswidth(char*);
void     net_reevaluatefacet(NODEPROTO*);
INTSML   net_evalbusname(INTBIG, char*, char***, ARCINST*, NODEPROTO*, INTSML);
void     net_freediffmemory(void);
void     net_freeflatmemory(void);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
