/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PolyQTree {
    private static int MAX_NUM_CHILDREN = 4;
    private static int MAX_DEPTH = 10;
    private HashMap layers = new HashMap();
    private Rectangle2D rootBox;

    public PolyQTree(Rectangle2D root) {
        this.rootBox = root;
    }

    public void print() {
        Iterator it = this.getIterator();
        while (it.hasNext()) {
            PolyQNode root = (PolyQNode)it.next();
            if (root == null) continue;
            root.print();
        }
    }

    public Iterator getKeyIterator() {
        return this.layers.keySet().iterator();
    }

    public Iterator getIterator() {
        return this.layers.values().iterator();
    }

    public Set getObjects(Object layer, boolean modified) {
        HashSet objSet = new HashSet();
        PolyQNode root = (PolyQNode)this.layers.get(layer);
        if (root != null) {
            root.getLeafObjects(objSet, modified);
        }
        return objSet;
    }

    public void insert(Object layer, PolyNode obj) {
        Rectangle2D areaBB;
        boolean done;
        PolyQNode root = (PolyQNode)this.layers.get(layer);
        if (root == null) {
            root = new PolyQNode();
            this.layers.put(layer, root);
        }
        if (!(done = root.findAndRemoveObjects(this.rootBox, obj, areaBB = obj.getBounds2D()))) {
            done = root.insert(this.rootBox, obj, areaBB);
        }
        if (!done) {
            System.out.println("Repeated element?");
        }
    }

    public void insert(PolyQTree other, AffineTransform trans) {
        Iterator it = other.layers.keySet().iterator();
        while (it.hasNext()) {
            Object layer = it.next();
            Set set = other.getObjects(layer, false);
            Iterator i = set.iterator();
            while (i.hasNext()) {
                PolyNode geo = (PolyNode)i.next();
                geo.transform(trans);
                this.insert(layer, geo);
            }
        }
    }

    private static class PolyQNode {
        private Set nodes;
        private PolyQNode[] children;

        private PolyQNode() {
        }

        private int getQuadrants(double centerX, double centerY, Rectangle2D box) {
            int loc = 0;
            if (box.getMinY() < centerY) {
                if (box.getMinX() < centerX) {
                    loc |= 1;
                }
                if (box.getMaxX() > centerX) {
                    loc |= 2;
                }
            }
            if (box.getMaxY() > centerY) {
                if (box.getMinX() < centerX) {
                    loc |= 4;
                }
                if (box.getMaxX() > centerX) {
                    loc |= 8;
                }
            }
            return loc;
        }

        private Rectangle2D getBox(double x, double y, double w, double h, double centerX, double centerY, int loc) {
            if ((loc >> 0 & 1) == 1) {
                x = centerX;
            }
            if ((loc >> 1 & 1) == 1) {
                y = centerY;
            }
            return new Rectangle2D.Double(x, y, w, h);
        }

        protected void getLeafObjects(Set set, boolean modified) {
            if (this.nodes != null) {
                Iterator it = this.nodes.iterator();
                while (it.hasNext()) {
                    PolyNode node = (PolyNode)it.next();
                    if (modified && (!modified || node.isOriginal())) continue;
                    set.add(node);
                }
            }
            if (this.children == null) {
                return;
            }
            for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].getLeafObjects(set, modified);
            }
        }

        protected void print() {
            if (this.nodes == null) {
                return;
            }
            Iterator it = this.nodes.iterator();
            while (it.hasNext()) {
                System.out.println("Area " + it.next());
            }
            if (this.children == null) {
                return;
            }
            for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].print();
            }
        }

        private boolean compact() {
            if (this.children != null) {
                for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                    if (this.children[i] == null) continue;
                    return false;
                }
            }
            return this.nodes == null || this.nodes.isEmpty();
        }

        private static boolean intersects(Rectangle2D a, Rectangle2D b) {
            double x = b.getX();
            double y = b.getY();
            double w = b.getWidth();
            double h = b.getHeight();
            if (a.isEmpty() || w <= 0.0 || h <= 0.0) {
                return false;
            }
            double x0 = a.getX();
            double y0 = a.getY();
            return x + w >= x0 && y + h >= y0 && x <= x0 + a.getWidth() && y <= y0 + a.getHeight();
        }

        protected boolean findAndRemoveObjects(Rectangle2D box, PolyNode obj, Rectangle2D areaBB) {
            double centerX = box.getCenterX();
            double centerY = box.getCenterY();
            if (this.children != null) {
                int loc = this.getQuadrants(centerX, centerY, areaBB);
                double w = box.getWidth() / 2.0;
                double h = box.getHeight() / 2.0;
                double x = box.getX();
                double y = box.getY();
                for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                    if ((loc >> i & 1) != 1) continue;
                    Rectangle2D bb = this.getBox(x, y, w, h, centerX, centerY, i);
                    if (this.children[i] == null) continue;
                    if (this.children[i].findAndRemoveObjects(bb, obj, areaBB)) {
                        return true;
                    }
                    if (!this.children[i].compact()) continue;
                    this.children[i] = null;
                }
            } else if (this.nodes != null) {
                ArrayList<PolyNode> deleteList = new ArrayList<PolyNode>();
                Iterator it = this.nodes.iterator();
                while (it.hasNext()) {
                    PolyNode node = (PolyNode)it.next();
                    if (node.equals(obj)) {
                        return true;
                    }
                    if (!node.intersects(obj)) continue;
                    obj.add(node);
                    obj.setNotOriginal();
                    deleteList.add(node);
                }
                this.nodes.removeAll(deleteList);
                if (this.nodes.size() == 0) {
                    this.nodes.clear();
                    this.nodes = null;
                }
            }
            return false;
        }

        protected boolean insertInAllChildren(Rectangle2D box, double centerX, double centerY, PolyNode obj, Rectangle2D areaBB) {
            int loc = this.getQuadrants(centerX, centerY, areaBB);
            boolean inserted = false;
            double w = box.getWidth() / 2.0;
            double h = box.getHeight() / 2.0;
            double x = box.getX();
            double y = box.getY();
            for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                if ((loc >> i & 1) != 1) continue;
                Rectangle2D bb = this.getBox(x, y, w, h, centerX, centerY, i);
                if (this.children[i] == null) {
                    this.children[i] = new PolyQNode();
                }
                boolean done = this.children[i].insert(bb, obj, areaBB);
                inserted = inserted ? inserted : done;
            }
            return inserted;
        }

        protected boolean insert(Rectangle2D box, PolyNode obj, Rectangle2D areaBB) {
            if (!box.intersects(areaBB)) {
                return false;
            }
            double centerX = box.getCenterX();
            double centerY = box.getCenterY();
            if (this.children != null) {
                return this.insertInAllChildren(box, centerX, centerY, obj, areaBB);
            }
            if (this.nodes == null) {
                this.nodes = new HashSet();
            }
            boolean inserted = false;
            if (this.nodes.size() < MAX_NUM_CHILDREN) {
                inserted = this.nodes.add(obj);
            } else {
                this.children = new PolyQNode[MAX_NUM_CHILDREN];
                double w = box.getWidth() / 2.0;
                double h = box.getHeight() / 2.0;
                double x = box.getX();
                double y = box.getY();
                for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                    this.children[i] = new PolyQNode();
                    Rectangle2D bb = this.getBox(x, y, w, h, centerX, centerY, i);
                    Iterator it = this.nodes.iterator();
                    while (it.hasNext()) {
                        PolyNode node = (PolyNode)it.next();
                        this.children[i].insert(bb, node, node.getBounds2D());
                    }
                }
                this.nodes.clear();
                this.nodes = null;
                inserted = this.insertInAllChildren(box, centerX, centerY, obj, areaBB);
            }
            return inserted;
        }
    }

    public static class PolyNode
    extends Area {
        private byte original;

        public PolyNode(Shape shape) {
            super(shape);
        }

        public Point2D[] getPoints() {
            PathIterator pi = this.getPathIterator(null);
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        break;
                    }
                    default: {
                        Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            Point2D[] points = new Point2D[pointList.size()];
            return pointList.toArray(points);
        }

        public double getPerimeter() {
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            double perimeter = 0.0;
            PathIterator pi = this.getPathIterator(null);
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        Object[] points = pointList.toArray();
                        for (int i = 0; i < pointList.size(); ++i) {
                            int j = (i + 1) % pointList.size();
                            perimeter += ((Point2D)points[i]).distance((Point2D)points[j]);
                        }
                        pointList.clear();
                        break;
                    }
                    default: {
                        Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            return perimeter;
        }

        public double getArea() {
            if (this.isRectangular()) {
                Rectangle2D bounds = this.getBounds2D();
                return bounds.getHeight() * bounds.getWidth();
            }
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            double area = 0.0;
            PathIterator pi = this.getPathIterator(null);
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        Object[] points = pointList.toArray();
                        for (int i = 0; i < pointList.size(); ++i) {
                            int j = (i + 1) % pointList.size();
                            area += ((Point2D)points[i]).getX() * ((Point2D)points[j]).getY();
                            area -= ((Point2D)points[j]).getX() * ((Point2D)points[i]).getY();
                        }
                        pointList.clear();
                        break;
                    }
                    default: {
                        Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            return (area /= 2.0) < 0.0 ? -area : area;
        }

        public String toString() {
            return "PolyNode " + this.getBounds();
        }

        public boolean intersects(Area a) {
            if (a.isRectangular()) {
                return this.intersects(a.getBounds2D());
            }
            if (this.isRectangular()) {
                return a.intersects(this.getBounds2D());
            }
            Area area = (Area)this.clone();
            area.intersect(a);
            boolean inter = !area.isEmpty();
            return inter;
        }

        private boolean isOriginal() {
            boolean value = (this.original >> 0 & 1) == 0;
            return (this.original >> 0 & 1) == 0;
        }

        private void setNotOriginal() {
            this.original = (byte)(this.original | 1);
        }
    }
}

