/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class PortInst
extends ElectricObject {
    private NodeInst nodeInst;
    private PortProto portProto;

    private PortInst() {
    }

    public static PortInst newInstance(PortProto portProto, NodeInst nodeInst) {
        PortInst pi = new PortInst();
        pi.portProto = portProto;
        pi.nodeInst = nodeInst;
        return pi;
    }

    public NodeInst getNodeInst() {
        return this.nodeInst;
    }

    public PortProto getPortProto() {
        return this.portProto;
    }

    public final int getPortIndex() {
        return this.portProto.getPortIndex();
    }

    public Iterator getConnections() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Iterator it = this.nodeInst.getConnections();
        while (it.hasNext()) {
            Connection c = (Connection)it.next();
            if (c.getPortInst() != this) continue;
            connections.add(c);
        }
        return connections.iterator();
    }

    public PortProto getProtoEquivalent() {
        return this.portProto.getEquivalent();
    }

    public Rectangle2D getBounds() {
        Rectangle2D r = this.nodeInst.getShapeOfPort(this.portProto).getBounds2D();
        return r;
    }

    public Poly getPoly() {
        return this.nodeInst.getShapeOfPort(this.portProto);
    }

    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow wnd, boolean multipleStrings) {
        if (super.numDisplayableVariables(multipleStrings) == 0) {
            return 0;
        }
        Poly portPoly = this.getPoly();
        int justAdded = super.addDisplayableVariables(portPoly.getBounds2D(), polys, start, wnd, multipleStrings);
        for (int i = 0; i < justAdded; ++i) {
            polys[start + i].setPort(this.getPortProto());
        }
        return justAdded;
    }

    public String describe() {
        return this.nodeInst.describe() + "." + this.portProto.getName();
    }

    public String toString() {
        return "PortInst " + this.describe();
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Poly noPoly;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PortInst no = (PortInst)obj;
        Iterator it = this.getConnections();
        Iterator noIt = no.getConnections();
        Poly poly = this.getPoly();
        boolean check = poly.compare(noPoly = no.getPoly(), buffer);
        if (!check && buffer != null) {
            buffer.append("No same ports detected in " + this.portProto.getName() + " and " + no.getPortProto().getName() + "\n");
        }
        return check;
    }
}

