/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.Simulation;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class VerilogOut
extends Simulate {
    private String lastLine = null;
    private int linePos;
    private int lineLen;

    VerilogOut() {
    }

    protected Simulation.SimData readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        if (this.openTextInput(fileURL)) {
            return null;
        }
        VerilogOut.startProgressDialog("Verilog output", fileURL.getFile());
        Simulation.SimData sd = this.readVerilogFile(cell);
        VerilogOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private Simulation.SimData readVerilogFile(Cell cell) throws IOException {
        String keyword;
        Simulation.SimData sd = new Simulation.SimData();
        sd.setCell(cell);
        double timeScale = 1.0;
        String currentScope = "";
        int curLevel = 0;
        int numSignals = 0;
        HashMap symbolTable = new HashMap();
        ArrayList<Simulation.SimDigitalSignal> curArray = null;
        while ((keyword = this.getNextKeyword()) != null) {
            String currentLine;
            Simulation.SimDigitalSignal sig;
            if (keyword.equals("$date") || keyword.equals("$version")) {
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$timescale")) {
                String units = this.getNextKeyword();
                timeScale = TextUtils.atof(units);
                if (units.endsWith("ms")) {
                    timeScale /= 1000.0;
                } else if (units.endsWith("us")) {
                    timeScale /= 1000000.0;
                } else if (units.endsWith("ns")) {
                    timeScale /= 1.0E9;
                } else if (units.endsWith("ps")) {
                    timeScale /= 1.0E12;
                } else if (units.endsWith("fs")) {
                    timeScale /= 1.0E15;
                }
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$scope")) {
                String scope = this.getNextKeyword();
                if (scope == null) break;
                if (scope.equals("module") || scope.equals("task") || scope.equals("function")) {
                    this.cleanUpScope(curArray, sd);
                    curArray = new ArrayList<Simulation.SimDigitalSignal>();
                    String scopeName = this.getNextKeyword();
                    if (scopeName == null) break;
                    if (currentScope.length() > 0) {
                        currentScope = currentScope + ".";
                    }
                    currentScope = currentScope + scopeName;
                    ++curLevel;
                    curArray = new ArrayList();
                }
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$upscope")) {
                if (curLevel <= 0 || currentScope.length() == 0) {
                    System.out.println("Unbalanced $upscope on line " + this.lineReader.getLineNumber());
                    continue;
                }
                this.cleanUpScope(curArray, sd);
                curArray = new ArrayList();
                int dotPos = currentScope.lastIndexOf(46);
                if (dotPos >= 0) {
                    currentScope = currentScope.substring(0, dotPos);
                    --curLevel;
                }
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$var")) {
                String index;
                String signalName;
                String varName = this.getNextKeyword();
                if (varName == null) break;
                if (!varName.equals("wire") && !varName.equals("reg") && !varName.equals("supply0") && !varName.equals("supply1") && !varName.equals("parameter") && !varName.equals("trireg")) continue;
                String widthText = this.getNextKeyword();
                if (widthText == null) break;
                int width = TextUtils.atoi(widthText);
                String symbol = this.getNextKeyword();
                if (symbol == null || (signalName = this.getNextKeyword()) == null || (index = this.getNextKeyword()) == null) break;
                if (index.equals("$end")) {
                    index = "";
                } else {
                    this.parseToEnd();
                }
                ++numSignals;
                sig = new Simulation.SimDigitalSignal(null);
                sig.setSignalName(signalName + index);
                sig.setSignalContext(currentScope);
                sig.tempList = new ArrayList();
                if (index.length() > 0 && width == 1) {
                    curArray.add(sig);
                } else {
                    sd.addSignal(sig);
                }
                if (width > 1) {
                    sig.buildBussedSignalList();
                    for (int i = 0; i < width; ++i) {
                        Simulation.SimDigitalSignal subSig = new Simulation.SimDigitalSignal(null);
                        subSig.setSignalName(signalName + "[" + i + "]");
                        subSig.setSignalContext(currentScope);
                        subSig.tempList = new ArrayList();
                        sig.addToBussedSignalList(subSig);
                        this.addSignalToHashMap(subSig, symbol + "[" + i + "]", symbolTable);
                        ++numSignals;
                    }
                }
                this.addSignalToHashMap(sig, symbol, symbolTable);
                continue;
            }
            if (keyword.equals("$enddefinitions")) {
                this.parseToEnd();
                System.out.println("Found " + numSignals + " signal names");
                continue;
            }
            if (!keyword.equals("$dumpvars")) continue;
            double curTime = 0.0;
            while ((currentLine = this.getLineFromSimulator()) != null) {
                char chr = currentLine.charAt(0);
                String restOfLine = currentLine.substring(1);
                if (chr == '0' || chr == '1' || chr == 'x' || chr == 'z') {
                    Object entry = symbolTable.get(restOfLine);
                    if (entry == null) {
                        System.out.println("Unknown symbol '" + restOfLine + "' on line " + this.lineReader.getLineNumber());
                        continue;
                    }
                    if (entry instanceof List) {
                        entry = ((List)entry).get(0);
                    }
                    sig = (Simulation.SimDigitalSignal)entry;
                    int state = 0;
                    switch (chr) {
                        case '0': {
                            state = 8;
                            break;
                        }
                        case '1': {
                            state = 10;
                            break;
                        }
                        case 'x': {
                            state = 9;
                            break;
                        }
                        case 'z': {
                            state = 11;
                        }
                    }
                    VerilogStimuli vs = new VerilogStimuli(curTime, state);
                    sig.tempList.add(vs);
                    continue;
                }
                if (chr == '$') {
                    if (restOfLine.equals("end")) continue;
                    System.out.println("Unknown directive on line " + this.lineReader.getLineNumber() + ": " + currentLine);
                    continue;
                }
                if (chr == '#') {
                    curTime = (double)TextUtils.atoi(restOfLine) * timeScale;
                    continue;
                }
                if (chr == 'b') {
                    int spacePos = restOfLine.indexOf(32);
                    if (spacePos < 0) {
                        System.out.println("Bus has missing signal name on line " + this.lineReader.getLineNumber() + ": " + currentLine);
                        continue;
                    }
                    String symName = restOfLine.substring(spacePos + 1);
                    Object entry = symbolTable.get(symName);
                    if (entry == null) {
                        System.out.println("Unknown symbol '" + symName + "' on line " + this.lineReader.getLineNumber());
                        continue;
                    }
                    if (entry instanceof List) {
                        entry = ((List)entry).get(0);
                    }
                    Simulation.SimDigitalSignal sig2 = (Simulation.SimDigitalSignal)entry;
                    int i = 0;
                    Iterator it = sig2.getBussedSignals().iterator();
                    while (it.hasNext()) {
                        Simulation.SimDigitalSignal subSig = (Simulation.SimDigitalSignal)it.next();
                        char bit = restOfLine.charAt(i++);
                        int state = 0;
                        switch (bit) {
                            case '0': {
                                state = 8;
                                break;
                            }
                            case '1': {
                                state = 10;
                                break;
                            }
                            case 'x': {
                                state = 9;
                                break;
                            }
                            case 'z': {
                                state = 11;
                            }
                        }
                        VerilogStimuli vs = new VerilogStimuli(curTime, state);
                        subSig.tempList.add(vs);
                    }
                    continue;
                }
                System.out.println("Unknown stimulus on line " + this.lineReader.getLineNumber() + ": " + currentLine);
            }
        }
        Iterator it = symbolTable.values().iterator();
        while (it.hasNext()) {
            Object entry = it.next();
            List fullList = null;
            if (entry instanceof List) {
                fullList = (List)entry;
                entry = fullList.get(0);
            }
            Simulation.SimDigitalSignal sig = (Simulation.SimDigitalSignal)entry;
            int numStimuli = sig.tempList.size();
            if (numStimuli == 0) continue;
            sig.buildTime(numStimuli);
            sig.buildState(numStimuli);
            int i = 0;
            Iterator sIt = sig.tempList.iterator();
            while (sIt.hasNext()) {
                VerilogStimuli vs = (VerilogStimuli)sIt.next();
                sig.setCommonTimeUse(false);
                sig.setTime(i, vs.time);
                sig.setState(i, vs.state);
                ++i;
            }
            sig.tempList = null;
            if (fullList == null) continue;
            Iterator lIt = fullList.iterator();
            while (lIt.hasNext()) {
                Simulation.SimDigitalSignal oSig = (Simulation.SimDigitalSignal)lIt.next();
                if (oSig.getTimeVector() == null) {
                    oSig.setTimeVector(sig.getTimeVector());
                }
                if (oSig.getStateVector() == null) {
                    oSig.setStateVector(sig.getStateVector());
                }
                oSig.setCommonTimeUse(false);
            }
        }
        String singularPrefix = null;
        Iterator it2 = sd.getSignals().iterator();
        while (it2.hasNext()) {
            Simulation.SimSignal sSig = (Simulation.SimSignal)it2.next();
            String context = sSig.getSignalContext();
            if (context == null) {
                singularPrefix = null;
                break;
            }
            int dotPos = context.indexOf(46);
            if (dotPos >= 0) {
                context = context.substring(0, dotPos);
            }
            if (singularPrefix == null) {
                singularPrefix = context;
                continue;
            }
            if (singularPrefix.equals(context)) continue;
            singularPrefix = null;
            break;
        }
        if (singularPrefix != null) {
            int len = singularPrefix.length();
            Iterator it3 = sd.getSignals().iterator();
            while (it3.hasNext()) {
                Simulation.SimSignal sSig = (Simulation.SimSignal)it3.next();
                String context = sSig.getSignalContext();
                if (context.length() <= len) {
                    sSig.setSignalContext(null);
                    continue;
                }
                sSig.setSignalContext(context.substring(len + 1));
            }
        }
        return sd;
    }

    private void cleanUpScope(List curArray, Simulation.SimData sd) {
        if (curArray == null) {
            return;
        }
        String last = null;
        String scope = null;
        int firstEntry = 0;
        int firstIndex = 0;
        int lastIndex = 0;
        int numSignalsInArray = curArray.size();
        for (int j = 0; j < numSignalsInArray; ++j) {
            Simulation.SimDigitalSignal sig = (Simulation.SimDigitalSignal)curArray.get(j);
            int squarePos = sig.getSignalName().indexOf(91);
            if (squarePos < 0) continue;
            String purename = sig.getSignalName().substring(0, squarePos);
            int index = TextUtils.atoi(sig.getSignalName().substring(squarePos + 1));
            if (last == null) {
                firstEntry = j;
                last = purename;
                firstIndex = lastIndex = index;
                scope = sig.getSignalContext();
                continue;
            }
            if (last.equals(purename)) {
                lastIndex = index;
                continue;
            }
            Simulation.SimDigitalSignal arraySig = new Simulation.SimDigitalSignal(sd);
            arraySig.setSignalName(last + "[" + firstIndex + ":" + lastIndex + "]");
            arraySig.setSignalContext(scope);
            arraySig.buildBussedSignalList();
            int width = j - firstEntry;
            for (int i = 0; i < width; ++i) {
                Simulation.SimDigitalSignal subSig = (Simulation.SimDigitalSignal)curArray.get(firstEntry + i);
                arraySig.addToBussedSignalList(subSig);
            }
            last = null;
        }
        if (last != null) {
            Simulation.SimDigitalSignal arraySig = new Simulation.SimDigitalSignal(sd);
            arraySig.setSignalName(last + "[" + firstIndex + ":" + lastIndex + "]");
            arraySig.setSignalContext(scope);
            arraySig.buildBussedSignalList();
            int width = numSignalsInArray - firstEntry;
            for (int i = 0; i < width; ++i) {
                Simulation.SimDigitalSignal subSig = (Simulation.SimDigitalSignal)curArray.get(firstEntry + i);
                arraySig.addToBussedSignalList(subSig);
            }
        }
    }

    private void addSignalToHashMap(Simulation.SimDigitalSignal sig, String symbol, HashMap symbolTable) {
        Object entry = symbolTable.get(symbol);
        if (entry == null) {
            symbolTable.put(symbol, sig);
        } else if (entry instanceof Simulation.SimDigitalSignal) {
            ArrayList<Object> manySigs = new ArrayList<Object>();
            manySigs.add(entry);
            manySigs.add(sig);
            symbolTable.put(symbol, manySigs);
        } else if (entry instanceof List) {
            ((List)entry).add(sig);
        }
    }

    private void parseToEnd() throws IOException {
        String keyword;
        while ((keyword = this.getNextKeyword()) != null && !keyword.equals("$end")) {
        }
    }

    private String getNextKeyword() throws IOException {
        String keyword = null;
        do {
            if (this.lastLine == null) {
                this.lastLine = this.getLineFromSimulator();
                if (this.lastLine == null) break;
                this.lineLen = this.lastLine.length();
                this.linePos = 0;
            }
            if (this.linePos < this.lineLen) {
                char ch = this.lastLine.charAt(this.linePos);
                if (ch == ' ') {
                    ++this.linePos;
                } else {
                    int startOfKeyword = this.linePos++;
                    while (this.linePos < this.lineLen && this.lastLine.charAt(this.linePos) != ' ') {
                        ++this.linePos;
                    }
                    keyword = this.lastLine.substring(startOfKeyword, this.linePos);
                }
            }
            if (this.linePos < this.lineLen) continue;
            this.lastLine = null;
        } while (keyword == null);
        return keyword;
    }

    private static class VerilogStimuli {
        double time;
        int state;

        VerilogStimuli(double time, int state) {
            this.time = time;
            this.state = state;
        }
    }
}

