/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class NccCellAnnotations {
    private List annotText = new ArrayList();
    private List exportsConnByParent = new ArrayList();
    private String skipReason;
    private Cell.CellGroup groupToJoin;
    private List flattenInstances = new ArrayList();

    private void processExportsConnAnnot(String note) {
        ArrayList<NamePattern> connected = new ArrayList<NamePattern>();
        NamePatternLexer lex = new NamePatternLexer(note);
        lex.nextPattern();
        NamePattern np = lex.nextPattern();
        while (np != null) {
            connected.add(np);
            np = lex.nextPattern();
        }
        if (connected.size() > 0) {
            this.exportsConnByParent.add(connected);
        }
    }

    private void processSkipAnnotation(String note) {
        this.skipReason = "";
        int sp = note.indexOf(" ");
        if (sp != -1) {
            this.skipReason = note.substring(sp);
        }
    }

    private void processJoinGroupAnnotation(String note) {
        StringTokenizer lex = new StringTokenizer(note);
        lex.nextToken();
        if (!lex.hasMoreTokens()) {
            System.out.println("Missing Library:Cell argument " + note);
            return;
        }
        String libCell = lex.nextToken();
        int colon = libCell.indexOf(58);
        if (colon == -1) {
            System.out.println("group specification must be of form Library:Cell " + note);
            return;
        }
        String libName = libCell.substring(0, colon);
        String cellName = libCell.substring(colon + 1);
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            System.out.println("Can't find library " + libName + " from annotation " + note);
            return;
        }
        Cell cell = lib.findNodeProto(cellName);
        if (cell == null) {
            System.out.println("Can't find Cell " + cellName + " from annotation " + note);
            return;
        }
        this.groupToJoin = cell.getCellGroup();
        LayoutLib.error(this.groupToJoin == null, "null cell group?");
    }

    private void processFlattenInstancesAnnotation(String note) {
        NamePatternLexer lex = new NamePatternLexer(note);
        lex.nextPattern();
        NamePattern np = lex.nextPattern();
        while (np != null) {
            this.flattenInstances.add(np);
            np = lex.nextPattern();
        }
    }

    private void doAnnotation(String note) {
        this.annotText.add(note);
        if (note.startsWith("exportsConnectedByParent")) {
            this.processExportsConnAnnot(note);
        } else if (note.startsWith("skipNCC")) {
            this.processSkipAnnotation(note);
        } else if (note.startsWith("joinGroup")) {
            this.processJoinGroupAnnotation(note);
        } else if (note.startsWith("flattenInstances")) {
            this.processFlattenInstancesAnnotation(note);
        } else {
            System.out.println("Unrecognized NCC annotation: " + note);
        }
    }

    private NccCellAnnotations(Cell cell, Object annotation) {
        if (annotation instanceof String) {
            this.doAnnotation((String)annotation);
        } else if (annotation instanceof String[]) {
            String[] ss = (String[])annotation;
            for (int i = 0; i < ss.length; ++i) {
                this.doAnnotation(ss[i]);
            }
        } else {
            System.out.println("ignoring bad NCC annotation: " + annotation + " on Cell: " + cell.getName());
        }
    }

    public static NccCellAnnotations getAnnotations(Cell cell) {
        Variable nccVar = cell.getVar("ATTR_NCC");
        if (nccVar == null) {
            return null;
        }
        Object annotation = nccVar.getObject();
        return new NccCellAnnotations(cell, annotation);
    }

    public String getSkipReason() {
        return this.skipReason;
    }

    public Iterator getExportsConnected() {
        return this.exportsConnByParent.iterator();
    }

    public Iterator getAnnotationText() {
        return this.annotText.iterator();
    }

    public Cell.CellGroup getGroupToJoin() {
        return this.groupToJoin;
    }

    public boolean flattenInstance(String instName) {
        Iterator it = this.flattenInstances.iterator();
        while (it.hasNext()) {
            NamePattern pattern = (NamePattern)it.next();
            if (!pattern.matches(instName)) continue;
            return true;
        }
        return false;
    }

    private static class NamePatternLexer {
        private final String s;
        private int pos = 0;

        private int findWhite() {
            while (this.pos < this.s.length()) {
                if (Character.isWhitespace(this.s.charAt(this.pos))) {
                    return this.pos;
                }
                ++this.pos;
            }
            return -1;
        }

        private int findNonWhite() {
            while (this.pos < this.s.length()) {
                if (!Character.isWhitespace(this.s.charAt(this.pos))) {
                    return this.pos;
                }
                ++this.pos;
            }
            return -1;
        }

        private int findSlash() {
            while (this.pos < this.s.length()) {
                if (this.s.charAt(this.pos) == '/') {
                    return this.pos;
                }
                ++this.pos;
            }
            return -1;
        }

        public NamePatternLexer(String annot) {
            this.s = annot;
        }

        public NamePattern nextPattern() {
            int startTok = this.findNonWhite();
            if (startTok == -1) {
                return null;
            }
            if (this.s.charAt(startTok) == '/') {
                ++this.pos;
                startTok = this.pos++;
                int endTok = this.findSlash();
                if (endTok == -1) {
                    System.out.println("Regular Expression has no trailing '/'" + this.s.substring(startTok - 1));
                    endTok = this.s.length();
                }
                String pat = this.s.substring(startTok, endTok);
                return new NamePattern(true, pat);
            }
            int endTok = this.findWhite();
            if (endTok == -1) {
                endTok = this.s.length();
            }
            return new NamePattern(false, this.s.substring(startTok, endTok));
        }
    }

    public static class NamePattern {
        private final boolean isRegExp;
        private final String pattern;

        NamePattern(boolean isRegEx, String pat) {
            this.isRegExp = isRegEx;
            this.pattern = pat;
        }

        public boolean matches(String name) {
            return this.isRegExp ? name.matches(this.pattern) : name.equals(this.pattern);
        }
    }
}

