/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.dialogs.OpenFile;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class LibraryFiles
extends Input {
    protected int nodeProtoCount;
    protected Cell[] nodeProtoList;
    protected double[] cellLambda;
    protected static int totalCells;
    protected static int cellsConstructed;
    protected List scaledCells;
    protected List skewedCells;
    protected int errorCount;
    protected Version version;
    protected boolean convertMosisCmosTechnologies;
    protected boolean scaleLambdaBy20;
    protected boolean rotationMirrorBits;
    private static List libsBeingRead;
    protected static final boolean VERBOSE = false;
    protected static final double TINYDISTANCE;
    static final /* synthetic */ boolean $assertionsDisabled;

    LibraryFiles() {
    }

    public static void initializeLibraryInput() {
        libsBeingRead = new ArrayList();
    }

    public boolean readInputLibrary() {
        if (!$assertionsDisabled && libsBeingRead.contains(this)) {
            throw new AssertionError();
        }
        libsBeingRead.add(this);
        this.scaledCells = new ArrayList();
        this.skewedCells = new ArrayList();
        return this.readLib();
    }

    protected void scanNodesForRecursion(Cell cell, FlagSet markCellForNodes, NodeProto[] nil, int start, int end) {
        for (int j = start; j < end; ++j) {
            Cell otherCell;
            NodeProto np = nil[j];
            if (np instanceof PrimitiveNode || (otherCell = (Cell)np) == null || otherCell.isBit(markCellForNodes)) continue;
            LibraryFiles reader = this;
            if (otherCell.getLibrary() != cell.getLibrary()) {
                reader = this.getReaderForLib(otherCell.getLibrary());
            }
            if (reader == null) continue;
            reader.realizeCellsRecursively(otherCell, markCellForNodes, null, 0.0, 0.0);
        }
        cell.setBit(markCellForNodes);
    }

    protected boolean readLib() {
        return true;
    }

    protected View findOldViewName(String viewName) {
        if (this.version.getMajor() < 8) {
            if (viewName.equals("compensated")) {
                return View.LAYOUTCOMP;
            }
            if (viewName.equals("skeleton")) {
                return View.LAYOUTSKEL;
            }
            if (viewName.equals("simulation-snapshot")) {
                return View.DOCWAVE;
            }
            if (viewName.equals("netlist-netlisp-format")) {
                return View.NETLISTNETLISP;
            }
            if (viewName.equals("netlist-rsim-format")) {
                return View.NETLISTRSIM;
            }
            if (viewName.equals("netlist-silos-format")) {
                return View.NETLISTSILOS;
            }
            if (viewName.equals("netlist-quisc-format")) {
                return View.NETLISTQUISC;
            }
            if (viewName.equals("netlist-als-format")) {
                return View.NETLISTALS;
            }
        }
        return null;
    }

    protected Technology findTechnologyName(String name) {
        Technology tech = null;
        if (this.convertMosisCmosTechnologies) {
            if (name.equals("mocmossub")) {
                tech = MoCMOS.tech;
            } else if (name.equals("mocmos")) {
                tech = Technology.findTechnology("mocmosold");
            }
        }
        if (tech == null) {
            tech = Technology.findTechnology(name);
        }
        if (tech == null && name.equals("logic")) {
            tech = Schematics.tech;
        }
        if (tech == null && (name.equals("epic8c") || name.equals("epic7c"))) {
            tech = Technology.findTechnology("epic7s");
        }
        return tech;
    }

    protected Library readExternalLibraryFromFilename(String theFileName, FileType defaultType) {
        boolean exists;
        int slashPos;
        int colonPos;
        URL url = TextUtils.makeURLToFile(theFileName);
        String legalLibName = TextUtils.getFileNameWithoutExtension(url);
        String fileName = url.getFile();
        File libFile = new File(fileName);
        String libFileName = libFile.getName();
        String libFilePath = libFile.getParent();
        int backSlashPos = libFileName.lastIndexOf(92);
        int charPos = Math.max(backSlashPos, Math.max(colonPos = libFileName.lastIndexOf(58), slashPos = libFileName.lastIndexOf(47)));
        if (charPos >= 0) {
            libFileName = libFileName.substring(charPos + 1);
            libFilePath = "";
        }
        String libName = libFileName;
        FileType importType = OpenFile.getOpenFileType(libName, defaultType);
        if (libName.endsWith(".elib")) {
            libName = libName.substring(0, libName.length() - 5);
        } else if (libName.endsWith(".jelib")) {
            libName = libName.substring(0, libName.length() - 6);
        } else if (libName.endsWith(".txt")) {
            libName = libName.substring(0, libName.length() - 4);
        } else {
            libFileName = libFileName + "." + defaultType.getExtensions()[0];
        }
        Library elib = Library.findLibrary(legalLibName);
        if (elib != null) {
            return elib;
        }
        StringBuffer errmsg = new StringBuffer();
        URL externalURL = this.getLibrary(libFileName, libFile.getPath(), errmsg);
        if (externalURL == null) {
            externalURL = this.getLibrary(libName + "." + FileType.JELIB.getExtensions()[0], libFile.getPath(), errmsg);
        }
        if (externalURL == null) {
            externalURL = this.getLibrary(libName + "." + FileType.ELIB.getExtensions()[0], libFile.getPath(), errmsg);
        }
        if (externalURL == null) {
            externalURL = this.getLibrary(libName + "." + FileType.READABLEDUMP.getExtensions()[0], libFile.getPath(), errmsg);
        }
        boolean bl = exists = externalURL != null;
        if (!exists) {
            String description;
            System.out.println("Error: cannot find referenced library " + libFile.getPath() + ":");
            System.out.print(errmsg.toString());
            String pt = null;
            while (!((pt = OpenFile.chooseInputFile(defaultType, description = "Reference library '" + libFileName + "'")) == null || (externalURL = TextUtils.makeURLToFile(pt)) != null && (exists = TextUtils.URLExists(externalURL, null)))) {
            }
        }
        if (exists) {
            System.out.println("Reading referenced library " + externalURL.getFile());
            importType = OpenFile.getOpenFileType(externalURL.getFile(), defaultType);
            elib = Library.newInstance(legalLibName, externalURL);
        }
        if (elib != null) {
            String oldNote = progress.getNote();
            if (progress != null) {
                progress.setProgress(0);
                progress.setNote("Reading referenced library " + legalLibName + "...");
            }
            elib = LibraryFiles.readALibrary(externalURL, elib, importType);
            progress.setProgress((int)((long)(this.byteCount * 100) / this.fileLength));
            progress.setNote(oldNote);
        }
        if (elib == null) {
            System.out.println("Error: cannot find referenced library " + libFile.getPath());
            System.out.println("...Creating new " + legalLibName + " Library instead");
            elib = Library.newInstance(legalLibName, null);
            elib.setLibFile(TextUtils.makeURLToFile(theFileName));
            elib.clearFromDisk();
        }
        return elib;
    }

    private URL getLibrary(String libFileName, String fullPathName, StringBuffer errmsg) {
        URL externalURL = TextUtils.makeURLToFile(mainLibDirectory + libFileName);
        boolean exists = TextUtils.URLExists(externalURL, errmsg);
        if (!exists) {
            Iterator libIt = LibDirs.getLibDirs();
            while (libIt.hasNext() && !(exists = TextUtils.URLExists(externalURL = TextUtils.makeURLToFile((String)libIt.next() + File.separator + libFileName), errmsg))) {
            }
            if (!exists && !(exists = TextUtils.URLExists(externalURL = TextUtils.makeURLToFile(fullPathName), errmsg))) {
                externalURL = LibFile.getLibFile(libFileName);
                exists = TextUtils.URLExists(externalURL, errmsg);
            }
        }
        if (!exists) {
            return null;
        }
        return externalURL;
    }

    public static void cleanupLibraryInput() {
        Cell cell;
        Cell cell2;
        Cell cell3;
        int cellIndex;
        LibraryFiles reader;
        progress.setNote("Constructing cell contents...");
        progress.setProgress(0);
        HashSet<Cell> uncomputedCells = new HashSet<Cell>();
        Iterator it = libsBeingRead.iterator();
        while (it.hasNext()) {
            reader = (LibraryFiles)it.next();
            for (cellIndex = 0; cellIndex < reader.nodeProtoCount; ++cellIndex) {
                cell3 = reader.nodeProtoList[cellIndex];
                if (cell3 == null || cell3.getLibrary() != reader.lib) continue;
                uncomputedCells.add(cell3);
            }
        }
        it = libsBeingRead.iterator();
        while (it.hasNext()) {
            reader = (LibraryFiles)it.next();
            for (cellIndex = 0; cellIndex < reader.nodeProtoCount; ++cellIndex) {
                cell3 = reader.nodeProtoList[cellIndex];
                if (cell3 == null || cell3.getLibrary() != reader.lib) continue;
                reader.computeTech(cell3, uncomputedCells);
            }
        }
        totalCells = 0;
        FlagSet markCellForNodes = Cell.getFlagSet(1);
        Iterator it2 = libsBeingRead.iterator();
        while (it2.hasNext()) {
            LibraryFiles reader2 = (LibraryFiles)it2.next();
            totalCells += reader2.nodeProtoCount;
            for (int cellIndex2 = 0; cellIndex2 < reader2.nodeProtoCount; ++cellIndex2) {
                cell2 = reader2.nodeProtoList[cellIndex2];
                if (cell2 == null || cell2.getLibrary() != reader2.lib) continue;
                reader2.cellLambda[cellIndex2] = reader2.computeLambda(cell2, cellIndex2);
                cell2.setTempInt(cellIndex2);
                cell2.clearBit(markCellForNodes);
            }
        }
        cellsConstructed = 0;
        for (int i = 0; i < 20; ++i) {
            boolean unchanged = true;
            Iterator it3 = libsBeingRead.iterator();
            while (it3.hasNext()) {
                LibraryFiles reader3 = (LibraryFiles)it3.next();
                for (int cellIndex3 = 0; cellIndex3 < reader3.nodeProtoCount; ++cellIndex3) {
                    cell = reader3.nodeProtoList[cellIndex3];
                    if (cell == null || cell.getLibrary() != reader3.lib || !reader3.spreadLambda(cell, cellIndex3)) continue;
                    unchanged = false;
                }
            }
            if (unchanged) break;
        }
        it = libsBeingRead.iterator();
        while (it.hasNext()) {
            LibraryFiles reader4 = (LibraryFiles)it.next();
            for (int cellIndex4 = 0; cellIndex4 < reader4.nodeProtoCount; ++cellIndex4) {
                cell2 = reader4.nodeProtoList[cellIndex4];
                if (cell2 == null || cell2.isBit(markCellForNodes)) continue;
                reader4.realizeCellsRecursively(cell2, markCellForNodes, null, 0.0, 0.0);
            }
        }
        markCellForNodes.freeFlagSet();
        boolean first = true;
        Iterator it4 = libsBeingRead.iterator();
        while (it4.hasNext()) {
            Iterator sIt;
            StringBuffer sb;
            LibraryFiles reader5 = (LibraryFiles)it4.next();
            if (reader5.scaledCells != null && reader5.scaledCells.size() != 0) {
                if (first) {
                    System.out.println("WARNING: to accommodate scaling inconsistencies, these cells were created:");
                    first = false;
                }
                sb = new StringBuffer();
                sb.append("   Library " + reader5.lib.getName() + ":");
                sIt = reader5.scaledCells.iterator();
                while (sIt.hasNext()) {
                    cell = (Cell)sIt.next();
                    sb.append(" " + cell.noLibDescribe());
                }
                System.out.println(sb.toString());
            }
            if (reader5.skewedCells == null || reader5.skewedCells.size() == 0) continue;
            if (first) {
                System.out.println("ERROR: because of library inconsistencies, these stretched cells were created:");
                first = false;
            }
            sb = new StringBuffer();
            sb.append("   Library " + reader5.lib.getName() + ":");
            sIt = reader5.skewedCells.iterator();
            while (sIt.hasNext()) {
                cell = (Cell)sIt.next();
                sb.append(" " + cell.noLibDescribe());
            }
            System.out.println(sb.toString());
        }
        libsBeingRead.clear();
    }

    protected LibraryFiles getReaderForLib(Library lib) {
        Iterator it = libsBeingRead.iterator();
        while (it.hasNext()) {
            LibraryFiles reader = (LibraryFiles)it.next();
            if (reader.lib != lib) continue;
            return reader;
        }
        return null;
    }

    String convertCellName(String s) {
        StringBuffer buf = null;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\n' || ch == '|' || ch == ':') {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(s.substring(0, i));
                }
                buf.append('-');
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            String newS = buf.toString();
            System.out.println("Cell name " + s + " was converted to " + newS);
            return newS;
        }
        return s;
    }

    void setLineNumber(int lineNumber) {
    }

    ErrorLogger.MessageLog logError(String message) {
        ++this.errorCount;
        System.out.println(message);
        return errorLogger.logError(message, null, -1);
    }

    ErrorLogger.MessageLog logWarning(String message) {
        System.out.println(message);
        return errorLogger.logWarning(message, null, -1);
    }

    protected void computeTech(Cell cell, Set uncomputedCells) {
        uncomputedCells.remove(cell);
    }

    protected double computeLambda(Cell cell, int cellIndex) {
        return 1.0;
    }

    protected boolean spreadLambda(Cell cell, int cellIndex) {
        return false;
    }

    protected boolean canScale() {
        return false;
    }

    protected void realizeCellsRecursively(Cell cell, FlagSet recursiveSetupFlag, String scaledCellName, double scaleX, double scaleY) {
    }

    protected boolean readerHasExport(Cell c, String portName) {
        return false;
    }

    static {
        $assertionsDisabled = !LibraryFiles.class.desiredAssertionStatus();
        TINYDISTANCE = DBMath.getEpsilon() * 2.0;
    }

    protected static class NodeInstList {
        protected NodeInst[] theNode;
        protected NodeProto[] protoType;
        protected Name[] name;
        protected int[] lowX;
        protected int[] highX;
        protected int[] lowY;
        protected int[] highY;
        protected int[] anchorX;
        protected int[] anchorY;
        protected short[] rotation;
        protected int[] transpose;
        protected int[] userBits;

        protected NodeInstList() {
        }
    }
}

