/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.menus.MenuCommands;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class RoutingTab
extends PreferencePanel {
    private ArcProto initRoutDefArc;
    private JPanel sogArcList;
    private Map<ArcProto, JCheckBox> sogFavorChecks;
    private Map<ArcProto, JCheckBox> sogProhibitChecks;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel70;
    private JPanel jPanel1;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JLabel routArcLabel;
    private JRadioButton routAutoStitcher;
    private JComboBox routDefaultArc;
    private JCheckBox routMimicInteractive;
    private JCheckBox routMimicKeepPins;
    private JCheckBox routMimicNoOtherArcs;
    private JCheckBox routMimicNodeSizesMustMatch;
    private JCheckBox routMimicNodeTypesMustMatch;
    private JCheckBox routMimicNumArcsMustMatch;
    private JCheckBox routMimicOnlyNewTopology;
    private JCheckBox routMimicPortsMustMatch;
    private JCheckBox routMimicPortsWidthMustMatch;
    private JRadioButton routMimicStitcher;
    private JRadioButton routNoStitcher;
    private JCheckBox routOverrideArc;
    private ButtonGroup routStitcher;
    private JLabel routTechLabel;
    private JComboBox routTechnology;
    private JPanel routing;
    private JTextField sogComplexityLimit;
    private JTextField sogMaxArcWidth;
    private JScrollPane sogRouteArcOptions;
    private JComboBox sogRouteTechnology;

    public RoutingTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.routing;
    }

    public String getName() {
        return "Routing";
    }

    public void init() {
        boolean initRoutMimicOn = Routing.isMimicStitchOn();
        boolean initRoutAutoOn = Routing.isAutoStitchOn();
        if (!initRoutMimicOn && !initRoutAutoOn) {
            this.routNoStitcher.setSelected(true);
        } else if (initRoutMimicOn) {
            this.routMimicStitcher.setSelected(true);
        } else {
            this.routAutoStitcher.setSelected(true);
        }
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            this.routTechnology.addItem(tech.getTechName());
            this.sogRouteTechnology.addItem(tech.getTechName());
        }
        this.routTechnology.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RoutingTab.this.techChanged();
            }
        });
        this.sogFavorChecks = new HashMap<ArcProto, JCheckBox>();
        this.sogProhibitChecks = new HashMap<ArcProto, JCheckBox>();
        this.sogArcList = new JPanel();
        this.sogRouteArcOptions.setViewportView(this.sogArcList);
        this.sogRouteTechnology.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RoutingTab.this.sogTechChanged();
            }
        });
        this.sogRouteTechnology.setSelectedItem(Technology.getCurrent().getTechName());
        this.sogMaxArcWidth.setText(TextUtils.formatDouble(Routing.getSeaOfGatesMaxWidth()));
        this.sogComplexityLimit.setText(Integer.toString(Routing.getSeaOfGatesComplexityLimit()));
        this.routTechnology.setSelectedItem(Technology.getCurrent().getTechName());
        this.routOverrideArc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RoutingTab.this.overrideChanged();
            }
        });
        String prefArcName = Routing.getPreferredRoutingArc();
        this.initRoutDefArc = null;
        if (prefArcName.length() > 0) {
            this.initRoutDefArc = ArcProto.findArcProto(prefArcName);
            this.routOverrideArc.setSelected(true);
        } else {
            this.routOverrideArc.setSelected(false);
        }
        this.overrideChanged();
        if (this.initRoutDefArc != null) {
            this.routTechnology.setSelectedItem(this.initRoutDefArc.getTechnology().getTechName());
            this.routDefaultArc.setSelectedItem(this.initRoutDefArc.getName());
        }
        this.routMimicPortsMustMatch.setSelected(Routing.isMimicStitchMatchPorts());
        this.routMimicPortsWidthMustMatch.setSelected(Routing.isMimicStitchMatchPortWidth());
        this.routMimicNumArcsMustMatch.setSelected(Routing.isMimicStitchMatchNumArcs());
        this.routMimicNodeSizesMustMatch.setSelected(Routing.isMimicStitchMatchNodeSize());
        this.routMimicNodeTypesMustMatch.setSelected(Routing.isMimicStitchMatchNodeType());
        this.routMimicNoOtherArcs.setSelected(Routing.isMimicStitchNoOtherArcsSameDir());
        this.routMimicOnlyNewTopology.setSelected(Routing.isMimicStitchOnlyNewTopology());
        this.routMimicInteractive.setSelected(Routing.isMimicStitchInteractive());
        this.routMimicKeepPins.setSelected(Routing.isMimicStitchPinsKept());
    }

    private void overrideChanged() {
        boolean enableRest = this.routOverrideArc.isSelected();
        this.routTechnology.setEnabled(enableRest);
        this.routTechLabel.setEnabled(enableRest);
        this.routDefaultArc.setEnabled(enableRest);
        this.routArcLabel.setEnabled(enableRest);
    }

    private void techChanged() {
        String techName = (String)this.routTechnology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.routDefaultArc.removeAllItems();
        Iterator<ArcProto> it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            this.routDefaultArc.addItem(ap.getName());
        }
        this.routDefaultArc.setSelectedIndex(0);
    }

    private void sogTechChanged() {
        String techName = (String)this.sogRouteTechnology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.sogArcList = new JPanel();
        this.sogRouteArcOptions.setViewportView(this.sogArcList);
        this.sogArcList.setLayout(new GridBagLayout());
        int i = 0;
        Iterator<ArcProto> it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (!ap.getFunction().isMetal()) continue;
            JLabel arcName = new JLabel(ap.getName());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = i;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            this.sogArcList.add((Component)arcName, gbc);
            JCheckBox favorArc = this.sogFavorChecks.get(ap);
            if (favorArc == null) {
                favorArc = new JCheckBox("Favor");
                this.sogFavorChecks.put(ap, favorArc);
                if (Routing.isSeaOfGatesFavor(ap)) {
                    favorArc.setSelected(true);
                }
            }
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = i;
            this.sogArcList.add((Component)favorArc, gbc);
            JCheckBox prohibitArc = this.sogProhibitChecks.get(ap);
            if (prohibitArc == null) {
                prohibitArc = new JCheckBox("Prohibit");
                this.sogProhibitChecks.put(ap, prohibitArc);
                if (Routing.isSeaOfGatesPrevent(ap)) {
                    prohibitArc.setSelected(true);
                }
            }
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = i++;
            this.sogArcList.add((Component)prohibitArc, gbc);
        }
    }

    public void term() {
        boolean cur;
        String techName;
        Technology tech;
        int curSOGComplexity;
        JCheckBox check;
        boolean curAuto;
        boolean curMimic = this.routMimicStitcher.isSelected();
        if (curMimic != Routing.isMimicStitchOn()) {
            Routing.setMimicStitchOn(curMimic);
            MenuCommands.menuBar().updateAllButtons();
        }
        if ((curAuto = this.routAutoStitcher.isSelected()) != Routing.isAutoStitchOn()) {
            Routing.setAutoStitchOn(curAuto);
            MenuCommands.menuBar().updateAllButtons();
        }
        for (ArcProto ap : this.sogFavorChecks.keySet()) {
            check = this.sogFavorChecks.get(ap);
            if (check.isSelected() == Routing.isSeaOfGatesFavor(ap)) continue;
            Routing.setSeaOfGatesFavor(ap, check.isSelected());
        }
        for (ArcProto ap : this.sogProhibitChecks.keySet()) {
            check = this.sogProhibitChecks.get(ap);
            if (check.isSelected() == Routing.isSeaOfGatesPrevent(ap)) continue;
            Routing.setSeaOfGatesPrevent(ap, check.isSelected());
        }
        double curSOGMaxWid = TextUtils.atof(this.sogMaxArcWidth.getText());
        if (curSOGMaxWid != Routing.getSeaOfGatesMaxWidth()) {
            Routing.setSeaOfGatesMaxWidth(curSOGMaxWid);
        }
        if ((curSOGComplexity = TextUtils.atoi(this.sogComplexityLimit.getText())) != Routing.getSeaOfGatesComplexityLimit()) {
            Routing.setSeaOfGatesComplexityLimit(curSOGComplexity);
        }
        ArcProto ap = null;
        if (this.routOverrideArc.isSelected() && (tech = Technology.findTechnology(techName = (String)this.routTechnology.getSelectedItem())) != null) {
            String curArcName = (String)this.routDefaultArc.getSelectedItem();
            ap = tech.findArcProto(curArcName);
        }
        if (ap != this.initRoutDefArc) {
            String newArcName = "";
            if (ap != null) {
                newArcName = ap.getTechnology().getTechName() + ":" + ap.getName();
            }
            Routing.setPreferredRoutingArc(newArcName);
        }
        if ((cur = this.routMimicPortsMustMatch.isSelected()) != Routing.isMimicStitchMatchPorts()) {
            Routing.setMimicStitchMatchPorts(cur);
        }
        if ((cur = this.routMimicPortsWidthMustMatch.isSelected()) != Routing.isMimicStitchMatchPortWidth()) {
            Routing.setMimicStitchMatchPortWidth(cur);
        }
        if ((cur = this.routMimicNumArcsMustMatch.isSelected()) != Routing.isMimicStitchMatchNumArcs()) {
            Routing.setMimicStitchMatchNumArcs(cur);
        }
        if ((cur = this.routMimicNodeSizesMustMatch.isSelected()) != Routing.isMimicStitchMatchNodeSize()) {
            Routing.setMimicStitchMatchNodeSize(cur);
        }
        if ((cur = this.routMimicNodeTypesMustMatch.isSelected()) != Routing.isMimicStitchMatchNodeType()) {
            Routing.setMimicStitchMatchNodeType(cur);
        }
        if ((cur = this.routMimicNoOtherArcs.isSelected()) != Routing.isMimicStitchNoOtherArcsSameDir()) {
            Routing.setMimicStitchNoOtherArcsSameDir(cur);
        }
        if ((cur = this.routMimicOnlyNewTopology.isSelected()) != Routing.isMimicStitchOnlyNewTopology()) {
            Routing.setMimicStitchOnlyNewTopology(cur);
        }
        if ((cur = this.routMimicInteractive.isSelected()) != Routing.isMimicStitchInteractive()) {
            Routing.setMimicStitchInteractive(cur);
        }
        if ((cur = this.routMimicKeepPins.isSelected()) != Routing.isMimicStitchPinsKept()) {
            Routing.setMimicStitchPinsKept(cur);
        }
    }

    private void initComponents() {
        this.routStitcher = new ButtonGroup();
        this.routing = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel70 = new JLabel();
        this.routMimicPortsMustMatch = new JCheckBox();
        this.routMimicInteractive = new JCheckBox();
        this.routMimicNumArcsMustMatch = new JCheckBox();
        this.routMimicNodeSizesMustMatch = new JCheckBox();
        this.routMimicNodeTypesMustMatch = new JCheckBox();
        this.routMimicNoOtherArcs = new JCheckBox();
        this.routMimicPortsWidthMustMatch = new JCheckBox();
        this.routMimicKeepPins = new JCheckBox();
        this.routMimicOnlyNewTopology = new JCheckBox();
        this.jPanel8 = new JPanel();
        this.routTechLabel = new JLabel();
        this.routDefaultArc = new JComboBox();
        this.routNoStitcher = new JRadioButton();
        this.routAutoStitcher = new JRadioButton();
        this.routMimicStitcher = new JRadioButton();
        this.routTechnology = new JComboBox();
        this.routArcLabel = new JLabel();
        this.routOverrideArc = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.sogRouteTechnology = new JComboBox();
        this.sogRouteArcOptions = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.sogMaxArcWidth = new JTextField();
        this.jLabel3 = new JLabel();
        this.sogComplexityLimit = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RoutingTab.this.closeDialog(evt);
            }
        });
        this.routing.setLayout(new GridBagLayout());
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Mimic Stitcher"));
        this.jLabel70.setText("Restrictions (when non-interactive):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.jPanel7.add((Component)this.jLabel70, gridBagConstraints);
        this.routMimicPortsMustMatch.setText("Ports must match");
        this.routMimicPortsMustMatch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.jPanel7.add((Component)this.routMimicPortsMustMatch, gridBagConstraints);
        this.routMimicInteractive.setText("Interactive mimicking");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel7.add((Component)this.routMimicInteractive, gridBagConstraints);
        this.routMimicNumArcsMustMatch.setText("Number of existing arcs must match");
        this.routMimicNumArcsMustMatch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.jPanel7.add((Component)this.routMimicNumArcsMustMatch, gridBagConstraints);
        this.routMimicNodeSizesMustMatch.setText("Node sizes must match");
        this.routMimicNodeSizesMustMatch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.jPanel7.add((Component)this.routMimicNodeSizesMustMatch, gridBagConstraints);
        this.routMimicNodeTypesMustMatch.setText("Node types must match");
        this.routMimicNodeTypesMustMatch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.jPanel7.add((Component)this.routMimicNodeTypesMustMatch, gridBagConstraints);
        this.routMimicNoOtherArcs.setText("Cannot have other arcs in the same direction");
        this.routMimicNoOtherArcs.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.jPanel7.add((Component)this.routMimicNoOtherArcs, gridBagConstraints);
        this.routMimicPortsWidthMustMatch.setText("Bus ports must have same width");
        this.routMimicPortsWidthMustMatch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.jPanel7.add((Component)this.routMimicPortsWidthMustMatch, gridBagConstraints);
        this.routMimicKeepPins.setText("Keep pins");
        this.routMimicKeepPins.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.routMimicKeepPins.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel7.add((Component)this.routMimicKeepPins, gridBagConstraints);
        this.routMimicOnlyNewTopology.setText("Ignore if already connected elsewhere");
        this.routMimicOnlyNewTopology.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 4, 4);
        this.jPanel7.add((Component)this.routMimicOnlyNewTopology, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.routing.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel8.setBorder(BorderFactory.createTitledBorder("All Routers"));
        this.routTechLabel.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 1, 4);
        this.jPanel8.add((Component)this.routTechLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.jPanel8.add((Component)this.routDefaultArc, gridBagConstraints);
        this.routStitcher.add(this.routNoStitcher);
        this.routNoStitcher.setText("No stitcher running");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.jPanel8.add((Component)this.routNoStitcher, gridBagConstraints);
        this.routStitcher.add(this.routAutoStitcher);
        this.routAutoStitcher.setText("Auto-stitcher running");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel8.add((Component)this.routAutoStitcher, gridBagConstraints);
        this.routStitcher.add(this.routMimicStitcher);
        this.routMimicStitcher.setText("Mimic-stitcher running");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.jPanel8.add((Component)this.routMimicStitcher, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel8.add((Component)this.routTechnology, gridBagConstraints);
        this.routArcLabel.setText("Arc:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 20, 4, 4);
        this.jPanel8.add((Component)this.routArcLabel, gridBagConstraints);
        this.routOverrideArc.setText("Use this arc in stitching routers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.jPanel8.add((Component)this.routOverrideArc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.routing.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Sea-of-Gates Router"));
        this.jLabel1.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.sogRouteTechnology.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.jPanel1.add((Component)this.sogRouteTechnology, gridBagConstraints);
        this.sogRouteArcOptions.setMinimumSize(new Dimension(100, 100));
        this.sogRouteArcOptions.setOpaque(false);
        this.sogRouteArcOptions.setPreferredSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.jPanel1.add((Component)this.sogRouteArcOptions, gridBagConstraints);
        this.jLabel2.setText("Maximum arc width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.sogMaxArcWidth.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.jPanel1.add((Component)this.sogMaxArcWidth, gridBagConstraints);
        this.jLabel3.setText("Search complexity limit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.sogComplexityLimit.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.jPanel1.add((Component)this.sogComplexityLimit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.routing.add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.routing, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

