/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.redisplay.AbstractDrawing;
import com.sun.electric.tool.user.redisplay.AlphaBlender;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LayerDrawing {
    public static final int MINIMUMTEXTSIZE = 5;
    public static final int SINGLETONSTOADD = 5;
    public static final int MAXIMUMTEXTSIZE = 200;
    private static final boolean TAKE_STATS = false;
    private static int tinyCells;
    private static int tinyPrims;
    private static int totalCells;
    private static int renderedCells;
    private static int totalPrims;
    private static int tinyArcs;
    private static int linedArcs;
    private static int totalArcs;
    private static int offscreensCreated;
    private static int offscreenPixelsCreated;
    private static int offscreensUsed;
    private static int offscreenPixelsUsed;
    private static int cellsRendered;
    private static Set<ExpandedCellKey> offscreensUsedSet;
    private static int boxArrayCount;
    private static int boxCount;
    private static int boxDisplayCount;
    private static int lineCount;
    private static int polygonCount;
    private static int crossCount;
    private static int circleCount;
    private static int discCount;
    private static int arcCount;
    private static final boolean DEBUG = false;
    private final Dimension sz;
    private double scale;
    private VarContext varContext;
    private double originX;
    private double originY;
    private double scale_;
    private float factorX;
    private float factorY;
    private int nowPrinting;
    boolean highlightingLayers;
    private boolean lastFullInstantiate = false;
    private BitSet inPlaceSubcellPath;
    private Cell inPlaceCurrent;
    private boolean canDrawText;
    private double canDrawRelativeText = Double.MAX_VALUE;
    private static double maxObjectSize;
    private static double halfMaxObjectSize;
    private final Point tempPt1 = new Point();
    private final Point tempPt2 = new Point();
    private final Point tempPt3 = new Point();
    private final Point tempPt4 = new Point();
    private final int total;
    private final ArrayList<RenderTextInfo> renderTextList = new ArrayList();
    private final ArrayList<GreekTextInfo> greekTextList = new ArrayList();
    private final ArrayList<CrossTextInfo> crossTextList = new ArrayList();
    private final int numIntsPerRow;
    private Map<Layer, TransparentRaster> layerRasters = new HashMap<Layer, TransparentRaster>();
    private PatternedTransparentRaster currentPatternedTransparentRaster = new PatternedTransparentRaster();
    private boolean renderedWindow;
    private boolean periodicRefresh;
    private int objectCount;
    private long lastRefreshTime;
    private EditWindow wnd;
    private static Dimension topSz;
    private boolean patternedDisplay;
    private static boolean alphaBlendingOvercolor;
    private static Map<ExpandedCellKey, ExpandedCellInfo> expandedCells;
    private static final Set<CellId> changedCells;
    private static double expandedScale;
    private static int numberToReconcile;
    private static final Rectangle2D CENTERRECT;
    private static Color textColor;
    private static final EGraphics textGraphics;
    private static final EGraphics instanceGraphics;
    private static final Layer instanceLayer;
    private static final EGraphics gridGraphics;
    private static final Layer gridLayer;
    private static final EGraphics portGraphics;
    private int clipLX;
    private int clipHX;
    private int clipLY;
    private int clipHY;
    private final int width;
    private final EditWindow0 dummyWnd = new EditWindow0(){

        public VarContext getVarContext() {
            return LayerDrawing.this.varContext;
        }

        public double getScale() {
            return LayerDrawing.this.scale;
        }

        public double getGlobalTextScale() {
            return LayerDrawing.this.wnd.getGlobalTextScale();
        }
    };
    private static Rectangle tempRect;
    private double[] hsvTempArray = new double[3];
    private boolean[] arcOctTable = new boolean[9];
    private Point arcCenter;
    private int arcRadius;
    private int arcCol;
    private ERaster arcRaster;
    private boolean arcThick;

    static void drawTechPalette(Graphics2D g, int imgX, int imgY, Rectangle entrySize, double scale, VectorCache.VectorBase[] shapes) {
        int h;
        BufferedImage smallImg = new BufferedImage(entrySize.width, 2, 1);
        DataBufferInt smallDbi = (DataBufferInt)smallImg.getRaster().getDataBuffer();
        int[] smallOpaqueData = smallDbi.getData();
        LayerDrawing offscreen = new LayerDrawing(new Dimension(entrySize.width, entrySize.height));
        textColor = new Color(User.getColor(User.ColorPrefType.TEXT));
        textGraphics.setColor(textColor);
        offscreen.initOrigin(scale, EPoint.ORIGIN);
        offscreen.renderedWindow = true;
        offscreen.patternedDisplay = true;
        offscreen.canDrawText = true;
        offscreen.canDrawRelativeText = 0.0;
        offscreen.clipLX = 0;
        offscreen.clipHX = offscreen.sz.width - 1;
        offscreen.clipLY = 0;
        offscreen.clipHY = offscreen.sz.height - 1;
        offscreen.clearImage(null);
        offscreen.renderTextList.clear();
        offscreen.greekTextList.clear();
        offscreen.crossTextList.clear();
        ArrayList<VectorCache.VectorBase> shapeList = new ArrayList<VectorCache.VectorBase>();
        for (VectorCache.VectorBase shape : shapes) {
            shapeList.add(shape);
        }
        offscreen.drawList(0, 0, shapeList);
        AlphaBlender alphaBlender = new AlphaBlender();
        HashMap<Layer, int[]> layerBits = new HashMap<Layer, int[]>();
        for (Map.Entry<Layer, TransparentRaster> e : offscreen.layerRasters.entrySet()) {
            layerBits.put(e.getKey(), e.getValue().layerBitMap);
        }
        List<AbstractDrawing.LayerColor> blendingOrder = LayerDrawing.getBlendingOrderForTechPalette(layerBits.keySet());
        alphaBlender.init(User.getColor(User.ColorPrefType.BACKGROUND), blendingOrder, layerBits);
        int width = offscreen.sz.width;
        int height = offscreen.sz.height;
        boolean clipLY = false;
        int clipHY = height - 1;
        int numIntsPerRow = offscreen.numIntsPerRow;
        int baseByteIndex = 0;
        for (int y = 0; y < height; y += h) {
            h = Math.min(2, height - y);
            int baseIndex = 0;
            for (int k = 0; k < h; ++k) {
                alphaBlender.composeLine(baseByteIndex, 0, width - 1, smallOpaqueData, baseIndex);
                baseByteIndex += numIntsPerRow;
                baseIndex += width;
            }
            g.drawImage((Image)smallImg, imgX, imgY + y, null);
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (RenderTextInfo textInfo : offscreen.renderTextList) {
            textInfo.offX += imgX;
            textInfo.offY += imgY;
            textInfo.draw(g);
        }
    }

    private static List<AbstractDrawing.LayerColor> getBlendingOrderForTechPalette(Set<Layer> layersAvailable) {
        boolean alphaBlendingOvercolor = true;
        ArrayList<AbstractDrawing.LayerColor> layerColors = new ArrayList<AbstractDrawing.LayerColor>();
        ArrayList<Layer> sortedLayers = new ArrayList<Layer>(layersAvailable);
        Collections.sort(sortedLayers, Technology.LAYERS_BY_HEIGHT_LIFT_CONTACTS);
        float[] backgroundComps = new Color(User.getColor(User.ColorPrefType.BACKGROUND)).getRGBColorComponents(null);
        float bRed = backgroundComps[0];
        float bGreen = backgroundComps[1];
        float bBlue = backgroundComps[2];
        for (Layer layer : sortedLayers) {
            Color color = new Color(layer.getGraphics().getRGB());
            float[] compArray = color.getRGBComponents(null);
            float red = compArray[0];
            float green = compArray[1];
            float blue = compArray[2];
            float opacity = 0.7f;
            float inverseAlpha = 1.0f - opacity;
            if (alphaBlendingOvercolor) {
                red -= bRed * inverseAlpha;
                green -= bGreen * inverseAlpha;
                blue -= bBlue * inverseAlpha;
            } else {
                red *= opacity;
                green *= opacity;
                blue *= opacity;
            }
            layerColors.add(new AbstractDrawing.LayerColor(layer, red, green, blue, inverseAlpha));
        }
        return layerColors;
    }

    public LayerDrawing(Dimension sz) {
        this.sz = new Dimension(sz);
        this.width = sz.width;
        this.clipLX = 0;
        this.clipHX = sz.width - 1;
        this.clipLY = 0;
        this.clipHY = sz.height - 1;
        this.total = sz.height * sz.width;
        this.numIntsPerRow = (sz.width + 32 - 1) / 32;
        this.renderedWindow = true;
    }

    public LayerDrawing(double scale, int lX, int hX, int lY, int hY) {
        this.scale = scale;
        this.scale_ = (float)(scale / 400.0);
        this.originX = -lX;
        this.originY = hY;
        this.factorX = (float)(-this.originX / this.scale_);
        this.factorY = (float)(this.originY / this.scale_);
        this.sz = new Dimension(hX - lX + 1, hY - lY + 1);
        this.width = this.sz.width;
        this.clipLX = 0;
        this.clipHX = this.sz.width - 1;
        this.clipLY = 0;
        this.clipHY = this.sz.height - 1;
        this.total = this.sz.height * this.sz.width;
        this.numIntsPerRow = (this.sz.width + 32 - 1) / 32;
    }

    void initOrigin(double scale, Point2D offset) {
        this.scale = scale;
        this.scale_ = (float)(scale / 400.0);
        this.originX = (double)(this.sz.width / 2) - offset.getX() * scale;
        this.originY = (double)(this.sz.height / 2) + offset.getY() * scale;
        this.factorX = (float)(offset.getX() * 400.0 - (double)(this.sz.width / 2) / this.scale_);
        this.factorY = (float)(offset.getY() * 400.0 + (double)(this.sz.height / 2) / this.scale_);
    }

    public void setPrintingMode(int mode) {
        this.nowPrinting = mode;
    }

    public Dimension getSize() {
        return this.sz;
    }

    public static void clearSubCellCache() {
        expandedCells = new HashMap<ExpandedCellKey, ExpandedCellInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImage(Drawing drawing, boolean fullInstantiate, Rectangle2D drawLimitBounds) {
        HashSet<CellId> changedCellsCopy;
        Object subCell;
        long startTime = 0L;
        long clearTime = 0L;
        long countTime = 0L;
        long initialUsed = 0L;
        if (fullInstantiate != this.lastFullInstantiate) {
            LayerDrawing.clearSubCellCache();
            this.lastFullInstantiate = fullInstantiate;
        }
        EditWindow wnd = drawing.wnd;
        Cell cell = wnd.getInPlaceEditTopCell();
        List<NodeInst> inPlaceNodePath = wnd.getInPlaceEditNodePath();
        if (inPlaceNodePath.isEmpty()) {
            this.inPlaceSubcellPath = null;
        } else {
            this.inPlaceSubcellPath = new BitSet();
            for (NodeInst ni : inPlaceNodePath) {
                subCell = (Cell)ni.getProto();
                this.inPlaceSubcellPath.set(((Cell)subCell).getId().cellIndex);
            }
        }
        this.inPlaceCurrent = wnd.getCell();
        textColor = new Color(User.getColor(User.ColorPrefType.TEXT));
        textGraphics.setColor(textColor);
        instanceGraphics.setColor(new Color(User.getColor(User.ColorPrefType.INSTANCE)));
        gridGraphics.setColor(new Color(User.getColor(User.ColorPrefType.GRID)));
        if (expandedScale != drawing.da.scale) {
            LayerDrawing.clearSubCellCache();
            expandedScale = drawing.da.scale;
        }
        this.varContext = wnd.getVarContext();
        this.initOrigin(expandedScale, new Point2D.Double(drawing.da.offX, drawing.da.offY));
        this.patternedDisplay = expandedScale > User.getPatternedScaleLimit();
        alphaBlendingOvercolor = expandedScale > User.getAlphaBlendingOvercolorLimit();
        this.canDrawText = expandedScale > 1.0;
        this.canDrawRelativeText = this.canDrawText ? 0.0 : 5.0;
        maxObjectSize = 2.0 / expandedScale;
        halfMaxObjectSize = maxObjectSize / 2.0;
        topSz = this.sz;
        this.highlightingLayers = false;
        Iterator<Layer> it = Technology.getCurrent().getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (!layer.isDimmed()) continue;
            this.highlightingLayers = true;
            break;
        }
        Rectangle renderBounds = null;
        if (drawLimitBounds != null) {
            renderBounds = this.databaseToScreen(drawLimitBounds);
            this.clipLX = Math.max(renderBounds.x, 0);
            this.clipHX = Math.min(renderBounds.x + renderBounds.width, this.sz.width) - 1;
            this.clipLY = Math.max(renderBounds.y, 0);
            this.clipHY = Math.min(renderBounds.y + renderBounds.height, this.sz.height) - 1;
        } else {
            this.clipLX = 0;
            this.clipHX = this.sz.width - 1;
            this.clipLY = 0;
            this.clipHY = this.sz.height - 1;
        }
        this.clearImage(renderBounds);
        this.periodicRefresh = true;
        this.wnd = wnd;
        this.objectCount = 0;
        this.lastRefreshTime = System.currentTimeMillis();
        subCell = changedCells;
        synchronized (subCell) {
            changedCellsCopy = new HashSet<CellId>(changedCells);
            changedCells.clear();
        }
        LayerDrawing.forceRedraw(changedCellsCopy);
        VectorCache.theCache.forceRedraw();
        numberToReconcile = 5;
        for (ExpandedCellInfo count : expandedCells.values()) {
            count.instanceCount = 0;
        }
        this.countCell(cell, drawLimitBounds, fullInstantiate, Orientation.IDENT, DBMath.MATID);
        this.renderTextList.clear();
        this.greekTextList.clear();
        this.crossTextList.clear();
        this.drawCell(cell, drawLimitBounds, fullInstantiate, Orientation.IDENT, 0, 0, true, wnd.getVarContext());
        if (cell != null && wnd.isGrid()) {
            this.drawGrid(wnd, drawing.da);
        }
    }

    public void clearImage(Rectangle bounds) {
        if (bounds == null) {
            for (TransparentRaster raster : this.layerRasters.values()) {
                raster.eraseAll();
            }
        } else {
            for (TransparentRaster raster : this.layerRasters.values()) {
                raster.eraseBox(this.clipLX, this.clipHX, this.clipLY, this.clipHY);
            }
        }
    }

    private void drawGrid(EditWindow wnd, WindowFrame.DisplayAttributes da) {
        double spacingX = wnd.getGridXSpacing();
        double spacingY = wnd.getGridYSpacing();
        if (spacingX == 0.0 || spacingY == 0.0) {
            return;
        }
        double boldSpacingX = spacingX * (double)User.getDefGridXBoldFrequency();
        double boldSpacingY = spacingY * (double)User.getDefGridYBoldFrequency();
        double boldSpacingThreshX = spacingX / 4.0;
        double boldSpacingThreshY = spacingY / 4.0;
        Rectangle2D displayable = this.displayableBounds(da.getIntoCellTransform());
        double lX = displayable.getMinX();
        double lY = displayable.getMaxY();
        double hX = displayable.getMaxX();
        double hY = displayable.getMinY();
        double scaleX = (double)this.sz.width / (hX - lX);
        double scaleY = (double)this.sz.height / (lY - hY);
        double x1 = DBMath.toNearest(lX, spacingX);
        double y1 = DBMath.toNearest(lY, spacingY);
        boolean allBoldDots = false;
        if (spacingX * scaleX < 5.0 || spacingY * scaleY < 5.0) {
            x1 = DBMath.toNearest(x1, boldSpacingX);
            spacingX = boldSpacingX;
            y1 = DBMath.toNearest(y1, boldSpacingY);
            spacingY = boldSpacingY;
            if (spacingX * scaleX < 10.0 || spacingY * scaleY < 10.0) {
                return;
            }
        } else if (spacingX * scaleX > 75.0 && spacingY * scaleY > 75.0) {
            allBoldDots = true;
        }
        Point2D.Double tmpPt = new Point2D.Double();
        AffineTransform outofCellTransform = da.getOutofCellTransform();
        ERaster raster = this.getRaster(gridLayer, gridGraphics, false);
        for (double i = y1; i > hY; i -= spacingY) {
            double boldValueY = i;
            boldValueY = i < 0.0 ? (boldValueY -= boldSpacingThreshY / 2.0) : (boldValueY += boldSpacingThreshY / 2.0);
            boolean everyTenY = Math.abs(boldValueY) % boldSpacingY < boldSpacingThreshY;
            for (double j = x1; j < hX; j += spacingX) {
                boolean everyTenX;
                tmpPt.setLocation(j, i);
                outofCellTransform.transform(tmpPt, tmpPt);
                this.databaseToScreen(tmpPt.getX(), tmpPt.getY(), this.tempPt1);
                int x = this.tempPt1.x;
                int y = this.tempPt1.y;
                if (x < 0 || x >= this.sz.width || y < 0 || y >= this.sz.height) continue;
                double boldValueX = j;
                boldValueX = j < 0.0 ? (boldValueX -= boldSpacingThreshX / 2.0) : (boldValueX += boldSpacingThreshX / 2.0);
                boolean bl = everyTenX = Math.abs(boldValueX) % boldSpacingX < boldSpacingThreshX;
                if (allBoldDots && everyTenX && everyTenY) {
                    int boxHY;
                    int boxLY;
                    int boxHX;
                    int boxLX = x - 2;
                    if (boxLX < 0) {
                        boxLX = 0;
                    }
                    if ((boxHX = x + 2) >= this.sz.width) {
                        boxHX = this.sz.width - 1;
                    }
                    if ((boxLY = y - 2) < 0) {
                        boxLY = 0;
                    }
                    if ((boxHY = y + 2) >= this.sz.height) {
                        boxHY = this.sz.height - 1;
                    }
                    raster.fillBox(boxLX, boxHX, boxLY, boxHY);
                    if (x > 1) {
                        raster.fillPoint(x - 2, y);
                    }
                    if (x < this.sz.width - 2) {
                        raster.fillPoint(x + 2, y);
                    }
                    if (y > 1) {
                        raster.fillPoint(x, y - 2);
                    }
                    if (y >= this.sz.height - 2) continue;
                    raster.fillPoint(x, y + 2);
                    continue;
                }
                if (allBoldDots || everyTenX && everyTenY) {
                    raster.fillPoint(x, y);
                    if (x > 0) {
                        raster.fillPoint(x - 1, y);
                    }
                    if (x < this.sz.width - 1) {
                        raster.fillPoint(x + 1, y);
                    }
                    if (y > 0) {
                        raster.fillPoint(x, y - 1);
                    }
                    if (y >= this.sz.height - 1) continue;
                    raster.fillPoint(x, y + 1);
                    continue;
                }
                raster.fillPoint(x, y);
            }
        }
        if (User.isGridAxesShown()) {
            tmpPt.setLocation(0.0, 0.0);
            outofCellTransform.transform(tmpPt, tmpPt);
            this.databaseToScreen(tmpPt.getX(), tmpPt.getY(), this.tempPt1);
            int x = this.tempPt1.x;
            int y = this.tempPt1.y;
            if (x >= 0 && x < this.sz.width) {
                raster.fillVerLine(x, 0, this.sz.height - 1);
            }
            if (y >= 0 && y < this.sz.height) {
                raster.fillHorLine(y, 0, this.sz.width - 1);
            }
        }
    }

    private Rectangle2D displayableBounds(AffineTransform intoCellTransform) {
        Point2D.Double low = new Point2D.Double();
        this.screenToDatabase(0, 0, low);
        intoCellTransform.transform(low, low);
        Point2D.Double high = new Point2D.Double();
        this.screenToDatabase(this.sz.width - 1, this.sz.height - 1, high);
        intoCellTransform.transform(high, high);
        double lowX = Math.min(((Point2D)low).getX(), ((Point2D)high).getX());
        double lowY = Math.min(((Point2D)low).getY(), ((Point2D)high).getY());
        double sizeX = Math.abs(((Point2D)high).getX() - ((Point2D)low).getX());
        double sizeY = Math.abs(((Point2D)high).getY() - ((Point2D)low).getY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(lowX, lowY, sizeX, sizeY);
        return bounds;
    }

    private void periodicRefresh() {
        if (this.periodicRefresh) {
            ++this.objectCount;
            if (this.objectCount > 100) {
                this.objectCount = 0;
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastRefreshTime > 1000L) {
                    this.wnd.repaint();
                }
            }
        }
    }

    private void drawCell(Cell cell, Rectangle2D drawLimitBounds, boolean fullInstantiate, Orientation orient, int oX, int oY, boolean topLevel, VarContext context) {
        ++renderedCells;
        VectorCache.VectorCell vc = VectorCache.theCache.drawCell(cell.getId(), orient, context, this.scale);
        for (VectorCache.VectorSubCell vsc : vc.subCells) {
            boolean expanded;
            ++totalCells;
            int soX = vsc.offsetX + oX;
            int soY = vsc.offsetY + oY;
            VectorCache.VectorCell subVC = VectorCache.theCache.findVectorCell(vsc.subCellId, vc.orient.concatenate(vsc.n.orient));
            this.gridToScreen(subVC.lX + soX, subVC.hY + soY, this.tempPt1);
            this.gridToScreen(subVC.hX + soX, subVC.lY + soY, this.tempPt2);
            int lX = this.tempPt1.x;
            int lY = this.tempPt1.y;
            int hX = this.tempPt2.x;
            int hY = this.tempPt2.y;
            if (hX < this.clipLX || lX > this.clipHX || hY < this.clipLY || lY > this.clipHY) continue;
            boolean onPathDown = this.inPlaceSubcellPath != null && this.inPlaceSubcellPath.get(vsc.subCellId.cellIndex);
            boolean isExpanded = cell.isExpanded(vsc.n.nodeId);
            boolean bl = expanded = isExpanded || fullInstantiate;
            if (!expanded && onPathDown) {
                expanded = true;
            }
            CellId subCellId = vsc.subCellId;
            Cell subCell = VectorCache.theCache.database.getCell(subCellId);
            if (expanded) {
                int soY_;
                int soX_;
                Orientation subOrient = orient.concatenate(vsc.n.orient);
                if (!this.expandedCellCached(subCell, subOrient, soX_ = vsc.offsetX + oX, soY_ = vsc.offsetY + oY, context, fullInstantiate)) {
                    ++cellsRendered;
                    NodeInst ni = subCell.getNodeById(vsc.n.nodeId);
                    this.drawCell(subCell, drawLimitBounds, fullInstantiate, subOrient, soX_, soY_, false, context.push(ni));
                }
            } else {
                int[] op = subVC.outlinePoints;
                int p1x = op[0] + soX;
                int p1y = op[1] + soY;
                int p2x = op[2] + soX;
                int p2y = op[3] + soY;
                int p3x = op[4] + soX;
                int p3y = op[5] + soY;
                int p4x = op[6] + soX;
                int p4y = op[7] + soY;
                this.gridToScreen(p1x, p1y, this.tempPt1);
                this.gridToScreen(p2x, p2y, this.tempPt2);
                ERaster instanceRaster = this.getRaster(instanceLayer, instanceGraphics, false);
                this.drawLine(this.tempPt1, this.tempPt2, 0, instanceRaster);
                this.gridToScreen(p2x, p2y, this.tempPt1);
                this.gridToScreen(p3x, p3y, this.tempPt2);
                this.drawLine(this.tempPt1, this.tempPt2, 0, instanceRaster);
                this.gridToScreen(p3x, p3y, this.tempPt1);
                this.gridToScreen(p4x, p4y, this.tempPt2);
                this.drawLine(this.tempPt1, this.tempPt2, 0, instanceRaster);
                this.gridToScreen(p1x, p1y, this.tempPt1);
                this.gridToScreen(p4x, p4y, this.tempPt2);
                this.drawLine(this.tempPt1, this.tempPt2, 0, instanceRaster);
                if (this.canDrawText && User.isTextVisibilityOnInstance()) {
                    tempRect.setBounds(lX, lY, hX - lX, hY - lY);
                    TextDescriptor descript = vsc.n.protoDescriptor;
                    Cell np = VectorCache.theCache.database.getCell(vsc.subCellId);
                    this.drawText(tempRect, Poly.Type.TEXTBOX, descript, np.describe(false), textGraphics);
                }
            }
            if (!this.canDrawText || !topLevel && !onPathDown && this.inPlaceCurrent != cell) continue;
            this.drawPortList(vsc, subVC, soX, soY, isExpanded);
        }
        this.drawList(oX, oY, vc.filledShapes);
        this.drawList(oX, oY, vc.shapes);
        if (topLevel) {
            this.drawList(oX, oY, vc.getTopOnlyShapes());
        }
    }

    private boolean expandedCellCached(Cell subCell, Orientation orient, int oX, int oY, VarContext context, boolean fullInstantiate) {
        if (expandedCells == null) {
            return false;
        }
        if (subCell.isIcon()) {
            return false;
        }
        ExpandedCellKey expansionKey = new ExpandedCellKey(subCell, orient);
        ExpandedCellInfo expandedCellCount = expandedCells.get(expansionKey);
        if (expandedCellCount != null && expandedCellCount.offscreen == null) {
            if (expandedCellCount.tooLarge) {
                return false;
            }
            if (expandedCellCount.singleton && expandedCellCount.instanceCount < 2) {
                if (numberToReconcile > 0) {
                    --numberToReconcile;
                    expandedCellCount.singleton = false;
                } else {
                    return false;
                }
            }
        }
        if (expandedCellCount == null || expandedCellCount.offscreen == null) {
            Rectangle2D textBounds;
            Rectangle2D.Double cellBounds = new Rectangle2D.Double();
            ((Rectangle2D)cellBounds).setRect(subCell.getBounds());
            if (this.canDrawText && (textBounds = subCell.getTextBounds(this.dummyWnd)) != null) {
                cellBounds.add(textBounds);
            }
            AffineTransform rotTrans = orient.pureRotate();
            DBMath.transformRect(cellBounds, rotTrans);
            int lX = (int)Math.ceil(cellBounds.getMinX() * this.scale - 0.5);
            int hX = (int)Math.floor(cellBounds.getMaxX() * this.scale + 0.5);
            int lY = (int)Math.ceil(cellBounds.getMinY() * this.scale - 0.5);
            int hY = (int)Math.floor(cellBounds.getMaxY() * this.scale + 0.5);
            assert (lX <= hX && lY <= hY);
            if (expandedCellCount == null) {
                expandedCellCount = new ExpandedCellInfo();
                expandedCells.put(expansionKey, expandedCellCount);
            }
            if (hX - lX >= LayerDrawing.topSz.width / 32 && hY - lY >= LayerDrawing.topSz.height / 32) {
                expandedCellCount.tooLarge = true;
                return false;
            }
            expandedCellCount.offscreen = new LayerDrawing(this.scale, lX, hX, lY, hY);
            expandedCellCount.offscreen.drawCell(subCell, null, fullInstantiate, orient, 0, 0, false, context);
            ++offscreensCreated;
            offscreenPixelsCreated += ((ExpandedCellInfo)expandedCellCount).offscreen.total;
        }
        this.gridToScreen(oX, oY, this.tempPt1);
        this.copyBits(expandedCellCount.offscreen, this.tempPt1.x, this.tempPt1.y);
        ++offscreensUsed;
        offscreenPixelsUsed += ((ExpandedCellInfo)expandedCellCount).offscreen.total;
        return true;
    }

    private void countCell(Cell cell, Rectangle2D drawLimitBounds, boolean fullInstantiate, Orientation orient, AffineTransform prevTrans) {
        Iterator<NodeInst> nodes = cell.getNodes();
        while (nodes.hasNext()) {
            NodeInst ni = nodes.next();
            if (!ni.isCellInstance()) continue;
            if (drawLimitBounds != null) {
                Rectangle2D curBounds = ni.getBounds();
                Rectangle2D.Double bounds = new Rectangle2D.Double(curBounds.getX(), curBounds.getY(), curBounds.getWidth(), curBounds.getHeight());
                DBMath.transformRect(bounds, prevTrans);
                if (!DBMath.rectsIntersect(bounds, drawLimitBounds)) {
                    return;
                }
            }
            this.countNode(ni, drawLimitBounds, fullInstantiate, orient, prevTrans);
        }
    }

    private void countNode(NodeInst ni, Rectangle2D drawLimitBounds, boolean fullInstantiate, Orientation orient, AffineTransform trans) {
        double objWidth = Math.max(ni.getXSize(), ni.getYSize());
        if (objWidth < maxObjectSize) {
            return;
        }
        Orientation subOrient = orient.concatenate(ni.getOrient());
        AffineTransform subTrans = ni.transformOut(trans);
        NodeProto np = ni.getProto();
        Cell subCell = (Cell)np;
        Rectangle2D cellBounds = subCell.getBounds();
        Poly poly = new Poly(cellBounds);
        poly.transform(subTrans);
        cellBounds = poly.getBounds2D();
        Rectangle screenBounds = this.databaseToScreen(cellBounds);
        if (screenBounds.width <= 0 || screenBounds.height <= 0) {
            return;
        }
        if (screenBounds.x > this.sz.width || screenBounds.x + screenBounds.width < 0) {
            return;
        }
        if (screenBounds.y > this.sz.height || screenBounds.y + screenBounds.height < 0) {
            return;
        }
        boolean expanded = ni.isExpanded();
        if (fullInstantiate) {
            expanded = true;
        }
        boolean bl = expanded = expanded || this.inPlaceSubcellPath != null && this.inPlaceSubcellPath.get(subCell.getId().cellIndex);
        if (!expanded) {
            return;
        }
        if (screenBounds.width < this.sz.width / 2 || screenBounds.height <= this.sz.height / 2) {
            ExpandedCellKey expansionKey = new ExpandedCellKey(subCell, subOrient);
            ExpandedCellInfo expansionCount = expandedCells.get(expansionKey);
            if (expansionCount == null) {
                expansionCount = new ExpandedCellInfo();
                expansionCount.instanceCount = 1;
                expandedCells.put(expansionKey, expansionCount);
            } else {
                expansionCount.instanceCount++;
                if (expansionCount.instanceCount > 1) {
                    return;
                }
            }
        }
        this.countCell(subCell, null, fullInstantiate, subOrient, subTrans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceRedraw(Cell cell) {
        Set<CellId> set = changedCells;
        synchronized (set) {
            changedCells.add(cell.getId());
        }
    }

    private static void forceRedraw(Set<CellId> changedCells) {
        if (expandedCells == null) {
            return;
        }
        ArrayList<ExpandedCellKey> keys = new ArrayList<ExpandedCellKey>();
        for (ExpandedCellKey eck : expandedCells.keySet()) {
            keys.add(eck);
        }
        for (ExpandedCellKey expansionKey : keys) {
            if (!changedCells.contains(expansionKey.cell.getId())) continue;
            expandedCells.remove(expansionKey);
        }
    }

    private void copyBits(LayerDrawing srcOffscreen, int centerX, int centerY) {
        if (srcOffscreen == null) {
            return;
        }
        Dimension dim = srcOffscreen.sz;
        int cornerX = centerX - (int)srcOffscreen.originX;
        int cornerY = centerY - (int)srcOffscreen.originY;
        int minSrcX = Math.max(0, this.clipLX - cornerX);
        int maxSrcX = Math.min(dim.width - 1, this.clipHX - cornerX);
        int minSrcY = Math.max(0, this.clipLY - cornerY);
        int maxSrcY = Math.min(dim.height - 1, this.clipHY - cornerY);
        if (minSrcX > maxSrcX || minSrcY > maxSrcY) {
            return;
        }
        for (Map.Entry<Layer, TransparentRaster> e : srcOffscreen.layerRasters.entrySet()) {
            Layer layer = e.getKey();
            ERaster raster = this.getRaster(layer, layer.getGraphics(), false);
            if (raster == null) continue;
            TransparentRaster polSrc = e.getValue();
            raster.copyBits(polSrc, minSrcX, maxSrcX, minSrcY, maxSrcY, cornerX, cornerY);
        }
    }

    ERaster getRaster(Layer layer, EGraphics graphics, boolean forceVisible) {
        TransparentRaster raster;
        if (layer != null) {
            layer = layer.getNonPseudoLayer();
        }
        if ((layer == null || layer.getTechnology() == null) && layer != instanceLayer && layer != gridLayer) {
            layer = Artwork.tech().defaultLayer;
        }
        if ((raster = this.layerRasters.get(layer)) == null) {
            raster = new TransparentRaster(this.sz.height, this.numIntsPerRow);
            this.layerRasters.put(layer, raster);
        }
        int[] pattern = null;
        if (graphics == null) {
            graphics = layer.getGraphics();
        }
        if (this.nowPrinting != 0 ? graphics.isPatternedOnPrinter() : graphics.isPatternedOnDisplay()) {
            pattern = graphics.getReversedPattern();
        }
        if (pattern != null && this.patternedDisplay && this.renderedWindow) {
            EGraphics.Outline o = graphics.getOutlined();
            if (o == EGraphics.Outline.NOPAT) {
                o = null;
            }
            this.currentPatternedTransparentRaster.init(raster.layerBitMap, raster.intsPerRow, pattern, o);
            raster = this.currentPatternedTransparentRaster;
        }
        return raster;
    }

    private void gridToScreen(int dbX, int dbY, Point result) {
        double scrX = (double)((float)dbX - this.factorX) * this.scale_;
        double scrY = (double)(this.factorY - (float)dbY) * this.scale_;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    private void drawList(int oX, int oY, List<VectorCache.VectorBase> shapes) {
        block13: for (VectorCache.VectorBase vb : shapes) {
            this.periodicRefresh();
            if (vb instanceof VectorCache.VectorText) {
                double size;
                VectorCache.VectorText vt = (VectorCache.VectorText)vb;
                TextDescriptor td = vt.descript;
                if (td != null && !td.isAbsoluteSize() ? (size = td.getTrueSize(expandedScale, this.wnd)) <= this.canDrawRelativeText : !this.canDrawText) continue;
                switch (vt.textType) {
                    case 4: {
                        if (User.isTextVisibilityOnArc()) break;
                        continue block13;
                    }
                    case 3: {
                        if (User.isTextVisibilityOnNode()) break;
                        continue block13;
                    }
                    case 1: {
                        if (User.isTextVisibilityOnCell()) break;
                        continue block13;
                    }
                    case 2: {
                        if (User.isTextVisibilityOnExport()) break;
                        continue block13;
                    }
                    case 5: {
                        if (User.isTextVisibilityOnAnnotation()) break;
                        continue block13;
                    }
                    case 6: {
                        if (User.isTextVisibilityOnInstance()) break;
                        continue block13;
                    }
                }
                String drawString = vt.str;
                int lX = vt.bounds.x;
                int lY = vt.bounds.y;
                int hX = lX + vt.bounds.width;
                int hY = lY + vt.bounds.height;
                this.gridToScreen(lX + oX, hY + oY, this.tempPt1);
                this.gridToScreen(hX + oX, lY + oY, this.tempPt2);
                lX = this.tempPt1.x;
                lY = this.tempPt1.y;
                hX = this.tempPt2.x;
                hY = this.tempPt2.y;
                EGraphics graphics = vt.graphics;
                if (vt.textType == 2 && vt.basePort != null) {
                    if (!vt.basePort.getParent().isVisible()) continue;
                    int exportDisplayLevel = User.getExportDisplayLevel();
                    if (exportDisplayLevel == 2) {
                        int cX = (lX + hX) / 2;
                        int cY = (lY + hY) / 2;
                        this.crossTextList.add(new CrossTextInfo(cX, cY, textColor));
                        continue;
                    }
                    if (exportDisplayLevel == 1) {
                        drawString = Export.getShortName(drawString);
                    }
                    graphics = textGraphics;
                }
                tempRect.setBounds(lX, lY, hX - lX, hY - lY);
                this.drawText(tempRect, vt.style, vt.descript, drawString, graphics);
                continue;
            }
            ERaster raster = this.getRaster(vb.layer, vb.graphics, false);
            if (raster == null) continue;
            if (vb instanceof VectorCache.VectorManhattan) {
                ++boxCount;
                VectorCache.VectorManhattan vm = (VectorCache.VectorManhattan)vb;
                boxArrayCount += vm.coords.length / 4;
                for (int i = 0; i < vm.coords.length; i += 4) {
                    int c1X = vm.coords[i];
                    int c1Y = vm.coords[i + 1];
                    int c2X = vm.coords[i + 2];
                    int c2Y = vm.coords[i + 3];
                    this.gridToScreen(c1X + oX, c2Y + oY, this.tempPt1);
                    this.gridToScreen(c2X + oX, c1Y + oY, this.tempPt2);
                    int lX = this.tempPt1.x;
                    int lY = this.tempPt1.y;
                    int hX = this.tempPt2.x;
                    int hY = this.tempPt2.y;
                    this.drawBox(lX, hX, lY, hY, raster);
                }
                continue;
            }
            if (vb instanceof VectorCache.VectorPolygon) {
                ++polygonCount;
                VectorCache.VectorPolygon vp = (VectorCache.VectorPolygon)vb;
                Point[] intPoints = new Point[vp.points.length];
                for (int i = 0; i < vp.points.length; ++i) {
                    intPoints[i] = new Point();
                    this.gridToScreen(vp.points[i].x + oX, vp.points[i].y + oY, intPoints[i]);
                }
                Point[] clippedPoints = GenMath.clipPoly(intPoints, this.clipLX, this.clipHX, this.clipLY, this.clipHY);
                this.drawPolygon(clippedPoints, raster);
                continue;
            }
            if (vb instanceof VectorCache.VectorLine) {
                ++lineCount;
                VectorCache.VectorLine vl = (VectorCache.VectorLine)vb;
                this.gridToScreen(vl.fX + oX, vl.fY + oY, this.tempPt1);
                this.gridToScreen(vl.tX + oX, vl.tY + oY, this.tempPt2);
                this.drawLine(this.tempPt1, this.tempPt2, vl.texture, raster);
                continue;
            }
            if (vb instanceof VectorCache.VectorCross) {
                ++crossCount;
                VectorCache.VectorCross vcr = (VectorCache.VectorCross)vb;
                this.gridToScreen(vcr.x + oX, vcr.y + oY, this.tempPt1);
                int size = vcr.small ? 3 : 5;
                this.drawCross(this.tempPt1.x, this.tempPt1.y, size, raster);
                continue;
            }
            if (vb instanceof VectorCache.VectorCircle) {
                VectorCache.VectorCircle vci = (VectorCache.VectorCircle)vb;
                this.gridToScreen(vci.cX + oX, vci.cY + oY, this.tempPt1);
                this.gridToScreen(vci.eX + oX, vci.eY + oY, this.tempPt2);
                switch (vci.nature) {
                    case 0: {
                        ++circleCount;
                        this.drawCircle(this.tempPt1, this.tempPt2, raster);
                        break;
                    }
                    case 1: {
                        ++circleCount;
                        this.drawThickCircle(this.tempPt1, this.tempPt2, raster);
                        break;
                    }
                    case 2: {
                        ++discCount;
                        this.drawDisc(this.tempPt1, this.tempPt2, raster);
                    }
                }
                continue;
            }
            if (!(vb instanceof VectorCache.VectorCircleArc)) continue;
            ++arcCount;
            VectorCache.VectorCircleArc vca = (VectorCache.VectorCircleArc)vb;
            this.gridToScreen(vca.cX + oX, vca.cY + oY, this.tempPt1);
            this.gridToScreen(vca.eX1 + oX, vca.eY1 + oY, this.tempPt2);
            this.gridToScreen(vca.eX2 + oX, vca.eY2 + oY, this.tempPt3);
            this.drawCircleArc(this.tempPt1, this.tempPt2, this.tempPt3, vca.thick, raster);
        }
    }

    private void drawPortList(VectorCache.VectorSubCell vsc, VectorCache.VectorCell subVC_, int oX, int oY, boolean expanded) {
        if (!User.isTextVisibilityOnPort()) {
            return;
        }
        List<VectorCache.VectorCellExport> portShapes = subVC_.vcg.getPortShapes();
        int[] portCenters = subVC_.getPortCenters();
        assert (portShapes.size() * 2 == portCenters.length);
        for (int i = 0; i < portShapes.size(); ++i) {
            VectorCache.VectorCellExport vce = portShapes.get(i);
            if (vsc.shownPorts.get(vce.getChronIndex())) continue;
            int cX = portCenters[i * 2];
            int cY = portCenters[i * 2 + 1];
            this.gridToScreen(cX + oX, cY + oY, this.tempPt1);
            cX = this.tempPt1.x;
            cY = this.tempPt1.y;
            int portDisplayLevel = User.getPortDisplayLevel();
            Color portColor = vce.getPortColor();
            if (expanded) {
                portColor = textColor;
            }
            if (portColor != null) {
                portGraphics.setColor(portColor);
            }
            if (portDisplayLevel == 2) {
                this.crossTextList.add(new CrossTextInfo(cX, cY, portColor != null ? portColor : textColor));
                continue;
            }
            boolean shortName = portDisplayLevel == 1;
            String drawString = vce.getName(shortName);
            tempRect.setBounds(cX, cY, 0, 0);
            this.drawText(tempRect, vce.style, vce.descript, drawString, portGraphics);
        }
    }

    int getTheColor(EGraphics desc, boolean dimmed) {
        if (this.nowPrinting == 2) {
            return 0;
        }
        int col = desc.getRGB();
        if (this.highlightingLayers) {
            col = dimmed ? this.dimColor(col) : this.brightenColor(col);
        }
        return col;
    }

    private int dimColor(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        this.fromRGBtoHSV(r, g, b, this.hsvTempArray);
        this.hsvTempArray[1] = this.hsvTempArray[1] * 0.2;
        col = this.fromHSVtoRGB(this.hsvTempArray[0], this.hsvTempArray[1], this.hsvTempArray[2]);
        return col;
    }

    private int brightenColor(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        this.fromRGBtoHSV(r, g, b, this.hsvTempArray);
        this.hsvTempArray[1] = this.hsvTempArray[1] * 1.5;
        if (this.hsvTempArray[1] > 1.0) {
            this.hsvTempArray[1] = 1.0;
        }
        col = this.fromHSVtoRGB(this.hsvTempArray[0], this.hsvTempArray[1], this.hsvTempArray[2]);
        return col;
    }

    private void fromRGBtoHSV(int ir, int ig, int ib, double[] hsi) {
        double r = (float)ir / 255.0f;
        double g = (float)ig / 255.0f;
        double b = (float)ib / 255.0f;
        hsi[2] = Math.max(Math.max(r, g), b);
        double x = Math.min(Math.min(r, g), b);
        hsi[1] = hsi[2] == 0.0 ? 0.0 : (hsi[2] - x) / hsi[2];
        hsi[0] = 0.0;
        if (hsi[1] != 0.0) {
            double rdot = (hsi[2] - r) / (hsi[2] - x);
            double gdot = (hsi[2] - g) / (hsi[2] - x);
            double bdot = (hsi[2] - b) / (hsi[2] - x);
            if (b == x && r == hsi[2]) {
                hsi[0] = (1.0 - gdot) / 6.0;
            } else if (b == x && g == hsi[2]) {
                hsi[0] = (1.0 + rdot) / 6.0;
            } else if (r == x && g == hsi[2]) {
                hsi[0] = (3.0 - bdot) / 6.0;
            } else if (r == x && b == hsi[2]) {
                hsi[0] = (3.0 + gdot) / 6.0;
            } else if (g == x && b == hsi[2]) {
                hsi[0] = (5.0 - rdot) / 6.0;
            } else if (g == x && r == hsi[2]) {
                hsi[0] = (5.0 + bdot) / 6.0;
            } else {
                System.out.println("Cannot convert (" + ir + "," + ig + "," + ib + "), for x=" + x + " i=" + hsi[2] + " s=" + hsi[1]);
            }
        }
    }

    private int fromHSVtoRGB(double h, double s, double v) {
        int i = (int)(h *= 6.0);
        double f = h - (double)i;
        double m = v * (1.0 - s);
        double n = v * (1.0 - s * f);
        double k = v * (1.0 - s * (1.0 - f));
        int r = 0;
        int g = 0;
        int b = 0;
        switch (i) {
            case 0: {
                r = (int)(v * 255.0);
                g = (int)(k * 255.0);
                b = (int)(m * 255.0);
                break;
            }
            case 1: {
                r = (int)(n * 255.0);
                g = (int)(v * 255.0);
                b = (int)(m * 255.0);
                break;
            }
            case 2: {
                r = (int)(m * 255.0);
                g = (int)(v * 255.0);
                b = (int)(k * 255.0);
                break;
            }
            case 3: {
                r = (int)(m * 255.0);
                g = (int)(n * 255.0);
                b = (int)(v * 255.0);
                break;
            }
            case 4: {
                r = (int)(k * 255.0);
                g = (int)(m * 255.0);
                b = (int)(v * 255.0);
                break;
            }
            case 5: {
                r = (int)(v * 255.0);
                g = (int)(m * 255.0);
                b = (int)(n * 255.0);
            }
        }
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            System.out.println("(" + h + "," + s + "," + v + ") -> (" + r + "," + g + "," + b + ") (i=" + i + ")");
            if (r < 0) {
                r = 0;
            }
            if (r > 255) {
                r = 255;
            }
            if (g < 0) {
                g = 0;
            }
            if (g > 255) {
                g = 255;
            }
            if (b < 0) {
                b = 0;
            }
            if (b > 255) {
                b = 255;
            }
        }
        return b << 16 | g << 8 | r;
    }

    public void drawBox(int lX, int hX, int lY, int hY, ERaster raster) {
        block26: {
            EGraphics.Outline o;
            block25: {
                if (lX < this.clipLX) {
                    lX = this.clipLX;
                }
                if (hX > this.clipHX) {
                    hX = this.clipHX;
                }
                if (lY < this.clipLY) {
                    lY = this.clipLY;
                }
                if (hY > this.clipHY) {
                    hY = this.clipHY;
                }
                if (lX > hX || lY > hY) {
                    return;
                }
                ++boxDisplayCount;
                o = raster.getOutline();
                if (lY == hY) {
                    if (lX == hX) {
                        if (o == null) {
                            raster.fillPoint(lX, lY);
                        } else {
                            raster.drawPoint(lX, lY);
                        }
                    } else if (o == null) {
                        raster.fillHorLine(lY, lX, hX);
                    } else {
                        raster.drawHorLine(lY, lX, hX);
                    }
                    return;
                }
                if (lX == hX) {
                    if (o == null) {
                        raster.fillVerLine(lX, lY, hY);
                    } else {
                        raster.drawVerLine(lX, lY, hY);
                    }
                    return;
                }
                raster.fillBox(lX, hX, lY, hY);
                if (o == null) {
                    return;
                }
                if (!o.isSolidPattern()) break block25;
                raster.drawVerLine(lX, lY, hY);
                raster.drawHorLine(hY, lX, hX);
                raster.drawVerLine(hX, lY, hY);
                raster.drawHorLine(lY, lX, hX);
                if (o.getThickness() == 1) break block26;
                for (int i = 1; i < o.getThickness(); ++i) {
                    if (lX + i <= this.clipHX) {
                        raster.drawVerLine(lX + i, lY, hY);
                    }
                    if (hY - i >= this.clipLX) {
                        raster.drawHorLine(hY - i, lX, hX);
                    }
                    if (hX - i >= this.clipLY) {
                        raster.drawVerLine(hX - i, lY, hY);
                    }
                    if (lY + i > this.clipHY) continue;
                    raster.drawHorLine(lY + i, lX, hX);
                }
                break block26;
            }
            int pattern = o.getPattern();
            int len = o.getLen();
            LayerDrawing.drawVerOutline(lX, lY, hY, pattern, len, raster);
            LayerDrawing.drawHorOutline(hY, lX, hX, pattern, len, raster);
            LayerDrawing.drawVerOutline(hX, lY, hY, pattern, len, raster);
            LayerDrawing.drawHorOutline(lY, lX, hX, pattern, len, raster);
            if (o.getThickness() != 1) {
                for (int i = 1; i < o.getThickness(); ++i) {
                    if (lX + i <= this.clipHX) {
                        LayerDrawing.drawVerOutline(lX + i, lY, hY, pattern, len, raster);
                    }
                    if (hY - i >= this.clipLX) {
                        LayerDrawing.drawHorOutline(hY - i, lX, hX, pattern, len, raster);
                    }
                    if (hX - i >= this.clipLY) {
                        LayerDrawing.drawVerOutline(hX - i, lY, hY, pattern, len, raster);
                    }
                    if (lY + i > this.clipHY) continue;
                    LayerDrawing.drawHorOutline(lY + i, lX, hX, pattern, len, raster);
                }
            }
        }
    }

    private static void drawHorOutline(int y, int lX, int hX, int pattern, int len, ERaster raster) {
        int i = 0;
        for (int x = lX; x <= hX; ++x) {
            if ((pattern & 1 << i) != 0) {
                raster.drawPoint(x, y);
            }
            if (++i != len) continue;
            i = 0;
        }
    }

    private static void drawVerOutline(int x, int lY, int hY, int pattern, int len, ERaster raster) {
        int i = 0;
        for (int y = lY; y <= hY; ++y) {
            if ((pattern & 1 << i) != 0) {
                raster.drawPoint(x, y);
            }
            if (++i != len) continue;
            i = 0;
        }
    }

    void drawLine(Point pt1, Point pt2, int texture, ERaster raster) {
        if (GenMath.clipLine(pt1, pt2, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        switch (texture) {
            case 0: {
                this.drawSolidLine(pt1.x, pt1.y, pt2.x, pt2.y, raster);
                break;
            }
            case 1: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, 136, 8, raster);
                break;
            }
            case 2: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, 231, 8, raster);
                break;
            }
            case 3: {
                this.drawThickLine(pt1.x, pt1.y, pt2.x, pt2.y, raster);
            }
        }
    }

    private void drawCross(int cX, int cY, int size, ERaster raster) {
        int hY;
        int lY;
        int hX;
        int lX;
        if (this.clipLY <= cY && cY <= this.clipHY && (lX = Math.max(this.clipLX, cX - size)) <= (hX = Math.min(this.clipHX, cX + size))) {
            raster.drawHorLine(cY, lX, hX);
        }
        if (this.clipLX <= cX && cX <= this.clipHX && (lY = Math.max(this.clipLY, cY - size)) <= (hY = Math.min(this.clipHY, cY + size))) {
            raster.drawVerLine(cX, lY, hY);
        }
    }

    private void drawSolidLine(int x1, int y1, int x2, int y2, ERaster raster) {
        int dy;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            raster.drawPoint(x, y);
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                raster.drawPoint(x, y);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            raster.drawPoint(x, y);
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                raster.drawPoint(x, y);
            }
        }
    }

    private void drawOutline(int x1, int y1, int x2, int y2, int pattern, int len, ERaster raster) {
        this.tempPt3.x = x1;
        this.tempPt3.y = y1;
        this.tempPt4.x = x2;
        this.tempPt4.y = y2;
        if (GenMath.clipLine(this.tempPt3, this.tempPt4, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        this.drawPatLine(this.tempPt3.x, this.tempPt3.y, this.tempPt4.x, this.tempPt4.y, pattern, len, raster);
    }

    private void drawPatLine(int x1, int y1, int x2, int y2, int pattern, int len, ERaster raster) {
        int dy;
        int i = 0;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            raster.drawPoint(x, y);
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                if (++i == len) {
                    i = 0;
                }
                if ((pattern & 1 << i) == 0) continue;
                raster.drawPoint(x, y);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            raster.drawPoint(x, y);
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                if (++i == len) {
                    i = 0;
                }
                if ((pattern & 1 << i) == 0) continue;
                raster.drawPoint(x, y);
            }
        }
    }

    private void drawThickLine(int x1, int y1, int x2, int y2, ERaster raster) {
        int dy;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            this.drawThickPoint(x, y, raster);
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                this.drawThickPoint(x, y, raster);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            this.drawThickPoint(x, y, raster);
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                this.drawThickPoint(x, y, raster);
            }
        }
    }

    void drawPolygon(Point[] points, ERaster raster) {
        int i;
        PolySeg edgelist = null;
        PolySeg[] polySegs = new PolySeg[points.length];
        for (i = 0; i < points.length; ++i) {
            polySegs[i] = new PolySeg();
            if (i == 0) {
                polySegs[i].fx = points[points.length - 1].x;
                polySegs[i].fy = points[points.length - 1].y;
            } else {
                polySegs[i].fx = points[i - 1].x;
                polySegs[i].fy = points[i - 1].y;
            }
            polySegs[i].tx = points[i].x;
            polySegs[i].ty = points[i].y;
        }
        block1: for (i = 0; i < points.length; ++i) {
            int j = polySegs[i].ty - polySegs[i].fy;
            if (j > 0) {
                polySegs[i].direction = 1;
            } else if (j < 0) {
                polySegs[i].direction = -1;
            } else {
                polySegs[i].direction = 0;
            }
            if (j == 0) {
                polySegs[i].increment = 0;
            } else {
                polySegs[i].increment = polySegs[i].tx - polySegs[i].fx;
                if (polySegs[i].increment != 0) {
                    polySegs[i].increment = (polySegs[i].increment * 65536 - j + 1) / j;
                }
            }
            polySegs[i].tx <<= 16;
            polySegs[i].fx <<= 16;
            if (polySegs[i].fy > polySegs[i].ty) {
                j = polySegs[i].tx;
                polySegs[i].tx = polySegs[i].fx;
                polySegs[i].fx = j;
                j = polySegs[i].ty;
                polySegs[i].ty = polySegs[i].fy;
                polySegs[i].fy = j;
            }
            if (edgelist == null) {
                edgelist = polySegs[i];
                polySegs[i].nextedge = null;
                continue;
            }
            if (edgelist.fy > polySegs[i].fy) {
                polySegs[i].nextedge = edgelist;
                edgelist = polySegs[i];
                continue;
            }
            PolySeg a = edgelist;
            while (a != null) {
                if (a.nextedge == null || a.nextedge.fy > polySegs[i].fy) {
                    polySegs[i].nextedge = a.nextedge;
                    a.nextedge = polySegs[i];
                    continue block1;
                }
                a = a.nextedge;
            }
        }
        int ycur = 0;
        PolySeg active = null;
        while (active != null || edgelist != null) {
            if (active == null) {
                active = edgelist;
                active.nextactive = null;
                edgelist = edgelist.nextedge;
                ycur = active.fy;
            }
            block4: while (edgelist != null && edgelist.fy <= ycur) {
                if (active.fx > edgelist.fx || active.fx == edgelist.fx && active.increment > edgelist.increment) {
                    edgelist.nextactive = active;
                    active = edgelist;
                    edgelist = edgelist.nextedge;
                    continue;
                }
                PolySeg a = active;
                while (a != null) {
                    if (a.nextactive == null || a.nextactive.fx > edgelist.fx || a.nextactive.fx == edgelist.fx && a.nextactive.increment > edgelist.increment) {
                        edgelist.nextactive = a.nextactive;
                        a.nextactive = edgelist;
                        edgelist = edgelist.nextedge;
                        continue block4;
                    }
                    a = a.nextactive;
                }
            }
            int wrap = 0;
            PolySeg left = active;
            PolySeg edge = active;
            while (edge != null) {
                if ((wrap += edge.direction) == 0) {
                    int j = left.fx + 32768 >> 16;
                    int k = edge.fx + 32768 >> 16;
                    raster.fillHorLine(ycur, j, k);
                    left = edge.nextactive;
                }
                edge = edge.nextactive;
            }
            ++ycur;
            PolySeg lastedge = null;
            PolySeg edge2 = active;
            while (edge2 != null) {
                if (ycur >= edge2.ty) {
                    if (lastedge == null) {
                        active = edge2.nextactive;
                    } else {
                        lastedge.nextactive = edge2.nextactive;
                    }
                } else {
                    edge2.fx += edge2.increment;
                    lastedge = edge2;
                }
                edge2 = edge2.nextactive;
            }
        }
        EGraphics.Outline o = raster.getOutline();
        if (o == null) {
            return;
        }
        for (int i2 = 0; i2 < points.length; ++i2) {
            int last = i2 - 1;
            if (last < 0) {
                last = points.length - 1;
            }
            int fX = points[last].x;
            int fY = points[last].y;
            int tX = points[i2].x;
            int tY = points[i2].y;
            this.drawOutline(fX, fY, tX, tY, o.getPattern(), o.getLen(), raster);
            if (o.getThickness() == 1) continue;
            int ang = GenMath.figureAngle(new Point2D.Double(fX, fY), new Point2D.Double(tX, tY));
            double sin = DBMath.sin(ang + 900);
            double cos = DBMath.cos(ang + 900);
            for (int t = 1; t < o.getThickness(); ++t) {
                int dX = (int)(cos * (double)t + 0.5);
                int dY = (int)(sin * (double)t + 0.5);
                this.drawOutline(fX + dX, fY + dY, tX + dX, tY + dY, o.getPattern(), o.getLen(), raster);
            }
        }
    }

    public void drawText(Rectangle rect, Poly.Type style, TextDescriptor descript, String s, EGraphics desc) {
        if (s == null) {
            return;
        }
        int len = s.length();
        if (len == 0) {
            return;
        }
        Color color = textColor;
        if (desc != null) {
            color = desc.getOpaqueColor();
        }
        int col = color.getRGB() & 0xFFFFFF;
        int size = EditWindow.getDefaultFontSize();
        boolean fontStyle = false;
        String fontName = User.getDefaultFont();
        boolean italic = false;
        boolean bold = false;
        boolean underline = false;
        int rotation = 0;
        int greekScale = 0;
        if (descript != null) {
            AbstractTextDescriptor.ActiveFont af;
            double dSize;
            Color full;
            rotation = descript.getRotation().getIndex();
            int colorIndex = descript.getColorIndex();
            if (colorIndex != 0 && (full = EGraphics.getColorFromIndex(colorIndex)) != null) {
                col = full.getRGB() & 0xFFFFFF;
            }
            if ((size = Math.min((int)(dSize = descript.getTrueSize(this.scale, this.wnd)), 200)) < 5) {
                greekScale = 2;
                while ((size = (int)(dSize * (double)greekScale)) < 5) {
                    greekScale *= 2;
                }
            }
            italic = descript.isItalic();
            bold = descript.isBold();
            underline = descript.isUnderline();
            int fontIndex = descript.getFace();
            if (fontIndex != 0 && (af = AbstractTextDescriptor.ActiveFont.findActiveFont(fontIndex)) != null) {
                fontName = af.getName();
            }
        }
        if (style == Poly.Type.TEXTBOX && (rect.x >= this.sz.width || rect.x + rect.width < 0 || rect.y >= this.sz.height || rect.y + rect.height < 0)) {
            return;
        }
        long startTime = 0L;
        RenderTextInfo renderInfo = new RenderTextInfo();
        if (!renderInfo.buildInfo(s, fontName, size, italic, bold, underline, rect, style, rotation, color)) {
            return;
        }
        if (greekScale != 0) {
            int lY;
            int width = (int)renderInfo.bounds.getWidth() / greekScale;
            int sizeIndent = (size / greekScale + 1) / 4;
            Point pt = LayerDrawing.getTextCorner(width, size / greekScale, style, rect, rotation);
            int lX = pt.x;
            int hX = lX + width;
            int hY = lY = pt.y + sizeIndent;
            if (lX < 0) {
                lX = 0;
            }
            if (hX >= this.sz.width) {
                hX = this.sz.width - 1;
            }
            if (lY < 0) {
                lY = 0;
            }
            if (hY >= this.sz.height) {
                hY = this.sz.height - 1;
            }
            if (lX > hX || lY > hY) {
                return;
            }
            this.greekTextList.add(new GreekTextInfo(lX, hX, lY, hY, color));
            return;
        }
        if (renderInfo.bounds.getMinX() >= (double)this.sz.width || renderInfo.bounds.getMaxX() < 0.0 || renderInfo.bounds.getMinY() >= (double)this.sz.height || renderInfo.bounds.getMaxY() < 0.0) {
            return;
        }
        this.renderTextList.add(renderInfo);
    }

    private static Point getTextCorner(int rasterWidth, int rasterHeight, Poly.Type style, Rectangle rect, int rotation) {
        int textWidth = rasterWidth;
        int textHeight = rasterHeight;
        int offX = 0;
        int offY = 0;
        if (style == Poly.Type.TEXTCENT) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTTOP) {
            offX = -textWidth / 2;
        } else if (style == Poly.Type.TEXTBOT) {
            offX = -textWidth / 2;
            offY = -textHeight;
        } else if (style == Poly.Type.TEXTLEFT) {
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTRIGHT) {
            offX = -textWidth;
            offY = -textHeight / 2;
        } else if (style != Poly.Type.TEXTTOPLEFT) {
            if (style == Poly.Type.TEXTBOTLEFT) {
                offY = -textHeight;
            } else if (style == Poly.Type.TEXTTOPRIGHT) {
                offX = -textWidth;
            } else if (style == Poly.Type.TEXTBOTRIGHT) {
                offX = -textWidth;
                offY = -textHeight;
            }
        }
        if (style == Poly.Type.TEXTBOX) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        }
        if (rotation != 0) {
            int saveOffX = offX;
            switch (rotation) {
                case 1: {
                    offX = offY;
                    offY = -saveOffX;
                    break;
                }
                case 2: {
                    offX = -offX;
                    offY = -offY;
                    break;
                }
                case 3: {
                    offX = -offY;
                    offY = saveOffX;
                }
            }
        }
        int cX = (int)rect.getCenterX() + offX;
        int cY = (int)rect.getCenterY() + offY;
        return new Point(cX, cY);
    }

    public static Font getFont(String msg, String font, int tSize, boolean italic, boolean bold, boolean underline) {
        Font theFont;
        int fontStyle = 0;
        if (italic) {
            fontStyle |= 2;
        }
        if (bold) {
            fontStyle |= 1;
        }
        if ((theFont = new Font(font, fontStyle, tSize)) == null) {
            System.out.println("Could not find font " + font + " to render text: " + msg);
            return null;
        }
        return theFont;
    }

    void drawCircle(Point center, Point edge, ERaster raster) {
        int x;
        int radius = (int)center.distance(edge);
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        int y = radius;
        int d = 3 - 2 * radius;
        if (left >= 0 && right < this.sz.width && top >= 0 && bottom < this.sz.height) {
            for (x = 0; x <= y; ++x) {
                raster.drawPoint(center.x + x, center.y + y);
                raster.drawPoint(center.x - x, center.y + y);
                raster.drawPoint(center.x + x, center.y - y);
                raster.drawPoint(center.x - x, center.y - y);
                raster.drawPoint(center.x + y, center.y + x);
                raster.drawPoint(center.x - y, center.y + x);
                raster.drawPoint(center.x + y, center.y - x);
                raster.drawPoint(center.x - y, center.y - x);
                if (d < 0) {
                    d += 4 * x + 6;
                    continue;
                }
                d += 4 * (x - y) + 10;
                --y;
            }
        } else {
            while (x <= y) {
                int thisx;
                int thisy = center.y + y;
                if (thisy >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if (d < 0) {
                    d += 4 * x + 6;
                } else {
                    d += 4 * (x - y) + 10;
                    --y;
                }
                ++x;
            }
        }
    }

    void drawThickCircle(Point center, Point edge, ERaster raster) {
        int radius = (int)center.distance(edge);
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            int thisx;
            int thisy = center.y + y;
            if (thisy >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if (d < 0) {
                d += 4 * x + 6;
                continue;
            }
            d += 4 * (x - y) + 10;
            --y;
        }
    }

    private void drawDiscRow(int thisy, int startx, int endx, ERaster raster) {
        if (thisy < this.clipLY || thisy > this.clipHY) {
            return;
        }
        if (startx < this.clipLX) {
            startx = this.clipLX;
        }
        if (endx > this.clipHX) {
            endx = this.clipHX;
        }
        raster.fillHorLine(thisy, startx, endx);
    }

    void drawDisc(Point center, Point edge, ERaster raster) {
        int radius = (int)center.distance(edge);
        EGraphics.Outline o = raster.getOutline();
        if (o != null) {
            this.drawCircle(center, edge, raster);
        }
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        if (radius == 1) {
            if (left < 0) {
                left = 0;
            }
            if (right >= this.sz.width) {
                right = this.sz.width - 1;
            }
            for (int y = top; y < bottom; ++y) {
                if (y < 0 || y >= this.sz.height) continue;
                for (int x = left; x < right; ++x) {
                    raster.drawPoint(x, y);
                }
            }
            return;
        }
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            this.drawDiscRow(center.y + y, center.x - x, center.x + x, raster);
            this.drawDiscRow(center.y - y, center.x - x, center.x + x, raster);
            this.drawDiscRow(center.y + x, center.x - y, center.x + y, raster);
            this.drawDiscRow(center.y - x, center.x - y, center.x + y, raster);
            if (d < 0) {
                d += 4 * x + 6;
                continue;
            }
            d += 4 * (x - y) + 10;
            --y;
        }
    }

    private int arcFindOctant(int x, int y) {
        if (x > 0) {
            if (y >= 0) {
                if (y >= x) {
                    return 7;
                }
                return 8;
            }
            if (x >= -y) {
                return 1;
            }
            return 2;
        }
        if (y > 0) {
            if (y > -x) {
                return 6;
            }
            return 5;
        }
        if (y > x) {
            return 4;
        }
        return 3;
    }

    private Point arcXformOctant(int x, int y, int oct) {
        switch (oct) {
            case 1: {
                return new Point(-y, x);
            }
            case 2: {
                return new Point(x, -y);
            }
            case 3: {
                return new Point(-x, -y);
            }
            case 4: {
                return new Point(-y, -x);
            }
            case 5: {
                return new Point(y, -x);
            }
            case 6: {
                return new Point(-x, y);
            }
            case 7: {
                return new Point(x, y);
            }
            case 8: {
                return new Point(y, x);
            }
        }
        return null;
    }

    private void arcDoPixel(int x, int y) {
        if (x < this.clipLX || x > this.clipHX || y < this.clipLY || y > this.clipHY) {
            return;
        }
        if (this.arcThick) {
            this.drawThickPoint(x, y, this.arcRaster);
        } else {
            this.arcRaster.drawPoint(x, y);
        }
    }

    private void arcOutXform(int x, int y) {
        if (this.arcOctTable[1]) {
            this.arcDoPixel(y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[2]) {
            this.arcDoPixel(x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[3]) {
            this.arcDoPixel(-x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[4]) {
            this.arcDoPixel(-y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[5]) {
            this.arcDoPixel(-y + this.arcCenter.x, x + this.arcCenter.y);
        }
        if (this.arcOctTable[6]) {
            this.arcDoPixel(-x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[7]) {
            this.arcDoPixel(x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[8]) {
            this.arcDoPixel(y + this.arcCenter.x, x + this.arcCenter.y);
        }
    }

    private void arcBresCW(Point pt, Point pt1) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt1.x && pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        while (pt.x < pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.x;
        }
        while (pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            --pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    private void arcBresMidCW(Point pt) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        if (pt.x == pt.y) {
            this.arcOutXform(pt.x, pt.y);
        }
    }

    private void arcBresMidCCW(Point pt) {
        int d = 3 + 2 * pt.y - 4 * pt.x;
        while (pt.x > 0) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        this.arcOutXform(0, this.arcRadius);
    }

    private void arcBresCCW(Point pt, Point pt1) {
        int d = 3 + 2 * pt.y + 4 * pt.x;
        while (pt.x > pt1.x && pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        while (pt.x > pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            --pt.x;
        }
        while (pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    void drawCircleArc(Point center, Point p1, Point p2, boolean thick, ERaster raster) {
        if (p1.x == p2.x && p1.y == p2.y) {
            return;
        }
        this.arcRaster = raster;
        this.arcCenter = center;
        int pa_x = p2.x - this.arcCenter.x;
        int pa_y = p2.y - this.arcCenter.y;
        int pb_x = p1.x - this.arcCenter.x;
        int pb_y = p1.y - this.arcCenter.y;
        this.arcRadius = (int)this.arcCenter.distance(p2);
        int alternate = (int)this.arcCenter.distance(p1);
        int start_oct = this.arcFindOctant(pa_x, pa_y);
        int end_oct = this.arcFindOctant(pb_x, pb_y);
        this.arcThick = thick;
        if (this.arcRadius != alternate) {
            int diff = this.arcRadius - alternate;
            switch (end_oct) {
                case 6: 
                case 7: {
                    pb_y += diff;
                    break;
                }
                case 1: 
                case 8: {
                    pb_x += diff;
                    break;
                }
                case 2: 
                case 3: {
                    pb_y -= diff;
                    break;
                }
                case 4: 
                case 5: {
                    pb_x -= diff;
                }
            }
        }
        for (int i = 1; i < 9; ++i) {
            this.arcOctTable[i] = false;
        }
        if (start_oct == end_oct) {
            this.arcOctTable[start_oct] = true;
            Point pa = this.arcXformOctant(pa_x, pa_y, start_oct);
            Point pb = this.arcXformOctant(pb_x, pb_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresCW(pa, pb);
            } else {
                this.arcBresCCW(pa, pb);
            }
            this.arcOctTable[start_oct] = false;
        } else {
            this.arcOctTable[start_oct] = true;
            Point pt = this.arcXformOctant(pa_x, pa_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresMidCW(pt);
            } else {
                this.arcBresMidCCW(pt);
            }
            this.arcOctTable[start_oct] = false;
            this.arcOctTable[end_oct] = true;
            pt = this.arcXformOctant(pb_x, pb_y, end_oct);
            if ((end_oct & 1) != 0) {
                this.arcBresMidCCW(pt);
            } else {
                this.arcBresMidCW(pt);
            }
            this.arcOctTable[end_oct] = false;
            if (this.MODP(start_oct + 1) != end_oct) {
                if (this.MODP(start_oct + 1) == this.MODM(end_oct - 1)) {
                    this.arcOctTable[this.MODP((int)(start_oct + 1))] = true;
                } else {
                    int i = this.MODP(start_oct + 1);
                    while (i != end_oct) {
                        this.arcOctTable[i] = true;
                        i = this.MODP(i + 1);
                    }
                }
                this.arcBresMidCW(new Point(0, this.arcRadius));
            }
        }
    }

    private int MODM(int x) {
        return x < 1 ? x + 8 : x;
    }

    private int MODP(int x) {
        return x > 8 ? x - 8 : x;
    }

    private void drawPoint(int x, int y, byte[] layerBitMap, byte layerBitMask) {
        int n = y * this.width + x;
        layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
    }

    private void drawThickPoint(int x, int y, ERaster raster) {
        raster.drawPoint(x, y);
        if (x > this.clipLX) {
            raster.drawPoint(x - 1, y);
        }
        if (x < this.clipHX) {
            raster.drawPoint(x + 1, y);
        }
        if (y > this.clipLY) {
            raster.drawPoint(x, y - 1);
        }
        if (y < this.sz.height - 1) {
            raster.drawPoint(x, y + 1);
        }
    }

    private void drawThickPoint(int x, int y, byte[] layerBitMap, byte layerBitMask) {
        int baseIndex;
        int n = baseIndex = y * this.sz.width + x;
        layerBitMap[n] = (byte)(layerBitMap[n] | layerBitMask);
        if (x > this.clipLX) {
            int n2 = baseIndex - 1;
            layerBitMap[n2] = (byte)(layerBitMap[n2] | layerBitMask);
        }
        if (x < this.clipHX) {
            int n3 = baseIndex + 1;
            layerBitMap[n3] = (byte)(layerBitMap[n3] | layerBitMask);
        }
        if (y > this.clipLY) {
            int n4 = baseIndex - this.width;
            layerBitMap[n4] = (byte)(layerBitMap[n4] | layerBitMask);
        }
        if (y < this.sz.height - 1) {
            int n5 = baseIndex + this.width;
            layerBitMap[n5] = (byte)(layerBitMap[n5] | layerBitMask);
        }
    }

    private void databaseToScreen(double dbX, double dbY, Point result) {
        double scrX = this.originX + dbX * this.scale;
        double scrY = this.originY - dbY * this.scale;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    private void screenToDatabase(int x, int y, Point2D result) {
        result.setLocation(((double)x - this.originX) / this.scale, (this.originY - (double)y) / this.scale);
    }

    private Rectangle databaseToScreen(Rectangle2D db) {
        int swap;
        Point llPt = this.tempPt1;
        Point urPt = this.tempPt2;
        this.databaseToScreen(db.getMinX(), db.getMinY(), llPt);
        this.databaseToScreen(db.getMaxX(), db.getMaxY(), urPt);
        int screenLX = llPt.x;
        int screenHX = urPt.x;
        int screenLY = llPt.y;
        int screenHY = urPt.y;
        if (screenHX < screenLX) {
            swap = screenHX;
            screenHX = screenLX;
            screenLX = swap;
        }
        if (screenHY < screenLY) {
            swap = screenHY;
            screenHY = screenLY;
            screenLY = swap;
        }
        return new Rectangle(screenLX, screenLY, screenHX - screenLX + 1, screenHY - screenLY + 1);
    }

    static {
        offscreensUsedSet = new HashSet<ExpandedCellKey>();
        expandedCells = null;
        changedCells = new HashSet<CellId>();
        expandedScale = 0.0;
        CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        textGraphics = new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        instanceGraphics = new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        instanceLayer = Layer.newInstanceFree(null, "Instance", instanceGraphics);
        gridGraphics = new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        gridLayer = Layer.newInstanceFree(null, "Grid", gridGraphics);
        portGraphics = new EGraphics(false, false, null, 0, 255, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        tempRect = new Rectangle();
    }

    private class CrossTextInfo {
        int x;
        int y;
        Color color;

        private CrossTextInfo(int x, int y, Color color) {
            this.x = x;
            this.y = y;
            this.color = color;
        }

        private void draw(Graphics2D g) {
            g.setColor(this.color);
            g.drawLine(this.x - 3, this.y, this.x + 3, this.y);
            g.drawLine(this.x, this.y - 3, this.x, this.y + 3);
        }
    }

    private class GreekTextInfo {
        int lX;
        int hX;
        int lY;
        int hY;
        Color color;

        private GreekTextInfo(int lX, int hX, int lY, int hY, Color color) {
            this.lX = lX;
            this.hX = hX;
            this.lY = lY;
            this.hY = hY;
            this.color = color;
        }

        private void draw(Graphics2D g) {
            g.setColor(this.color);
            g.drawLine(this.lX, this.lY, this.hX, this.hY);
        }
    }

    private static class RenderTextInfo {
        private GlyphVector gv;
        private LineMetrics lm;
        private Rectangle2D rasBounds;
        private Rectangle2D bounds;
        private boolean underline;
        private int rotation;
        private Color color;
        private Rectangle rect;
        private int offX;
        private int offY;

        private RenderTextInfo() {
        }

        private boolean buildInfo(String msg, String fontName, int tSize, boolean italic, boolean bold, boolean underline, Rectangle probableBoxedBounds, Poly.Type style, int rotation, Color color) {
            double scale;
            Font font = LayerDrawing.getFont(msg, fontName, tSize, italic, bold, underline);
            this.underline = underline;
            this.rotation = rotation;
            this.color = color;
            this.rect = (Rectangle)probableBoxedBounds.clone();
            FontRenderContext frc = new FontRenderContext(null, true, true);
            this.gv = font.createGlyphVector(frc, msg);
            this.lm = font.getLineMetrics(msg, frc);
            Rectangle2D rasRect = this.gv.getLogicalBounds();
            int width = (int)rasRect.getWidth();
            int height = (int)((double)this.lm.getHeight() + 0.5);
            if (width <= 0 || height <= 0) {
                return false;
            }
            int fontStyle = font.getStyle();
            int boxedWidth = (int)probableBoxedBounds.getWidth();
            int boxedHeight = (int)probableBoxedBounds.getHeight();
            if (boxedWidth > 1 && boxedHeight > 1 && (width > boxedWidth || height > boxedHeight) && (font = new Font(fontName, fontStyle, (int)((double)tSize * (scale = Math.min((double)boxedWidth / (double)width, (double)boxedHeight / (double)height))))) != null) {
                this.gv = font.createGlyphVector(frc, msg);
                this.lm = font.getLineMetrics(msg, frc);
                rasRect = this.gv.getLogicalBounds();
                height = (int)((double)this.lm.getHeight() + 0.5);
                if (height <= 0) {
                    return false;
                }
                width = (int)rasRect.getWidth();
            }
            if (underline) {
                ++height;
            }
            this.rasBounds = new Rectangle2D.Double(0.0, this.lm.getAscent() - this.lm.getLeading(), width, height);
            Point anchorPoint = LayerDrawing.getTextCorner(width, height, style, probableBoxedBounds, rotation);
            this.bounds = rotation == 1 || rotation == 3 ? new Rectangle2D.Double(((Point2D)anchorPoint).getX(), ((Point2D)anchorPoint).getY(), height, width) : new Rectangle2D.Double(((Point2D)anchorPoint).getX(), ((Point2D)anchorPoint).getY(), width, height);
            int textWidth = (int)this.rasBounds.getWidth();
            int textHeight = (int)this.rasBounds.getHeight();
            if (style == Poly.Type.TEXTCENT) {
                this.offX = -textWidth / 2;
                this.offY = -textHeight / 2;
            } else if (style == Poly.Type.TEXTTOP) {
                this.offX = -textWidth / 2;
            } else if (style == Poly.Type.TEXTBOT) {
                this.offX = -textWidth / 2;
                this.offY = -textHeight;
            } else if (style == Poly.Type.TEXTLEFT) {
                this.offY = -textHeight / 2;
            } else if (style == Poly.Type.TEXTRIGHT) {
                this.offX = -textWidth;
                this.offY = -textHeight / 2;
            } else if (style != Poly.Type.TEXTTOPLEFT) {
                if (style == Poly.Type.TEXTBOTLEFT) {
                    this.offY = -textHeight;
                } else if (style == Poly.Type.TEXTTOPRIGHT) {
                    this.offX = -textWidth;
                } else if (style == Poly.Type.TEXTBOTRIGHT) {
                    this.offX = -textWidth;
                    this.offY = -textHeight;
                }
            }
            if (style == Poly.Type.TEXTBOX) {
                this.offX = -textWidth / 2;
                this.offY = -textHeight / 2;
            }
            return true;
        }

        private void draw(Graphics2D g) {
            int width = (int)this.rasBounds.getWidth();
            int height = (int)this.rasBounds.getHeight();
            g.setColor(this.color);
            if (this.rotation == 0) {
                int atX = (int)this.rect.getCenterX() + this.offX;
                int atY = (int)this.rect.getCenterY() + this.offY;
                g.drawGlyphVector(this.gv, (float)((double)atX - this.rasBounds.getX()), (float)atY + (this.lm.getAscent() - this.lm.getLeading()));
                if (this.underline) {
                    g.drawLine(atX, atY + height - 1, atX + width - 1, atY + height - 1);
                }
            } else {
                AffineTransform saveAT = g.getTransform();
                g.translate(this.rect.getCenterX(), this.rect.getCenterY());
                g.rotate((double)(-this.rotation) * Math.PI / 2.0);
                g.drawGlyphVector(this.gv, (float)((double)this.offX - this.rasBounds.getX()), (float)this.offY + (this.lm.getAscent() - this.lm.getLeading()));
                if (this.underline) {
                    g.drawLine(this.offX, this.offY + height - 1, this.offX + width - 1, this.offY + height - 1);
                }
                g.setTransform(saveAT);
            }
        }
    }

    private static class PatternedTransparentRaster
    extends TransparentRaster {
        int[] pattern;
        EGraphics.Outline outline;

        PatternedTransparentRaster() {
        }

        private void init(int[] layerBitMap, int intsPerRow, int[] pattern, EGraphics.Outline outline) {
            ((TransparentRaster)this).init(layerBitMap, intsPerRow);
            this.pattern = pattern;
            this.outline = outline;
        }

        public void fillBox(int lX, int hX, int lY, int hY) {
            int baseIndex = lY * this.intsPerRow;
            int lIndex = baseIndex + (lX >> 5);
            int hIndex = baseIndex + (hX >> 5);
            if (lIndex == hIndex) {
                int mask = (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
                for (int y = lY; y < hY; ++y) {
                    int pat = mask & this.pattern[y & 0xF];
                    if (pat != 0) {
                        int n = lIndex;
                        this.layerBitMap[n] = this.layerBitMap[n] | pat;
                    }
                    lIndex += this.intsPerRow;
                }
            } else {
                int lMask = -(1 << (lX & 0x1F));
                int hMask = (2 << (hX & 0x1F)) - 1;
                for (int y = lY; y <= hY; ++y) {
                    int pat = this.pattern[y & 0xF];
                    if (pat != 0) {
                        int n = lIndex;
                        this.layerBitMap[n] = this.layerBitMap[n] | lMask & pat;
                        int index = lIndex + 1;
                        while (index < hIndex) {
                            int n2 = index++;
                            this.layerBitMap[n2] = this.layerBitMap[n2] | pat;
                        }
                        int n3 = hIndex;
                        this.layerBitMap[n3] = this.layerBitMap[n3] | hMask & pat;
                    }
                    lIndex += this.intsPerRow;
                    hIndex += this.intsPerRow;
                }
            }
        }

        public void fillHorLine(int y, int lX, int hX) {
            int pat = this.pattern[y & 0xF];
            if (pat == 0) {
                return;
            }
            int baseIndex = y * this.intsPerRow;
            int lIndex = baseIndex + (lX >> 5);
            int hIndex = baseIndex + (hX >> 5);
            if (lIndex == hIndex) {
                int mask = pat & (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
                if (mask != 0) {
                    int n = lIndex;
                    this.layerBitMap[n] = this.layerBitMap[n] | mask;
                }
            } else {
                int n = lIndex++;
                this.layerBitMap[n] = this.layerBitMap[n] | pat & -(1 << (lX & 0x1F));
                while (lIndex < hIndex) {
                    int n2 = lIndex++;
                    this.layerBitMap[n2] = this.layerBitMap[n2] | pat;
                }
                int n3 = hIndex;
                this.layerBitMap[n3] = this.layerBitMap[n3] | pat & (2 << (hX & 0x1F)) - 1;
            }
        }

        public void fillVerLine(int x, int lY, int hY) {
            int baseIndex = lY * this.intsPerRow + (x >> 5);
            int mask = 1 << (x & 0x1F);
            for (int y = lY; y <= hY; ++y) {
                if ((this.pattern[y & 0xF] & mask) != 0) {
                    int n = baseIndex;
                    this.layerBitMap[n] = this.layerBitMap[n] | mask;
                }
                baseIndex += this.intsPerRow;
            }
        }

        public void fillPoint(int x, int y) {
            int mask = 1 << (x & 0x1F) & this.pattern[y & 0xF];
            if (mask != 0) {
                int n = y * this.intsPerRow + (x >> 5);
                this.layerBitMap[n] = this.layerBitMap[n] | mask;
            }
        }

        public EGraphics.Outline getOutline() {
            return this.outline;
        }

        public void copyBits(TransparentRaster src, int minSrcX, int maxSrcX, int minSrcY, int maxSrcY, int dx, int dy) {
            int[] srcLayerBitMap = src.layerBitMap;
            assert ((minSrcY + dy) * this.intsPerRow + (minSrcX + dx >> 5) >= 0);
            assert ((maxSrcY + dy) * this.intsPerRow + (maxSrcX + dx >> 5) < this.layerBitMap.length);
            for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                int destY = srcY + dy;
                int pat = this.pattern[destY & 0xF];
                if (pat == 0) continue;
                int srcBaseIndex = srcY * src.intsPerRow;
                int destBaseIndex = destY * this.intsPerRow;
                for (int srcX = minSrcX; srcX <= maxSrcX; ++srcX) {
                    int destMask;
                    int destX = srcX + dx;
                    if ((srcLayerBitMap[srcBaseIndex + (srcX >> 5)] & 1 << (srcX & 0x1F)) == 0 || (pat & (destMask = 1 << (destX & 0x1F))) == 0) continue;
                    int n = destBaseIndex + (destX >> 5);
                    this.layerBitMap[n] = this.layerBitMap[n] | destMask;
                }
            }
        }
    }

    private static class TransparentRaster
    implements ERaster {
        private static TransparentRaster current = new TransparentRaster();
        int[] layerBitMap;
        int intsPerRow;

        private TransparentRaster() {
        }

        TransparentRaster(int height, int numIntsPerRow) {
            this.intsPerRow = numIntsPerRow;
            this.layerBitMap = new int[height * numIntsPerRow];
        }

        private void init(int[] layerBitMap, int intsPerRow) {
            this.layerBitMap = layerBitMap;
            this.intsPerRow = intsPerRow;
        }

        public void fillBox(int lX, int hX, int lY, int hY) {
            int baseIndex = lY * this.intsPerRow;
            int lIndex = baseIndex + (lX >> 5);
            int hIndex = baseIndex + (hX >> 5);
            if (lIndex == hIndex) {
                int mask = (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
                for (int y = lY; y < hY; ++y) {
                    int n = lIndex;
                    this.layerBitMap[n] = this.layerBitMap[n] | mask;
                    lIndex += this.intsPerRow;
                }
            } else {
                int lMask = -(1 << (lX & 0x1F));
                int hMask = (2 << (hX & 0x1F)) - 1;
                for (int y = lY; y <= hY; ++y) {
                    int n = lIndex;
                    this.layerBitMap[n] = this.layerBitMap[n] | lMask;
                    for (int index = lIndex + 1; index < hIndex; ++index) {
                        this.layerBitMap[index] = -1;
                    }
                    int n2 = hIndex;
                    this.layerBitMap[n2] = this.layerBitMap[n2] | hMask;
                    lIndex += this.intsPerRow;
                    hIndex += this.intsPerRow;
                }
            }
        }

        public void eraseBox(int lX, int hX, int lY, int hY) {
            int baseIndex = lY * this.intsPerRow;
            int lIndex = baseIndex + (lX >> 5);
            int hIndex = baseIndex + (hX >> 5);
            if (lIndex == hIndex) {
                int mask = (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
                mask ^= 0xFFFFFFFF;
                for (int y = lY; y < hY; ++y) {
                    int n = lIndex;
                    this.layerBitMap[n] = this.layerBitMap[n] & mask;
                    lIndex += this.intsPerRow;
                }
            } else {
                int lMask = -(1 << (lX & 0x1F));
                int hMask = (2 << (hX & 0x1F)) - 1;
                lMask ^= 0xFFFFFFFF;
                hMask ^= 0xFFFFFFFF;
                for (int y = lY; y <= hY; ++y) {
                    int n = lIndex;
                    this.layerBitMap[n] = this.layerBitMap[n] & lMask;
                    for (int index = lIndex + 1; index < hIndex; ++index) {
                        this.layerBitMap[index] = 0;
                    }
                    int n2 = hIndex;
                    this.layerBitMap[n2] = this.layerBitMap[n2] & hMask;
                    lIndex += this.intsPerRow;
                    hIndex += this.intsPerRow;
                }
            }
        }

        public void eraseAll() {
            for (int i = 0; i < this.layerBitMap.length; ++i) {
                this.layerBitMap[i] = 0;
            }
        }

        public void fillHorLine(int y, int lX, int hX) {
            int baseIndex = y * this.intsPerRow;
            int lIndex = baseIndex + (lX >> 5);
            int hIndex = baseIndex + (hX >> 5);
            if (lIndex == hIndex) {
                int n = lIndex;
                this.layerBitMap[n] = this.layerBitMap[n] | (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
            } else {
                int n = lIndex++;
                this.layerBitMap[n] = this.layerBitMap[n] | -(1 << (lX & 0x1F));
                while (lIndex < hIndex) {
                    int n2 = lIndex++;
                    this.layerBitMap[n2] = this.layerBitMap[n2] | 0xFFFFFFFF;
                }
                int n3 = hIndex;
                this.layerBitMap[n3] = this.layerBitMap[n3] | (2 << (hX & 0x1F)) - 1;
            }
        }

        public void fillVerLine(int x, int lY, int hY) {
            int baseIndex = lY * this.intsPerRow + (x >> 5);
            int mask = 1 << (x & 0x1F);
            for (int y = lY; y <= hY; ++y) {
                int n = baseIndex;
                this.layerBitMap[n] = this.layerBitMap[n] | mask;
                baseIndex += this.intsPerRow;
            }
        }

        public void fillPoint(int x, int y) {
            int n = y * this.intsPerRow + (x >> 5);
            this.layerBitMap[n] = this.layerBitMap[n] | 1 << (x & 0x1F);
        }

        public void drawHorLine(int y, int lX, int hX) {
            int baseIndex = y * this.intsPerRow;
            int lIndex = baseIndex + (lX >> 5);
            int hIndex = baseIndex + (hX >> 5);
            if (lIndex == hIndex) {
                int n = lIndex;
                this.layerBitMap[n] = this.layerBitMap[n] | (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
            } else {
                int n = lIndex++;
                this.layerBitMap[n] = this.layerBitMap[n] | -(1 << (lX & 0x1F));
                while (lIndex < hIndex) {
                    int n2 = lIndex++;
                    this.layerBitMap[n2] = this.layerBitMap[n2] | 0xFFFFFFFF;
                }
                int n3 = hIndex;
                this.layerBitMap[n3] = this.layerBitMap[n3] | (2 << (hX & 0x1F)) - 1;
            }
        }

        public void drawVerLine(int x, int lY, int hY) {
            int baseIndex = lY * this.intsPerRow + (x >> 5);
            int mask = 1 << (x & 0x1F);
            for (int y = lY; y <= hY; ++y) {
                int n = baseIndex;
                this.layerBitMap[n] = this.layerBitMap[n] | mask;
                baseIndex += this.intsPerRow;
            }
        }

        public void drawPoint(int x, int y) {
            int n = y * this.intsPerRow + (x >> 5);
            this.layerBitMap[n] = this.layerBitMap[n] | 1 << (x & 0x1F);
        }

        public EGraphics.Outline getOutline() {
            return null;
        }

        public void copyBits(TransparentRaster src, int minSrcX, int maxSrcX, int minSrcY, int maxSrcY, int dx, int dy) {
            int[] srcLayerBitMap = src.layerBitMap;
            int minDestX = minSrcX + dx;
            int maxDestX = maxSrcX + dx;
            int minDestY = minSrcY + dy;
            int maxDestY = maxSrcY + dy;
            int leftShift = dx & 0x1F;
            int rightShift = 32 - leftShift;
            int srcBaseIndex = minSrcY * src.intsPerRow + (minSrcX >> 5);
            int destBaseIndex = minDestY * this.intsPerRow + (minDestX >> 5);
            int numDestInts = (maxDestX >> 5) - (minDestX >> 5);
            if (numDestInts == 0) {
                int destMask = (2 << (maxDestX & 0x1F)) - (1 << (minDestX & 0x1F));
                if (minSrcX >> 5 != maxSrcX >> 5) {
                    for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                        int s0 = srcLayerBitMap[srcBaseIndex];
                        int s1 = srcLayerBitMap[srcBaseIndex + 1];
                        int v = (s0 >>> rightShift | s1 << leftShift) & destMask;
                        if (v != 0) {
                            int n = destBaseIndex;
                            this.layerBitMap[n] = this.layerBitMap[n] | v;
                        }
                        srcBaseIndex += src.intsPerRow;
                        destBaseIndex += this.intsPerRow;
                    }
                } else if ((minDestX & 0x1F) >= (minSrcX & 0x1F)) {
                    for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                        int s = srcLayerBitMap[srcBaseIndex];
                        int v = s << leftShift & destMask;
                        if (v != 0) {
                            int n = destBaseIndex;
                            this.layerBitMap[n] = this.layerBitMap[n] | v;
                        }
                        srcBaseIndex += src.intsPerRow;
                        destBaseIndex += this.intsPerRow;
                    }
                } else {
                    for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                        int s = srcLayerBitMap[srcBaseIndex];
                        int v = s >>> rightShift & destMask;
                        if (v != 0) {
                            int n = destBaseIndex;
                            this.layerBitMap[n] = this.layerBitMap[n] | v;
                        }
                        srcBaseIndex += src.intsPerRow;
                        destBaseIndex += this.intsPerRow;
                    }
                }
            } else {
                int minDestMask = -(1 << (minDestX & 0x1F));
                int maxDestMask = (2 << (maxDestX & 0x1F)) - 1;
                int srcIncr = src.intsPerRow - (maxSrcX >> 5) + (minSrcX >> 5) - 1;
                if (leftShift == 0) {
                    for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                        int vf;
                        int v0;
                        assert (srcBaseIndex == srcY * src.intsPerRow + (minSrcX >> 5));
                        assert (destBaseIndex == (srcY + dy) * this.intsPerRow + (minDestX >> 5));
                        if ((v0 = srcLayerBitMap[srcBaseIndex++] & minDestMask) != 0) {
                            int n = destBaseIndex;
                            this.layerBitMap[n] = this.layerBitMap[n] | v0;
                        }
                        ++destBaseIndex;
                        for (int i = 1; i < numDestInts; ++i) {
                            int v;
                            if ((v = srcLayerBitMap[srcBaseIndex++]) != 0) {
                                int n = destBaseIndex;
                                this.layerBitMap[n] = this.layerBitMap[n] | v;
                            }
                            ++destBaseIndex;
                        }
                        if ((vf = srcLayerBitMap[srcBaseIndex++] & maxDestMask) != 0) {
                            int n = destBaseIndex;
                            this.layerBitMap[n] = this.layerBitMap[n] | vf;
                        }
                        srcBaseIndex += srcIncr;
                        destBaseIndex += this.intsPerRow - numDestInts;
                    }
                } else if (numDestInts == 2 && minSrcX >> 5 == maxSrcX >> 5) {
                    for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                        int vf;
                        assert (srcBaseIndex == srcY * src.intsPerRow + (minSrcX >> 5));
                        assert (destBaseIndex == (srcY + dy) * this.intsPerRow + (minDestX >> 5));
                        int s = srcLayerBitMap[srcBaseIndex];
                        int b0 = srcLayerBitMap[srcBaseIndex++];
                        int v0 = s << leftShift & minDestMask;
                        if (v0 != 0) {
                            int n = destBaseIndex;
                            this.layerBitMap[n] = this.layerBitMap[n] | v0;
                        }
                        if ((vf = s >>> rightShift & maxDestMask) != 0) {
                            int n = destBaseIndex + 1;
                            this.layerBitMap[n] = this.layerBitMap[n] | vf;
                        }
                        srcBaseIndex += src.intsPerRow;
                        destBaseIndex += this.intsPerRow;
                    }
                } else {
                    boolean minSrcPair = leftShift > (minDestX & 0x1F);
                    boolean maxSrcPair = leftShift <= (maxDestX & 0x1F);
                    for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                        int b0;
                        int v0;
                        assert (srcBaseIndex == srcY * src.intsPerRow + (minSrcX >> 5));
                        assert (destBaseIndex == (srcY + dy) * this.intsPerRow + (minDestX >> 5));
                        int s = minSrcPair ? srcLayerBitMap[srcBaseIndex++] : 0;
                        if ((v0 = (s >>> rightShift | (b0 = srcLayerBitMap[srcBaseIndex++]) << leftShift) & minDestMask) != 0) {
                            int n = destBaseIndex;
                            this.layerBitMap[n] = this.layerBitMap[n] | v0;
                        }
                        ++destBaseIndex;
                        s = b0;
                        for (int i = 1; i < numDestInts; ++i) {
                            int b;
                            int v;
                            if ((v = s >>> rightShift | (b = srcLayerBitMap[srcBaseIndex++]) << leftShift) != 0) {
                                int n = destBaseIndex;
                                this.layerBitMap[n] = this.layerBitMap[n] | v;
                            }
                            ++destBaseIndex;
                            s = b;
                        }
                        int bf = maxSrcPair ? srcLayerBitMap[srcBaseIndex++] : 0;
                        int vf = (s >>> rightShift | bf << leftShift) & maxDestMask;
                        if (vf != 0) {
                            int n = destBaseIndex;
                            this.layerBitMap[n] = this.layerBitMap[n] | vf;
                        }
                        srcBaseIndex += srcIncr;
                        destBaseIndex += this.intsPerRow - numDestInts;
                    }
                }
            }
        }
    }

    static interface ERaster {
        public void fillBox(int var1, int var2, int var3, int var4);

        public void fillHorLine(int var1, int var2, int var3);

        public void fillVerLine(int var1, int var2, int var3);

        public void fillPoint(int var1, int var2);

        public void drawHorLine(int var1, int var2, int var3);

        public void drawVerLine(int var1, int var2, int var3);

        public void drawPoint(int var1, int var2);

        public EGraphics.Outline getOutline();

        public void copyBits(TransparentRaster var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }

    static class Drawing
    extends AbstractDrawing {
        private static final int SMALL_IMG_HEIGHT = 2;
        private VolatileImage vImg;
        private BufferedImage smallImg;
        private int[] smallOpaqueData;
        private final AlphaBlender alphaBlender = new AlphaBlender();
        private volatile boolean needComposite;
        private volatile DrawingData drawingData;
        private static boolean joglChecked = false;
        private static Class<?> layerDrawerClass;
        private static Method joglShowLayerMethod;

        Drawing(EditWindow wnd) {
            super(wnd);
        }

        public boolean paintComponent(Graphics2D g, Dimension sz) {
            assert (SwingUtilities.isEventDispatchThread());
            assert (sz.equals(this.wnd.getSize()));
            DrawingData drawingData = this.drawingData;
            if (drawingData == null || !drawingData.offscreen.getSize().equals(sz)) {
                return false;
            }
            if (this.vImg == null || this.vImg.getWidth() != sz.width || this.vImg.getHeight() != sz.height) {
                if (this.vImg != null) {
                    this.vImg.flush();
                }
                this.vImg = this.wnd.createVolatileImage(sz.width, sz.height);
            }
            if (this.smallImg == null || this.smallImg.getWidth() != sz.width) {
                this.smallImg = new BufferedImage(sz.width, 2, 1);
                DataBufferInt smallDbi = (DataBufferInt)this.smallImg.getRaster().getDataBuffer();
                this.smallOpaqueData = smallDbi.getData();
            }
            do {
                int returnCode;
                if ((returnCode = this.vImg.validate(this.wnd.getGraphicsConfiguration())) == 1) {
                    this.renderOffscreen(drawingData);
                } else if (returnCode == 2) {
                    this.vImg.flush();
                    this.vImg = this.wnd.createVolatileImage(sz.width, sz.height);
                    this.renderOffscreen(drawingData);
                } else if (this.needComposite) {
                    this.renderOffscreen(drawingData);
                }
                g.drawImage(this.vImg, 0, 0, this.wnd);
            } while (this.vImg.contentsLost());
            return true;
        }

        private void renderOffscreen(DrawingData dd) {
            this.needComposite = false;
            do {
                if (this.vImg.validate(this.wnd.getGraphicsConfiguration()) == 2) {
                    this.vImg = this.wnd.createVolatileImage(dd.width, dd.height);
                }
                long startTime = System.currentTimeMillis();
                Graphics2D g = this.vImg.createGraphics();
                if (User.isLegacyComposite()) {
                    this.legacyLayerComposite(g, dd);
                } else {
                    this.layerComposite(g, dd);
                }
                long compositeTime = System.currentTimeMillis();
                for (GreekTextInfo greekInfo : dd.greekText) {
                    greekInfo.draw(g);
                }
                for (CrossTextInfo crossInfo : dd.crossText) {
                    crossInfo.draw(g);
                }
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                for (RenderTextInfo textInfo : dd.renderText) {
                    textInfo.draw(g);
                }
                g.dispose();
            } while (this.vImg.contentsLost());
        }

        public void opacityChanged() {
            assert (SwingUtilities.isEventDispatchThread());
            this.needComposite = true;
        }

        public boolean hasOpacity() {
            return true;
        }

        private void layerComposite(Graphics2D g, DrawingData dd) {
            int h;
            HashMap<Layer, int[]> layerBits = new HashMap<Layer, int[]>();
            for (Map.Entry e : dd.layerRasters.entrySet()) {
                layerBits.put((Layer)e.getKey(), ((TransparentRaster)e.getValue()).layerBitMap);
            }
            List<AbstractDrawing.LayerColor> blendingOrder = this.wnd.getBlendingOrder(layerBits.keySet(), dd.patternedDisplay, alphaBlendingOvercolor);
            this.alphaBlender.init(User.getColor(User.ColorPrefType.BACKGROUND), blendingOrder, layerBits);
            int width = dd.width;
            int height = dd.height;
            boolean clipLY = false;
            int clipHY = height - 1;
            int numIntsPerRow = dd.numIntsPerRow;
            int baseByteIndex = 0;
            for (int y = 0; y < height; y += h) {
                h = Math.min(2, height - y);
                int baseIndex = 0;
                for (int k = 0; k < h; ++k) {
                    this.alphaBlender.composeLine(baseByteIndex, 0, width - 1, this.smallOpaqueData, baseIndex);
                    baseByteIndex += numIntsPerRow;
                    baseIndex += width;
                }
                g.drawImage((Image)this.smallImg, 0, y, null);
            }
        }

        private void legacyLayerComposite(Graphics2D g, DrawingData dd) {
            this.wnd.getBlendingOrder(dd.layerRasters.keySet(), false, false);
            Technology curTech = Technology.getCurrent();
            if (curTech == null) {
                for (Layer layer : dd.layerRasters.keySet()) {
                    int transparentDepth = layer.getGraphics().getTransparentLayer();
                    if (transparentDepth == 0 || layer.getTechnology() == null) continue;
                    curTech = layer.getTechnology();
                }
            }
            if (curTech == null) {
                curTech = Generic.tech();
            }
            Color[] colorMap = curTech.getColorMap();
            boolean dimmedTransparentLayers = false;
            Iterator<Layer> it = curTech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                if (!layer.isDimmed() || layer.getGraphics().getTransparentLayer() == 0) continue;
                dimmedTransparentLayers = true;
                break;
            }
            if (dimmedTransparentLayers) {
                Color[] newColorMap = new Color[colorMap.length];
                int numTransparents = curTech.getNumTransparentLayers();
                boolean[] dimLayer = new boolean[numTransparents];
                for (int i = 0; i < numTransparents; ++i) {
                    dimLayer[i] = true;
                }
                Iterator<Layer> it2 = curTech.getLayers();
                while (it2.hasNext()) {
                    int tIndex;
                    Layer layer = it2.next();
                    if (layer.isDimmed() || (tIndex = layer.getGraphics().getTransparentLayer()) == 0) continue;
                    dimLayer[tIndex - 1] = false;
                }
                for (int i = 0; i < colorMap.length; ++i) {
                    newColorMap[i] = colorMap[i];
                    if (i == 0) continue;
                    boolean dimThisEntry = true;
                    for (int j = 0; j < numTransparents; ++j) {
                        if ((i & 1 << j) == 0 || dimLayer[j]) continue;
                        dimThisEntry = false;
                        break;
                    }
                    newColorMap[i] = dimThisEntry ? new Color(dd.offscreen.dimColor(colorMap[i].getRGB())) : new Color(dd.offscreen.brightenColor(colorMap[i].getRGB()));
                }
                colorMap = newColorMap;
            }
            int numTransparent = 0;
            int numOpaque = 0;
            boolean deepestTransparentDepth = false;
            for (Layer layer : dd.layerRasters.keySet()) {
                if (!layer.isVisible()) continue;
                if (layer.getGraphics().getTransparentLayer() == 0) {
                    ++numOpaque;
                    continue;
                }
                ++numTransparent;
            }
            TransparentRaster[] transparentRasters = new TransparentRaster[numTransparent];
            int[] transparentMasks = new int[numTransparent];
            TransparentRaster[] opaqueRasters = new TransparentRaster[numOpaque];
            int[] opaqueCols = new int[numOpaque];
            numOpaque = 0;
            numTransparent = 0;
            for (Map.Entry e : dd.layerRasters.entrySet()) {
                Layer layer = (Layer)e.getKey();
                if (!layer.isVisible()) continue;
                TransparentRaster raster = (TransparentRaster)e.getValue();
                int transparentNum = layer.getGraphics().getTransparentLayer();
                if (transparentNum != 0) {
                    transparentMasks[numTransparent] = 1 << transparentNum - 1 & colorMap.length - 1;
                    transparentRasters[numTransparent++] = raster;
                    continue;
                }
                opaqueCols[numOpaque] = dd.offscreen.getTheColor(layer.getGraphics(), layer.isDimmed());
                opaqueRasters[numOpaque++] = raster;
            }
            int numIntsPerRow = dd.numIntsPerRow;
            int backgroundColor = User.getColor(User.ColorPrefType.BACKGROUND) & 0xFFFFFF;
            boolean lx = false;
            int hx = dd.width - 1;
            int ly = 0;
            int hy = dd.height - 1;
            for (int y = ly; y <= hy; ++y) {
                int baseByteIndex = y * numIntsPerRow;
                for (int x = 0; x <= hx; ++x) {
                    int pixelValue;
                    int entry = baseByteIndex + (x >> 5);
                    int maskBit = 1 << (x & 0x1F);
                    int opaqueIndex = -1;
                    for (int i = 0; i < opaqueRasters.length; ++i) {
                        if ((opaqueRasters[i].layerBitMap[entry] & maskBit) == 0) continue;
                        opaqueIndex = i;
                    }
                    if (opaqueIndex >= 0) {
                        pixelValue = opaqueCols[opaqueIndex];
                    } else {
                        int bits = 0;
                        for (int i = 0; i < transparentRasters.length; ++i) {
                            if ((transparentRasters[i].layerBitMap[entry] & maskBit) == 0) continue;
                            bits |= transparentMasks[i];
                        }
                        pixelValue = bits != 0 ? colorMap[bits].getRGB() & 0xFFFFFF : backgroundColor;
                    }
                    this.smallOpaqueData[x] = pixelValue;
                }
                g.drawImage((Image)this.smallImg, 0, y, null);
            }
        }

        public void render(Dimension sz, WindowFrame.DisplayAttributes da, boolean fullInstantiate, Rectangle2D bounds) {
            LayerDrawing offscreen = null;
            if (this.drawingData != null && this.drawingData.offscreen.getSize().equals(sz)) {
                offscreen = this.drawingData.offscreen;
            }
            if (offscreen == null) {
                offscreen = new LayerDrawing(sz);
            }
            this.da = da;
            offscreen.drawImage(this, fullInstantiate, bounds);
            this.needComposite = true;
            this.drawingData = new DrawingData(offscreen);
        }

        public static boolean hasJogl() {
            if (!joglChecked) {
                joglChecked = true;
                try {
                    layerDrawerClass = Class.forName("com.sun.electric.plugins.jogl.LayerDrawer");
                    joglShowLayerMethod = layerDrawerClass.getMethod("showLayer", Dimension.class, new int[0].getClass(), Double.TYPE, Double.TYPE, Double.TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return joglShowLayerMethod != null;
        }

        public void testJogl() {
            if (Drawing.hasJogl()) {
                try {
                    int numBoxes = 1000000;
                    int[] boxes = new int[numBoxes * 4];
                    for (int i = 0; i < numBoxes; ++i) {
                        int x = i * 5 % 501 - 100;
                        int y = i * 7 % 500 - 200;
                        boxes[i * 4 + 0] = x;
                        boxes[i * 4 + 1] = y;
                        boxes[i * 4 + 2] = x + 10;
                        boxes[i * 4 + 3] = y + 10;
                    }
                }
                catch (Exception e) {
                    System.out.println("Unable to run the LayerDrawer input module (" + e.getClass() + ")");
                    e.printStackTrace(System.out);
                }
                return;
            }
        }
    }

    private static class DrawingData {
        private final LayerDrawing offscreen;
        private final int width;
        private final int height;
        private final int numIntsPerRow;
        private final boolean patternedDisplay;
        private final Map<Layer, TransparentRaster> layerRasters;
        private final GreekTextInfo[] greekText;
        private final RenderTextInfo[] renderText;
        private final CrossTextInfo[] crossText;

        DrawingData(LayerDrawing offscreen) {
            this.offscreen = offscreen;
            this.width = ((LayerDrawing)offscreen).sz.width;
            this.height = ((LayerDrawing)offscreen).sz.height;
            this.numIntsPerRow = offscreen.numIntsPerRow;
            this.patternedDisplay = offscreen.patternedDisplay;
            this.layerRasters = new HashMap<Layer, TransparentRaster>(offscreen.layerRasters);
            this.greekText = offscreen.greekTextList.toArray(new GreekTextInfo[offscreen.greekTextList.size()]);
            this.crossText = offscreen.crossTextList.toArray(new CrossTextInfo[offscreen.crossTextList.size()]);
            this.renderText = offscreen.renderTextList.toArray(new RenderTextInfo[offscreen.renderTextList.size()]);
        }
    }

    private static class ExpandedCellInfo {
        private boolean singleton = true;
        private int instanceCount;
        private boolean tooLarge;
        private LayerDrawing offscreen = null;

        ExpandedCellInfo() {
        }
    }

    private static class ExpandedCellKey {
        private Cell cell;
        private Orientation orient;

        private ExpandedCellKey(Cell cell, Orientation orient) {
            this.cell = cell;
            this.orient = orient;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExpandedCellKey) {
                ExpandedCellKey that = (ExpandedCellKey)obj;
                return this.cell == that.cell && this.orient.equals(that.orient);
            }
            return false;
        }

        public int hashCode() {
            return this.cell.hashCode() ^ this.orient.hashCode();
        }
    }

    private static class PolySeg {
        private int fx;
        private int fy;
        private int tx;
        private int ty;
        private int direction;
        private int increment;
        private PolySeg nextedge;
        private PolySeg nextactive;

        private PolySeg() {
        }
    }
}

