/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class MoveBy
extends EDialog {
    private Preferences prefs;
    private static final String MOVEX = "movex";
    private static final String MOVEY = "movey";
    private JButton cancel;
    private JTextField dX;
    private JTextField dY;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton ok;

    public static void showMoveByDialog() {
        MoveBy dialog = new MoveBy(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    public MoveBy(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        EDialog.makeTextFieldSelectAllOnTab(this.dX);
        EDialog.makeTextFieldSelectAllOnTab(this.dY);
        this.prefs = Preferences.userNodeForPackage(MoveBy.class);
        double movex = this.prefs.getDouble(MOVEX, 0.0);
        double movey = this.prefs.getDouble(MOVEY, 0.0);
        Cell cell = WindowFrame.getCurrentCell();
        Technology tech = cell == null ? null : cell.getTechnology();
        this.dX.setText(TextUtils.formatDistance(movex, tech));
        this.dY.setText(TextUtils.formatDistance(movey, tech));
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.dX = new JTextField();
        this.jLabel2 = new JLabel();
        this.dY = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Move By Amount");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MoveBy.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoveBy.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoveBy.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("dX:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.dX.setColumns(8);
        this.dX.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.dX, gridBagConstraints);
        this.jLabel2.setText("dY:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.dY.setColumns(8);
        this.dY.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.dY, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        Cell cell = WindowFrame.getCurrentCell();
        Technology tech = cell == null ? null : cell.getTechnology();
        double dx = TextUtils.atofDistance(this.dX.getText(), tech);
        double dy = TextUtils.atofDistance(this.dY.getText(), tech);
        this.prefs.putDouble(MOVEX, dx);
        this.prefs.putDouble(MOVEY, dy);
        CircuitChanges.manyMove(dx, dy);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

