/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ECoord
implements Serializable {
    private static final boolean GATHER_SEARCHES = false;
    private final long gridValue;
    private final transient double lambdaValue;
    private final boolean isSmall;
    private static ECoord[] hash = new ECoord[2];
    private static int hashSize = 0;
    private static final float LOAD_FACTOR = 0.75f;
    private static int numSearches;
    private static int numConflicts;
    private static int numRetries;
    private static long[] searches;
    static final ECoord ZERO;

    private ECoord(long gridValue) {
        this.gridValue = gridValue;
        this.lambdaValue = DBMath.gridToLambda(gridValue);
        this.isSmall = GenMath.isSmallInt(gridValue);
    }

    private Object readResolve() {
        return ECoord.fromGrid(this.gridValue);
    }

    double lambdaValue() {
        return this.lambdaValue;
    }

    long gridValue() {
        return this.gridValue;
    }

    boolean isSmall() {
        return this.isSmall;
    }

    static ECoord fromLambda(double lambdaValue) {
        return ECoord.fromGrid(DBMath.lambdaToGrid(lambdaValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ECoord fromGrid(long gridValue) {
        int i;
        ECoord[] hashCopy;
        block8: {
            ++numSearches;
            hashCopy = hash;
            int hashCode2 = ECoord.hash((int)gridValue);
            i = hashCode2 & hash.length - 1;
            ECoord c = hashCopy[i];
            if (c != null) {
                if (c.gridValue == gridValue) {
                    return c;
                }
                int h2 = ECoord.h2(hashCode2);
                do {
                    ++numConflicts;
                    c = hashCopy[i = i + h2 & hash.length - 1];
                    if (c == null) break block8;
                } while (c.gridValue != gridValue);
                return c;
            }
        }
        Class<ECoord> clazz = ECoord.class;
        synchronized (ECoord.class) {
            if (hashCopy != hash || hash[i] != null) {
                ++numRetries;
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return ECoord.fromGrid(gridValue);
            }
            ++hashSize;
            ECoord result2 = ECoord.hash[i] = new ECoord(gridValue);
            if ((float)hash.length * 0.75f < (float)hashSize) {
                ECoord.rehash();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return result2;
        }
    }

    public String toString() {
        return Double.toString(this.lambdaValue);
    }

    private static void rehash() {
        ECoord[] newHash = new ECoord[hash.length * 2];
        int mask = newHash.length - 1;
        for (ECoord c : hash) {
            if (c == null) continue;
            int hash = ECoord.hash((int)c.gridValue);
            int h2 = ECoord.h2(hash);
            int i = hash & mask;
            while (newHash[i] != null) {
                i = i + h2 & mask;
            }
            newHash[i] = c;
        }
        hash = newHash;
    }

    static int hash(int h) {
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    static int h2(int h) {
        return 1;
    }

    private static synchronized void putSearch(long gridValue) {
        if (numSearches == searches.length) {
            long[] newSearches = new long[numSearches * 2];
            System.arraycopy(searches, 0, newSearches, 0, numSearches);
            searches = newSearches;
        }
        ECoord.searches[ECoord.numSearches] = gridValue;
    }

    static void dumpSearches(DataOutputStream out) throws IOException {
        for (int i = 0; i < numSearches; ++i) {
            out.writeLong(searches[i]);
        }
        ECoord.printStatistics();
    }

    static void printStatistics() {
        System.out.println("ECoord: numSearches=" + numSearches + " numConflicts=" + numConflicts + "(" + numConflicts * 100 / numSearches + "%) numInserts=" + hashSize + " hashSize=" + hash.length);
        if (numRetries > 0) {
            System.out.println(numRetries + " RETRIES !!!");
        }
    }

    private static void testHash(ArrayList<Long> input2) {
        long startTime = System.currentTimeMillis();
        for (Long l : input2) {
            ECoord.fromLambda(l.doubleValue());
        }
        long stopTime = System.currentTimeMillis();
        int count2 = 0;
        for (ECoord c : hash) {
            if (c == null) continue;
            assert (c == ECoord.fromGrid(c.gridValue));
            ++count2;
        }
        assert (count2 == hashSize);
        ECoord.printStatistics();
        System.out.println("t=" + (stopTime - startTime));
    }

    public static void main(String[] args) {
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream("ecoord.dat")));
            ArrayList<Long> input2 = new ArrayList<Long>();
            while (in.available() > 0) {
                input2.add(in.readLong());
            }
            in.close();
            for (int i = 0; i < 2; ++i) {
                System.gc();
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            ECoord.testHash(input2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        searches = new long[1];
        ZERO = ECoord.fromGrid(0L);
    }
}

