/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc.wellcheck;

import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.erc.wellcheck.Utils;
import com.sun.electric.tool.erc.wellcheck.WellCheckAnalysisStrategy;
import com.sun.electric.tool.erc.wellcheck.WellCon;
import com.sun.electric.util.CollectionFactory;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnRailCheck
implements WellCheckAnalysisStrategy {
    private Set<Integer> networkExportAvailable;
    private Set<Integer> networkWithExportCache;
    private Map<Integer, List<ERCWellCheck.Transistor>> transistors;
    private List<ERCWellCheck.Transistor> alreadyHit;
    private ERCWellCheck.StrategyParameter parameter;

    public OnRailCheck(ERCWellCheck.StrategyParameter parameter, Set<Integer> networkExportAvailable, Map<Integer, List<ERCWellCheck.Transistor>> transistors) {
        this.networkExportAvailable = networkExportAvailable;
        this.transistors = transistors;
        this.networkWithExportCache = CollectionFactory.createHashSet();
        this.parameter = parameter;
    }

    @Override
    public void execute() {
        int cacheHits = 0;
        for (WellCon wc : this.parameter.getWellCons()) {
            if (!wc.isOnRail()) {
                if (this.networkExportAvailable.contains(wc.getNetNum())) {
                    wc.setOnRail(true);
                } else if (this.networkWithExportCache.contains(wc.getNetNum())) {
                    wc.setOnRail(true);
                    ++cacheHits;
                } else {
                    HashSet<Integer> startPath = new HashSet<Integer>();
                    List<ERCWellCheck.Transistor> startTrans = this.transistors.get(wc.getNetNum());
                    if (startTrans != null && this.createTransistorChain(startPath, startTrans.get(0), false)) {
                        wc.setOnRail(true);
                        this.networkWithExportCache.addAll(startPath);
                    }
                }
            }
            if (wc.isOnRail() || wc.isOnProperRail()) continue;
            if (Utils.canBeSubstrateTap(wc.getFun())) {
                if (!this.parameter.getWellPrefs().mustConnectPWellToGround) continue;
                this.parameter.logError("P-Well contact '" + wc.getNi().getName() + "' not connected to ground", wc);
                continue;
            }
            if (!this.parameter.getWellPrefs().mustConnectNWellToPower) continue;
            this.parameter.logError("N-Well contact '" + wc.getNi().getName() + "' not connected to ground", wc);
        }
    }

    private boolean createTransistorChain(Set<Integer> path, ERCWellCheck.Transistor node, boolean result2) {
        this.alreadyHit = new LinkedList<ERCWellCheck.Transistor>();
        if (!(result2 |= this.createTransistorRec(path, node, result2, node.getDrainNet().get()))) {
            result2 |= this.createTransistorRec(path, node, result2, node.getSourceNet().get());
        }
        return result2;
    }

    private boolean createTransistorRec(Set<Integer> path, ERCWellCheck.Transistor node, boolean result2, int num) {
        LinkedList<ERCWellCheck.Transistor> transis = new LinkedList<ERCWellCheck.Transistor>();
        transis.add(node);
        this.alreadyHit.add(node);
        while (transis.size() > 0) {
            ERCWellCheck.Transistor transistor = (ERCWellCheck.Transistor)transis.get(0);
            transis.remove(transistor);
            Integer neighbor = null;
            neighbor = transistor.getDrainNet().get() == num ? Integer.valueOf(transistor.getSourceNet().get()) : Integer.valueOf(transistor.getDrainNet().get());
            path.add(neighbor);
            num = neighbor;
            if (!(result2 |= this.networkExportAvailable.contains(neighbor))) {
                result2 |= this.networkWithExportCache.contains(neighbor);
            }
            if (result2) {
                return result2;
            }
            for (ERCWellCheck.Transistor trans : this.transistors.get(neighbor)) {
                if (this.alreadyHit.contains(trans)) continue;
                transis.add(trans);
                this.alreadyHit.add(trans);
            }
        }
        return result2;
    }
}

