/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.concurrency;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarRegionNode;
import com.sun.electric.tool.routing.experimentalAStar3.concurrency.RouteJob;
import com.sun.electric.tool.routing.experimentalAStar3.datastructures.Point3D;
import com.sun.electric.tool.routing.experimentalAStar3.goal.RegionGoal;
import com.sun.electric.tool.routing.experimentalAStar3.machine.AStarRegionMachine;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.AStarRegionNodeObjectPool;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalRouteJob
extends RouteJob
implements Callable<GlobalRouteJob> {
    public RouteJob routeJob;
    private Point3D fromInsideRegion;
    private Point3D toInsideRegion;
    private AStarRegionMachine machine;
    private RegionGoal goal = new RegionGoal();
    public List<AStarRegionNode> resultPath;

    public GlobalRouteJob() {
        this.goal.setMaximumRevolutions(300000);
        this.machine = new AStarRegionMachine(new AStarRegionNodeObjectPool());
    }

    public void initialize(RouteJob routeJob, Point3D fromRegion, Point3D toRegion, Point3D fromInsideRegion, Point3D toInsideRegion) {
        this.routeJob = routeJob;
        this.from = fromRegion;
        this.to = toRegion;
        this.fromInsideRegion = fromInsideRegion;
        this.toInsideRegion = toInsideRegion;
    }

    public RouteJob getRouteJob() {
        return this.routeJob;
    }

    @Override
    public GlobalRouteJob call() throws Exception {
        AStarRegionNode startRegion = this.routeJob.getBoundingBox().nodeAt(this.from.getX(), this.from.getY(), this.from.getZ());
        AStarRegionNode goalRegion = this.routeJob.getBoundingBox().nodeAt(this.to.getX(), this.to.getY(), this.to.getZ());
        startRegion.setAsStartRegion(true);
        goalRegion.setAsGoalRegion(true);
        startRegion.setEntryPoint(startRegion.routingMap.nodeAt(this.fromInsideRegion.getX(), this.fromInsideRegion.getY(), this.fromInsideRegion.getZ()));
        goalRegion.setExitPoint(goalRegion.routingMap.nodeAt(this.toInsideRegion.getX(), this.toInsideRegion.getY(), this.toInsideRegion.getZ()));
        this.machine.setUpSearchSpace(this.routeJob.getBoundingBox(), this.goal);
        this.resultPath = this.machine.findPath(this.from.getX(), this.from.getY(), this.from.getZ(), this.to.getX(), this.to.getY(), this.to.getZ());
        startRegion.setAsStartRegion(false);
        goalRegion.setAsGoalRegion(false);
        return this;
    }
}

