/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.AmpsVsVolts;
import com.sun.electric.tool.simulation.test.ChainControl;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.Logger;
import com.sun.electric.tool.simulation.test.SubchainNode;
import com.sun.electric.tool.simulation.test.TestNode;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class SamplerControl
extends Logger {
    ChainControl control;
    private final int polarity;
    public final Map map;
    private final String[] controlEnable = new String[CONTROL_NODES.length];
    private final String[] controlDisable = new String[CONTROL_NODES.length];
    public static final String[] CONTROL_NODES = new String[]{"calibrate", "enable", "enable_f"};
    public static final int IND_CALIBRATE = 0;
    public static final int IND_ENABLE = 1;
    public static final int IND_ENABLE_F = 2;
    public static final int POLARITY_NORMAL = 0;
    public static final int POLARITY_INVERTED = 1;
    private static final String[] CONTROL_ENABLE = new String[]{"1", "0"};
    private static final String[] CONTROL_DISABLE = new String[]{"0", "1"};

    public SamplerControl(ChainControl control, int polarity) {
        this.control = control;
        if (polarity != 0 && polarity != 1) {
            Infrastructure.fatal("Bad polarity value " + polarity + ", only POLARITY_NORMAL and POLARITY_INVERTED are " + " supported");
        }
        this.polarity = polarity;
        this.map = new HashMap();
        Arrays.fill(this.controlEnable, CONTROL_ENABLE[polarity]);
        Arrays.fill(this.controlDisable, CONTROL_DISABLE[polarity]);
        String[] paths = control.getDescendents("");
        for (int ind = 0; ind < paths.length; ++ind) {
            if (!this.isSampler(paths[ind])) continue;
            this.map.put(paths[ind], control.getSubchainPin(paths[ind]));
            this.preclear(paths[ind]);
        }
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer("SamplerControl, control=" + this.control);
        buffy.append("\n  Samplers on each pin:");
        TreeSet pins = new TreeSet(this.map.values());
        for (String pin : pins) {
            buffy.append("\n    " + pin + ": ");
            String[] samplers = this.getSamplersOnPin(pin);
            for (int ind = 0; ind < samplers.length; ++ind) {
                buffy.append(" " + samplers[ind]);
            }
        }
        buffy.append("\n");
        return buffy.toString();
    }

    void checkPath(String path) {
        if (!this.map.containsKey(path)) {
            Infrastructure.fatal("Path " + path + " is not a recognized " + "sampler" + "\nSee SamplerControl javadoc for how to " + "identify sampler nodes");
        }
    }

    public void clear(String path) {
        this.preclear(path);
        this.logSet("SamplerControl.clear(): clearing " + path);
        this.control.shift(this.control.getParentChain(path), false, true);
    }

    private void preclear(String path) {
        this.checkPath(path);
        for (int ind = 0; ind < CONTROL_NODES.length; ++ind) {
            this.control.setInBits(path + "." + CONTROL_NODES[ind], this.controlDisable[ind]);
        }
    }

    public void setEnables(String path, boolean enable, boolean enable_f) {
        this.checkPath(path);
        if (enable || enable_f) {
            this.clearSiblings(path);
        }
        this.setOne(path, false, enable, enable_f);
    }

    public void setCalibrate(String path, boolean calibrate) {
        this.checkPath(path);
        this.setControl(path, 0, calibrate);
        this.logSet("SamplerControl.setCalibrate(): setting " + path + " to calibrate");
        this.control.shift(this.control.getParentChain(path), false, true);
    }

    private void clearSiblings(String path) {
        String targetPin = (String)this.map.get(path);
        String[] paths = this.getSamplersOnPin(targetPin);
        for (int ind = 0; ind < paths.length; ++ind) {
            this.clear(paths[ind]);
        }
    }

    public void calibrate(String fileName, String path, AmpsVsVolts ivspec) throws IOException {
        PrintWriter file = new PrintWriter(new FileWriter(fileName));
        file.println("# calibration (voltage, current) for sampler at path " + path);
        this.setCalibrate(path, true);
        ivspec.measure(file);
        this.setCalibrate(path, false);
        file.close();
    }

    private boolean isSampler(String path) {
        TestNode node = (TestNode)this.control.findNode(path);
        if (node.getChildCount() < 3 || !(node instanceof SubchainNode)) {
            return false;
        }
        int[] numInstances = this.getNumInstances(node);
        boolean oneOfEach = true;
        boolean anyPresent = false;
        for (int ind = 0; ind < CONTROL_NODES.length; ++ind) {
            if (numInstances[ind] != 1) {
                oneOfEach = false;
            }
            if (numInstances[ind] <= 0) continue;
            anyPresent = true;
        }
        if (oneOfEach) {
            if (this.control.getSubchainPin(path).length() <= 0) {
                System.err.println("*** SamplerControl warning: node " + path + "\nappears to be a sampler, but does not have" + " a valid pin name.  Please set the " + "\n'pin' attribute in the XML file or use" + " ChainControl.setSubchainPin()");
                return false;
            }
            return true;
        }
        if (anyPresent) {
            System.err.println("*** SamplerControl warning: node " + path + "\nmay be a sampler that does not contain " + "required nodes." + "\nSamplers must contain exactly one each of '" + CONTROL_NODES[0] + "', '" + CONTROL_NODES[1] + "', and '" + CONTROL_NODES[2] + "'");
            return false;
        }
        return false;
    }

    public String[] getSamplersOnPin(String targetPin) {
        ArrayList<String> list2 = new ArrayList<String>();
        for (String path : this.map.keySet()) {
            String pin = (String)this.map.get(path);
            if (!pin.equals(targetPin)) continue;
            list2.add(path);
        }
        String[] paths = new String[list2.size()];
        for (int ind = 0; ind < paths.length; ++ind) {
            paths[ind] = (String)list2.get(ind);
        }
        return paths;
    }

    private void setControl(String path, int ind, boolean enable) {
        if (enable) {
            this.control.setInBits(path + "." + CONTROL_NODES[ind], this.controlEnable[ind]);
        } else {
            this.control.setInBits(path + "." + CONTROL_NODES[ind], this.controlDisable[ind]);
        }
    }

    private void setOne(String path, boolean calibrate, boolean enable, boolean enable_f) {
        this.checkPath(path);
        if (calibrate && !enable && !enable_f) {
            System.out.println("WARNING: Odd setting for sampler at " + path + ": calibrate true, but enable and enable_f false.");
        }
        this.setControl(path, 0, calibrate);
        this.setControl(path, 1, enable);
        this.setControl(path, 2, enable_f);
        this.logSet("SamplerControl.setOne(): setting " + path);
        this.control.shift(this.control.getParentChain(path), false, true);
    }

    private int[] getNumInstances(TestNode node) {
        int[] numInstances = new int[CONTROL_NODES.length];
        for (int kidIndex = 0; kidIndex < node.getChildCount(); ++kidIndex) {
            TestNode kid = (TestNode)node.getChildAt(kidIndex);
            String kidName = kid.getName();
            for (int ind = 0; ind < CONTROL_NODES.length; ++ind) {
                if (!kidName.equals(CONTROL_NODES[ind])) continue;
                String kidPath = kid.getPathString(1);
                int length = this.control.getLength(kidPath);
                if (length == 1) {
                    int n = ind;
                    numInstances[n] = numInstances[n] + 1;
                    continue;
                }
                System.err.println("*** SamplerControl warning: node " + kidPath + " has length " + length + ", should have length 1");
            }
        }
        return numInstances;
    }

    public static void main(String[] args) {
        ChainControl control = new ChainControl("heater.xml");
        control.setSubchainPin("heater.SW_expC.transmit.sample_cT", "frog");
        control.setSubchainPin("heater.NW_expC.transmit.sample_cT", "frog");
        control.setSubchainPin("heater.SE_expC.transmit.sample_cT", "toad");
        control.setSubchainPin("heater.NE_expC.transmit.sample_cT", "bar");
        SamplerControl samplers = new SamplerControl(control, 1);
    }
}

