/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDialog
extends JDialog {
    private static Map<Class<?>, Point> locations = new HashMap();
    private static Map<Class<?>, Dimension> sizes = new HashMap();
    private static TextBoxFocusListener textBoxFocusListener = new TextBoxFocusListener();
    private static TextBoxMouseListener textBoxMouseListener = new TextBoxMouseListener();
    private static JTextField justMoused = null;

    protected EDialog(Frame parent, boolean modal) {
        super(parent, "", modal, (GraphicsConfiguration)(parent == null ? (TopLevel.getCurrentJFrame() == null ? null : TopLevel.getCurrentJFrame().getGraphicsConfiguration()) : parent.getGraphicsConfiguration()));
        Point pt = EDialog.getDialogLocation(this.getClass());
        this.setLocation(pt.x, pt.y);
        this.addComponentListener(new MoveComponentListener());
        String CANCEL_DIALOG = "cancel-dialog";
        KeyStroke accel = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(2).put(accel, "cancel-dialog");
        this.getRootPane().getActionMap().put("cancel-dialog", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                EDialog.this.escapePressed();
            }
        });
        if (!modal) {
            TopLevel.addModelessDialog(this);
        }
    }

    public static Point getDialogLocation(Class<?> clz) {
        Point pt = locations.get(clz);
        if (pt == null) {
            pt = User.getDefaultWindowPos();
            pt.x += 100;
            pt.y += 50;
        }
        return pt;
    }

    public static Dimension getDialogSize(Class<?> clz) {
        Dimension sz = sizes.get(clz);
        return sz;
    }

    protected void finishInitialization() {
        Dimension sz = EDialog.getDialogSize(this.getClass());
        if (sz != null) {
            this.setSize(sz);
        }
    }

    protected void ensureMinimumSize() {
        Dimension sz = EDialog.getDialogSize(this.getClass());
        if (sz == null) {
            return;
        }
        Dimension curSz = this.getSize();
        if (curSz.width < sz.width || curSz.height < sz.height) {
            this.setSize(sz);
        }
    }

    protected void escapePressed() {
    }

    protected void closeDialog() {
        this.setVisible(false);
    }

    public static void ensureComboBoxFont(JComboBox fontBox, String font) {
        int totFonts = fontBox.getItemCount();
        boolean found = false;
        for (int i = 0; i < totFonts; ++i) {
            if (!font.equals(fontBox.getItemAt(i))) continue;
            found = true;
            break;
        }
        if (!found) {
            fontBox.addItem(font);
        }
    }

    public static boolean recursivelyHighlight(JTree tree, DefaultMutableTreeNode curNode, DefaultMutableTreeNode objWanted, TreePath topPath) {
        for (int i = 0; i < curNode.getChildCount(); ++i) {
            TreePath lowerPath;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)curNode.getChildAt(i);
            if (node == objWanted) {
                lowerPath = topPath.pathByAddingChild(node);
                tree.setSelectionPath(lowerPath);
                tree.scrollPathToVisible(lowerPath);
                return true;
            }
            lowerPath = topPath.pathByAddingChild(node);
            if (!EDialog.recursivelyHighlight(tree, node, objWanted, lowerPath)) continue;
            return true;
        }
        return false;
    }

    public static void focusOnTextField(JTextComponent textComponent) {
        textComponent.selectAll();
    }

    public static void focusClearOnTextField(JTextComponent textComponent) {
        textComponent.select(0, 0);
    }

    public static void makeTextFieldSelectAllOnTab(JTextField textField) {
        textField.addFocusListener(textBoxFocusListener);
        textField.addMouseListener(textBoxMouseListener);
    }

    public static void centerSelection(JList list2) {
        int listSize;
        int curIndex = list2.getSelectedIndex();
        int lowIndexToEnsure = curIndex - (listSize = list2.getLastVisibleIndex() - list2.getFirstVisibleIndex()) / 2 + 1;
        if (lowIndexToEnsure < 0) {
            lowIndexToEnsure = 0;
        }
        list2.ensureIndexIsVisible(lowIndexToEnsure);
        int highIndexToEnsure = curIndex + listSize / 2 - 1;
        if (highIndexToEnsure >= list2.getModel().getSize()) {
            highIndexToEnsure = list2.getModel().getSize() - 1;
        }
        list2.ensureIndexIsVisible(highIndexToEnsure);
    }

    public static class MoveComponentListener
    implements ComponentListener {
        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            Class<?> cls = e.getSource().getClass();
            Rectangle bound = ((Container)e.getSource()).getBounds();
            sizes.put(cls, new Dimension(bound.width, bound.height));
        }

        public void componentMoved(ComponentEvent e) {
            Class<?> cls = e.getSource().getClass();
            Rectangle bound = ((Container)e.getSource()).getBounds();
            int x = (int)bound.getMinX();
            int y = (int)bound.getMinY();
            locations.put(cls, new Point(x, y));
        }
    }

    private static class TextBoxFocusListener
    implements FocusListener {
        private TextBoxFocusListener() {
        }

        public void focusGained(FocusEvent evt) {
            JTextField textField;
            Component source = evt.getComponent();
            if (source instanceof JTextField && (textField = (JTextField)source).isEnabled() && textField.isEditable() && textField != justMoused) {
                textField.selectAll();
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private static class TextBoxMouseListener
    implements MouseListener {
        private TextBoxMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            JTextField textField;
            Component source = evt.getComponent();
            if (source instanceof JTextField && (textField = (JTextField)source).isEnabled() && textField.isEditable()) {
                justMoused = textField;
            }
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }
    }
}

