/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Router {
    protected boolean verbose = false;
    protected Tool tool;

    public void createRoute(Route route, Cell cell) {
        new CreateRouteJob(this.toString(), route, cell, this.verbose, this.tool);
    }

    public static boolean createRouteNoJob(Route route, Cell cell, Map<ArcProto, Integer> arcsCreatedMap, Map<NodeProto, Integer> nodesCreatedMap, EditingPreferences ep) {
        RouteElementPort rep2;
        EDatabase.serverDatabase().checkChanging();
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, true) != 0) {
            return true;
        }
        for (RouteElement e : route) {
            if (e.getAction() != RouteElement.RouteElementAction.newNode || e.isDone()) continue;
            e.doAction(ep);
            RouteElementPort rep3 = (RouteElementPort)e;
            Integer i = nodesCreatedMap.get(rep3.getPortProto().getParent());
            if (i == null) {
                i = new Integer(0);
            }
            i = new Integer(i + 1);
            nodesCreatedMap.put(rep3.getPortProto().getParent(), i);
        }
        for (RouteElement e : route) {
            if (e.getAction() == RouteElement.RouteElementAction.newNode) continue;
            ElectricObject result2 = e.doAction(ep);
            if (e.getAction() != RouteElement.RouteElementAction.newArc) continue;
            if (result2 == null) {
                return true;
            }
            RouteElementArc rea = (RouteElementArc)e;
            Integer i = arcsCreatedMap.get(rea.getArcProto());
            if (i == null) {
                i = new Integer(0);
            }
            i = new Integer(i + 1);
            arcsCreatedMap.put(rea.getArcProto(), i);
        }
        if (arcsCreatedMap.get(Generic.tech().unrouted_arc) == null && (rep2 = route.getStart()) != null && rep2.getPortInst() != null) {
            PortInst pi = rep2.getPortInst();
            Iterator<Connection> it = pi.getConnections();
            while (it.hasNext()) {
                Connection conn = it.next();
                ArcInst ai = conn.getArc();
                if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                Connection oconn = ai.getConnection(1 - conn.getEndIndex());
                if (oconn.getPortInst() != route.getEnd().getPortInst()) {
                    RouteElementPort newEnd = RouteElementPort.existingPortInst(oconn.getPortInst(), oconn.getLocation(), ep);
                    RouteElementArc newArc = RouteElementArc.newArc(cell, Generic.tech().unrouted_arc, Generic.tech().unrouted_arc.getDefaultLambdaBaseWidth(ep), route.getEnd(), newEnd, route.getEnd().getLocation(), oconn.getLocation(), null, ai.getTextDescriptor(ArcInst.ARC_NAME), ai, ai.isHeadExtended(), ai.isTailExtended(), null);
                    newArc.doAction(ep);
                }
                if (!conn.getArc().isLinked()) continue;
                conn.getArc().kill();
            }
        }
        return false;
    }

    public static void reportRoutingResults(String prefix, Map<ArcProto, Integer> arcsCreatedMap, Map<NodeProto, Integer> nodesCreatedMap, boolean beep) {
        ArrayList<ArcProto> arcEntries = new ArrayList<ArcProto>(arcsCreatedMap.keySet());
        ArrayList<NodeProto> nodeEntries = new ArrayList<NodeProto>(nodesCreatedMap.keySet());
        if (arcEntries.isEmpty() && nodeEntries.isEmpty()) {
            System.out.println(prefix + ": nothing added");
        } else {
            Integer i;
            System.out.print(prefix + " added: ");
            Collections.sort(arcEntries, new TextUtils.ObjectsByToString());
            Collections.sort(nodeEntries, new TextUtils.ObjectsByToString());
            int total = arcEntries.size() + nodeEntries.size();
            int sofar = 0;
            for (ArcProto ap : arcEntries) {
                i = arcsCreatedMap.get(ap);
                if (++sofar > 1 && total > 1) {
                    if (sofar < total) {
                        System.out.print(", ");
                    } else {
                        System.out.print(" and ");
                    }
                }
                System.out.print(i + " " + ap.describe());
                if (i > 1) {
                    System.out.print(" arcs");
                    continue;
                }
                System.out.print(" arc");
            }
            for (NodeProto np : nodeEntries) {
                i = nodesCreatedMap.get(np);
                if (++sofar > 1 && total > 1) {
                    if (sofar < total) {
                        System.out.print(", ");
                    } else {
                        System.out.print(" and ");
                    }
                }
                System.out.print(i + " " + np.describe(false));
                if (i > 1) {
                    System.out.print(" nodes");
                    continue;
                }
                System.out.print(" node");
            }
            System.out.println();
            if (beep) {
                Job.getUserInterface().beep();
            }
        }
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public static ArcProto getArcToUse(PortProto port1, PortProto port2) {
        ArcProto curAp = User.getUserTool().getCurrentArcProto();
        if (curAp == Schematics.tech().wire_arc && port1 != null && port2 != null) {
            boolean bus2;
            boolean bus1 = port1.getParent() == Schematics.tech().busPinNode || port1.getNameKey().isBus();
            boolean bl = bus2 = port2.getParent() == Schematics.tech().busPinNode || port2.getNameKey().isBus();
            if (bus1 && bus2) {
                return Schematics.tech().bus_arc;
            }
        }
        PortProto pp1 = null;
        PortProto pp2 = null;
        if (port1 == null) {
            pp1 = port2;
        } else {
            pp1 = port1;
            pp2 = port2;
        }
        if (pp1 == null && pp2 == null) {
            return null;
        }
        if (pp2 == null ? pp1.connectsTo(curAp) : pp1.connectsTo(curAp) && pp2.connectsTo(curAp)) {
            return curAp;
        }
        Technology tech = pp1.getParent().getTechnology();
        ArcProto ap = Router.findArcThatConnects(tech, pp1, pp2);
        if (ap != null) {
            return ap;
        }
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology anyTech = it.next();
            if (anyTech == tech || anyTech == Generic.tech() || (ap = Router.findArcThatConnects(anyTech, pp1, pp2)) == null) continue;
            return ap;
        }
        return null;
    }

    private static ArcProto findArcThatConnects(Technology tech, PortProto pp1, PortProto pp2) {
        Iterator<ArcProto> it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (!pp1.connectsTo(ap) || pp2 != null && !pp2.connectsTo(ap)) continue;
            return ap;
        }
        return null;
    }

    public static double getArcWidthToUse(ElectricObject obj, ArcProto ap, int arcAngle, boolean ignoreAngle, EditingPreferences ep) {
        Cell cell;
        Export export;
        PortInst exportedInst;
        double width2;
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            if (ignoreAngle) {
                return ai.getLambdaBaseWidth();
            }
            int angle = ai.getDefinedAngle();
            if (angle % 1800 == arcAngle) {
                return ai.getLambdaBaseWidth();
            }
            return ap.getDefaultLambdaBaseWidth(ep);
        }
        if (obj == null || !(obj instanceof PortInst)) {
            return ap.getDefaultLambdaBaseWidth(ep);
        }
        PortInst pi = (PortInst)obj;
        boolean arcFound = false;
        double width = ap.getDefaultLambdaBaseWidth(ep);
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            int angle;
            Connection c = it.next();
            ArcInst ai = c.getArc();
            if (ai.getProto() != ap || !ignoreAngle && (angle = ai.getDefinedAngle()) % 1800 != arcAngle % 1800 || ep.isFatWires() && c.getArc().getLambdaBaseWidth() == ap.getDefaultLambdaBaseWidth(ep)) continue;
            double newWidth = c.getArc().getLambdaBaseWidth();
            if (width < newWidth) {
                width = newWidth;
            }
            arcFound = true;
        }
        if (arcFound) {
            return width;
        }
        NodeInst ni = pi.getNodeInst();
        if (!arcFound && ni.getProto() instanceof PrimitiveNode) {
            PrimitiveNode pn = (PrimitiveNode)ni.getProto();
            if (ep.isFatWires() && (pn.getFunction().isContact() || pn.getFunction() == PrimitiveNode.Function.SUBSTRATE || pn.getFunction() == PrimitiveNode.Function.WELL)) {
                double xsize = ni.getXSizeWithoutOffset();
                double ysize = ni.getYSizeWithoutOffset();
                Iterator<Poly> pit = ni.getShape(Poly.newLambdaBuilder());
                while (pit.hasNext()) {
                    Poly poly = pit.next();
                    if (poly.getLayer() != ap.getLayer(0)) continue;
                    xsize = poly.getBounds2D().getWidth();
                    ysize = poly.getBounds2D().getHeight();
                }
                if (arcAngle % 1800 == 0) {
                    width = ysize;
                }
                if ((arcAngle - 900) % 1800 == 0) {
                    width = xsize;
                }
            }
            if (pn.getFunction().isPin()) {
                Iterator<Connection> it2 = pi.getConnections();
                while (it2.hasNext()) {
                    double newWidth;
                    Connection c = it2.next();
                    ArcInst ai = c.getArc();
                    if (ai.getProto() != ap || !(width < (newWidth = c.getArc().getLambdaBaseWidth()))) continue;
                    width = newWidth;
                }
            }
        }
        if (ni.isCellInstance() && (width2 = Router.getArcWidthToUse(exportedInst = (export = (cell = (Cell)ni.getProto()).findExport(pi.getPortProto().getName())).getOriginalPort(), ap, arcAngle, ignoreAngle, ep)) > width) {
            width = width2;
        }
        return width;
    }

    protected static class ContactSize {
        private Rectangle2D contactSize;
        private int startAngle;
        private int endAngle;
        private double startArcWidth;
        private double endArcWidth;

        public Rectangle2D getContactSize() {
            return this.contactSize;
        }

        public int getStartAngle() {
            return this.startAngle;
        }

        public int getEndAngle() {
            return this.endAngle;
        }

        public double getStartWidth() {
            return this.startArcWidth;
        }

        public double getEndWidth() {
            return this.endArcWidth;
        }

        public ContactSize(ElectricObject startObj, ElectricObject endObj, Point2D startLoc, Point2D endLoc, Point2D cornerLoc, ArcProto startArc, ArcProto endArc, boolean ignoreAngles, EditingPreferences ep) {
            AngleAndDimensions start = ContactSize.getAngleAndDimensions(startObj, startLoc, cornerLoc, startArc, endObj == null, ignoreAngles, ep);
            AngleAndDimensions end = ContactSize.getAngleAndDimensions(endObj, endLoc, cornerLoc, endArc, startObj == null, ignoreAngles, ep);
            this.startAngle = start.angle;
            this.endAngle = end.angle;
            EDimension startDim = start.dim;
            EDimension endDim = end.dim;
            EDimension startPref = start.pref;
            EDimension endPref = end.pref;
            double startW = startDim.getWidth();
            double startH = startDim.getHeight();
            double endW = endDim.getWidth();
            double endH = endDim.getHeight();
            if (startW == 0.0) {
                startW = endW;
            }
            if (startH == 0.0) {
                startH = endH;
            }
            if (endW == 0.0) {
                endW = startW;
            }
            if (endH == 0.0) {
                endH = startH;
            }
            if (endPref.getWidth() > startPref.getWidth()) {
                startW = endW;
            } else if (endPref.getWidth() == startPref.getWidth() && endW < startW) {
                startW = endW;
            }
            if (endPref.getHeight() > startPref.getHeight()) {
                startH = endH;
            } else if (endPref.getHeight() == startPref.getHeight() && endH < startH) {
                startH = endH;
            }
            if (endObj == null && ep.isFatWires()) {
                if (startW > startH) {
                    startH = startW;
                }
                if (startH > startW) {
                    startW = startH;
                }
            }
            this.contactSize = new Rectangle2D.Double(cornerLoc.getX() - startW / 2.0, cornerLoc.getY() - startH / 2.0, startW, startH);
            this.startArcWidth = this.startAngle % 1800 == 0 ? this.contactSize.getHeight() : ((this.startAngle + 900) % 1800 == 0 ? this.contactSize.getWidth() : this.contactSize.getHeight());
            this.endArcWidth = this.endAngle % 1800 == 0 ? this.contactSize.getHeight() : ((this.endAngle + 900) % 1800 == 0 ? this.contactSize.getWidth() : this.contactSize.getWidth());
        }

        private static AngleAndDimensions getAngleAndDimensions(ElectricObject obj, Point2D loc, Point2D cornerLoc, ArcProto arc, boolean otherObjNull, boolean ignoreAngles, EditingPreferences ep) {
            double w = 0.0;
            double h = 0.0;
            double prefW = 0.0;
            double prefH = 0.0;
            int angle = 0;
            if (obj instanceof ArcInst) {
                ArcInst ai = (ArcInst)obj;
                angle = ai.getDefinedAngle();
                double size2 = ai.getLambdaBaseWidth();
                if (loc.equals(cornerLoc)) {
                    if (angle % 1800 == 0) {
                        h = size2;
                    } else {
                        w = (angle + 900) % 1800 == 0 ? size2 : (h = size2);
                    }
                } else {
                    angle = GenMath.figureAngle(loc, cornerLoc);
                    if (angle % 1800 == 0) {
                        h = size2;
                    } else {
                        w = (angle + 900) % 1800 == 0 ? size2 : (h = size2);
                    }
                }
                if (angle % 1800 == 0) {
                    prefH = 1.0;
                }
                if ((angle + 900) % 1800 == 0) {
                    prefW = 1.0;
                }
                if (otherObjNull) {
                    w = h = size2;
                    prefW = 1.0;
                    prefH = 1.0;
                }
            }
            if (obj instanceof PortInst) {
                PortInst pi = (PortInst)obj;
                if (otherObjNull) {
                    ignoreAngles = true;
                }
                if (loc.equals(cornerLoc)) {
                    w = Router.getArcWidthToUse(pi, arc, 900, ignoreAngles, ep);
                    h = Router.getArcWidthToUse(pi, arc, 0, ignoreAngles, ep);
                } else {
                    angle = GenMath.figureAngle(loc, cornerLoc);
                    if (angle % 1800 == 0) {
                        h = Router.getArcWidthToUse(pi, arc, angle, ignoreAngles, ep);
                    } else if ((angle + 900) % 1800 == 0) {
                        w = Router.getArcWidthToUse(pi, arc, angle, ignoreAngles, ep);
                    } else {
                        h = w = Router.getArcWidthToUse(pi, arc, angle, true, ep);
                    }
                }
            }
            return new AngleAndDimensions(angle, new EDimension(w, h), new EDimension(prefW, prefH));
        }

        private static class AngleAndDimensions {
            final int angle;
            final EDimension dim;
            final EDimension pref;

            private AngleAndDimensions(int angle, EDimension dim, EDimension pref) {
                this.angle = angle;
                this.dim = dim;
                this.pref = pref;
            }
        }
    }

    protected static class CreateRouteJob
    extends Job {
        protected Route route;
        private Cell cell;
        private PortInst portToHighlight;
        private boolean beep;

        protected CreateRouteJob(String what, Route route, Cell cell, boolean verbose, Tool tool) {
            super(what, tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.route = route;
            this.cell = cell;
            this.beep = User.isPlayClickSoundsWhenCreatingArcs();
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
            HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
            Router.createRouteNoJob(this.route, this.cell, arcsCreatedMap, nodesCreatedMap, this.getEditingPreferences());
            this.portToHighlight = null;
            RouteElementPort finalRE = this.route.getEnd();
            if (finalRE != null) {
                this.portToHighlight = finalRE.getPortInst();
            }
            Router.reportRoutingResults("Wiring", arcsCreatedMap, nodesCreatedMap, this.beep);
            this.fieldVariableChanged("portToHighlight");
            return true;
        }

        @Override
        public void terminateOK() {
            UserInterface ui;
            EditWindow_ wnd;
            if (this.portToHighlight != null && (wnd = (ui = Job.getUserInterface()).getCurrentEditWindow_()) != null) {
                wnd.clearHighlighting();
                wnd.addElectricObject(this.portToHighlight, this.cell);
                wnd.finishedHighlighting();
            }
        }
    }
}

