/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.algorithm;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapVisitorBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarNodeBase;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.ObjectPool;
import java.util.List;

public abstract class AStarMapBase<T extends AStarNodeBase<T>> {
    protected ObjectPool<T> objectPool;

    public abstract T nodeAt(int var1, int var2, int var3);

    public abstract void setTileBlocked(int var1, int var2, int var3, boolean var4);

    public abstract boolean isTileBlocked(int var1, int var2, int var3);

    protected void visitIfNotBlocked(AStarMapVisitorBase<T> visitor, T origin, int x2, int y, int z) {
        if (!this.isTileBlocked(x2, y, z)) {
            visitor.visitNeighbour(origin, x2, y, z);
        }
    }

    public abstract void visitNeighboursOf(T var1, AStarMapVisitorBase<T> var2);

    protected void visitNeighboursOf8(T origin, AStarMapVisitorBase<T> visitor) {
        int x2 = ((AStarNodeBase)origin).getX();
        int y = ((AStarNodeBase)origin).getY();
        int z = ((AStarNodeBase)origin).getZ();
        this.visitIfNotBlocked(visitor, origin, x2 - 1, y, z);
        this.visitIfNotBlocked(visitor, origin, x2 + 1, y, z);
        this.visitIfNotBlocked(visitor, origin, x2, y - 1, z);
        this.visitIfNotBlocked(visitor, origin, x2, y + 1, z);
        if (!(this.isTileBlocked(x2 - 1, y - 1, z) || this.isTileBlocked(x2 - 1, y, z) || this.isTileBlocked(x2, y - 1, z))) {
            visitor.visitNeighbour(origin, x2 - 1, y - 1, z);
        }
        if (!(this.isTileBlocked(x2 + 1, y - 1, z) || this.isTileBlocked(x2 + 1, y, z) || this.isTileBlocked(x2, y - 1, z))) {
            visitor.visitNeighbour(origin, x2 + 1, y - 1, z);
        }
        if (!(this.isTileBlocked(x2 - 1, y + 1, z) || this.isTileBlocked(x2 - 1, y, z) || this.isTileBlocked(x2, y + 1, z))) {
            visitor.visitNeighbour(origin, x2 - 1, y + 1, z);
        }
        if (!(this.isTileBlocked(x2 + 1, y + 1, z) || this.isTileBlocked(x2 + 1, y, z) || this.isTileBlocked(x2, y + 1, z))) {
            visitor.visitNeighbour(origin, x2 + 1, y + 1, z);
        }
    }

    protected void visitNeighboursOf4(T origin, AStarMapVisitorBase<T> visitor) {
        int x2 = ((AStarNodeBase)origin).getX();
        int y = ((AStarNodeBase)origin).getY();
        int z = ((AStarNodeBase)origin).getZ();
        this.visitIfNotBlocked(visitor, origin, x2 - 1, y, z);
        this.visitIfNotBlocked(visitor, origin, x2 + 1, y, z);
        this.visitIfNotBlocked(visitor, origin, x2, y - 1, z);
        this.visitIfNotBlocked(visitor, origin, x2, y + 1, z);
    }

    public abstract void clearMapKeepBlocks();

    public abstract AStarMapBase<T> clone();

    public boolean tryInsertPath(List<T> path) {
        for (AStarNodeBase node : path) {
            if (!this.isTileBlocked(node.getX(), node.getY(), node.getZ())) continue;
            return false;
        }
        for (AStarNodeBase node : path) {
            this.setTileBlocked(node.getX(), node.getY(), node.getZ(), true);
        }
        return true;
    }

    public abstract int getMaxXNodes();

    public abstract int getMaxYNodes();

    public abstract int getMaxZNodes();

    public void setObjectPool(ObjectPool<T> objectPool) {
        this.objectPool = objectPool;
    }
}

