/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class SpiceTab
extends PreferencePanel {
    private JPanel epicFrame;
    private JPanel execution;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel9;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JPanel modelCards;
    private JCheckBox overwriteOutputFile;
    private JPanel spice;
    private JButton spiceBrowseHeaderFile;
    private JButton spiceBrowseTrailerFile;
    private JComboBox spiceEnginePopup;
    private JComboBox spiceGlobalTreatment;
    private ButtonGroup spiceHeader;
    private JTextField spiceHeaderCardExtension;
    private JTextField spiceHeaderCardFile;
    private JRadioButton spiceHeaderCardsFromFile;
    private JRadioButton spiceHeaderCardsWithExtension;
    private JComboBox spiceLevelPopup;
    private JRadioButton spiceNoHeaderCards;
    private JRadioButton spiceNoTrailerCards;
    private JComboBox spiceParasitics;
    private JComboBox spicePrimitivesetPopup;
    private JComboBox spiceResistorShorting;
    private JButton spiceRunHelp;
    private JComboBox spiceRunPopup;
    private JCheckBox spiceRunProbe;
    private JTextField spiceRunProgram;
    private JTextField spiceRunProgramArgs;
    private ButtonGroup spiceTrailer;
    private JTextField spiceTrailerCardExtension;
    private JTextField spiceTrailerCardFile;
    private JRadioButton spiceTrailerCardsFromFile;
    private JRadioButton spiceTrailerCardsWithExtension;
    private JCheckBox spiceUseCellParameters;
    private JCheckBox spiceWriteEmptySubcircuits;
    private JCheckBox spiceWriteEndStatement;
    private JCheckBox spiceWritePwrGndSubcircuit;
    private JCheckBox spiceWriteSubcktTopCell;
    private JCheckBox spiceWriteTransSizesInLambda;
    private JPanel upperLeft;
    private JPanel upperRight;
    private JTextField useDir;
    private JCheckBox useDirCheckBox;
    private JPanel writingSpice;

    public SpiceTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.spiceRunProgram);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceRunProgramArgs);
        EDialog.makeTextFieldSelectAllOnTab(this.useDir);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceHeaderCardExtension);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceHeaderCardFile);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceTrailerCardExtension);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceTrailerCardFile);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.spice;
    }

    @Override
    public String getName() {
        return "Spice/CDL";
    }

    @Override
    public void init() {
        this.spiceEnginePopup.addItem(SimulationTool.SpiceEngine.SPICE_ENGINE_2);
        this.spiceEnginePopup.addItem(SimulationTool.SpiceEngine.SPICE_ENGINE_3);
        this.spiceEnginePopup.addItem(SimulationTool.SpiceEngine.SPICE_ENGINE_H);
        this.spiceEnginePopup.addItem(SimulationTool.SpiceEngine.SPICE_ENGINE_P);
        this.spiceEnginePopup.addItem(SimulationTool.SpiceEngine.SPICE_ENGINE_G);
        this.spiceEnginePopup.addItem(SimulationTool.SpiceEngine.SPICE_ENGINE_S);
        this.spiceEnginePopup.addItem(SimulationTool.SpiceEngine.SPICE_ENGINE_O);
        this.spiceEnginePopup.addItem(SimulationTool.SpiceEngine.SPICE_ENGINE_H_ASSURA);
        this.spiceEnginePopup.setSelectedItem((Object)SimulationTool.getSpiceEngine());
        this.spiceLevelPopup.addItem("1");
        this.spiceLevelPopup.addItem("2");
        this.spiceLevelPopup.addItem("3");
        this.spiceLevelPopup.setSelectedItem(SimulationTool.getSpiceLevel());
        this.spiceResistorShorting.addItem("None");
        this.spiceResistorShorting.addItem("Normal only");
        this.spiceResistorShorting.addItem("Normal and Poly");
        this.spiceResistorShorting.setSelectedIndex(SimulationTool.getSpiceShortResistors());
        this.spiceParasitics.addItem(SimulationTool.SpiceParasitics.SIMPLE);
        this.spiceParasitics.addItem(SimulationTool.SpiceParasitics.RC_CONSERVATIVE);
        this.spiceParasitics.setSelectedItem((Object)SimulationTool.getSpiceParasiticsLevel());
        this.spiceGlobalTreatment.addItem("No special treatment");
        this.spiceGlobalTreatment.addItem("Use .GLOBAL block");
        this.spiceGlobalTreatment.addItem("Create .SUBCKT ports");
        this.spiceGlobalTreatment.setSelectedIndex(SimulationTool.getSpiceGlobalTreatment().getCode());
        String[] libFiles = LibFile.getSpicePartsLibraries();
        for (int i = 0; i < libFiles.length; ++i) {
            this.spicePrimitivesetPopup.addItem(libFiles[i]);
        }
        this.spicePrimitivesetPopup.setSelectedItem(SimulationTool.getSpicePartsLibrary());
        this.spiceWritePwrGndSubcircuit.setSelected(SimulationTool.isSpiceWritePwrGndInTopCell());
        this.spiceUseCellParameters.setSelected(SimulationTool.isSpiceUseCellParameters());
        this.spiceWriteTransSizesInLambda.setSelected(SimulationTool.isSpiceWriteTransSizeInLambda());
        this.spiceWriteSubcktTopCell.setSelected(SimulationTool.isSpiceWriteSubcktTopCell());
        this.spiceWriteEndStatement.setSelected(SimulationTool.isSpiceWriteFinalDotEnd());
        this.spiceWriteEmptySubcircuits.setSelected(SimulationTool.isSpiceWriteEmptySubckts());
        String spiceHeaderCardInitial = SimulationTool.getSpiceHeaderCardInfo();
        boolean noHeader = false;
        if (spiceHeaderCardInitial.startsWith("N O N E ")) {
            noHeader = true;
            spiceHeaderCardInitial = spiceHeaderCardInitial.substring("N O N E ".length());
        }
        if (spiceHeaderCardInitial.length() == 0) {
            noHeader = true;
        }
        if (spiceHeaderCardInitial.startsWith("Extension ")) {
            this.spiceHeaderCardsWithExtension.setSelected(true);
            this.spiceHeaderCardExtension.setText(spiceHeaderCardInitial.substring("Extension ".length()));
        } else {
            this.spiceHeaderCardsFromFile.setSelected(true);
            this.spiceHeaderCardFile.setText(spiceHeaderCardInitial);
        }
        if (noHeader) {
            this.spiceNoHeaderCards.setSelected(true);
        }
        String spiceTrailerCardInitial = SimulationTool.getSpiceTrailerCardInfo();
        boolean noTrailer = false;
        if (spiceTrailerCardInitial.startsWith("N O N E ")) {
            noTrailer = true;
            spiceTrailerCardInitial = spiceTrailerCardInitial.substring("N O N E ".length());
        }
        if (spiceTrailerCardInitial.length() == 0) {
            noTrailer = true;
        }
        if (spiceTrailerCardInitial.startsWith("Extension ")) {
            this.spiceTrailerCardsWithExtension.setSelected(true);
            this.spiceTrailerCardExtension.setText(spiceTrailerCardInitial.substring("Extension ".length()));
        } else {
            this.spiceTrailerCardsFromFile.setSelected(true);
            this.spiceTrailerCardFile.setText(spiceTrailerCardInitial);
        }
        if (noTrailer) {
            this.spiceNoTrailerCards.setSelected(true);
        }
        this.spiceBrowseHeaderFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceBrowseHeaderFileActionPerformed();
            }
        });
        this.spiceBrowseTrailerFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceBrowseTrailerFileActionPerformed();
            }
        });
        this.useDir.setText(SimulationTool.getSpiceRunDir());
        this.useDirCheckBox.setSelected(SimulationTool.getSpiceUseRunDir());
        this.overwriteOutputFile.setSelected(SimulationTool.getSpiceOutputOverwrite());
        this.spiceRunProbe.setSelected(SimulationTool.getSpiceRunProbe());
        this.spiceRunProgram.setText(SimulationTool.getSpiceRunProgram());
        this.spiceRunProgramArgs.setText(SimulationTool.getSpiceRunProgramArgs());
        String[] runChoices = SimulationTool.getSpiceRunChoiceValues();
        for (int i = 0; i < runChoices.length; ++i) {
            this.spiceRunPopup.addItem(runChoices[i]);
        }
        this.spiceRunPopup.setSelectedItem(SimulationTool.getSpiceRunChoice());
        if (this.spiceRunPopup.getSelectedIndex() == 0) {
            this.setSpiceRunOptionsEnabled(false);
        } else {
            this.setSpiceRunOptionsEnabled(true);
        }
    }

    private void spiceBrowseTrailerFileActionPerformed() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceTrailerCardFile.setText(fileName);
        this.spiceTrailerCardsFromFile.setSelected(true);
    }

    private void spiceBrowseHeaderFileActionPerformed() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceHeaderCardFile.setText(fileName);
        this.spiceHeaderCardsFromFile.setSelected(true);
    }

    @Override
    public void term() {
        int sr;
        SimulationTool.SpiceEngine engine = (SimulationTool.SpiceEngine)((Object)this.spiceEnginePopup.getSelectedItem());
        if (SimulationTool.getSpiceEngine() != engine) {
            SimulationTool.setSpiceEngine(engine);
        }
        String stringNow = (String)this.spiceLevelPopup.getSelectedItem();
        if (!SimulationTool.getSpiceLevel().equals(stringNow)) {
            SimulationTool.setSpiceLevel(stringNow);
        }
        if ((sr = this.spiceResistorShorting.getSelectedIndex()) != SimulationTool.getSpiceShortResistors()) {
            SimulationTool.setSpiceShortResistors(sr);
        }
        SimulationTool.SpiceParasitics sp2 = (SimulationTool.SpiceParasitics)((Object)this.spiceParasitics.getSelectedItem());
        if (SimulationTool.getSpiceParasiticsLevel() != sp2) {
            SimulationTool.setSpiceParasiticsLevel(sp2);
        }
        SimulationTool.SpiceGlobal signal = SimulationTool.SpiceGlobal.find(this.spiceGlobalTreatment.getSelectedIndex());
        if (SimulationTool.getSpiceGlobalTreatment() != signal) {
            SimulationTool.setSpiceGlobalTreatment(signal);
        }
        stringNow = (String)this.spicePrimitivesetPopup.getSelectedItem();
        if (!SimulationTool.getSpicePartsLibrary().equals(stringNow)) {
            SimulationTool.setSpicePartsLibrary(stringNow);
        }
        boolean booleanNow = this.spiceWritePwrGndSubcircuit.isSelected();
        if (SimulationTool.isSpiceWritePwrGndInTopCell() != booleanNow) {
            SimulationTool.setSpiceWritePwrGndInTopCell(booleanNow);
        }
        booleanNow = this.spiceUseCellParameters.isSelected();
        if (SimulationTool.isSpiceUseCellParameters() != booleanNow) {
            SimulationTool.setSpiceUseCellParameters(booleanNow);
        }
        booleanNow = this.spiceWriteTransSizesInLambda.isSelected();
        if (SimulationTool.isSpiceWriteTransSizeInLambda() != booleanNow) {
            SimulationTool.setSpiceWriteTransSizeInLambda(booleanNow);
        }
        booleanNow = this.spiceWriteSubcktTopCell.isSelected();
        if (SimulationTool.isSpiceWriteSubcktTopCell() != booleanNow) {
            SimulationTool.setSpiceWriteSubcktTopCell(booleanNow);
        }
        booleanNow = this.spiceWriteEndStatement.isSelected();
        if (SimulationTool.isSpiceWriteFinalDotEnd() != booleanNow) {
            SimulationTool.setSpiceWriteFinalDotEnd(booleanNow);
        }
        booleanNow = this.spiceWriteEmptySubcircuits.isSelected();
        if (SimulationTool.isSpiceWriteEmptySubckts() != booleanNow) {
            SimulationTool.setSpiceWriteEmptySubckts(booleanNow);
        }
        String header = "N O N E ";
        header = this.spiceHeaderCardExtension.getText().length() > 0 ? header + "Extension " + this.spiceHeaderCardExtension.getText() : header + this.spiceHeaderCardFile.getText();
        if (this.spiceHeaderCardsWithExtension.isSelected()) {
            header = "Extension " + this.spiceHeaderCardExtension.getText();
        } else if (this.spiceHeaderCardsFromFile.isSelected()) {
            header = this.spiceHeaderCardFile.getText();
        }
        if (!SimulationTool.getSpiceHeaderCardInfo().equals(header)) {
            SimulationTool.setSpiceHeaderCardInfo(header);
        }
        String trailer = "N O N E ";
        trailer = this.spiceTrailerCardExtension.getText().length() > 0 ? trailer + "Extension " + this.spiceTrailerCardExtension.getText() : trailer + this.spiceTrailerCardFile.getText();
        if (this.spiceTrailerCardsWithExtension.isSelected()) {
            trailer = "Extension " + this.spiceTrailerCardExtension.getText();
        } else if (this.spiceTrailerCardsFromFile.isSelected()) {
            trailer = this.spiceTrailerCardFile.getText();
        }
        if (!SimulationTool.getSpiceTrailerCardInfo().equals(trailer)) {
            SimulationTool.setSpiceTrailerCardInfo(trailer);
        }
        stringNow = (String)this.spiceRunPopup.getSelectedItem();
        if (!SimulationTool.getSpiceRunChoice().equals(stringNow)) {
            SimulationTool.setSpiceRunChoice(stringNow);
        }
        stringNow = this.useDir.getText();
        if (!SimulationTool.getSpiceRunDir().equals(stringNow)) {
            SimulationTool.setSpiceRunDir(stringNow);
        }
        booleanNow = this.useDirCheckBox.isSelected();
        if (SimulationTool.getSpiceUseRunDir() != booleanNow) {
            SimulationTool.setSpiceUseRunDir(booleanNow);
        }
        booleanNow = this.overwriteOutputFile.isSelected();
        if (SimulationTool.getSpiceOutputOverwrite() != booleanNow) {
            SimulationTool.setSpiceOutputOverwrite(booleanNow);
        }
        booleanNow = this.spiceRunProbe.isSelected();
        if (SimulationTool.getSpiceRunProbe() != booleanNow) {
            SimulationTool.setSpiceRunProbe(booleanNow);
        }
        stringNow = this.spiceRunProgram.getText();
        if (!SimulationTool.getSpiceRunProgram().equals(stringNow)) {
            SimulationTool.setSpiceRunProgram(stringNow);
        }
        stringNow = this.spiceRunProgramArgs.getText();
        if (!SimulationTool.getSpiceRunProgramArgs().equals(stringNow)) {
            SimulationTool.setSpiceRunProgramArgs(stringNow);
        }
    }

    @Override
    public void reset() {
        if (!SimulationTool.getFactorySpiceEngine().equals((Object)SimulationTool.getSpiceEngine())) {
            SimulationTool.setSpiceEngine(SimulationTool.getFactorySpiceEngine());
        }
        if (!SimulationTool.getFactorySpiceLevel().equals(SimulationTool.getSpiceLevel())) {
            SimulationTool.setSpiceLevel(SimulationTool.getFactorySpiceLevel());
        }
        if (SimulationTool.getFactorySpiceShortResistors() != SimulationTool.getSpiceShortResistors()) {
            SimulationTool.setSpiceShortResistors(SimulationTool.getFactorySpiceShortResistors());
        }
        if (!SimulationTool.getFactorySpiceParasiticsLevel().equals((Object)SimulationTool.getSpiceParasiticsLevel())) {
            SimulationTool.setSpiceParasiticsLevel(SimulationTool.getFactorySpiceParasiticsLevel());
        }
        if (SimulationTool.getFactorySpiceGlobalTreatment() != SimulationTool.getSpiceGlobalTreatment()) {
            SimulationTool.setSpiceGlobalTreatment(SimulationTool.getFactorySpiceGlobalTreatment());
        }
        if (!SimulationTool.getFactorySpicePartsLibrary().equals(SimulationTool.getSpicePartsLibrary())) {
            SimulationTool.setSpicePartsLibrary(SimulationTool.getFactorySpicePartsLibrary());
        }
        if (SimulationTool.isFactorySpiceWritePwrGndInTopCell() != SimulationTool.isSpiceWritePwrGndInTopCell()) {
            SimulationTool.setSpiceWritePwrGndInTopCell(SimulationTool.isFactorySpiceWritePwrGndInTopCell());
        }
        if (SimulationTool.isFactorySpiceUseCellParameters() != SimulationTool.isSpiceUseCellParameters()) {
            SimulationTool.setSpiceUseCellParameters(SimulationTool.isFactorySpiceUseCellParameters());
        }
        if (SimulationTool.isFactorySpiceWriteTransSizeInLambda() != SimulationTool.isSpiceWriteTransSizeInLambda()) {
            SimulationTool.setSpiceWriteTransSizeInLambda(SimulationTool.isFactorySpiceWriteTransSizeInLambda());
        }
        if (SimulationTool.isFactorySpiceWriteSubcktTopCell() != SimulationTool.isSpiceWriteSubcktTopCell()) {
            SimulationTool.setSpiceWriteSubcktTopCell(SimulationTool.isFactorySpiceWriteSubcktTopCell());
        }
        if (SimulationTool.isFactorySpiceWriteFinalDotEnd() != SimulationTool.isSpiceWriteFinalDotEnd()) {
            SimulationTool.setSpiceWriteFinalDotEnd(SimulationTool.isFactorySpiceWriteFinalDotEnd());
        }
        if (SimulationTool.isFactorySpiceWriteEmptySubckts() != SimulationTool.isSpiceWriteEmptySubckts()) {
            SimulationTool.setSpiceWriteEmptySubckts(SimulationTool.isFactorySpiceWriteEmptySubckts());
        }
        if (!SimulationTool.getFactorySpiceHeaderCardInfo().equals(SimulationTool.getSpiceHeaderCardInfo())) {
            SimulationTool.setSpiceHeaderCardInfo(SimulationTool.getFactorySpiceHeaderCardInfo());
        }
        if (!SimulationTool.getFactorySpiceTrailerCardInfo().equals(SimulationTool.getSpiceTrailerCardInfo())) {
            SimulationTool.setSpiceTrailerCardInfo(SimulationTool.getFactorySpiceTrailerCardInfo());
        }
        if (!SimulationTool.getFactorySpiceRunChoice().equals(SimulationTool.getSpiceRunChoice())) {
            SimulationTool.setSpiceRunChoice(SimulationTool.getFactorySpiceRunChoice());
        }
        if (!SimulationTool.getFactorySpiceRunProgram().equals(SimulationTool.getSpiceRunProgram())) {
            SimulationTool.setSpiceRunProgram(SimulationTool.getFactorySpiceRunProgram());
        }
        if (!SimulationTool.getFactorySpiceRunProgramArgs().equals(SimulationTool.getSpiceRunProgramArgs())) {
            SimulationTool.setSpiceRunProgramArgs(SimulationTool.getFactorySpiceRunProgramArgs());
        }
        if (SimulationTool.getFactorySpiceUseRunDir() != SimulationTool.getSpiceUseRunDir()) {
            SimulationTool.setSpiceUseRunDir(SimulationTool.getFactorySpiceUseRunDir());
        }
        if (!SimulationTool.getFactorySpiceRunDir().equals(SimulationTool.getSpiceRunDir())) {
            SimulationTool.setSpiceRunDir(SimulationTool.getFactorySpiceRunDir());
        }
        if (SimulationTool.getFactorySpiceOutputOverwrite() != SimulationTool.getSpiceOutputOverwrite()) {
            SimulationTool.setSpiceOutputOverwrite(SimulationTool.getFactorySpiceOutputOverwrite());
        }
        if (SimulationTool.getFactorySpiceRunProbe() != SimulationTool.getSpiceRunProbe()) {
            SimulationTool.setSpiceRunProbe(SimulationTool.getFactorySpiceRunProbe());
        }
    }

    private void setSpiceRunOptionsEnabled(boolean enabled) {
        this.useDirCheckBox.setEnabled(enabled);
        this.overwriteOutputFile.setEnabled(enabled);
        this.spiceRunProgram.setEnabled(enabled);
        this.spiceRunProgramArgs.setEnabled(enabled);
        this.spiceRunHelp.setEnabled(enabled);
        this.spiceRunProbe.setEnabled(enabled);
        this.useDir.setEnabled(enabled);
        if (enabled && !this.useDirCheckBox.isSelected()) {
            this.useDir.setEnabled(false);
        }
    }

    private void initComponents() {
        this.spiceHeader = new ButtonGroup();
        this.spiceTrailer = new ButtonGroup();
        this.spice = new JPanel();
        this.execution = new JPanel();
        this.spiceRunPopup = new JComboBox();
        this.spiceRunProgram = new JTextField();
        this.jLabel17 = new JLabel();
        this.useDirCheckBox = new JCheckBox();
        this.useDir = new JTextField();
        this.overwriteOutputFile = new JCheckBox();
        this.spiceRunHelp = new JButton();
        this.jLabel3 = new JLabel();
        this.spiceRunProgramArgs = new JTextField();
        this.spiceRunProbe = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.writingSpice = new JPanel();
        this.upperLeft = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel9 = new JLabel();
        this.spiceEnginePopup = new JComboBox();
        this.spiceLevelPopup = new JComboBox();
        this.jLabel13 = new JLabel();
        this.spicePrimitivesetPopup = new JComboBox();
        this.epicFrame = new JPanel();
        this.spiceResistorShorting = new JComboBox();
        this.jLabel4 = new JLabel();
        this.spiceParasitics = new JComboBox();
        this.jLabel6 = new JLabel();
        this.spiceGlobalTreatment = new JComboBox();
        this.upperRight = new JPanel();
        this.spiceWriteEndStatement = new JCheckBox();
        this.spiceWriteTransSizesInLambda = new JCheckBox();
        this.spiceUseCellParameters = new JCheckBox();
        this.spiceWriteSubcktTopCell = new JCheckBox();
        this.spiceWritePwrGndSubcircuit = new JCheckBox();
        this.spiceWriteEmptySubcircuits = new JCheckBox();
        this.modelCards = new JPanel();
        this.spiceHeaderCardExtension = new JTextField();
        this.spiceNoHeaderCards = new JRadioButton();
        this.spiceHeaderCardsWithExtension = new JRadioButton();
        this.spiceHeaderCardsFromFile = new JRadioButton();
        this.spiceNoTrailerCards = new JRadioButton();
        this.spiceTrailerCardsWithExtension = new JRadioButton();
        this.spiceTrailerCardsFromFile = new JRadioButton();
        this.spiceHeaderCardFile = new JTextField();
        this.spiceBrowseHeaderFile = new JButton();
        this.spiceTrailerCardExtension = new JTextField();
        this.spiceTrailerCardFile = new JTextField();
        this.spiceBrowseTrailerFile = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.setTitle("Spice Preferences");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SpiceTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.spice.setToolTipText("Options for Spice deck generation");
        this.spice.setLayout(new GridBagLayout());
        this.execution.setBorder(BorderFactory.createTitledBorder("Running Spice"));
        this.execution.setLayout(new GridBagLayout());
        this.spiceRunPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceRunPopupActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.execution.add((Component)this.spiceRunPopup, gridBagConstraints);
        this.spiceRunProgram.setColumns(8);
        this.spiceRunProgram.setMinimumSize(new Dimension(100, 20));
        this.spiceRunProgram.setPreferredSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.execution.add((Component)this.spiceRunProgram, gridBagConstraints);
        this.jLabel17.setText("Run program:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 2, 4, 4);
        this.execution.add((Component)this.jLabel17, gridBagConstraints);
        this.useDirCheckBox.setText("Use dir:");
        this.useDirCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.useDirCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.execution.add((Component)this.useDirCheckBox, gridBagConstraints);
        this.useDir.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.execution.add((Component)this.useDir, gridBagConstraints);
        this.overwriteOutputFile.setText("Overwrite existing output file (no prompts)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.execution.add((Component)this.overwriteOutputFile, gridBagConstraints);
        this.spiceRunHelp.setText("Help");
        this.spiceRunHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceRunHelpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.execution.add((Component)this.spiceRunHelp, gridBagConstraints);
        this.jLabel3.setText("With args:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.execution.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.execution.add((Component)this.spiceRunProgramArgs, gridBagConstraints);
        this.spiceRunProbe.setText("Run probe");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.execution.add((Component)this.spiceRunProbe, gridBagConstraints);
        this.jLabel2.setText("After writing deck:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.execution.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.execution, gridBagConstraints);
        this.writingSpice.setBorder(BorderFactory.createTitledBorder("Writing Spice Deck"));
        this.writingSpice.setLayout(new GridBagLayout());
        this.upperLeft.setLayout(new GridBagLayout());
        this.jLabel5.setText("Parasitics:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel1.setText("Spice engine:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel9.setText("Spice level:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spiceEnginePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spiceLevelPopup, gridBagConstraints);
        this.jLabel13.setText("Spice primitive set:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spicePrimitivesetPopup, gridBagConstraints);
        this.epicFrame.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.upperLeft.add((Component)this.epicFrame, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spiceResistorShorting, gridBagConstraints);
        this.jLabel4.setText("Resistor shorting:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spiceParasitics, gridBagConstraints);
        this.jLabel6.setText("Globals:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spiceGlobalTreatment, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.writingSpice.add((Component)this.upperLeft, gridBagConstraints);
        this.upperRight.setLayout(new GridBagLayout());
        this.spiceWriteEndStatement.setText("Write .end statement");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceWriteEndStatement, gridBagConstraints);
        this.spiceWriteTransSizesInLambda.setText("Write trans sizes in units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceWriteTransSizesInLambda, gridBagConstraints);
        this.spiceUseCellParameters.setText("Use cell parameters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceUseCellParameters, gridBagConstraints);
        this.spiceWriteSubcktTopCell.setText("Write .subckt for top cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceWriteSubcktTopCell, gridBagConstraints);
        this.spiceWritePwrGndSubcircuit.setText("Write VDD/GND in top cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceWritePwrGndSubcircuit, gridBagConstraints);
        this.spiceWriteEmptySubcircuits.setText("Write empty subcircuits");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceWriteEmptySubcircuits, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.writingSpice.add((Component)this.upperRight, gridBagConstraints);
        this.modelCards.setLayout(new GridBagLayout());
        this.spiceHeaderCardExtension.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.modelCards.add((Component)this.spiceHeaderCardExtension, gridBagConstraints);
        this.spiceHeader.add(this.spiceNoHeaderCards);
        this.spiceNoHeaderCards.setText("No Header cards");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceNoHeaderCards, gridBagConstraints);
        this.spiceHeader.add(this.spiceHeaderCardsWithExtension);
        this.spiceHeaderCardsWithExtension.setText("Use Header cards from files with extension:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceHeaderCardsWithExtension, gridBagConstraints);
        this.spiceHeader.add(this.spiceHeaderCardsFromFile);
        this.spiceHeaderCardsFromFile.setText("Use Header cards from file:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceHeaderCardsFromFile, gridBagConstraints);
        this.spiceTrailer.add(this.spiceNoTrailerCards);
        this.spiceNoTrailerCards.setText("No Trailer cards");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceNoTrailerCards, gridBagConstraints);
        this.spiceTrailer.add(this.spiceTrailerCardsWithExtension);
        this.spiceTrailerCardsWithExtension.setText("Use Trailer cards from files with extension:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceTrailerCardsWithExtension, gridBagConstraints);
        this.spiceTrailer.add(this.spiceTrailerCardsFromFile);
        this.spiceTrailerCardsFromFile.setText("Use Trailer cards from File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceTrailerCardsFromFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.modelCards.add((Component)this.spiceHeaderCardFile, gridBagConstraints);
        this.spiceBrowseHeaderFile.setText("Browse");
        this.spiceBrowseHeaderFile.setMinimumSize(new Dimension(78, 20));
        this.spiceBrowseHeaderFile.setPreferredSize(new Dimension(78, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.modelCards.add((Component)this.spiceBrowseHeaderFile, gridBagConstraints);
        this.spiceTrailerCardExtension.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.modelCards.add((Component)this.spiceTrailerCardExtension, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.modelCards.add((Component)this.spiceTrailerCardFile, gridBagConstraints);
        this.spiceBrowseTrailerFile.setText("Browse");
        this.spiceBrowseTrailerFile.setMinimumSize(new Dimension(78, 20));
        this.spiceBrowseTrailerFile.setPreferredSize(new Dimension(78, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.modelCards.add((Component)this.spiceBrowseTrailerFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.modelCards.add((Component)this.jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.modelCards.add((Component)this.jSeparator5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.writingSpice.add((Component)this.modelCards, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.spice.add((Component)this.writingSpice, gridBagConstraints);
        this.getContentPane().add((Component)this.spice, new GridBagConstraints());
        this.pack();
    }

    private void spiceRunPopupActionPerformed(ActionEvent evt) {
        if (this.spiceRunPopup.getSelectedIndex() == 0) {
            this.setSpiceRunOptionsEnabled(false);
        } else {
            this.setSpiceRunOptionsEnabled(true);
        }
    }

    private void spiceRunHelpActionPerformed(ActionEvent evt) {
        String[] message = new String[]{"IMPORTANT: This executes a single program with the given arguments.  It does NOT run a command-line command.", "For example, 'echo blah > file' will NOT work. Encapsulate it in a script if you want to do such things.", "-----------------", "The following variables are available to use in the program name and arguments:", "   ${WORKING_DIR}:  The current working directory", "   ${USE_DIR}:  The path entered in the 'Use Directory' field, if specified (defaults to WORKING_DIR)", "   ${FILEPATH}:  The full path of the output file", "   ${FILENAME}:  The output file name (with extension)", "   ${FILENAME_NO_EXT}:  The output file name (without extension)", "Example: Program: \"hspice\".  Arguments: \"${FILEPATH}\""};
        JOptionPane.showMessageDialog(this, message, "Spice Run Help", 1);
    }

    private void useDirCheckBoxActionPerformed(ActionEvent evt) {
        this.useDir.setEnabled(this.useDirCheckBox.isSelected());
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

