/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore2;

import com.sun.electric.tool.routing.experimentalLeeMoore2.GlobalRouterV3;
import com.sun.electric.tool.routing.experimentalLeeMoore2.RegionDirection;
import com.sun.electric.tool.routing.experimentalLeeMoore2.Vector2i;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class GlobalRouterPathFinder {
    GlobalRouterV3 glr;
    int[] fields;

    public GlobalRouterPathFinder(GlobalRouterV3 router) {
        this.glr = router;
        this.fields = new int[this.glr.regions_x * this.glr.regions_y];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = Integer.MAX_VALUE;
        }
    }

    private int GetFieldIndex(int x, int y) {
        return y * this.glr.regions_x + x;
    }

    private void SetField(int x, int y, int value) {
        this.fields[this.GetFieldIndex((int)x, (int)y)] = value;
    }

    private int GetField(int x, int y) {
        return this.fields[this.GetFieldIndex(x, y)];
    }

    public ArrayList<Vector2i> ConvertToPath(ArrayList<RegionDirection> dirs, Vector2i start) {
        ArrayList<Vector2i> ret = new ArrayList<Vector2i>();
        Vector2i pos = new Vector2i(start);
        ret.add(pos);
        for (RegionDirection rd : dirs) {
            Vector2i nb = this.glr.GetNeighborPos(pos, rd);
            assert (this.glr.IsCoordinateValid(nb.x, nb.y));
            ret.add(nb);
        }
        return ret;
    }

    private ArrayList<RegionDirection> FindShortestPathLeeMoore(int seg_id) {
        Vector2i start = this.glr.segments[seg_id].start;
        Vector2i end = this.glr.segments[seg_id].end;
        LinkedList<LeeMooreJob> jobs = new LinkedList<LeeMooreJob>();
        LeeMooreJob cj = new LeeMooreJob(new Vector2i(start), 0);
        this.SetField(start.x, start.y, 0);
        while (cj != null && !cj.pos.equals(end)) {
            for (RegionDirection dir : RegionDirection.values()) {
                if (dir == RegionDirection.rd_undefined || !this.glr.IsCoordinateValid(this.glr.GetNeighborX(cj.pos.x, dir), this.glr.GetNeighborY(cj.pos.y, dir))) continue;
                Vector2i neighbor = this.glr.GetNeighborPos(cj.pos, dir);
                int n = this.GetField(neighbor.x, neighbor.y);
                if (n >= 0 && n < Integer.MAX_VALUE && n <= cj.length + 1 || this.glr.RegionAt(cj.pos.x, cj.pos.y).GetRegionBorder(dir).IsBlocked()) continue;
                this.SetField(neighbor.x, neighbor.y, cj.length + 1);
                jobs.offer(new LeeMooreJob(neighbor, cj.length + 1));
            }
            cj = (LeeMooreJob)jobs.poll();
        }
        if (cj == null || !cj.pos.equals(end)) {
            return null;
        }
        int l = cj.length;
        ArrayList<RegionDirection> ret_list = new ArrayList<RegionDirection>();
        Vector2i it = new Vector2i(end);
        while (!it.equals(start)) {
            int min = Integer.MAX_VALUE;
            RegionDirection min_dir = RegionDirection.rd_undefined;
            RegionDirection[] directions = RegionDirection.values();
            List<RegionDirection> dir_list = Arrays.asList(directions);
            Collections.shuffle(dir_list);
            for (int i = 0; i < dir_list.size(); ++i) {
                directions[i] = dir_list.get(i);
            }
            for (RegionDirection dir : directions) {
                int w;
                if (dir == RegionDirection.rd_undefined || !this.glr.IsCoordinateValid(this.glr.GetNeighborX(it.x, dir), this.glr.GetNeighborY(it.y, dir)) || (w = this.GetField(this.glr.GetNeighborX(it.x, dir), this.glr.GetNeighborY(it.y, dir))) < 0 || w >= min) continue;
                min = w;
                min_dir = dir;
            }
            if (min_dir == RegionDirection.rd_undefined) {
                assert (min_dir != RegionDirection.rd_undefined);
                return null;
            }
            ret_list.add(0, GlobalRouterV3.GetOppositeDir(min_dir));
            assert (ret_list.size() <= l);
            it = this.glr.GetNeighborPos(it, min_dir);
        }
        return ret_list;
    }

    public List<RegionDirection> FindShortestPath(int seg_id) {
        return this.FindShortestPathLeeMoore(seg_id);
    }

    private class LeeMooreJob {
        Vector2i pos;
        int length;

        private LeeMooreJob(Vector2i p, int l) {
            this.pos = p;
            this.length = l;
        }
    }
}

