/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ProtocolViolationException;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.Parser;

public class NestedParser
implements Parser {
    private final Field targetField;
    private final Parser nestedParser;
    private boolean newFrame;
    boolean optional;

    public NestedParser(Parser p, boolean optional, Field f, boolean newFrame) {
        this.targetField = f;
        this.optional = optional;
        this.nestedParser = p;
        this.newFrame = newFrame;
    }

    @Override
    public int getSize(Message src) {
        Message inner = (Message)ReflectUtil.justGet(src, this.targetField);
        if (inner == null) {
            if (this.optional) {
                return 0;
            }
            throw new AssertionError((Object)String.format("empty non-optional nested message in field '%s'", this.targetField));
        }
        return this.nestedParser.getSize(inner);
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        if (this.newFrame) {
            frameObj = dstObj;
            frameOffset = 0;
        }
        if (this.optional) {
            if (frameSizePath == null) {
                throw new AssertionError((Object)"optional nested message needs @FrameSize");
            }
            int remaining = frameOffset + ReflectUtil.justGetInt(frameObj, frameSizePath) - srcBuf.position();
            if (remaining < 0) {
                throw new ProtocolViolationException("remaining size negative");
            }
            if (remaining == 0) {
                if (!this.optional) {
                    throw new ProtocolViolationException("not optional");
                }
                ReflectUtil.justSet(dstObj, this.targetField, null);
                return 0;
            }
        }
        if (this.targetField.getType().isInterface()) {
            throw new AssertionError((Object)String.format("Target field '%s' is an interface, not a class.", this.targetField));
        }
        ReflectUtil.justSet(dstObj, this.targetField, ReflectUtil.justInstantiate(this.targetField.getType()));
        try {
            return this.nestedParser.parse(srcBuf, frameOffset, frameObj, (Message)ReflectUtil.justGet(dstObj, this.targetField), frameSizePath);
        }
        catch (ProtocolViolationException e) {
            throw e.augmentPath("nested parser on " + this.targetField.toString());
        }
    }

    @Override
    public int write(ByteBuffer dstBuf, Message src) {
        Object nestedMessage = ReflectUtil.justGet(src, this.targetField);
        if (nestedMessage == null) {
            return 0;
        }
        return this.nestedParser.write(dstBuf, (Message)nestedMessage);
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
        Message nestedMessage = (Message)ReflectUtil.justGet(m, this.targetField);
        if (this.newFrame) {
            this.nestedParser.patch(nestedMessage, this.nestedParser.getSize(nestedMessage), null, nestedMessage);
        } else {
            this.nestedParser.patch(nestedMessage, frameSize, frameSizePath, frameObj);
        }
    }

    @Override
    public int getStaticSize() {
        return this.nestedParser.getStaticSize();
    }
}

