/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Construct;
import org.gnunet.construct.Message;
import org.gnunet.construct.MessageLoader;
import org.gnunet.construct.MessageUnion;
import org.gnunet.construct.ProtocolViolationException;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.Parser;

public class UnionParser
implements Parser {
    private final Field targetField;
    private final List<Field> unionTagPath;
    private final ReflectUtil.NumField unionTagField;
    private final Class<? extends MessageUnion> unionType;
    boolean optional;

    public UnionParser(boolean optional, Class<? extends MessageUnion> unionType, List<Field> unionTagPath, Field f) {
        this.targetField = f;
        this.optional = optional;
        this.unionTagPath = unionTagPath;
        this.unionTagField = new ReflectUtil.NumField(unionTagPath.get(unionTagPath.size() - 1));
        this.unionType = unionType;
    }

    @Override
    public int getSize(Message src) {
        Object target = ReflectUtil.justGet(src, this.targetField);
        if (target == null) {
            if (this.optional) {
                return 0;
            }
            throw new AssertionError((Object)"non-optional union member must not be null");
        }
        Class<?> cls = ReflectUtil.justGet(src, this.targetField).getClass();
        Parser parser = Construct.getParser(cls);
        return parser.getSize((Message)ReflectUtil.justGet(src, this.targetField));
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        if (this.optional) {
            if (frameSizePath == null) {
                throw new AssertionError((Object)"missing @FrameSize");
            }
            int remaining = frameOffset + ReflectUtil.justGetInt(frameObj, frameSizePath) - srcBuf.position();
            if (remaining <= 0) {
                if (!this.optional) {
                    throw new ProtocolViolationException("not optional");
                }
                ReflectUtil.justSet(dstObj, this.targetField, null);
                return 0;
            }
        }
        long unionTag = this.unionTagField.get(ReflectUtil.followFieldPathToParent(this.unionTagPath, dstObj));
        Class<? extends MessageUnion> cls = MessageLoader.getUnionClass(this.unionType, (int)unionTag);
        ReflectUtil.justSet(dstObj, this.targetField, ReflectUtil.justInstantiate(cls));
        Message theUnion = (Message)ReflectUtil.justGet(dstObj, this.targetField);
        Parser parser = Construct.getParser(cls);
        return parser.parse(srcBuf, frameOffset, frameObj, theUnion, frameSizePath);
    }

    @Override
    public int write(ByteBuffer dstBuf, Message src) {
        Object target = ReflectUtil.justGet(src, this.targetField);
        if (target == null) {
            if (this.optional) {
                return 0;
            }
            throw new AssertionError((Object)"non-optional union member must not be null");
        }
        Class<?> currentUnionClass = target.getClass();
        Parser p = Construct.getParser(currentUnionClass);
        return p.write(dstBuf, (Message)ReflectUtil.justGet(src, this.targetField));
    }

    public int getTag(Message m) {
        return MessageLoader.getUnionTag(this.unionType, ReflectUtil.justGet(m, this.targetField).getClass());
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
        Class<?> currentUnionClass = ReflectUtil.justGet(m, this.targetField).getClass();
        Parser p = Construct.getParser(currentUnionClass);
        p.patch((Message)ReflectUtil.justGet(m, this.targetField), frameSize, frameSizePath, frameObj);
        this.unionTagField.set(ReflectUtil.followFieldPathToParent(this.unionTagPath, m), this.getTag(m));
    }

    @Override
    public int getStaticSize() {
        return 0;
    }
}

