/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.List;
import org.gnunet.construct.Construct;
import org.gnunet.mq.Envelope;
import org.gnunet.mq.MessageQueue;
import org.gnunet.util.GnunetMessage;
import org.gnunet.util.MessageStreamTokenizer;
import org.gnunet.util.MstCalllback;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.RunaboutMessageReceiver;
import org.gnunet.util.Scheduler;
import org.gnunet.util.UnknownMessageBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper
extends MessageQueue {
    private static final Logger logger = LoggerFactory.getLogger(Helper.class);
    private final ProcessBuilder processBuilder;
    private final RunaboutMessageReceiver receiver;
    private Process process;
    private WriteThread writeThread;
    private ReadThread readThread;
    private Scheduler.TaskConfiguration writeTaskConfig;
    private Scheduler.TaskIdentifier writeTaskId;
    private Scheduler.TaskConfiguration readTaskConfig;
    private Scheduler.TaskIdentifier readTaskId;
    private ByteBuffer writeBuffer = ByteBuffer.allocate(1024);
    private MessageStreamTokenizer mst;
    private boolean killed;

    private String getBinaryPath(String binaryName) {
        if (!binaryName.contains("gnunet")) {
            return binaryName;
        }
        String prefix = System.getenv("GNUNET_PREFIX");
        if (prefix == null || prefix.isEmpty()) {
            return binaryName;
        }
        return prefix + "/lib/" + "gnunet/" + "libexec/" + binaryName;
    }

    public Helper(boolean withControlPipe, String binaryName, List<String> argv, RunaboutMessageReceiver receiver) {
        logger.debug("in helper constructor");
        this.receiver = receiver;
        LinkedList<String> command = new LinkedList<String>();
        if (binaryName == null) {
            throw new AssertionError();
        }
        command.add(this.getBinaryPath(binaryName));
        if (argv != null) {
            command.addAll(argv);
        }
        this.processBuilder = new ProcessBuilder(command);
        try {
            this.process = this.processBuilder.start();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.mst = new MessageStreamTokenizer(new HelperMstCallback());
        this.writeThread = new WriteThread();
        this.readThread = new ReadThread();
        logger.debug("creating helper");
        try {
            this.readThread.pipe.source().configureBlocking(false);
            this.writeThread.pipe.sink().configureBlocking(false);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.writeThread.start();
        this.readThread.start();
        this.readTaskConfig = new Scheduler.TaskConfiguration(RelativeTime.FOREVER, new ReadTask());
        this.readTaskConfig.addSelectEvent(this.readThread.pipe.source(), 1);
        this.writeTaskConfig = new Scheduler.TaskConfiguration(RelativeTime.FOREVER, new WriteTask());
        this.writeTaskConfig.addSelectEvent(this.writeThread.pipe.sink(), 4);
        this.readTaskId = this.readTaskConfig.schedule();
        this.reportReadyForSubmit();
    }

    public boolean kill(boolean softkill) {
        logger.debug("killing helper process (soft={})", (Object)softkill);
        this.killed = true;
        if (this.readTaskId != null) {
            this.readTaskId.cancel();
            this.readTaskId = null;
        }
        if (this.writeTaskId != null) {
            this.writeTaskId.cancel();
            this.writeTaskId = null;
        }
        try {
            this.readThread.pipe.source().close();
            this.readThread.pipe.sink().close();
            this.writeThread.pipe.source().close();
            this.writeThread.pipe.sink().close();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        if (softkill) {
            try {
                this.process.getInputStream().close();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
        this.process.destroy();
        return true;
    }

    public boolean waitFor() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void submit(Envelope ev) {
        if (this.writeTaskId != null) {
            throw new AssertionError();
        }
        logger.debug("submitting envelope to helper thread");
        GnunetMessage gm = new GnunetMessage();
        gm.header = new GnunetMessage.Header();
        gm.body = ev.message;
        Construct.patch(gm);
        gm.header.messageSize = Construct.getSize(gm);
        if (this.writeBuffer.capacity() < gm.header.messageSize) {
            this.writeBuffer = ByteBuffer.allocate(gm.header.messageSize);
        }
        this.writeBuffer.clear();
        int n = Construct.write(this.writeBuffer, gm);
        this.writeBuffer.flip();
        logger.debug("wrote message size {} to write buffer", (Object)n);
        this.writeTaskId = this.writeTaskConfig.schedule();
    }

    @Override
    protected void retract() {
        throw new UnsupportedOperationException();
    }

    private class HelperMstCallback
    implements MstCalllback {
        private HelperMstCallback() {
        }

        @Override
        public void onUnknownMessage(UnknownMessageBody b) {
            logger.warn("got unknown message type");
        }

        @Override
        public void onKnownMessage(GnunetMessage msg) {
            logger.debug("processing message from helper");
            Helper.this.receiver.process(msg.body);
        }
    }

    private class WriteTask
    implements Scheduler.Task {
        private WriteTask() {
        }

        @Override
        public void run(Scheduler.RunContext ctx) {
            Helper.this.writeTaskId = null;
            try {
                int n = ((Helper)Helper.this).writeThread.pipe.sink().write(Helper.this.writeBuffer);
                logger.debug("wrote {} bytes in write task", (Object)n);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            if (Helper.this.writeBuffer.hasRemaining()) {
                Helper.this.writeTaskId = Helper.this.writeTaskConfig.schedule();
            } else {
                Helper.this.reportMessageSent();
                Helper.this.reportReadyForSubmit();
            }
        }
    }

    private class ReadTask
    implements Scheduler.Task {
        private ReadTask() {
        }

        @Override
        public void run(Scheduler.RunContext ctx) {
            int n;
            Helper.this.readTaskId = null;
            try {
                n = Helper.this.mst.readFrom(((Helper)Helper.this).readThread.pipe.source(), false);
            }
            catch (IOException e) {
                logger.warn("helper reader got io exception: {}", (Throwable)e);
                return;
            }
            if (n == -1) {
                logger.debug("helper reader got EOF");
                return;
            }
            if (!((Helper)Helper.this).readThread.pipe.sink().isOpen()) {
                logger.debug("read thread closed pipe");
                return;
            }
            Helper.this.readTaskId = Helper.this.readTaskConfig.schedule();
        }
    }

    private final class ReadThread
    extends Thread {
        Pipe pipe;

        public ReadThread() {
            try {
                this.pipe = Pipe.open();
            }
            catch (IOException e) {
                throw new RuntimeException("JVM does not support pipes");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] buf = new byte[1024];
            try {
                block3: while (true) {
                    logger.debug("reading from process");
                    int n = Helper.this.process.getInputStream().read(buf);
                    if (n == -1) {
                        logger.debug("reached EOF while reading from process");
                        return;
                    }
                    logger.debug("read {} bytes from process", (Object)n);
                    ByteBuffer b = ByteBuffer.wrap(buf, 0, n);
                    while (true) {
                        if (!b.hasRemaining()) continue block3;
                        this.pipe.sink().write(b);
                    }
                    break;
                }
            }
            catch (ClosedChannelException e) {
                logger.debug("channel closed for read thread");
                return;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    private final class WriteThread
    extends Thread {
        final Pipe pipe;

        public WriteThread() {
            try {
                this.pipe = Pipe.open();
            }
            catch (IOException e) {
                throw new RuntimeException("JVM does not support pipes");
            }
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            WritableByteChannel channel = Channels.newChannel(Helper.this.process.getOutputStream());
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            block3: while (true) {
                buffer.clear();
                logger.debug("waiting for readable pipe in thread");
                int n = this.pipe.source().read(buffer);
                if (n == -1) {
                    logger.debug("write thread pipe closed");
                    return;
                }
                logger.debug("read {} bytes from pipe", (Object)n);
                buffer.flip();
                while (true) {
                    if (!buffer.hasRemaining()) continue block3;
                    n = channel.write(buffer);
                    Helper.this.process.getOutputStream().flush();
                    logger.debug("written {} bytes to process", (Object)n);
                }
                break;
            }
            catch (ClosedChannelException e) {
                logger.debug("channel closed for write thread");
                return;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }
}

