/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.voting;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.gnunet.secretsharing.Parameters;
import org.gnunet.secretsharing.ThresholdPublicKey;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Configuration;
import org.gnunet.util.HashCode;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.crypto.EcdsaPrivateKey;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.gnunet.util.crypto.EcdsaSignature;
import org.gnunet.util.crypto.EddsaSignature;
import org.gnunet.voting.EncryptedVote;
import org.gnunet.voting.GroupCert;
import org.gnunet.voting.InvalidBallotException;
import org.gnunet.voting.VotingParameters;
import org.gnunet.voting.messages.KeyQueryResponseMessage;

public class Ballot {
    String topic;
    String group;
    AbsoluteTime keygenStartTime;
    AbsoluteTime keygenEndTime;
    List<String> choices;
    AbsoluteTime startTime;
    AbsoluteTime closingTime;
    AbsoluteTime concludeTime;
    AbsoluteTime queryTime;
    AbsoluteTime endTime;
    BiMap<String, PeerIdentity> authorities;
    SortedMap<String, EddsaSignature> registrationSigs;
    EcdsaPublicKey caPub;
    EcdsaPublicKey issuerPub;
    EcdsaSignature issuerSig;
    EcdsaPublicKey voterPub;
    SortedMap<String, EddsaSignature> confirmationSigs;
    GroupCert groupCert;
    SortedMap<String, KeyQueryResponseMessage> thresholdPublicKeys;
    BigInteger[] generators;
    public int threshold;
    EncryptedVote encryptedVote;

    public Ballot(String filename) {
        Configuration cfg = new Configuration();
        cfg.parse(filename);
        this.fillBallot(cfg);
    }

    public Ballot(Configuration cfg) {
        this.fillBallot(cfg);
    }

    private AbsoluteTime getTime(Configuration cfg, String timeValueName) {
        Optional<String> optTimeHuman = cfg.getValueString("election", "TIME_" + timeValueName);
        Optional<String> optTimeStamp = cfg.getValueString("election", "TIMESTAMP_" + timeValueName);
        if (optTimeStamp.isPresent()) {
            try {
                long stamp = Long.parseLong((String)optTimeStamp.get());
                return AbsoluteTime.fromSeconds(stamp);
            }
            catch (NumberFormatException e) {
                throw new InvalidBallotException("time value " + timeValueName + " malformed");
            }
        }
        if (optTimeHuman.isPresent()) {
            AbsoluteTime time = AbsoluteTime.fromString((String)optTimeHuman.get());
            if (null == time) {
                throw new InvalidBallotException("timestamp value " + timeValueName + " malformed");
            }
            return time;
        }
        throw new InvalidBallotException("time value " + timeValueName + " missing");
    }

    private void fillBallot(Configuration cfg) {
        EddsaSignature sig;
        Optional<String> optTopic = cfg.getValueString("election", "TOPIC");
        if (!optTopic.isPresent()) {
            throw new InvalidBallotException("ballot has no topic");
        }
        this.topic = (String)optTopic.get();
        Optional<String> optChoices = cfg.getValueString("election", "CHOICES");
        if (!optChoices.isPresent()) {
            throw new InvalidBallotException("ballot has no choices");
        }
        this.choices = Arrays.asList(((String)optChoices.get()).split(Pattern.quote("//")));
        if (this.choices.size() < 2) {
            throw new InvalidBallotException("less than two choices present");
        }
        Optional<String> optGroup = cfg.getValueString("election", "GROUP");
        if (!optGroup.isPresent()) {
            throw new InvalidBallotException("ballot must have elegibility group");
        }
        this.group = (String)optGroup.get();
        Optional<Long> optThreshold = cfg.getValueNumber("election", "THRESHOLD");
        if (!optThreshold.isPresent()) {
            throw new InvalidBallotException("ballot must have threshold");
        }
        if ((Long)optThreshold.get() <= 0L) {
            throw new InvalidBallotException("threshold must be positive");
        }
        this.threshold = ((Long)optThreshold.get()).intValue();
        this.authorities = HashBiMap.create();
        for (Map.Entry<String, String> e : cfg.getSection("authorities").entrySet()) {
            String alias = e.getKey();
            PeerIdentity peerIdentity = PeerIdentity.fromString(e.getValue());
            if (peerIdentity == null) {
                throw new InvalidBallotException(String.format("authority %s has invalid peer identity", alias));
            }
            this.authorities.put((Object)alias, (Object)peerIdentity);
        }
        if (this.authorities.size() < 1) {
            throw new InvalidBallotException("ballot must specify at least one authority");
        }
        Optional<String> optCaPub = cfg.getValueString("election", "CA_PUB");
        if (!optCaPub.isPresent()) {
            throw new InvalidBallotException("no CA pub key given");
        }
        this.caPub = EcdsaPublicKey.fromString((String)optCaPub.get());
        if (null == this.caPub) {
            throw new InvalidBallotException("CA pub key invalid");
        }
        Optional<String> optIssuerPub = cfg.getValueString("election", "ISSUER_PUB");
        if (optIssuerPub.isPresent()) {
            this.issuerPub = EcdsaPublicKey.fromString((String)optIssuerPub.get());
            Optional<String> optIssuerSig = cfg.getValueString("election", "ISSUER_SIG");
            if (!optIssuerSig.isPresent()) {
                throw new InvalidBallotException("issuer public key present, but no signature");
            }
            this.issuerSig = EcdsaSignature.fromString((String)optIssuerSig.get());
        }
        this.registrationSigs = new TreeMap<String, EddsaSignature>();
        for (Map.Entry<String, String> e : cfg.getSection("registration-signatures").entrySet()) {
            sig = EddsaSignature.fromString(e.getValue());
            if (null == sig) {
                throw new InvalidBallotException("registration signature has invalid format");
            }
            if (!this.authorities.containsKey((Object)e.getKey())) {
                throw new InvalidBallotException("ballot contains superfluous registration signature");
            }
            this.registrationSigs.put(e.getKey(), sig);
        }
        this.confirmationSigs = new TreeMap<String, EddsaSignature>();
        for (Map.Entry<String, String> e : cfg.getSection("vouchers").entrySet()) {
            sig = EddsaSignature.fromString(e.getValue());
            if (null == sig) {
                throw new InvalidBallotException("voucher signature has invalid format");
            }
            if (!this.authorities.containsKey((Object)e.getKey())) {
                throw new InvalidBallotException("ballot contains superfluous voucher signature");
            }
            this.confirmationSigs.put(e.getKey(), sig);
        }
        Optional<String> optVoterPub = cfg.getValueString("vote", "VOTER_PUB");
        if (optVoterPub.isPresent()) {
            this.voterPub = EcdsaPublicKey.fromString((String)optVoterPub.get());
            if (null == this.voterPub) {
                throw new InvalidBallotException("voter public key present but invalid");
            }
            this.encryptedVote = EncryptedVote.parseFromConfiguration(cfg, this.voterPub);
        }
        this.startTime = this.getTime(cfg, "START");
        this.closingTime = this.getTime(cfg, "CLOSING");
        this.concludeTime = this.getTime(cfg, "CONCLUDE");
        this.queryTime = this.getTime(cfg, "QUERY");
        this.endTime = this.getTime(cfg, "END");
        this.keygenStartTime = this.getTime(cfg, "KEYGEN_START");
        this.keygenEndTime = this.getTime(cfg, "KEYGEN_END");
        if (cfg.haveValue("vote", "GROUP_SIG")) {
            this.groupCert = GroupCert.fromBallotConfig(this, cfg);
        }
        this.thresholdPublicKeys = new TreeMap<String, KeyQueryResponseMessage>();
        for (Map.Entry<String, String> e : cfg.getSection("threshold-pubkeys").entrySet()) {
            String alias = e.getKey();
            if (!this.authorities.containsKey((Object)alias)) {
                throw new InvalidBallotException(String.format("Alias '%s' has threshold pubkey, but alias does not belong to any authority.", alias));
            }
            Optional<String> optSig = cfg.getValueString("threshold-pubkey-sigs", alias);
            if (!optSig.isPresent()) {
                throw new InvalidBallotException(String.format("no signature present for threshold pubkey from authority '%s'", alias));
            }
            KeyQueryResponseMessage m = new KeyQueryResponseMessage();
            m.signature = EddsaSignature.fromString((String)optSig.get());
            m.signedGuidKey = new KeyQueryResponseMessage.BallotPublicKey();
            m.signedGuidKey.ballotGuid = this.getBallotGuid();
            m.signedGuidKey.publicKey = ThresholdPublicKey.fromString(e.getValue());
            this.thresholdPublicKeys.put(alias, m);
        }
        if (cfg.haveValue("generators", "g0")) {
            this.generators = new BigInteger[this.choices.size()];
            for (int i = 0; i < this.choices.size(); ++i) {
                Optional<String> optG = cfg.getValueString("generators", "g" + i);
                if (!optG.isPresent()) {
                    throw new InvalidBallotException(String.format("Generator %s is missing.  Please issue the ballot correctlly", i));
                }
                this.generators[i] = new BigInteger((String)optG.get(), 16);
            }
        }
    }

    public HashCode getBallotGuid() {
        MessageDigest digest;
        if (this.issuerPub == null) {
            throw new InvalidBallotException("can't compute GUID of a ballot without issuer");
        }
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("crypto algorithm required but not provided");
        }
        digest.update(this.topic.getBytes());
        for (String choice : this.choices) {
            digest.update(choice.getBytes());
        }
        for (Map.Entry x : this.authorities.entrySet()) {
            digest.update(((String)x.getKey()).getBytes());
            digest.update(((PeerIdentity)x.getValue()).data);
        }
        digest.update(this.issuerPub.y);
        digest.update(this.caPub.y);
        digest.update(Longs.toByteArray((long)this.keygenStartTime.getSeconds()));
        digest.update(Longs.toByteArray((long)this.keygenEndTime.getSeconds()));
        digest.update(Longs.toByteArray((long)this.startTime.getSeconds()));
        digest.update(Longs.toByteArray((long)this.endTime.getSeconds()));
        digest.update(Longs.toByteArray((long)this.closingTime.getSeconds()));
        digest.update(Longs.toByteArray((long)this.queryTime.getSeconds()));
        return HashCode.fromHashCode(digest.digest());
    }

    public ThresholdPublicKey getMajorityThresholdPublicKey() {
        HashMap counts = Maps.newHashMap();
        for (Map.Entry<String, KeyQueryResponseMessage> e : this.thresholdPublicKeys.entrySet()) {
            ThresholdPublicKey pk = e.getValue().signedGuidKey.publicKey;
            if (counts.containsKey(pk)) {
                counts.put(pk, (Integer)counts.get(pk) + 1);
                continue;
            }
            counts.put(pk, 1);
        }
        int maxCount = 0;
        ThresholdPublicKey bestKey = null;
        for (Map.Entry e : counts.entrySet()) {
            if ((Integer)e.getValue() <= maxCount) continue;
            maxCount = (Integer)e.getValue();
            bestKey = (ThresholdPublicKey)e.getKey();
        }
        if (maxCount < this.threshold) {
            return null;
        }
        return bestKey;
    }

    public void encodeChoice(String choice, ThresholdPublicKey thresholdPublicKey, EcdsaPrivateKey voterPrivateKey) {
        if (null == this.generators || this.generators.length != this.choices.size()) {
            throw new InvalidBallotException("Can't encrypt vote without valid generators.");
        }
        int choiceId = -1;
        int i = 0;
        for (String possibleChoice : this.choices) {
            if (choice.equals(possibleChoice)) {
                choiceId = i;
            }
            ++i;
        }
        this.voterPub = voterPrivateKey.getPublicKey();
        this.encryptedVote = EncryptedVote.fromChoice(choiceId, thresholdPublicKey, this.voterPub, this.generators);
        System.out.println("voter encrypted vote, ciphertext: " + this.encryptedVote.v.toString());
        System.out.println("threshold key (of voter): " + thresholdPublicKey.toString());
    }

    public Configuration toConfiguration() {
        Configuration cfg = new Configuration();
        cfg.setValueString("election", "TOPIC", this.topic);
        cfg.setValueString("election", "GROUP", this.group);
        cfg.setValueString("election", "CHOICES", Joiner.on((String)"//").join(this.choices));
        cfg.setValueString("election", "CA_PUB", this.caPub.toString());
        cfg.setValueNumber("election", "THRESHOLD", this.threshold);
        cfg.setValueNumber("election", "TIMESTAMP_KEYGEN_START", this.keygenStartTime.getSeconds());
        cfg.setValueNumber("election", "TIMESTAMP_KEYGEN_END", this.keygenEndTime.getSeconds());
        cfg.setValueNumber("election", "TIMESTAMP_START", this.startTime.getSeconds());
        cfg.setValueNumber("election", "TIMESTAMP_CLOSING", this.closingTime.getSeconds());
        cfg.setValueNumber("election", "TIMESTAMP_QUERY", this.queryTime.getSeconds());
        cfg.setValueNumber("election", "TIMESTAMP_CONCLUDE", this.concludeTime.getSeconds());
        cfg.setValueNumber("election", "TIMESTAMP_END", this.endTime.getSeconds());
        for (Map.Entry entry : this.authorities.entrySet()) {
            cfg.setValueString("authorities", (String)entry.getKey(), ((PeerIdentity)entry.getValue()).toString());
        }
        if (null != this.registrationSigs) {
            for (Map.Entry entry : this.registrationSigs.entrySet()) {
                cfg.setValueString("registration-signatures", (String)entry.getKey(), ((EddsaSignature)entry.getValue()).toString());
            }
        }
        if (null != this.confirmationSigs) {
            for (Map.Entry entry : this.confirmationSigs.entrySet()) {
                cfg.setValueString("vouchers", (String)entry.getKey(), ((EddsaSignature)entry.getValue()).toString());
            }
        }
        if (null != this.issuerPub) {
            cfg.setValueString("election", "ISSUER_PUB", this.issuerPub.toString());
            cfg.setValueString("election", "ISSUER_SIG", this.issuerSig.toString());
        }
        if (null != this.encryptedVote) {
            this.encryptedVote.writeToConfiguration(cfg);
        }
        if (null != this.voterPub) {
            cfg.setValueString("vote", "VOTER_PUB", this.voterPub.toString());
        }
        if (null != this.groupCert) {
            this.groupCert.writeBallotConfig(cfg);
        }
        for (Map.Entry entry : this.thresholdPublicKeys.entrySet()) {
            cfg.setValueString("threshold-pubkeys", (String)entry.getKey(), ((KeyQueryResponseMessage)entry.getValue()).signedGuidKey.publicKey.toString());
            cfg.setValueString("threshold-pubkey-sigs", (String)entry.getKey(), ((KeyQueryResponseMessage)entry.getValue()).signature.toString());
        }
        if (this.generators != null) {
            for (int i = 0; i < this.generators.length; ++i) {
                cfg.setValueString("generators", "g" + i, this.generators[i].toString(16));
            }
        }
        return cfg;
    }

    public String serialize() {
        return this.toConfiguration().serialize();
    }

    public String describe() {
        StringBuilder buf = new StringBuilder();
        buf.append("Topic: ");
        buf.append("'");
        buf.append(this.topic);
        buf.append("'\n");
        buf.append("Voter Group: ");
        buf.append(this.group);
        buf.append("\n");
        buf.append("Threshold: ");
        buf.append(this.threshold);
        buf.append("\n");
        buf.append("Start Time: ");
        buf.append(this.startTime.toFancyString());
        buf.append("\n");
        buf.append("Closing Time: ");
        buf.append(this.closingTime.toFancyString());
        buf.append("\n");
        buf.append("Conclude Time: ");
        buf.append(this.concludeTime.toFancyString());
        buf.append("\n");
        buf.append("Query Time: ");
        buf.append(this.queryTime.toFancyString());
        buf.append("\n");
        buf.append("End Time: ");
        buf.append(this.endTime.toFancyString());
        buf.append("\n");
        buf.append("Choices:\n");
        for (int i = 0; i < this.choices.size(); ++i) {
            buf.append(i + 1);
            buf.append(". '");
            buf.append(this.choices.get(i));
            buf.append("'\n");
        }
        buf.append("Authorities:\n");
        for (Map.Entry entry : this.authorities.entrySet()) {
            buf.append("'");
            buf.append((String)entry.getKey());
            buf.append("', ");
            buf.append(((PeerIdentity)entry.getValue()).toString());
            buf.append("\n");
        }
        if (this.issuerPub == null) {
            buf.append("issue status: not issued\n");
        } else {
            buf.append("issue status: issued, GUID ");
            buf.append(this.getBallotGuid().toString());
            buf.append("\n");
        }
        if (!this.registrationSigs.isEmpty()) {
            buf.append("ballot is registered with the following authorities:\n");
            for (Map.Entry entry : this.registrationSigs.entrySet()) {
                buf.append((String)entry.getKey());
                buf.append(" ");
            }
            buf.append("\n");
        } else {
            buf.append("ballot not registered");
        }
        if (!this.confirmationSigs.isEmpty()) {
            buf.append("ballot's vote has been submitted to with the following authorities:\n");
            for (Map.Entry entry : this.confirmationSigs.entrySet()) {
                buf.append((String)entry.getKey());
                buf.append(" ");
            }
            buf.append("\n");
        } else {
            buf.append("ballot not submitted\n");
        }
        if (this.encryptedVote != null) {
            buf.append("choice selected\n");
        } else {
            buf.append("no choice selected\n");
        }
        if (this.voterPub != null) {
            buf.append("voter: ");
            buf.append(this.voterPub.toString());
            buf.append("\n");
            if (this.groupCert == null) {
                buf.append("voter not in group\n");
            } else {
                buf.append("voter in group\n");
            }
        } else {
            buf.append("no voter\n");
        }
        if (this.thresholdPublicKeys != null && this.thresholdPublicKeys.size() != 0) {
            buf.append("Authorities with threshold public key:\n");
            for (String string : this.thresholdPublicKeys.keySet()) {
                buf.append(string);
                buf.append("\n");
            }
        } else {
            buf.append("no threshold public keys");
        }
        return buf.toString();
    }

    public List<PeerIdentity> getRemainingSubmitAuthorities() {
        LinkedList<PeerIdentity> remaining = new LinkedList<PeerIdentity>();
        for (Map.Entry x : this.authorities.entrySet()) {
            if (this.confirmationSigs.containsKey(x.getKey())) continue;
            remaining.add((PeerIdentity)x.getValue());
        }
        return remaining;
    }

    public List<PeerIdentity> getRemainingRegisterAuthorities() {
        LinkedList<PeerIdentity> remaining = new LinkedList<PeerIdentity>();
        for (Map.Entry x : this.authorities.entrySet()) {
            if (this.registrationSigs.containsKey(x.getKey())) continue;
            remaining.add((PeerIdentity)x.getValue());
        }
        return remaining;
    }

    public void issue(EcdsaPrivateKey privateKey) {
        this.generators = new BigInteger[this.choices.size()];
        for (int i = 0; i < this.choices.size(); ++i) {
            this.generators[i] = VotingParameters.selectSubgroupGenerator(Parameters.elgamalP, Parameters.elgamalQ);
        }
        this.issuerPub = privateKey.getPublicKey();
        this.issuerSig = privateKey.sign(this.getBallotGuid().data, 0);
    }

    public void addRegistrationSignature(PeerIdentity currentAuthority, EddsaSignature registrationSignature) {
        String alias = (String)this.authorities.inverse().get((Object)currentAuthority);
        this.registrationSigs.put(alias, registrationSignature);
    }

    public void addConfirmation(PeerIdentity currentAuthority, EddsaSignature confirmationSignature) {
        String alias = (String)this.authorities.inverse().get((Object)currentAuthority);
        this.confirmationSigs.put(alias, confirmationSignature);
    }

    public List<PeerIdentity> getAuthorities() {
        return new ArrayList<PeerIdentity>(this.authorities.values());
    }

    public void encodeGroup(GroupCert groupCert) {
        Preconditions.checkNotNull((Object)groupCert);
        if (this.groupCert != null) {
            throw new InvalidBallotException("ballot already has group information");
        }
        this.voterPub = groupCert.getMemberPublicKey();
        this.groupCert = groupCert;
    }

    public List<PeerIdentity> getRemainingKeyAuthorities() {
        LinkedList<PeerIdentity> remaining = new LinkedList<PeerIdentity>();
        for (Map.Entry x : this.authorities.entrySet()) {
            if (this.thresholdPublicKeys.containsKey(x.getKey())) continue;
            remaining.add((PeerIdentity)x.getValue());
        }
        return remaining;
    }

    public void addThresholdPublicKey(PeerIdentity currentAuthority, KeyQueryResponseMessage m) {
        String alias = (String)this.authorities.inverse().get((Object)currentAuthority);
        this.thresholdPublicKeys.put(alias, m);
    }
}

