/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.Type;
import gnu.expr.Declaration;
import gnu.expr.Keyword;
import gnu.expr.LambdaExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.lists.LList;
import gnu.mapping.CallContext;
import gnu.mapping.Location;
import gnu.mapping.MethodProc;
import java.lang.reflect.Array;

class Closure
extends MethodProc {
    Object[][] evalFrames;
    LambdaExp lambda;

    public int numArgs() {
        return this.lambda.min_args | this.lambda.max_args << 12;
    }

    public Closure(LambdaExp lambdaExp, CallContext callContext) {
        this.lambda = lambdaExp;
        Object[][] objectArray = callContext.evalFrames;
        if (objectArray != null) {
            int n;
            for (n = objectArray.length; n > 0 && objectArray[n - 1] == null; --n) {
            }
            this.evalFrames = new Object[n][];
            System.arraycopy(objectArray, 0, this.evalFrames, 0, n);
        }
        this.setSymbol(this.lambda.getSymbol());
    }

    public int match0(CallContext callContext) {
        return this.matchN(new Object[0], callContext);
    }

    public int match1(Object object2, CallContext callContext) {
        return this.matchN(new Object[]{object2}, callContext);
    }

    public int match2(Object object2, Object object3, CallContext callContext) {
        return this.matchN(new Object[]{object2, object3}, callContext);
    }

    public int match3(Object object2, Object object3, Object object4, CallContext callContext) {
        return this.matchN(new Object[]{object2, object3, object4}, callContext);
    }

    public int match4(Object object2, Object object3, Object object4, Object object5, CallContext callContext) {
        return this.matchN(new Object[]{object2, object3, object4, object5}, callContext);
    }

    public int matchN(Object[] objectArray, CallContext callContext) {
        int n = objectArray.length;
        int n2 = this.numArgs();
        int n3 = n2 & 0xFFF;
        if (n < n3) {
            return 0xFFF10000 | n3;
        }
        int n4 = n2 >> 12;
        if (n > n4 && n4 >= 0) {
            return 0xFFF20000 | n4;
        }
        Object[] objectArray2 = new Object[this.lambda.frameSize];
        int n5 = this.lambda.keywords == null ? 0 : this.lambda.keywords.length;
        int n6 = this.lambda.defaultArgs == null ? 0 : this.lambda.defaultArgs.length - n5;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = this.lambda.min_args;
        for (Declaration declaration = this.lambda.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            Object object2;
            if (n7 < n10) {
                object2 = objectArray[n7++];
            } else if (n7 < n10 + n6) {
                object2 = n7 < n ? objectArray[n7++] : this.lambda.evalDefaultArg(n8, callContext);
                ++n8;
            } else if (this.lambda.max_args < 0 && n7 == n10 + n6) {
                if (declaration.type instanceof ArrayType) {
                    Object object3;
                    int n11 = n - n7;
                    Type type = ((ArrayType)declaration.type).getComponentType();
                    if (type == Type.objectType) {
                        object3 = new Object[n11];
                        System.arraycopy(objectArray, n7, object3, 0, n11);
                        object2 = object3;
                    } else {
                        object3 = type.getReflectClass();
                        object2 = Array.newInstance(object3, n11);
                        for (int i = 0; i < n11; ++i) {
                            Object object4;
                            try {
                                object4 = type.coerceFromObject(objectArray[n7 + i]);
                            }
                            catch (ClassCastException classCastException) {
                                return 0xFFF40000 | n7 + i;
                            }
                            Array.set(object2, i, object4);
                        }
                    }
                } else {
                    object2 = LList.makeList(objectArray, n7);
                }
            } else {
                Keyword keyword;
                int n12 = n10 + n6;
                if ((object2 = Keyword.searchForKeyword(objectArray, n12, keyword = this.lambda.keywords[n9++])) == Special.dfault) {
                    object2 = this.lambda.evalDefaultArg(n8, callContext);
                }
                ++n8;
            }
            if (declaration.type != null) {
                try {
                    object2 = declaration.type.coerceFromObject(object2);
                }
                catch (ClassCastException classCastException) {
                    return 0xFFF40000 | n7;
                }
            }
            if (declaration.isIndirectBinding()) {
                Location location2 = declaration.makeIndirectLocationFor();
                location2.set(object2);
                object2 = location2;
            }
            objectArray2[declaration.evalIndex] = object2;
        }
        callContext.values = objectArray2;
        callContext.where = 0;
        callContext.next = 0;
        callContext.proc = this;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(CallContext callContext) throws Throwable {
        int n;
        int n2 = ScopeExp.nesting(this.lambda);
        Object[] objectArray = callContext.values;
        Object[][] objectArray2 = callContext.evalFrames;
        int n3 = n = this.evalFrames == null ? 0 : this.evalFrames.length;
        if (n2 >= n) {
            n = n2;
        }
        Object[][] objectArrayArray = new Object[n += 10][];
        if (this.evalFrames != null) {
            System.arraycopy(this.evalFrames, 0, objectArrayArray, 0, this.evalFrames.length);
        }
        objectArrayArray[n2] = objectArray;
        callContext.evalFrames = objectArrayArray;
        try {
            if (this.lambda.body == null) {
                StringBuffer stringBuffer = new StringBuffer("procedure ");
                String string = this.lambda.getName();
                if (string == null) {
                    string = "<anonymous>";
                }
                stringBuffer.append(string);
                int n4 = this.lambda.getLineNumber();
                if (n4 > 0) {
                    stringBuffer.append(" at line ");
                    stringBuffer.append(n4);
                }
                stringBuffer.append(" was called before it was expanded");
                throw new RuntimeException(stringBuffer.toString());
            }
            this.lambda.body.apply(callContext);
        }
        finally {
            callContext.evalFrames = objectArray2;
        }
    }

    public Object getProperty(Object object2, Object object3) {
        Object object4 = super.getProperty(object2, object3);
        if (object4 == null) {
            object4 = this.lambda.getProperty(object2, object3);
        }
        return object4;
    }
}

