/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.mapping.ProcedureN;
import gnu.math.IntNum;

public abstract class ArithOp
extends ProcedureN
implements CanInline,
Inlineable {
    public ArithOp(String string) {
        super(string);
    }

    public Object defaultResult() {
        return IntNum.zero();
    }

    public abstract int primitiveOpcode();

    public static int classify(Type type) {
        boolean bl = false;
        if (type instanceof PrimType) {
            char c = type.getSignature().charAt(0);
            if (c == 'V' || c == 'Z' || c == 'C') {
                return 0;
            }
            if (c == 'D' || c == 'F') {
                return 3;
            }
            return 4;
        }
        if (type.isSubtype(Arithmetic.typeIntNum)) {
            return 4;
        }
        if (type.isSubtype(Arithmetic.typeDFloNum)) {
            return 3;
        }
        if (type.isSubtype(Arithmetic.typeRealNum)) {
            return 2;
        }
        if (type.isSubtype(Arithmetic.typeNumeric)) {
            return 1;
        }
        return 0;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Type type;
        Expression[] expressionArray = applyExp.getArgs();
        int n = expressionArray.length;
        if (n == 0) {
            compilation.compileConstant(this.defaultResult(), target);
            return;
        }
        if (n == 1 || target instanceof IgnoreTarget) {
            ApplyExp.compile(applyExp, compilation, target);
            return;
        }
        Type type2 = this.getReturnType(expressionArray);
        int n2 = Arithmetic.classifyType(type2);
        if (n2 == 0) {
            ApplyExp.compile(applyExp, compilation, target);
            return;
        }
        Type type3 = target.getType();
        int n3 = Arithmetic.classifyType(type3);
        if ((n3 == 1 || n3 == 2) && n2 >= 1 && n2 <= 4) {
            n2 = n3;
            type = n3 == 1 ? LangPrimType.intType : LangPrimType.longType;
        } else if ((n3 == 8 || n3 == 7) && n2 > 0 && n2 <= 10) {
            n2 = n3;
            type = n3 == 7 ? LangPrimType.floatType : LangPrimType.doubleType;
        } else if (n2 == 7) {
            type = LangPrimType.floatType;
        } else if (n2 == 8 || n2 == 9) {
            n2 = 8;
            type = LangPrimType.doubleType;
        } else {
            type = type2;
        }
        if (n2 != 1 && n2 != 2 && n2 != 7 && n2 != 8) {
            ApplyExp.compile(applyExp, compilation, target);
            return;
        }
        Target target2 = StackTarget.getInstance(type);
        CodeAttr codeAttr = compilation.getCode();
        for (int i = 0; i < n; ++i) {
            expressionArray[i].compile(compilation, target2);
            if (i == 0) continue;
            switch (n2) {
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    codeAttr.emitBinop(this.primitiveOpcode(), type);
                }
            }
        }
        target.compileFromStack(compilation, type);
    }

    public Type getReturnType(Expression[] expressionArray) {
        int n = expressionArray.length;
        if (n == 0) {
            return Arithmetic.typeIntNum;
        }
        ClassType classType = Type.pointer_type;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Expression expression = expressionArray[i];
            int n3 = Arithmetic.classifyType(expression.getType());
            if (i != 0 && n3 != 0 && n3 <= n2) continue;
            n2 = n3;
        }
        return Arithmetic.kindType(n2);
    }
}

