/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Dimensions;
import gnu.math.Unit;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

class MulUnit
extends Unit
implements Externalizable {
    Unit unit1;
    Unit unit2;
    int power1;
    int power2;
    MulUnit next;

    MulUnit(Unit unit, int n, Unit unit2, int n2) {
        this.unit1 = unit;
        this.unit2 = unit2;
        this.power1 = n;
        this.power2 = n2;
        this.dims = Dimensions.product(unit.dims, n, unit2.dims, n2);
        this.factor = n == 1 ? unit.factor : Math.pow(unit.factor, n);
        if (n2 < 0) {
            int n3 = -n2;
            while (--n3 >= 0) {
                this.factor /= unit2.factor;
            }
        } else {
            int n4 = n2;
            while (--n4 >= 0) {
                this.factor *= unit2.factor;
            }
        }
        this.next = unit.products;
        unit.products = this;
    }

    MulUnit(Unit unit, Unit unit2, int n) {
        this(unit, 1, unit2, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append(this.unit1);
        if (this.power1 != 1) {
            stringBuffer.append('^');
            stringBuffer.append(this.power1);
        }
        if (this.power2 != 0) {
            stringBuffer.append('*');
            stringBuffer.append(this.unit2);
            if (this.power2 != 1) {
                stringBuffer.append('^');
                stringBuffer.append(this.power2);
            }
        }
        return stringBuffer.toString();
    }

    public Unit sqrt() {
        if ((this.power1 & 1) == 0 && (this.power2 & 1) == 0) {
            return MulUnit.times(this.unit1, this.power1 >> 1, this.unit2, this.power2 >> 1);
        }
        return super.sqrt();
    }

    static MulUnit lookup(Unit unit, int n, Unit unit2, int n2) {
        MulUnit mulUnit = unit.products;
        while (mulUnit != null) {
            if (mulUnit.unit1 == unit && mulUnit.unit2 == unit2 && mulUnit.power1 == n && mulUnit.power2 == n2) {
                return mulUnit;
            }
            mulUnit = mulUnit.next;
        }
        return null;
    }

    public static MulUnit make(Unit unit, int n, Unit unit2, int n2) {
        MulUnit mulUnit = MulUnit.lookup(unit, n, unit2, n2);
        if (mulUnit != null) {
            return mulUnit;
        }
        return new MulUnit(unit, n, unit2, n2);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.unit1);
        objectOutput.writeInt(this.power1);
        objectOutput.writeObject(this.unit2);
        objectOutput.writeInt(this.power2);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.unit1 = (Unit)objectInput.readObject();
        this.power1 = objectInput.readInt();
        this.unit2 = (Unit)objectInput.readObject();
        this.power2 = objectInput.readInt();
    }

    public Object readResolve() throws ObjectStreamException {
        MulUnit mulUnit = MulUnit.lookup(this.unit1, this.power1, this.unit2, this.power2);
        if (mulUnit != null) {
            return mulUnit;
        }
        return this;
    }
}

