/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpExpVisitor;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.LangExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.Special;
import gnu.kawa.functions.Convert;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.lispexpr.SeqSizeType;
import gnu.kawa.reflect.MappedArrayType;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Procedure;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import gnu.text.Char;
import kawa.lang.SyntaxForm;
import kawa.lang.SyntaxPattern;
import kawa.lang.SyntaxRule;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;
import kawa.standard.Scheme;

public class BindDecls {
    public static final BindDecls instance = new BindDecls();
    public boolean allowShadowing = false;
    public boolean makeConstant = true;
    public Object ifKeyword = Special.ifk;
    public Procedure compareEquals = Scheme.isEqual;
    public Type booleanType = Scheme.booleanType;
    static final Symbol underScoreSymbol = Symbol.valueOf("_");

    public Declaration define(Symbol name, TemplateScope templateScope, ScopeExp scope, Translator comp) {
        Declaration oldDecl = comp.lexical.lookup((Object)name, false);
        Declaration decl = comp.define((Object)name, templateScope, scope);
        if (!this.allowShadowing && oldDecl != null && oldDecl.context != scope && !(oldDecl.context instanceof ModuleExp)) {
            comp.error('w', decl, "new declaration '", "' shadows old declaration");
            comp.error('w', oldDecl, "(this is the previous declaration of '", "')");
        }
        return decl;
    }

    public Object parsePatternNext(Pair patList, Translator comp) {
        Pair nextPair;
        Object next = patList.getCdr();
        if (next instanceof Pair && comp.matches((nextPair = (Pair)next).getCar(), "::")) {
            Object nextCdr = nextPair.getCdr();
            next = nextCdr instanceof Pair ? ((Pair)nextCdr).getCdr() : nextCdr;
        }
        return next;
    }

    public Object[] parsePatternCar(Pair patList, int scanNesting, ScopeExp scope, Translator comp) {
        return this.parsePatternCar(patList, null, null, scanNesting, scope, comp);
    }

    public Object[] parsePatternCar(Pair patList, Expression init, TemplateScope templateScope, int scanNesting, ScopeExp scope, Translator comp) {
        Pair nextPair;
        Object next = patList.getCdr();
        Type type = null;
        if (next instanceof Pair && comp.matches((nextPair = (Pair)next).getCar(), "::")) {
            Object nextCdr = nextPair.getCdr();
            if (nextCdr instanceof Pair) {
                Pair nextCdrPair = (Pair)nextCdr;
                type = comp.exp2Type(nextCdrPair);
                next = nextCdrPair.getCdr();
            } else {
                Object saveLoc = comp.pushPositionOf(nextPair);
                comp.error('e', "missing type after '::'");
                comp.popPositionOf(saveLoc);
                next = nextCdr;
            }
        }
        Object pattern = patList.getCar();
        Object saveLoc = comp.pushPositionOf(patList);
        Object patval = pattern;
        while (patval instanceof SyntaxForm) {
            SyntaxForm patSyntax = (SyntaxForm)patval;
            templateScope = patSyntax.getScope();
            patval = patSyntax.getDatum();
        }
        patval = comp.namespaceResolve(patval);
        Declaration decl = null;
        QuoteExp literal = this.literalPattern(patval, comp);
        if (literal != null) {
            decl = scope.addDeclaration((Object)null);
            this.addCondition(scope, this.compareLiteral(decl, literal));
        } else if (patval instanceof Symbol) {
            if (patval == underScoreSymbol) {
                decl = scope.addDeclaration((Object)null);
            } else {
                decl = this.define((Symbol)patval, templateScope, scope, comp);
                Translator.setLine(decl, (Object)patList);
            }
            if (init != null) {
                BindDecls.setInitializer(decl, init, scope, comp);
            }
            if (scope instanceof ModuleExp && (patval == underScoreSymbol || !scope.getFlag(0x2000000) && !comp.sharedModuleDefs())) {
                decl.setPrivate(true);
            }
            if (this.makeConstant) {
                decl.setFlag(16384L);
            }
            decl.setFlag(262144L);
        } else if (patval == this.ifKeyword) {
            if (next instanceof Pair) {
                Pair nextPair2 = (Pair)next;
                decl = this.addCondition(scope, nextPair2.getCar());
                next = nextPair2.getCdr();
            } else {
                comp.error('e', "missing expression after " + this.ifKeyword);
            }
        } else if (pattern instanceof Pair) {
            Pair patpair = (Pair)pattern;
            Object patcar = patpair.getCar();
            if (patcar == LispLanguage.bracket_list_sym) {
                decl = scope.addDeclaration((Object)null);
                if (init != null) {
                    BindDecls.setInitializer(decl, init, scope, comp);
                }
                if (type != null) {
                    // empty if block
                }
                decl.setPrivate(true);
                decl.setFlag(0x20000044000L);
                this.parseBracketListPattern(patpair, scanNesting, scope, decl, comp);
            } else if (patcar == LispLanguage.splice_sym || patcar == LispLanguage.splice_colon_sym) {
                Object patcdr = patpair.getCdr();
                if (Translator.listLength(patcdr) != 1) {
                    comp.syntaxError("bad syntax for splice pattern cdr:" + patcdr);
                } else {
                    boolean keywordsOk;
                    Object[] r = this.parsePatternCar((Pair)patcdr, null, templateScope, scanNesting, scope, comp);
                    decl = (Declaration)r[1];
                    decl.setFlag(0x40000000000L);
                    boolean bl = keywordsOk = patcar == LispLanguage.splice_colon_sym;
                    if (keywordsOk) {
                        decl.setFlag(0x200000000000L);
                        if (scope instanceof LambdaExp) {
                            scope.setFlag(32768);
                        }
                    }
                    if (!decl.getFlag(8192L)) {
                        decl.setType(keywordsOk ? LangObjType.argVectorType : ArrayType.make(Type.objectType));
                    }
                }
            } else {
                comp.syntaxError("unrecognized pattern operator " + patcar);
            }
        } else {
            comp.error('e', "unrecognized pattern " + pattern);
        }
        if (decl != null) {
            decl.setScanNesting(scanNesting);
            if (type != null) {
                decl.setType(MappedArrayType.maybe(type, scanNesting));
                decl.setFlag(8192L);
            }
        }
        comp.popPositionOf(saveLoc);
        return new Object[]{next, decl};
    }

    public void parseBracketListPattern(Pair patpair, int scanNesting, ScopeExp scope, Declaration decl, Translator comp) {
        ClassType listType = ClassType.make("java.util.List");
        decl.setFlag(0x20000000000L);
        if (decl.getTypeExpRaw() != null) {
            Declaration d = scope.addDeclaration((Object)null);
            d.setFlag(0x30000000000L);
            d.setScanNesting(scanNesting);
            BindDecls.setInitializer(d, new ReferenceExp(decl), scope, comp);
            decl = d;
        }
        int count = 0;
        Object cdr = patpair.getCdr();
        int ellipsisCount = 0;
        int spliceCount = 0;
        while (cdr != LList.Empty && cdr instanceof Pair) {
            Expression init;
            Object nextCaar;
            Object curCar;
            SimpleSymbol ellipsis;
            Object nextCar;
            patpair = (Pair)cdr;
            boolean sawEllipsis = false;
            boolean sawSplice = false;
            int curScanNesting = scanNesting;
            cdr = this.parsePatternNext(patpair, comp);
            if (cdr instanceof Pair && SyntaxPattern.literalIdentifierEq(nextCar = ((Pair)cdr).getCar(), null, ellipsis = SyntaxRule.dots3Symbol, null)) {
                sawEllipsis = true;
                ++curScanNesting;
                ++ellipsisCount;
                cdr = ((Pair)cdr).getCdr();
            }
            if (Translator.listLength(curCar = patpair.getCar()) == 2 && ((nextCaar = ((Pair)curCar).getCar()) == LispLanguage.splice_sym || nextCaar == LispLanguage.splice_colon_sym)) {
                sawSplice = true;
                ++spliceCount;
                patpair = (Pair)((Pair)curCar).getCdr();
            }
            if (sawEllipsis || sawSplice) {
                int restCount = Translator.listLength(cdr);
                Method dropMethod = ClassType.make("gnu.lists.Sequences").getDeclaredMethod("drop", restCount == 0 ? 2 : 3);
                Expression[] args = new Expression[restCount == 0 ? 2 : 3];
                args[0] = new ReferenceExp(decl);
                args[1] = new QuoteExp(count, Type.intType);
                if (restCount != 0) {
                    args[2] = new QuoteExp(restCount, Type.intType);
                }
                init = new ApplyExp(dropMethod, args);
            } else {
                Method indexMethod;
                int index;
                if (ellipsisCount + spliceCount > 0) {
                    index = -1 - Translator.listLength(cdr);
                    indexMethod = ConsumerTarget.typeSequences.getDeclaredMethod("getAt", 2);
                } else {
                    index = count;
                    indexMethod = listType.getMethod("get", new Type[]{Type.intType});
                }
                init = new ApplyExp(indexMethod, new ReferenceExp(decl), new QuoteExp(index, Type.intType));
            }
            if (scanNesting > 0) {
                init = BindDecls.mapInit(init, decl);
            }
            Object[] r = this.parsePatternCar(patpair, init, null, curScanNesting, scope, comp);
            Declaration d = (Declaration)r[1];
            d.setScanNesting(curScanNesting);
            d.setFlag(0x10000000000L);
            if (sawEllipsis) {
                d.setFlag(0x800000000000L);
            }
            ++count;
        }
        if (ellipsisCount + spliceCount > 1) {
            comp.error('e', "more than one '...' or '@' in a pattern not supported");
        }
        SeqSizeType seqType = new SeqSizeType(count - ellipsisCount - spliceCount, ellipsisCount + spliceCount == 0);
        decl.setType(MappedArrayType.maybe(seqType, scanNesting));
    }

    public static void setInitializer(Declaration decl, Expression init, ScopeExp scope, Translator comp) {
        if (scope instanceof ModuleExp || scope instanceof LetExp && scope.getFlag(2)) {
            SetExp sexp = new SetExp(decl, init);
            comp.pushForm(sexp);
            decl.noteValueFromSet(sexp);
        } else {
            decl.setInitValue(init);
            decl.noteValueFromLet(scope);
        }
    }

    static Expression mapInit(Expression init, Declaration decl) {
        LambdaExp lambda = new LambdaExp();
        Declaration param = lambda.addParameter(null);
        ReplaceDecl v = new ReplaceDecl();
        v.oldDecl = decl;
        v.newDecl = param;
        v.visit(init, null);
        lambda.body = init;
        return new ApplyExp(Scheme.map, lambda, new ReferenceExp(decl));
    }

    Declaration addCondition(ScopeExp scope, Object condition2) {
        Declaration decl = scope.addDeclaration((Object)null);
        Expression cond = condition2 instanceof Expression ? Compilation.makeCoercion((Expression)condition2, this.booleanType) : new LangExp(LList.list3(new QuoteExp(Convert.cast), new QuoteExp(this.booleanType), condition2));
        decl.setInitValue(cond);
        decl.setFlag(0x30000000000L);
        decl.setType(QuoteExp.isTrueTypeExp, LangPrimType.isTrueType);
        return decl;
    }

    public QuoteExp literalPattern(Object patval, Translator comp) {
        if (patval instanceof Number || patval == null || patval instanceof Character || patval instanceof Char || patval instanceof Boolean || patval instanceof CharSequence) {
            return QuoteExp.getInstance(patval);
        }
        if (patval instanceof Pair) {
            Pair p2;
            Pair p1 = (Pair)patval;
            Object p1cdr = p1.getCdr();
            if (comp.matches(p1.getCar(), "quote") && p1cdr instanceof Pair && (p2 = (Pair)p1cdr).getCdr() == LList.Empty) {
                return QuoteExp.getInstance(p2.getCar());
            }
        }
        return null;
    }

    public Expression compareLiteral(Declaration param, QuoteExp literal) {
        return new ApplyExp(this.compareEquals, new ReferenceExp(param), literal);
    }

    static class ReplaceDecl
    extends ExpExpVisitor<Void> {
        Declaration oldDecl;
        Declaration newDecl;

        ReplaceDecl() {
        }

        @Override
        protected Expression visitReferenceExp(ReferenceExp exp, Void ignored) {
            if (exp.getBinding() == this.oldDecl) {
                exp.setBinding(this.newDecl);
            }
            return exp;
        }
    }
}

