/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "Board.h"
#include "BoardException.h"
#include <sstream>
#include <time.h>
Board::Board(int xSize,int ySize):xSize_(xSize),ySize_(ySize),
	warped_(0), players_(0), active_players_(0), remaining_players_(0), turn_(0) , n_att_(0),actualPlayer_(NULL),
	nbCoupperTurnAttack_(6),
	nbCoutRestant_(0),actualAction_(NOTCHOOSE),
	nbCoupperTurnDefend_(3),
	nbCoupperTurnGuerilla_(1),winner_(NULL)
{
	case_=new Case[xSize*ySize];
	isPlayerChoosedByHazard=false;
}

Board::Board(int xSize,int ySize,int warped,int players,int active_players,int remaining_players,int turn ,int n_att)
	:xSize_(xSize),ySize_(ySize),actualPlayer_(NULL),
	warped_(warped), players_(players), active_players_(active_players), remaining_players_(remaining_players), turn_(turn) , n_att_(n_att),
	nbCoupperTurnAttack_(6),
	nbCoutRestant_(0),actualAction_(NOTCHOOSE),
	nbCoupperTurnDefend_(3),
	nbCoupperTurnGuerilla_(1),winner_(NULL)
{
	case_=new Case[xSize*ySize];
	isPlayerChoosedByHazard=false;
}

Board::~Board(void)
{
}
/*
Case &Board::getCase(int x, int y){
	if ((x+y*xSize_)<0 || (x+y*xSize_) >xSize_*ySize_||x<0||y<0||x>=xSize_||y>=ySize_)
	{
		throw BoardException("bad coordinate , verify x or y");
	}
	return case_[x+y*xSize_];
}*/
Case *Board::getCaseNoThrow(int x, int y){
	if ((x+y*xSize_)<0 || (x+y*xSize_) >xSize_*ySize_||x<0||y<0||x>=xSize_||y>=ySize_)
	{
		return NULL;
	}
	return &case_[x+y*xSize_];
}

void Board::setCase(int x, int y, Case pcase) {
	if ((x+y*xSize_)<0 || (x+y*xSize_) >xSize_*ySize_)
	{
		throw BoardException("bad coordinate , verify x or y");
	}
	case_[x+y*xSize_]=pcase;
}

std::string Board::toString(){
	int ix=0;
	int iy=0;
	
	std::stringstream retValue;
	for (ix=0;ix<xSize_;ix++)
	for (iy=0;iy<ySize_;iy++)
	{

		retValue<<":["<<ix<<","<<iy<<"]"<<case_[ix+iy*xSize_].toString()<<std::endl;
	}
	return retValue.str();
}

int Board::getWidth(){
	return xSize_;
}

int Board::getHeight(){
	return ySize_;
}

Player *Board::getOrCreatePlayerByName(std::string name){
	if (playerMap_[name]==NULL)
	{
		playerMap_[name]=new Player(name);
	}
	return playerMap_[name];
}

Player *Board::getActualPlayer(){
	return actualPlayer_;
}

void Board::setActualPlayer(Player *act){
	actualPlayer_=act;
}

void Board::setFirstPlayerAsActualPlayer(){
	if (!isPlayerChoosedByHazard)
	{
		if (playerMap_.size()!=0)
		{
			 int index=0;
			 actualPlayer_=playerMap_.begin()->second;
		}
	}
	else
	{
			setHazardPlayerAsActualPlayer();
	}
}
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <cstdlib>
#include <cstring>
void Board::setHazardPlayerAsActualPlayer(){
	if (playerMap_.size()!=0)
	{
		/* initialize random seed: */
		srand ((unsigned int) time(NULL) );
		unsigned int index=(unsigned int)(abs(rand()) % playerMap_.size());
		std::map<std::string,Player*>::iterator el= playerMap_.begin(); 
		unsigned int i=0;
		for (i=0;i<index;i++)
		{
			el++;
		}
		actualPlayer_=el->second;
	}
}
void Board::setPlayerChoosedByHazard(bool plByH){
	isPlayerChoosedByHazard=plByH;
}

void Board::setNbCoutRestant(int  a){nbCoutRestant_=a; }
void Board::setNbCoupperTurnAttack(int a){nbCoupperTurnAttack_=a;}
void Board::setNbCoupperTurnDefend(int a){nbCoupperTurnDefend_=a;}
void Board::setNbCoupperTurnGuerilla(int a){nbCoupperTurnGuerilla_=a;}

int Board::getNbCoutRestant(){return nbCoutRestant_;}
int Board::getNbCoupperTurnAttack(){return nbCoupperTurnAttack_;}
int Board::getNbCoupperTurnDefend(){return nbCoupperTurnDefend_;}
int Board::getNbCoupperTurnGuerilla(){return nbCoupperTurnGuerilla_;}

void Board::decNbCoutRestant(){ nbCoutRestant_--;}
void Board::incNbCoutRestant(){ nbCoutRestant_++;}


void Board::setNextPlayer(){
	std::map<std::string,Player*>::iterator el= playerMap_.find(actualPlayer_->getName());
	int count=0;
	do{
		el++;
		count++;
		if (el==playerMap_.end())
		{
			el=playerMap_.begin();
		}
	}while (el->second->hasLost()&&count<playerMap_.size());
	actualPlayer_=el->second;
}

void Board::setActionMode(ActualActionMode m){
	actualAction_=m;
}

Board::ActualActionMode Board::getActionMode(){
	return actualAction_;
}

Player * Board::getWinner(){
	return winner_;
}


void Board::setWinner(Player * w){
	winner_=w;
}

Player * Board::getPlayer(int i)
{
	std::map<std::string,Player*>::iterator p=playerMap_.begin();
	unsigned int j=0;
	for (j=0;j<playerMap_.size();j++)
	{
		if (i==j) return p->second;
		p++;
	}
	return NULL;
}

int Board::getNbPlayers(){
	return playerMap_.size();

}


std::istream&  operator>> (std::istream& in, Board& per)

{
	int version=0;
	in >> version;
	if (version==1)
	{
		
		in >> per.xSize_;
		in >> per.ySize_;
		in >> per.warped_;
		in >> per.players_;
		in >> per.active_players_;
		in >> per.remaining_players_;
		in >> per.turn_ ; 
		in >> per.n_att_;

		//Manage players
		int nbPlayer=0;
		in >> nbPlayer;
		int i=0;
		for (i=0;i<nbPlayer;i++)
		{
			Player *pl = new Player("");
			in >> *pl;
			per.playerMap_[pl->getName()]=pl;
		}

		//manage actualPlayer
		std::string tempo;
		in >> tempo; 
		std::map<std::string,Player*>::iterator itt=per.playerMap_.find(tempo);
		if (itt!=per.playerMap_.end())
		{
			per.actualPlayer_=itt->second;
		}
		else
			per.actualPlayer_=NULL;
		//Case management
		int nbCase=0;
		in >> nbCase;
		per.case_=new Case[nbCase];
		for (i=0;i<nbCase;i++)
		{
			
			in >> per.case_[i];
			itt=per.playerMap_.find(per.case_[i].playerName_);
			if (itt!=per.playerMap_.end())
			{
				per.case_[i].setPlayer(itt->second);
			}
			else
				per.case_[i].setPlayer(NULL);

			itt=per.playerMap_.find(per.case_[i].previousplayername_);
			if (itt!=per.playerMap_.end())
			{
				per.case_[i].setPreviousPlayer(itt->second);
			}
			else
				per.case_[i].setPreviousPlayer(NULL);
		}
		
		in >> per.isPlayerChoosedByHazard;
		in >> per.nbCoutRestant_;
		in >> per.nbCoupperTurnAttack_;
		in >> per.nbCoupperTurnDefend_;
		in >> per.nbCoupperTurnGuerilla_;
		int act=0;
		in >> act;
		per.actualAction_=(Board::ActualActionMode)act;
		//Winner
		in >> tempo; 
		itt=per.playerMap_.find(tempo);
		if (itt!=per.playerMap_.end())
		{
			per.winner_=itt->second;
		}
		else
			per.winner_=NULL;
	}

	return in;

}

std::ostream&  operator<< (std::ostream& in, Board& per)

{
	int version=0;
	in << 1;
	in << per.xSize_;
	in << per.ySize_;
	in << per.warped_;
	in << per.players_;
	in << per.active_players_;
	in << per.remaining_players_;
	in << per.turn_ ; 
	in << per.n_att_;

	//Player
	std::map<std::string,Player*>::iterator itt=per.playerMap_.begin();
	in <<per.playerMap_.size();
	while (itt!=per.playerMap_.end())
	{
		in << *(itt->second);
		itt++;
	}
	//Actual Player
	std::string empty;
	if (per.actualPlayer_!=NULL)
		in << per.actualPlayer_->getName();
	else
		in << empty;
	//Cases
	in << per.xSize_*per.ySize_;
	int i=0;
	for (i=0;i<per.xSize_*per.ySize_;i++)
	{
		in << per.case_[i];
	}
	in << per.isPlayerChoosedByHazard;
	in << per.nbCoutRestant_;
	in << per.nbCoupperTurnAttack_;
	in << per.nbCoupperTurnDefend_;
	in << per.nbCoupperTurnGuerilla_;
	in << per.actualAction_;
	if (per.winner_!=NULL)
		in << per.winner_->getName();
	else
		in << empty;
	
	

	return in;

}


Serializer&  operator>> (Serializer& in, Board& per)

{
	int version=0;
	in >> version;
	if (version==1)
	{
		
		in >> per.xSize_;
		in >> per.ySize_;
		in >> per.warped_;
		in >> per.players_;
		in >> per.active_players_;
		in >> per.remaining_players_;
		in >> per.turn_ ; 
		in >> per.n_att_;

		//Manage players
		int nbPlayer=0;
		in >> nbPlayer;
		int i=0;
		for (i=0;i<nbPlayer;i++)
		{
			Player *pl = new Player("");
			in >> *pl;
			per.playerMap_[pl->getName()]=pl;
		}

		//manage actualPlayer
		std::string tempo;
		in >> tempo; 
		std::map<std::string,Player*>::iterator itt=per.playerMap_.find(tempo);
		if (itt!=per.playerMap_.end())
		{
			per.actualPlayer_=itt->second;
		}
		else
			per.actualPlayer_=NULL;
		//Case management
		int nbCase=0;
		in >> nbCase;
		per.case_=new Case[nbCase];
		for (i=0;i<nbCase;i++)
		{
			
			in >> per.case_[i];
			Case *cc=&per.case_[i];
			itt=per.playerMap_.find(per.case_[i].playerName_);
			if (itt!=per.playerMap_.end())
			{
				per.case_[i].setPlayer(itt->second);
			}
			else
				per.case_[i].setPlayer(NULL);

			itt=per.playerMap_.find(per.case_[i].previousplayername_);
			if (itt!=per.playerMap_.end())
			{
				per.case_[i].setPreviousPlayer(itt->second);
			}
			else
				per.case_[i].setPreviousPlayer(NULL);
		}
		
		in >> per.isPlayerChoosedByHazard;
		in >> per.nbCoutRestant_;
		in >> per.nbCoupperTurnAttack_;
		in >> per.nbCoupperTurnDefend_;
		in >> per.nbCoupperTurnGuerilla_;
		int act=0;
		in >> act;
		per.actualAction_=(Board::ActualActionMode)act;
		//Winner
		tempo="";
		in >> tempo; 
		itt=per.playerMap_.find(tempo);
		if (itt!=per.playerMap_.end())
		{
			per.winner_=itt->second;
		}
		else
			per.winner_=NULL;
	}

	return in;

}

Serializer&  operator<< (Serializer& in, Board& per)

{
	int version=0;
	in << 1;
	in << per.xSize_;
	in << per.ySize_;
	in << per.warped_;
	in << per.players_;
	in << per.active_players_;
	in << per.remaining_players_;
	in << per.turn_ ; 
	in << per.n_att_;

	//Player
	std::map<std::string,Player*>::iterator itt=per.playerMap_.begin();
	in <<(int)per.playerMap_.size();
	while (itt!=per.playerMap_.end())
	{
		in << *(itt->second);
		itt++;
	}
	//Actual Player
	std::string empty;
	if (per.actualPlayer_!=NULL)
		in << per.actualPlayer_->getName();
	else
		in << empty;
	//Cases
	in << (per.xSize_*per.ySize_);
	int i=0;
	for (i=0;i<per.xSize_*per.ySize_;i++)
	{
		in << per.case_[i];
	}
	in << per.isPlayerChoosedByHazard;
	in << per.nbCoutRestant_;
	in << per.nbCoupperTurnAttack_;
	in << per.nbCoupperTurnDefend_;
	in << per.nbCoupperTurnGuerilla_;
	in << (int)per.actualAction_;
	empty="";
	if (per.winner_!=NULL)
		in << per.winner_->getName();
	else
		in << empty;
	
	

	return in;

}
/*
int Board::operator =(Board b){


}*/

void Board::setCases(Case *pcase){
	if (case_!=NULL) delete []case_;
	case_=pcase;
}

void Board::setWidth(int z){xSize_=z;}
void Board::setHeight(int z){ySize_=z;}

void Board::recalculatePlayer(){
	playerMap_.clear();
	for (int i=0;i<xSize_*ySize_;i++)
	{
		if(case_[i].getPlayer()!=NULL)
		{
			getOrCreatePlayerByName(case_[i].getPlayer()->getName());
		}
	}
}
