/* wrapper for capasbin/html
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/* ||>> ================================================================ <<|| */
/*       1         2         3         4         5         6         7        */
/* 45678901234567890123456789012345678901234567890123456789012345678901234567 */
/* created by Isaac Tsai 1996                                                 */
/* ||>> ================================================================ <<|| */

#include <signal.h>

#include "capaParser.h"
#include "capaCommon.h"
#include "ranlib.h"

#define   _MAIN_PROGRAM_
#include "capaCGI.h"

/* |>> ====================== begin of main() =========================== <<| */

int main(int argc, char *argv[]) 
{ 
#ifdef __alpha
  struct timespec      a_ts, b_ts;
#endif
  /*
  time_t               curtime;
  char                *time_str;
  double               tdiff;
  long                 sec_diff, nsec_diff;
  char                 log_str[FILE_NAME_LENGTH];
  */
#ifdef CGI_DBUG
  char                 filename[FILE_NAME_LENGTH];
#endif
  int                  tmp_int;
  
#ifdef __alpha  
  getclock(TIMEOFDAY, &a_ts);
#endif   
  signal(SIGFPE, SIG_IGN);
  strcpy(g_prog_name,argv[0]);
  setbuf(stdout,NULL);  /* non-buffered STREAM io */

#ifdef CGI_DBUG
   sprintf(filename,"cgi.DBUG");
   if ((g_cgi=fopen(filename,"a"))==NULL) {
     fprintf(stdout,"Error : can't open cgi debug\n"); 
     fflush(stdout);  return 2; 
   }
   setbuf(g_cgi,NULL);  /* non-buffered STREAM io */
#endif /* CGI_DBUG */

    fprintf(stdout,"Content-type: text/html%c%c",LF,LF);
    /*   fprintf(stdout,"<HTML><HEAD>\n");
      fprintf(stdout,"<BODY BGCOLOR=\"#FFFFFF\" LINK=\"#0000EE\" VLINK=\"#EE1100\">\n");
      fflush(stdout);  
   */

   /* HTML header can not be shown until input has been parsed, so that I can
      be in the class directory */
    tmp_int = w_get_input();
    web_printheader(stdout);
#ifdef  CAPA_WEB
    fprintf(stdout,"<!-- capasbin, CAPA Version %s, %s -->\n",
	    CAPA_VER,COMPILE_DATE);
#else
    fprintf(stdout,"<!-- capahtml, CAPA Version %s, %s -->\n",
	    CAPA_VER,COMPILE_DATE);
#endif
    fprintf(stdout,"<!-- CAPA is released under the GNU GPL v2 see COPYING for details. -->\n");
    if ((tmp_int!=0) && (!((tmp_int == 32)||(tmp_int == 64)||(tmp_int == (32|64))))) { 
      /* <== let's get rid of errcode 32 and 64, */
      /* REMOTE_HOST */
      fprintf(stdout,"<!-- w_get_input returned error code %d. -->\n",tmp_int);
      fprintf(stdout,"<!-- getinput error -->\n"); fflush(stdout);
      fprintf(stdout,"</BODY></HTML>\n"); 
#ifdef CGI_DBUG
      fprintf(g_cgi,"w_get_input(): error\n"); fflush(g_cgi);
#endif /* CGI_DBUG */
      web_printfooter(stdout);
      return (1);
    } else {
#ifdef CGI_DBUG
      fprintf(g_cgi,"w_get_input(): %d error, run_mode=%d\n",tmp_int,
	      g_run_mode); fflush(g_cgi);
#endif /* CGI_DBUG */    
      switch( g_run_mode ) {
      case 0:  break;
      case M_CHECKIN:  print_mainmenu(g_class_name, g_student_number, g_entered_pin); break;
      case M_TRYSET:   process_mode(TRY_SET_MODE);       break;
      case M_VIEWPREV: process_mode(VIEW_PREVIOUS_MODE); break;
      case M_VIEWSUMM: print_summary(g_cpath,g_class_name,g_student_number, g_entered_pin, g_login_set);
	   break;
      case M_EXAMSUMM: 
      case M_QUIZSUMM: process_summary(g_run_mode); break;
#ifdef   CAPA_WEB
      case M_CHECKANS: process_mode(CHECK_ANSWER_MODE); break;
#endif
      case M_TERMSCORE: print_termscore_page(g_cpath,g_class_name,g_student_number, g_entered_pin, g_login_set,stdout);
           break;
      default: break;
      }
      web_printfooter(stdout);
    }
    
    /*    fprintf(stdout,"</BODY></HTML>\n"); fflush(stdout);*/

#ifdef CGI_DBUG
    fflush(g_cgi); fclose(g_cgi);
#endif /* CGI_DBUG */

    /*
    getclock(TIMEOFDAY, &b_ts);
    sec_diff  = b_ts.tv_sec  - a_ts.tv_sec;
    nsec_diff = b_ts.tv_nsec - a_ts.tv_nsec;
    tdiff = (double)1000000000.0 * sec_diff + (double)nsec_diff;
    sprintf(log_str,"%s %s %lg",getenv("REMOTE_HOST"),getenv("HTTP_USER_AGENT"),tdiff);
    w_log_timing(g_student_number,g_login_set,g_student_data.s_sec,log_str);
    */
    return (0);
}


