/******************************** -*- C -*- ****************************
 *
 *	xmalloc, xrealloc and xfree for Smalltalk
 *
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 ***********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "alloc.h"

#include <stdio.h>

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#endif /* STDC_HEADERS */


PTR 
xmalloc (register size_t n)
{
  register PTR block;

  block = malloc(n);
  if (!block && n)
    nomemory(1);

  return (block);
}

PTR 
xcalloc (register size_t n, register size_t s)
{
  register PTR block;

  block = calloc(n, s);
  if (!block && n && s)
    nomemory(1);

  return (block);
}

PTR 
xrealloc (register PTR p, register size_t n)
{
  register PTR block;

  /* We must call malloc explicitly when BLOCK is 0, since some
     reallocs don't do this.  */
  if (!p) {
    block = malloc (n);
    if (!block && n)
      nomemory(1);
  } else {
    if (n)
      block = realloc(p, n);
    else {
      free (p);
      block = NULL;
    }
  }

  /* !!! check to see if realloc frees existing memory if it cannot
   *  allocate more -- hmmm, ANSI says it shouldn't */ 
  return (block);
}

void
xfree (register PTR p)
{
  if (p)
    free(p);
}

void
nomemory (int fatal)
{
  fprintf(stderr, "\n\n[Memory allocation failure]"
	"\nCan't allocate enough memory to continue.\n");

  if (fatal)
    exit (1);
}


