/******************************** -*- C -*- ****************************
 *
 *	Object table module Inlines.
 *
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 2000, 2001, 2002 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/

static inline OOP alloc_oop (PTR obj, long flags);

/* Mark the OOP object because it is part of the root set.  Integers
   and already-marked OOPs are not processed silently. */
#define MAYBE_MARK_OOP(oop) do {				  \
  if (IS_OOP(oop) && !IS_OOP_MARKED(oop)) {		  \
    _gst_mark_an_oop_internal(oop, NULL, NULL);			  \
  }							  \
} while(0)

/* Mark the OOPs starting at STARTOOP (included) and ending at ENDOOP
   (excluded). */
#define MARK_OOP_RANGE(startOOP, endOOP) do {		  \
  if ((startOOP) < (endOOP)) {				  \
    _gst_mark_an_oop_internal(NULL, startOOP, endOOP);		  \
  }							  \
} while(0)

/* In the non-incremental GC world, being FREE is all that matters for
 * validity.
 */
#define OOP_VALID(oop) \
  (!(oop->flags & F_FREE))

/* Answer the INDEX-th OOP in the table. */
#define OOP_AT(index) \
  ( &_gst_oop_table[index] )

/* Answer whether the INDEX-th OOP in the table is free. */
#define OOP_AVAILABLE(index) \
  ( _gst_oop_table[index].flags & F_FREE )

/* Answer the index of OOP in the table. */
#define OOP_INDEX(oop) \
  ( (OOP)(oop) - _gst_oop_table )

/* Answer whether OOP is a builtin OOP (a Character, true, false, nil). */
#define IS_BUILTIN_OOP(oop) \
  ( (OOP)(oop) - _gst_oop_table < 0 )

/* Set the indirect object pointer OOP to point to OBJ. */
#define SET_OOP_OBJECT(oop, obj) do {				\
  (oop)->object = (mst_Object) (obj);				\
} while(0)

/* Answer whether addr is part of the OOP table. */
#define IS_OOP_ADDR(addr)							\
  ((OOP)(addr) >= _gst_all_oops_table && (OOP)(addr) < &_gst_oop_table[_gst_oop_table_size] \
    && (((long)addr & (SIZEOF_LONG - 1)) == 0))

/* Answer whether addr is part of the object data. */
#define IS_OBJ_ADDR(addr)							\
  ((char *)(addr) >= _gst_mem_space.space && (char *)(addr) < _gst_mem_space.allocPtr \
    && (((long)(addr) & (SIZEOF_LONG - 1)) == 0))

/* Return the Character object for ASCII value C. */
#define CHAR_OOP_AT(c)      (&_gst_oop_table[(c) + CHAR_OBJECT_BASE])

/* Return the ASCII value corresponding to the Character object
   OOP. */
#define CHAR_OOP_VALUE(oop) ((oop) - &_gst_oop_table[CHAR_OBJECT_BASE])





/* Given an object OBJ, this routine allocates an OOP table slot for it
   and returns it.  It marks the OOP so that it indicates the object is in
   new space, and that the oop has been referenced on this pass (to keep
   the OOP table reaper from reclaiming this OOP). */
static inline OOP
alloc_oop (PTR objData, long flags)
{
  REGISTER (1, OOP oop);
  extern OOP _gst_first_free_oop;
  mst_Object obj;

  obj = (mst_Object) objData;

  oop = _gst_first_free_oop;
  _gst_first_free_oop = (OOP) oop->object;
  if (oop > _gst_last_used_oop)
    _gst_last_used_oop = oop;

#ifndef OPTIMIZE
  if (!(oop->flags & F_FREE))
    {
      _gst_errorf ("Non-free OOP in OOP free list!!!");
      exit (1);
    }
#endif

  oop->object = obj;
  oop->flags = flags;

  /* Force a GC as soon as possible if we're low on OOPs.  */
  if UNCOMMON (_gst_num_free_oops-- < LOW_WATER_OOP_THRESHOLD)
    _gst_mem_space.maxPtr = _gst_mem_space.allocPtr;

  return (oop);
}
