/*
** Copyright (C) 1999, 2000, Lorenzo Bettini <lorenzo.bettini@penteres.it>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


// messages.cc

#include "messages.h"

static Messages *_messager = 0 ;

void printMessage( const char *s, ostream &stream ) {
  if ( _messager )
    _messager->printMessage(s,stream) ;
}

void
printMessage_noln( const char *s, ostream &stream ) {
  if ( _messager )
    _messager->printMessage_noln(s,stream) ;
}

void printWarning( const char *s, ostream &stream ) {
  if ( _messager )
    _messager->printWarning(s,stream) ;
}

void printError( const char *s, ostream &stream ) {
  if ( _messager )
    _messager->printError(s,stream) ;
}

void setMessager( Messages *m ) {
  if ( m )
    _messager = m ;
}
