/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <string.h>
#include <iostream>
#include <fstream>
#include <stdlib.h>

#include "genfun.h"

#include "messages.h"
#include "tags.h"
#include "keys.h"
#include "textgen.h"
#include "decorators.h"
#include "fileutil.h"
#include "linenogen.h"
#include "docgenerator.h"

// globals
#include "linenumdigit.h"
#include "cmdlineargs.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

//----------------------------------------------------------------------------//
//	Don Stauffer																								June 2003
//----------------------------------------------------------------------------//
#include	"srcpretranslator.h"
#include	"srcuntabifier.h"

Pretranslator	*pretranslator;
//----------------------------------------------------------------------------//

using std::cout;
using std::cerr;
using std::endl;
using std::ofstream;

extern int java_scanner_lex() ;
extern int javascript_scanner_lex() ;
extern int cpp_scanner_lex() ;
extern int prolog_scanner_lex() ;
extern int perl_scanner_lex() ;
extern int php3_scanner_lex() ;
extern int python_scanner_lex() ;
extern int ruby_scanner_lex() ;
extern int flex_scanner_lex() ;
extern int changelog_scanner_lex() ;

extern int tabSpaces; // FIXME

static char *get_input_file_name(char *file_name);

void
processFile( char *source_language, char *output_format,
             char *inputFileName, char *outputFileName,
             short entire_doc )
{
  FILE *in = 0;
  bool deleteOStream = false ;

  if ( outputFileName ) {
    sout = new ofstream(outputFileName) ;
    if ( ! (*sout) ) {
      cerr << "Error in creating " << outputFileName << " for output" << endl ;
      exit(1) ;
    }
    deleteOStream = true;
  }

  if (inputFileName)
    {
      unsigned int lines = get_line_count (inputFileName);

      line_num_digit = 0;
      while (lines)
        {
          ++line_num_digit;
          lines /= 10;
        }
    }
  else
    line_num_digit = 5;
  // if we read from stdin, we can't read the file in advance and
  // check how many lines of code it contains.  In this case set
  // the number of digit for the line number to 5.

  if (inputFileName)
    {
      char *input_file_name = get_input_file_name (inputFileName);

      in = freopen (input_file_name, "r", stdin);
      if (!in) 
        {
          cerr << "Error in opening " << inputFileName
               << " for input" << endl ;
          exit(1) ;
        }

      delete input_file_name;
    }

  /*
   * Use default values for any options not provided
   */
  if (sout == 0) {
    sout = &cout;
  }

  if (in == 0) {
    ; /* Well stdin already points to stdin so, .... */
  }

  if ( entire_doc ) {
    GlobalDocGenerator->generate_top ();
  }

//----------------------------------------------------------------------------//
//	Don Stauffer																								June 2003
//----------------------------------------------------------------------------//
  if (tabSpaces)
    pretranslator = new Untabifier (tabSpaces);
  else if (args_info.line_number_given)
    pretranslator = new Untabifier(8);
  else
    pretranslator = new Pretranslator ();
//----------------------------------------------------------------------------//

  printMessage( "translating source code... ", cerr ) ;

  GlobalDocGenerator->generate_start_doc ();

  LineNumberDecorator::reset ();

  // decide which lexer to call
  if (strcmp (source_language, "java") == 0)
    java_scanner_lex () ;
  else if (strcmp (source_language, "javascript") == 0)
    javascript_scanner_lex () ;
  else if (strcmp (source_language, "cpp") == 0)
    cpp_scanner_lex ();
  else if (strcmp (source_language, "prolog") == 0)
    prolog_scanner_lex ();
  else if (strcmp (source_language, "perl") == 0)
    perl_scanner_lex ();
  else if (strcmp (source_language, "php3") == 0)
    php3_scanner_lex ();
  else if (strcmp (source_language, "python") == 0)
    python_scanner_lex ();
  else if (strcmp (source_language, "ruby") == 0)
    ruby_scanner_lex ();
  else if (strcmp (source_language, "flex") == 0)
    flex_scanner_lex ();
  else if (strcmp (source_language, "changelog") == 0)
    changelog_scanner_lex ();
  else
    {
      cerr << PACKAGE << ": ";
      cerr << "source language " << source_language << " not handled" << endl;
      exit (1);
    }
  // FIXME: a more object-oriented approach?

  GlobalDocGenerator->generate_end_doc ();

  printMessage( "done !", cerr ) ;

  if ( entire_doc ) {
    GlobalDocGenerator->generate_bottom ();
  }

  sout->flush ();

  if ( deleteOStream )
    delete sout ;

//----------------------------------------------------------------------------//
//	Don Stauffer																								June 2003
//----------------------------------------------------------------------------//
  delete pretranslator;
//----------------------------------------------------------------------------//

}

char *
get_input_file_name(char *file_name)
{
  unsigned int length = strlen (CHROOT_INPUT_DIR);

  if (length != 0)
    {
      char *new_name = new char [strlen (file_name) + length + 1];
      strcpy (new_name, strdup (CHROOT_INPUT_DIR));
      return strcat (new_name, file_name);
    }
  else
    return strdup (file_name);
}

//----------------------------------------------------------------------------//
//	Don Stauffer																								June 2003
//----------------------------------------------------------------------------//
void
generate (const char *s)
{
  pretranslator->generate (s);
}

void
generate (const char *s, int start, int	end)
{
  pretranslator->generate (s, start, end);
}

void
generateln (const char *s)
{
  pretranslator->generateln (s);
}

void 
generate_preproc ( const char  *s )
{ 
  pretranslator->generate_preproc (s);
}

void
generate_normal	(const char *s)
{
  pretranslator->generate_normal(s);
}

void
generateNewLine	(void)	
{
  generateln("");
}

void
generateTab(void)
{
  pretranslator->generateTab();
}

void
startComment(const char	*s)
{
  pretranslator->startComment(s);
}

void
endComment(const char *s)
{
  pretranslator->endComment(s);
}

void 
generateComment(const char *s)
{	
  pretranslator->generateComment(s);
}

void
startString(const char *s)
{	
  pretranslator->startString(s);
}

void
endString(const char *s)
{	
  pretranslator->endString(s);
}

void
generateString(const char *s)
{	
  pretranslator->generateString(s);
}

void
generateKeyWord(const char *s)
{	
  pretranslator->generateKeyWord(s);
}

void
generateBaseType(const char *s)
{	
  pretranslator->generateBaseType(s);
}

void
generatePreProc(const char *s)
{	
  pretranslator->generatePreProc(s);
}

void
generateNumber(const char *s)
{	
  pretranslator->generateNumber(s);
}

void
generateSymbol(const char *s)
{	
  pretranslator->generateSymbol(s);
}

void
generateFunction(const char *s)
{	
  pretranslator->generateFunction(s);
}

void
generateCBracket(const char *s)
{	
  pretranslator->generateCBracket(s);
}
