/* This file was generated by scm2c from source file "wbdefs.scm" */
/*  "wbdefs.scm" WB-tree File Based Associative String Data Base System. */
/*  Copyright (C) 1991, 1992, 1993, 2000 Free Software Foundation, Inc. */
/*  */
/*  This program is free software: you can redistribute it and/or modify */
/*  it under the terms of the GNU Lesser General Public License as */
/*  published by the Free Software Foundation, either version 3 of the */
/*  License, or (at your option) any later version. */
/*  */
/*  This program is distributed in the hope that it will be useful, but */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU */
/*  Lesser General Public License for more details. */
/*  */
/*  You should have received a copy of the GNU Lesser General Public */
/*  License along with this program.  If not, see */
/*  <http://www.gnu.org/licenses/>. */


/*  FLC-LEN must be larger than 2 times the maximum number of blocks */
/*  which would ever be needed for a freelist split. */

#define flc_len 0xa

/* amount to increase the ENT-TAB by when allocating buffers. */

#define ent_tab_inc 0x200

/*  Byte-array directory names */
/*  These should be protected against EBCDIC. */

#define flc_byts "FLC"

#define fld_byts "FLD"

#define used_byts "USED"

#define bsiz_byts "BSIZ"

#define root_byts "ROOT"

#define cln_byts "CLN"

#define authors_byts "authors"

#define no_byts ""

/* Return @var{x} if a valid error code (-1 @dots{} @var{MAXERR}); */
/* else 0. */

#define err_P(x) (((1)) && (0 > (x)) && ((x)>=(maxerr)))


#define realerr_P(x) (((1)) && ((x)<=(retryerr)) && ((x)>=(maxerr)))

/* Not @code{err_P}. */

#define success_P(x) (!(err_P(x)))

/*  Return Codes */

/* Successful execution (0). */

#define success 0

/*  ERROR Return Codes */

/* Successful execution; no data present or no change made. */

#define notpres  -1

/* Failure; no damage; caller can retry operation. */

#define terminated  -2

/* Failure; no damage; caller can retry operation. */

#define retryerr  -10

/* Failure, no damage, call was in error. */

#define keyerr  -13

/* Failure, no damage, call was in error. */

#define argerr  -15

/* Failure, no damage, out of room in file. */

#define noroom  -20

/* Failure, file or object was not of correct type. */

#define typerr  -30

/* I/O error, DB may be damaged. */

#define ioerr  -40

/* Internal error, DB may be damaged. */

#define strangerr  -45

/* Placeholder code. */

#define unkerr  -90

/* All error codes are between 0 and @samp{maxerr}. */

#define maxerr  -100



#define dir_typ 0x44

#define ind_typ 0x54

#define seq_typ 0x53

#define frl_typ 0x46


#define wcb_sap 1

#define wcb_sar 2

#define wcb_sac 4

#define wcb_fac 8


#define end_of_chain  -1

#define start_of_chain  -2


#define leaf 0x30

/*  BLK PREDICATES */


#define root_P(blk) ((blk_id(blk))==(blk_top_id(blk)))


#define end_of_chain_P(blk) (!(blk_nxt_id(blk)))


#define leaf_P(blk) ((blk_level(blk))==(leaf))


#define field_len(blk, pos) ((((unsigned char*)(blk))[pos]))


#define set_field_len(blk, pos, len) {blk[pos] = len;}

/*  This is dangerous.  At the moment all occurences of next-field */
/*  have simple expressions for the second argument. */


#define next_field(blk, pos) ((field_len(blk, pos))+(pos)+1)


#define next_cnvpair(blk, pos) (next_field(blk, next_field(blk, 1+(pos))))


#define blk_empty_P(blk) ((blk_end(blk))==(next_field(blk, 1+(blk_data_start))))

/*  LCK and ENT tables */

/*  If you change this, then change amnesia-ent! */
/*  This depends on segid never being less than -1 */

#define hash2int(segid, num) ((((segid)*0x61)+(num)+((num_buks)*(1+(0x61/(num_buks)))))%(num_buks))


#define same_buk_P(a_segid, a_num, b_segid, b_num) ((hash2int(a_segid, a_num))==(hash2int(b_segid, b_num)))


#define get_buk(segid, blk_num) (buk_tab[hash2int(segid, blk_num)])

/*  doesnt wait, ie, returns #F if busy */

#define get_buk_lck_P(segid, blk_num) (try_lck_P(lck_tab[hash2int(segid, blk_num)]))


#define get_buk_wait(segid, blk_num) (lck(lck_tab[hash2int(segid, blk_num)]),buk_tab[hash2int(segid, blk_num)])


#define rel_buk(segid, blk_num) {unlck(lck_tab[hash2int(segid, blk_num)]);}

/*  SET-BUK! assumes BUK is already lcked by caller */

#define set_buk(segid, blk_num, ent) {buk_tab[hash2int(segid, blk_num)] = ent;}

/* (defconst ACCFOO 'ACCFOO) */

#define accnone (1)

#define accread (2)

#define accwrite (3)

#define accpend (4)

/*  Tokens for use in the PKT:MATCH-POS field */

#define pastp (5)
			/* match(new-key, after-key) > repeatcount(after-key) */

#define qpastp (6)
			/* match(new-key, after-key) <= repeatcount(after-key) */

#define match (7)

#define matchend (8)

#define pastend (9)

/*  Operation codes for SCAN */

#define rem_scan  -1

#define count_scan 0

#define modify_scan 1
