A note about using the stream editor sed for the plugin:

Up to version 2.03a sed is pretty much inefficient for a plugin because
it waits until a certain amount of output has been accumulated before
it actually outputs anything. This is not really useful for most
purposes.

I discussed the problem with the sed maintainer Ken Pizzini and he
sent me a patch for the 3.02a that solves the problem. The patch will
be incorporated into all versions >= 3.02b but in case you can't get
a proper version right now I am appending the patch below.

Regards,
	Georg


------------------------------------------------------------------

From: Ken Pizzini <ken@halcyon.com>
Subject: Re: [sed] Problems with SED 
To: "Georg C. F. Greve" <greve@gnu.org>
Date: Mon, 08 Mar 1999 00:58:24 -0800

Attached is a patch which adds the "-u" option.  (It is
hand-edited from the whole of the changes in 3.02b, thus
patch "fuzz"ing is to be expected.  I have verified that
the patch below does work for me, however.)

		--Ken Pizzini


diff -u sed-3.02a/sed/execute.c sed-3.02b/sed/execute.c
--- sed-3.02a/sed/execute.c	Fri Aug 14 19:29:42 1998
+++ sed-3.02b/sed/execute.c	Sun Nov  1 00:07:53 1998
@@ -69,9 +68,13 @@
 #else
 # define ADDNUL(d)
 #endif
 
+/* If set, buffer input as minimally as practical,
+   and fflush(stdout) more often. */
+extern flagT force_unbuffered;
+
 /* If set, don't write out the line unless explicitly told to. */
 extern flagT no_default_output;
 
 /* Do we need to be pedantically POSIX compliant? */
 extern flagT POSIXLY_CORRECT;
@@ -118,9 +125,7 @@
   const char *cur;	/* only valid if base is non-NULL */
   size_t length;	/* only valid if base is non-NULL */
   size_t left;		/* only valid if base is non-NULL */
-#ifdef HAVE_ISATTY
-  flagT is_tty;		/* only valid if base is NULL */
-#endif
+  flagT no_buffering;	/* only valid if base is NULL */
 };
 
 
@@ -328,9 +333,8 @@
   return 1;
 }
 
-#ifdef HAVE_ISATTY
 /* fgets() doesn't let us handle NULs and fread() buffers too much
- * for interactive use.
+ * for interactive (or other unbuffered) uses.
  */
 static size_t slow_getline P_((char *buf, size_t buflen, FILE *));
 static size_t
@@ -353,7 +357,6 @@
     panic(_("input read error: %s"), strerror(errno));
   return resultlen;
 }
-#endif /*HAVE_ISATTY*/
 
 static flagT read_file_line P_((struct input *));
 static flagT
@@ -375,11 +378,9 @@
       buffer.length = 0;
       if (!feof(input->fp))
 	{
-#ifdef HAVE_ISATTY
-	  if (input->is_tty)
+	  if (input->no_buffering)
 	    buffer.length = slow_getline(buffer.text, buffer.alloc, input->fp);
 	  else
-#endif
 	    buffer.length = ck_fread(buffer.text, 1, buffer.alloc, input->fp);
 	}
 
@@ -415,7 +416,7 @@
     ck_fwrite(text, 1, length, fp);
   if (nl)
     ck_fwrite("\n", 1, 1, fp);
-  if (fp != stdout)
+  if (fp != stdout || force_unbuffered)
     ck_fflush(fp);
 }
 
@@ -508,7 +509,9 @@
     }
 
   input->read_fn = read_file_line;
-  if (map_file(input->fp, &input->base, &input->length))
+  if (force_unbuffered)
+    input->no_buffering = 1;
+  else if (map_file(input->fp, &input->base, &input->length))
     {
       input->cur = VCAST(char *)input->base;
       input->left = input->length;
@@ -516,7 +519,7 @@
     }
 #ifdef HAVE_ISATTY
   else
-    input->is_tty = isatty(fileno(input->fp));
+    input->no_buffering = isatty(fileno(input->fp));
 #endif
 }
 
diff -u sed-3.02a/sed/sed.c sed-3.02b/sed/sed.c
--- sed-3.02a/sed/sed.c	Fri Aug 14 18:35:42 1998
+++ sed-3.02b/sed/sed.c	Sat Oct 31 22:24:28 1998
@@ -64,10 +67,14 @@
 
 flagT use_extended_syntax_p = 0;
 
 flagT rx_testing = 0;
 
+/* If set, buffer input as minimally as practical,
+   and fflush(stdout) more often. */
+flagT force_unbuffered = 0;
+
 /* If set, don't write out the line unless explicitly told to */
 flagT no_default_output = 0;
 
 /* Do we need to be pedantically POSIX compliant? */
 flagT POSIXLY_CORRECT;
@@ -90,6 +106,8 @@
                  add the script to the commands to be executed\n\
   -f script-file, --file=script-file\n\
                  add the contents of script-file to the commands to be executed\n\
+  -u, --unbuffered\n\
+\n\
       --help     display this help and exit\n\
   -V, --version  output version information and exit\n\
 \n\
@@ -113,8 +133,9 @@
     {"rxtest", 0, NULL, 'r'},
     {"expression", 1, NULL, 'e'},
     {"file", 1, NULL, 'f'},
     {"quiet", 0, NULL, 'n'},
     {"silent", 0, NULL, 'n'},
+    {"unbuffered", 0, NULL, 'u'},
     {"version", 0, NULL, 'V'},
     {"help", 0, NULL, 'h'},
     {NULL, 0, NULL, 0}
@@ -135,7 +157,7 @@
   POSIXLY_CORRECT = (getenv("POSIXLY_CORRECT") != NULL);
 
   myname = *argv;
-  while ((opt = getopt_long(argc, argv, "hnrVe:f:", longopts, NULL)) != EOF)
+  while ((opt = getopt_long(argc, argv, "hnruVe:f:", longopts, NULL)) != EOF)
     {
       switch (opt)
 	{
@@ -150,7 +186,11 @@
 	case 'r':
 	  use_extended_syntax_p = 1;
 	  rx_testing = 1;
 	  break;
+	case 'u':
+	  force_unbuffered = 1;
+	  break;
+
 	case 'V':
 	  fprintf(stdout, "GNU %s version %s\n\n", PACKAGE, VERSION);
 	  fprintf(stdout, _("%s\n\
diff -u sed-3.02a/sed/sed.h sed-3.02b/sed/sed.h
--- sed-3.02a/sed/sed.h	Fri Aug 14 18:35:42 1998
+++ sed-3.02b/sed/sed.h	Sat Oct 31 21:39:39 1998
@@ -143,5 +143,6 @@
 
 extern flagT use_extended_syntax_p;
 extern flagT rx_testing;
+extern flagT force_unbuffered;
 extern flagT no_default_output;
 extern flagT POSIXLY_CORRECT;

------------------------------------------------------------------

